/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.event.KeyEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.tax.TreeObject;
import org.openide.util.WeakListeners;

public abstract class AbstractTreeCustomizer
extends JPanel
implements Customizer,
PropertyChangeListener {
    private static final long serialVersionUID = 7141277140374364170L;
    private static final String TEXT_DEFAULT = Util.THIS.getString("TEXT_DEFAULT");
    public static final String MIME_XML = "text/xml";
    public static final String MIME_DTD = "text/x-dtd";
    public static final String MIME_TXT = "text/plain";
    protected boolean initializing = false;
    private TreeObject treeObject = null;
    private boolean treeListening = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(Object object) throws IllegalArgumentException {
        try {
            this.initializing = true;
            if (!(object instanceof TreeObject)) {
                throw new IllegalArgumentException(object + Util.THIS.getString("PROP__invalid_instance"));
            }
            this.treeObject = (TreeObject)object;
            this.ownInitComponents();
            this.initValues();
        }
        finally {
            this.initializing = false;
        }
    }

    protected final TreeObject getTreeObject() {
        return this.treeObject;
    }

    private final void initValues() {
        this.initComponentValues();
        this.updateReadOnlyStatus();
        this.initListeners();
    }

    protected abstract void initComponentValues();

    protected void ownInitComponents() {
    }

    private void updateReadOnlyStatus() {
        this.updateReadOnlyStatus(!this.getTreeObject().isReadOnly());
    }

    protected abstract void updateReadOnlyStatus(boolean var1);

    private void initListeners() {
        if (!this.treeListening) {
            this.treeObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.treeObject));
            this.treeListening = true;
        }
    }

    protected void safePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("readOnly")) {
            this.updateReadOnlyStatus();
        }
    }

    public final void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        if (this.initializing) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.safePropertyChange(propertyChangeEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractTreeCustomizer.this.safePropertyChange(propertyChangeEvent);
                }
            });
        }
    }

    protected static String text2null(String string) {
        if (string.equals(TEXT_DEFAULT)) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        return string;
    }

    protected static String null2text(String string) {
        if (string == null) {
            return TEXT_DEFAULT;
        }
        return string;
    }

    protected static boolean applyKeyPressed(KeyEvent keyEvent) {
        return keyEvent.isControlDown() && keyEvent.getKeyCode() == 10;
    }
}

