/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileFilter;
import org.netbeans.modules.cnd.qnavigator.navigator.IndexOffsetNode;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmFileModel {
    private List<IndexOffsetNode> lineNumberIndex = Collections.synchronizedList(new ArrayList());
    private List<CppDeclarationNode> list = Collections.synchronizedList(new ArrayList());
    private CsmFileFilter filter;
    private Action[] actions;

    public CsmFileModel(CsmFileFilter csmFileFilter, Action[] actionArray) {
        this.filter = csmFileFilter;
        this.actions = actionArray;
    }

    public boolean setFile(CsmFile csmFile, boolean bl) {
        return this.buildModel(csmFile, bl);
    }

    public Node[] getNodes() {
        return this.list.toArray(new Node[0]);
    }

    private void clear() {
        this.lineNumberIndex.clear();
        this.list.clear();
    }

    public CsmFileFilter getFilter() {
        return this.filter;
    }

    public void addOffset(Node node, CsmOffsetable csmOffsetable, List<IndexOffsetNode> list) {
        list.add(new IndexOffsetNode(node, csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset()));
    }

    private boolean buildModel(CsmFile csmFile, boolean bl) {
        boolean bl2 = true;
        ArrayList<CppDeclarationNode> arrayList = new ArrayList<CppDeclarationNode>();
        ArrayList<IndexOffsetNode> arrayList2 = new ArrayList<IndexOffsetNode>();
        if (csmFile != null && csmFile.isValid()) {
            CppDeclarationNode cppDeclarationNode;
            if (this.filter.isApplicableInclude()) {
                for (CsmInclude csmInclude : csmFile.getIncludes()) {
                    cppDeclarationNode = CppDeclarationNode.nodeFactory((CsmObject)csmInclude, this, false, arrayList2);
                    if (cppDeclarationNode == null) continue;
                    arrayList.add(cppDeclarationNode);
                }
            }
            if (this.filter.isApplicableMacro()) {
                for (CsmInclude csmInclude : csmFile.getMacros()) {
                    cppDeclarationNode = CppDeclarationNode.nodeFactory((CsmObject)csmInclude, this, false, arrayList2);
                    if (cppDeclarationNode == null) continue;
                    arrayList.add(cppDeclarationNode);
                }
            }
            for (CsmInclude csmInclude : csmFile.getDeclarations()) {
                if (!this.filter.isApplicable((CsmOffsetable)csmInclude) || (cppDeclarationNode = CppDeclarationNode.nodeFactory((CsmObject)csmInclude, this, false, arrayList2)) == null) continue;
                arrayList.add(cppDeclarationNode);
            }
        }
        if (csmFile != null && csmFile.isValid()) {
            Collections.sort(arrayList);
            Collections.sort(arrayList2);
            this.resetScope(arrayList2);
            if (bl || this.isNeedChange(arrayList2)) {
                this.clear();
                this.list.addAll(arrayList);
                this.lineNumberIndex.addAll(arrayList2);
            } else {
                this.resetScope(this.lineNumberIndex);
                bl2 = false;
            }
        } else {
            this.clear();
        }
        arrayList.clear();
        arrayList2.clear();
        return bl2;
    }

    private boolean isNeedChange(List<IndexOffsetNode> list) {
        IndexOffsetNode indexOffsetNode;
        if (list.size() != this.lineNumberIndex.size()) {
            return true;
        }
        int n = 0;
        for (IndexOffsetNode indexOffsetNode2 : this.lineNumberIndex) {
            if (list.size() <= n) {
                return true;
            }
            indexOffsetNode = list.get(n);
            if (!this.compareNodeContent(indexOffsetNode2, indexOffsetNode)) {
                return true;
            }
            ++n;
        }
        n = 0;
        for (IndexOffsetNode indexOffsetNode2 : this.lineNumberIndex) {
            if (list.size() <= n) {
                return true;
            }
            indexOffsetNode = list.get(n);
            this.updateNodeContent(indexOffsetNode2, indexOffsetNode);
            ++n;
        }
        return false;
    }

    private boolean compareNodeContent(IndexOffsetNode indexOffsetNode, IndexOffsetNode indexOffsetNode2) {
        CppDeclarationNode cppDeclarationNode;
        CppDeclarationNode cppDeclarationNode2 = (CppDeclarationNode)indexOffsetNode.getNode();
        return cppDeclarationNode2.compareTo(cppDeclarationNode = (CppDeclarationNode)indexOffsetNode2.getNode()) == 0;
    }

    private void updateNodeContent(IndexOffsetNode indexOffsetNode, IndexOffsetNode indexOffsetNode2) {
        CppDeclarationNode cppDeclarationNode = (CppDeclarationNode)indexOffsetNode.getNode();
        CppDeclarationNode cppDeclarationNode2 = (CppDeclarationNode)indexOffsetNode2.getNode();
        cppDeclarationNode.resetNode(cppDeclarationNode2);
        indexOffsetNode.resetContent(indexOffsetNode2);
    }

    private void resetScope(List<IndexOffsetNode> list) {
        Stack<IndexOffsetNode> stack = new Stack<IndexOffsetNode>();
        for (IndexOffsetNode indexOffsetNode : list) {
            while (!stack.empty()) {
                IndexOffsetNode indexOffsetNode2 = (IndexOffsetNode)stack.peek();
                if (indexOffsetNode.getStartOffset() >= indexOffsetNode2.getStartOffset() && indexOffsetNode.getEndOffset() <= indexOffsetNode2.getEndOffset()) {
                    indexOffsetNode.setScope(indexOffsetNode2);
                    break;
                }
                stack.pop();
            }
            stack.push(indexOffsetNode);
        }
    }

    public Node setSelection(long l) {
        int n = Collections.binarySearch(this.lineNumberIndex, new IndexOffsetNode(null, l, l));
        if (n < 0) {
            n = -n - 2;
        }
        if (n > -1 && n < this.lineNumberIndex.size()) {
            IndexOffsetNode indexOffsetNode = this.lineNumberIndex.get(n);
            if (indexOffsetNode.getStartOffset() <= l && indexOffsetNode.getEndOffset() >= l) {
                return indexOffsetNode.getNode();
            }
            for (IndexOffsetNode indexOffsetNode2 = indexOffsetNode.getScope(); indexOffsetNode2 != null; indexOffsetNode2 = indexOffsetNode2.getScope()) {
                indexOffsetNode = indexOffsetNode2;
                if (indexOffsetNode2.getStartOffset() > l || indexOffsetNode2.getEndOffset() < l) continue;
                return indexOffsetNode2.getNode();
            }
            return indexOffsetNode.getNode();
        }
        return null;
    }

    public Action[] getActions() {
        return this.actions;
    }
}

