/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceGroupEvent;
import org.netbeans.modules.websvc.manager.model.WebServiceGroupListener;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceGroup {
    Set listeners = new HashSet();
    String groupId = null;
    String groupName = null;
    boolean userDefined = true;
    Set<String> webserviceIds = new HashSet<String>();

    public WebServiceGroup() {
        this(WebServiceListModel.getInstance().getUniqueWebServiceGroupId());
    }

    public WebServiceGroup(String string) {
        this.setId(string);
    }

    public void addWebServiceGroupListener(WebServiceGroupListener webServiceGroupListener) {
        this.listeners.add(webServiceGroupListener);
    }

    public void removeWebServiceGroupListener(WebServiceGroupListener webServiceGroupListener) {
        this.listeners.remove(webServiceGroupListener);
    }

    public void setId(String string) {
        this.groupId = string;
    }

    public String getId() {
        return this.groupId;
    }

    public String getName() {
        return this.groupName;
    }

    public void setName(String string) {
        this.modelDirty();
        this.groupName = string;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean bl) {
        this.userDefined = bl;
    }

    public void add(String string) {
        this.add(string, false);
    }

    public void remove(String string) {
        this.remove(string, false);
    }

    public void add(String string, boolean bl) {
        block4: {
            block3: {
                if (this.webserviceIds.contains(string)) break block3;
                WebServiceData webServiceData = WebServiceListModel.getInstance().getWebService(string);
                webServiceData.setGroupId(this.getId());
                this.webserviceIds.add(string);
                if (bl) {
                    return;
                }
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    WebServiceGroupEvent webServiceGroupEvent = new WebServiceGroupEvent(string, this.getId());
                    ((WebServiceGroupListener)iterator.next()).webServiceAdded(webServiceGroupEvent);
                }
                break block4;
            }
            if (bl) break block4;
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WebServiceGroupEvent webServiceGroupEvent = new WebServiceGroupEvent(string, this.getId());
                ((WebServiceGroupListener)iterator.next()).webServiceAdded(webServiceGroupEvent);
            }
        }
    }

    public void remove(String string, boolean bl) {
        if (this.webserviceIds.contains(string)) {
            this.webserviceIds.remove(string);
            if (bl) {
                return;
            }
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WebServiceGroupEvent webServiceGroupEvent = new WebServiceGroupEvent(string, this.getId());
                ((WebServiceGroupListener)iterator.next()).webServiceRemoved(webServiceGroupEvent);
            }
        }
    }

    public void modify(String string) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WebServiceGroupEvent webServiceGroupEvent = new WebServiceGroupEvent(string, this.getId());
            ((WebServiceGroupListener)iterator.next()).webServiceRemoved(webServiceGroupEvent);
        }
    }

    public void setWebServiceIds(Set set) {
        this.webserviceIds = set;
        Iterator<String> iterator = this.webserviceIds.iterator();
        while (iterator.hasNext()) {
            WebServiceData webServiceData = WebServiceListModel.getInstance().getWebService(iterator.next());
            webServiceData.setGroupId(this.getId());
        }
    }

    public Set<String> getWebServiceIds() {
        return this.webserviceIds;
    }

    private void modelDirty() {
        WebServiceListModel.getInstance().setDirty(true);
    }

    public boolean equals(Object object) {
        try {
            WebServiceGroup webServiceGroup = (WebServiceGroup)object;
            return webServiceGroup.getId().equals(this.getId());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getLocalizedMessage(), exception);
            return false;
        }
    }
}

