/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenSourcesImpl
implements Sources,
SourceGroupModifierImplementation {
    public static final String TYPE_OTHER = "Resources";
    public static final String TYPE_TEST_OTHER = "TestResources";
    public static final String TYPE_GEN_SOURCES = "GeneratedSources";
    public static final String TYPE_GROOVY = "groovy";
    public static final String TYPE_SCALA = "scala";
    public static final String NAME_GROOVYSOURCE = "81GroovySourceRoot";
    public static final String NAME_GROOVYTESTSOURCE = "82GroovyTestSourceRoot";
    public static final String NAME_SCALASOURCE = "91ScalaSourceRoot";
    public static final String NAME_SCALATESTSOURCE = "92ScalaTestSourceRoot";
    public static final String NAME_PROJECTROOT = "ProjectRoot";
    public static final String NAME_XDOCS = "XDocs";
    public static final String NAME_SOURCE = "1SourceRoot";
    public static final String NAME_TESTSOURCE = "2TestSourceRoot";
    public static final String NAME_GENERATED_SOURCE = "6GeneratedSourceRoot";
    private NbMavenProjectImpl project;
    private final List<ChangeListener> listeners;
    private Map<String, SourceGroup> javaGroup;
    private Map<File, SourceGroup> genSrcGroup;
    private Map<File, OtherGroup> otherMainGroups;
    private Map<File, OtherGroup> otherTestGroups;
    private Map<String, SourceGroup> groovyGroup;
    private Map<String, SourceGroup> scalaGroup;
    private final Object lock = new Object();

    public MavenSourcesImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
        this.listeners = new ArrayList<ChangeListener>();
        this.javaGroup = new TreeMap<String, SourceGroup>();
        this.genSrcGroup = new TreeMap<File, SourceGroup>();
        this.otherMainGroups = new TreeMap<File, OtherGroup>();
        this.otherTestGroups = new TreeMap<File, OtherGroup>();
        this.groovyGroup = new TreeMap<String, SourceGroup>();
        this.scalaGroup = new TreeMap<String, SourceGroup>();
        NbMavenProject.addPropertyChangeListener(this.project, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    MavenSourcesImpl.this.checkChanges(true, true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChanges(boolean bl, boolean bl2) {
        boolean bl3 = false;
        Object object = this.lock;
        synchronized (object) {
            MavenProject mavenProject = this.project.getOriginalMavenProject();
            FileObject fileObject = FileUtilities.convertStringToFileObject(mavenProject.getBuild().getSourceDirectory());
            bl3 |= this.checkSourceGroupCache(fileObject, NAME_SOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Sources"), this.javaGroup);
            fileObject = FileUtilities.convertStringToFileObject(mavenProject.getBuild().getTestSourceDirectory());
            bl3 |= this.checkSourceGroupCache(fileObject, NAME_TESTSOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Test_Sources"), this.javaGroup);
            bl3 |= this.checkGeneratedGroupsCache(this.project.getGeneratedSourceRoots());
            fileObject = FileUtilities.convertURItoFileObject(this.project.getGroovyDirectory(false));
            bl3 |= this.checkSourceGroupCache(fileObject, NAME_GROOVYSOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_GroovySources"), this.groovyGroup);
            fileObject = FileUtilities.convertURItoFileObject(this.project.getGroovyDirectory(true));
            bl3 |= this.checkSourceGroupCache(fileObject, NAME_GROOVYTESTSOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Test_GroovySources"), this.groovyGroup);
            fileObject = FileUtilities.convertURItoFileObject(this.project.getScalaDirectory(false));
            bl3 |= this.checkSourceGroupCache(fileObject, NAME_SCALASOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_ScalaSources"), this.scalaGroup);
            fileObject = FileUtilities.convertURItoFileObject(this.project.getScalaDirectory(true));
            bl3 |= this.checkSourceGroupCache(fileObject, NAME_SCALATESTSOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Test_ScalaSources"), this.scalaGroup);
            if (bl2) {
                bl3 |= this.checkOtherGroupsCache(this.project.getOtherRoots(false), false);
                bl3 |= this.checkOtherGroupsCache(this.project.getOtherRoots(true), true);
            }
        }
        if (bl3 && bl) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        Object object = this.listeners;
        synchronized (object) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String string) {
        if ("generic".equals(string)) {
            return new SourceGroup[]{GenericSources.group((Project)this.project, (FileObject)this.project.getProjectDirectory(), (String)NAME_PROJECTROOT, (String)((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName(), null, null)};
        }
        if ("java".equals(string)) {
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            SourceGroup[] sourceGroupArray = this.lock;
            synchronized (this.lock) {
                this.checkChanges(false, false);
                arrayList.addAll(this.javaGroup.values());
                // ** MonitorExit[var3_7] (shouldn't be in output)
                sourceGroupArray = new SourceGroup[arrayList.size()];
                sourceGroupArray = arrayList.toArray(sourceGroupArray);
                return sourceGroupArray;
            }
        }
        if (TYPE_GEN_SOURCES.equals(string)) {
            URI[] uRIArray = this.project.getGeneratedSourceRoots();
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            SourceGroup[] sourceGroupArray = this.lock;
            synchronized (this.lock) {
                this.checkGeneratedGroupsCache(uRIArray);
                arrayList.addAll(this.genSrcGroup.values());
                // ** MonitorExit[var4_13] (shouldn't be in output)
                sourceGroupArray = new SourceGroup[arrayList.size()];
                sourceGroupArray = arrayList.toArray(sourceGroupArray);
                return sourceGroupArray;
            }
        }
        if (TYPE_OTHER.equals(string) || TYPE_TEST_OTHER.equals(string)) {
            boolean bl = TYPE_TEST_OTHER.equals(string);
            ArrayList<OtherGroup> arrayList = new ArrayList<OtherGroup>();
            File[] fileArray = this.project.getOtherRoots(bl);
            SourceGroup[] sourceGroupArray = this.lock;
            synchronized (this.lock) {
                this.checkOtherGroupsCache(fileArray, bl);
                if (bl && !this.otherTestGroups.isEmpty()) {
                    arrayList.addAll(this.otherTestGroups.values());
                } else if (!bl && !this.otherMainGroups.isEmpty()) {
                    arrayList.addAll(this.otherMainGroups.values());
                }
                // ** MonitorExit[var5_16] (shouldn't be in output)
                sourceGroupArray = new SourceGroup[arrayList.size()];
                sourceGroupArray = arrayList.toArray(sourceGroupArray);
                return sourceGroupArray;
            }
        }
        if (TYPE_GROOVY.equals(string)) {
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            SourceGroup[] sourceGroupArray = this.lock;
            synchronized (this.lock) {
                this.checkChanges(false, false);
                arrayList.addAll(this.groovyGroup.values());
                // ** MonitorExit[var3_10] (shouldn't be in output)
                sourceGroupArray = new SourceGroup[arrayList.size()];
                sourceGroupArray = arrayList.toArray(sourceGroupArray);
                return sourceGroupArray;
            }
        }
        if (TYPE_SCALA.equals(string)) {
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            SourceGroup[] sourceGroupArray = this.lock;
            synchronized (this.lock) {
                this.checkChanges(false, false);
                arrayList.addAll(this.scalaGroup.values());
                // ** MonitorExit[var3_11] (shouldn't be in output)
                sourceGroupArray = new SourceGroup[arrayList.size()];
                sourceGroupArray = arrayList.toArray(sourceGroupArray);
                return sourceGroupArray;
            }
        }
        if ("resources".equals(string)) {
            return this.getOrCreateResourceSourceGroup(false);
        }
        return new SourceGroup[0];
    }

    private SourceGroup[] getOrCreateResourceSourceGroup(boolean bl) {
        URI[] uRIArray = this.project.getResources(bl);
        if (uRIArray.length > 0) {
            ArrayList<URI> arrayList = new ArrayList<URI>();
            ArrayList<SourceGroup> arrayList2 = new ArrayList<SourceGroup>();
            for (URI uRI : uRIArray) {
                FileObject fileObject = FileUtilities.convertURItoFileObject(uRI);
                if (fileObject == null) {
                    arrayList.add(uRI);
                    continue;
                }
                arrayList2.add(GenericSources.group((Project)this.project, (FileObject)fileObject, (String)"resources", (String)NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Project_Resources"), null, null));
            }
            if (arrayList2.size() == 0) {
                File file = new File((URI)arrayList.get(0));
                FileObject fileObject = null;
                try {
                    fileObject = FileUtil.createFolder((File)file);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                arrayList2.add(GenericSources.group((Project)this.project, (FileObject)fileObject, (String)"resources", (String)NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Project_Resources"), null, null));
            }
            return arrayList2.toArray(new SourceGroup[0]);
        }
        return new SourceGroup[0];
    }

    private boolean checkSourceGroupCache(FileObject fileObject, String string, String string2, Map<String, SourceGroup> map) {
        SourceGroup sourceGroup = map.get(string);
        if (fileObject == null && sourceGroup != null) {
            map.remove(string);
            return true;
        }
        if (fileObject == null) {
            return false;
        }
        boolean bl = false;
        if (sourceGroup == null) {
            sourceGroup = GenericSources.group((Project)this.project, (FileObject)fileObject, (String)string, (String)string2, null, null);
            map.put(string, sourceGroup);
            bl = true;
        } else if (!sourceGroup.getRootFolder().equals(fileObject)) {
            sourceGroup = GenericSources.group((Project)this.project, (FileObject)fileObject, (String)string, (String)string2, null, null);
            map.put(string, sourceGroup);
            bl = true;
        }
        return bl;
    }

    private boolean checkGeneratedGroupsCache(URI[] uRIArray) {
        boolean bl = false;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (URI uRI : uRIArray) {
            File file = FileUtil.normalizeFile((File)new File(uRI));
            FileObject fileObject = FileUtil.toFileObject((File)file);
            bl |= this.checkGeneratedGroupCache(fileObject, file, file.getName());
            arrayList.add(file);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.genSrcGroup.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (arrayList.contains(file)) continue;
            this.genSrcGroup.remove(file);
            bl = true;
        }
        return bl;
    }

    private boolean checkGeneratedGroupCache(FileObject fileObject, File file, String string) {
        SourceGroup sourceGroup = this.genSrcGroup.get(file);
        if (fileObject == null && sourceGroup != null) {
            this.genSrcGroup.remove(file);
            return true;
        }
        if (fileObject == null) {
            return false;
        }
        boolean bl = false;
        if (sourceGroup == null) {
            sourceGroup = new GeneratedGroup(this.project, fileObject, NAME_GENERATED_SOURCE + string, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Generated_Sources", (Object)string));
            this.genSrcGroup.put(file, sourceGroup);
            bl = true;
        } else if (!sourceGroup.getRootFolder().isValid() || !sourceGroup.getRootFolder().equals(fileObject)) {
            sourceGroup = new GeneratedGroup(this.project, fileObject, NAME_GENERATED_SOURCE + string, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Generated_Sources", (Object)string));
            this.genSrcGroup.put(file, sourceGroup);
            bl = true;
        }
        return bl;
    }

    private boolean checkOtherGroupsCache(File[] fileArray, boolean bl) {
        boolean bl2 = false;
        HashSet<File> hashSet = new HashSet<File>(bl ? this.otherTestGroups.keySet() : this.otherMainGroups.keySet());
        hashSet.removeAll(Arrays.asList(fileArray));
        URI[] uRIArray = this.project.getResources(bl);
        HashSet<File> hashSet2 = new HashSet<File>();
        for (URI comparable : uRIArray) {
            hashSet2.add(new File(comparable));
        }
        for (Comparable<URI> comparable : fileArray) {
            bl2 |= this.checkOtherGroup((File)comparable, (Set<File>)hashSet2, bl);
        }
        for (File file : hashSet) {
            bl2 |= this.checkOtherGroup(file, hashSet2, bl);
        }
        return bl2;
    }

    private boolean checkOtherGroup(File file, Set<File> set, boolean bl) {
        boolean bl2;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null && !fileObject.isFolder()) {
            fileObject = null;
        }
        Map<File, OtherGroup> map = bl ? this.otherTestGroups : this.otherMainGroups;
        OtherGroup otherGroup = map.get(file);
        boolean bl3 = set.contains(file);
        boolean bl4 = bl2 = otherGroup != null && otherGroup.getResource() != null;
        if (fileObject == null && otherGroup != null || fileObject != null && otherGroup != null && bl2 && !bl3) {
            map.remove(file);
            return true;
        }
        if (fileObject == null) {
            return false;
        }
        boolean bl5 = false;
        if (otherGroup == null || !otherGroup.getRootFolder().isValid() || !otherGroup.getRootFolder().equals(fileObject) || bl3 != bl2) {
            otherGroup = new OtherGroup(this.project, fileObject, "Resource" + (bl ? "Test" : "Main") + fileObject.getNameExt(), fileObject.getName(), bl);
            map.put(file, otherGroup);
            bl5 = true;
        }
        return bl5;
    }

    public SourceGroup createSourceGroup(String string, String string2) {
        assert (string != null);
        MavenProject mavenProject = this.project.getOriginalMavenProject();
        File file = null;
        if ("resources".equals(string)) {
            boolean bl = "main".equals(string2);
            SourceGroup[] sourceGroupArray = this.getOrCreateResourceSourceGroup(!bl);
            if (sourceGroupArray.length > 0) {
                return sourceGroupArray[0];
            }
            return null;
        }
        if ("java".equals(string)) {
            if ("main".equals(string2)) {
                file = FileUtilities.convertStringToFile(mavenProject.getBuild().getSourceDirectory());
            }
            if ("test".equals(string2)) {
                file = FileUtilities.convertStringToFile(mavenProject.getBuild().getTestSourceDirectory());
            }
        }
        if (file != null) {
            SourceGroup[] sourceGroupArray;
            file.mkdirs();
            FileUtil.refreshFor((File[])new File[]{file});
            this.checkChanges(false, true);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            assert (fileObject != null);
            for (SourceGroup sourceGroup : sourceGroupArray = this.getSourceGroups(string)) {
                if (!fileObject.equals(sourceGroup.getRootFolder())) continue;
                return sourceGroup;
            }
        }
        return null;
    }

    public boolean canCreateSourceGroup(String string, String string2) {
        return !(!"resources".equals(string) && !"java".equals(string) || !"main".equals(string2) && !"test".equals(string2));
    }

    public static final class GeneratedGroup
    implements SourceGroup {
        private final FileObject rootFolder;
        private File rootFile;
        private final String name;
        private final String displayName;
        private final Icon icon = null;
        private final Icon openedIcon = null;
        private NbMavenProjectImpl project;

        GeneratedGroup(NbMavenProjectImpl nbMavenProjectImpl, FileObject fileObject, String string, String string2) {
            this.project = nbMavenProjectImpl;
            this.rootFolder = fileObject;
            this.rootFile = FileUtil.toFile((FileObject)this.rootFolder);
            this.name = string;
            this.displayName = string2 != null ? string2 : NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Root_not_defined");
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public File getRootFolderFile() {
            return this.rootFile;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean bl) {
            return bl ? this.icon : this.openedIcon;
        }

        public boolean contains(FileObject fileObject) {
            if (fileObject != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)fileObject)) {
                throw new IllegalArgumentException();
            }
            if (this.project != null) {
                if (fileObject.isFolder() && fileObject != this.project.getProjectDirectory() && ProjectManager.getDefault().isProject(fileObject)) {
                    return false;
                }
                if (FileOwnerQuery.getOwner((FileObject)fileObject) != this.project) {
                    return false;
                }
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OtherGroup
    implements SourceGroup {
        private final FileObject rootFolder;
        private File rootFile;
        private final String name;
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;
        private NbMavenProjectImpl project;
        private Resource resource;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        OtherGroup(NbMavenProjectImpl nbMavenProjectImpl, FileObject fileObject, String string, String string2, boolean bl) {
            this.project = nbMavenProjectImpl;
            this.rootFolder = fileObject;
            this.rootFile = FileUtil.toFile((FileObject)this.rootFolder);
            this.resource = this.checkResource(fileObject, bl ? this.project.getOriginalMavenProject().getTestResources() : this.project.getOriginalMavenProject().getResources());
            if (this.resource != null) {
                Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/others-badge.png", (boolean)true);
                this.icon = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(false), (Image)image, (int)8, (int)8));
                this.openedIcon = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(true), (Image)image, (int)8, (int)8));
                this.displayName = this.name = FileUtilities.relativizeFile(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), FileUtilities.convertStringToFile(this.resource.getDirectory()));
            } else {
                this.icon = ImageUtilities.image2Icon((Image)NodeUtils.getTreeFolderIcon(false));
                this.openedIcon = ImageUtilities.image2Icon((Image)NodeUtils.getTreeFolderIcon(true));
                this.name = string;
                this.displayName = string2 != null ? string2 : NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Root_not_defined");
            }
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public File getRootFolderFile() {
            return this.rootFile;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (this.resource != null && this.resource.getTargetPath() != null) {
                return this.displayName + " -> " + this.resource.getTargetPath();
            }
            return this.displayName;
        }

        public Icon getIcon(boolean bl) {
            return bl ? this.icon : this.openedIcon;
        }

        public boolean contains(FileObject fileObject) {
            File file;
            if (fileObject != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)fileObject)) {
                throw new IllegalArgumentException();
            }
            if (this.project != null) {
                if (fileObject.isFolder() && fileObject != this.project.getProjectDirectory() && ProjectManager.getDefault().isProject(fileObject)) {
                    return false;
                }
                if (FileOwnerQuery.getOwner((FileObject)fileObject) != this.project) {
                    return false;
                }
            }
            if ((file = FileUtil.toFile((FileObject)fileObject)) != null) {
                return SharabilityQuery.getSharability((File)file) != 2;
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        private Resource checkResource(FileObject fileObject, List<Resource> list) {
            for (Resource resource : list) {
                URI uRI = FileUtilities.getDirURI(this.project.getProjectDirectory(), resource.getDirectory());
                FileObject fileObject2 = FileUtilities.convertURItoFileObject(uRI);
                if (fileObject2 == null || !fileObject2.equals(fileObject)) continue;
                return resource;
            }
            return null;
        }
    }
}

