/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModInstall
extends ModuleInstall
implements ErrorHandler,
EntityResolver {
    private static int MILIS_IN_SEC = 1000;
    private static int MILIS_IN_MIN = MILIS_IN_SEC * 60;
    private transient PropertyChangeListener projectsListener;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.maven.ModuleInstall");

    public void restored() {
        super.restored();
        try {
            Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/maven/touchme");
            preferences.put("touch", "me");
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
        this.disableOldModules();
        this.projectsListener = new OpenProjectsListener();
        OpenProjects.getDefault().addPropertyChangeListener(this.projectsListener);
        if (this.existsDefaultIndexLocation()) {
            final int n = RepositoryPreferences.getInstance().getIndexUpdateFrequency();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    List list = RepositoryPreferences.getInstance().getRepositoryInfos();
                    for (RepositoryInfo repositoryInfo : list) {
                        if (!repositoryInfo.isRemoteDownloadable() && !repositoryInfo.isLocal() || n == 3) continue;
                        boolean bl = false;
                        if (n == 2) {
                            LOGGER.finer("Index At Startup :" + repositoryInfo.getId());
                            bl = true;
                        } else if (n == 1 && ModInstall.this.checkDiff(repositoryInfo.getId(), 86400000L)) {
                            LOGGER.finer("Index Once a Day :" + repositoryInfo.getId());
                            bl = true;
                        } else if (n == 0 && ModInstall.this.checkDiff(repositoryInfo.getId(), 604800000L)) {
                            LOGGER.finer("Index once a Week :" + repositoryInfo.getId());
                            bl = true;
                        }
                        if (!bl || !repositoryInfo.isRemoteDownloadable()) continue;
                        RepositoryIndexer.indexRepo((RepositoryInfo)repositoryInfo);
                    }
                }
            }, MILIS_IN_MIN * 2);
        }
    }

    private boolean existsDefaultIndexLocation() {
        String string = System.getProperty("netbeans.user");
        assert (string != null);
        File file = new File(new File(new File(string, "var"), "cache"), "mavenindex");
        return file.exists() && file.isDirectory();
    }

    private boolean checkDiff(String string, long l) {
        Date date = RepositoryPreferences.getInstance().getLastIndexUpdate(string);
        Date date2 = new Date();
        LOGGER.finer("Check Date Diff :" + string);
        LOGGER.finer("Last Indexed Date :" + SimpleDateFormat.getInstance().format(date));
        LOGGER.finer("Now :" + SimpleDateFormat.getInstance().format(date2));
        long l2 = date2.getTime() - date.getTime();
        LOGGER.finer("Diff :" + l2);
        return l2 < 0L || l2 > l;
    }

    public void uninstalled() {
        super.uninstalled();
        if (this.projectsListener != null) {
            OpenProjects.getDefault().removePropertyChangeListener(this.projectsListener);
        }
    }

    private void disableOldModules() {
        Runnable runnable = new Runnable(){

            public void run() {
                final ArrayList<String> arrayList = new ArrayList<String>();
                Collection collection = Lookup.getDefault().lookupAll(ModuleInfo.class);
                for (ModuleInfo moduleInfo : collection) {
                    if (!moduleInfo.getCodeNameBase().startsWith("org.codehaus.mevenide")) continue;
                    arrayList.add(moduleInfo.getCodeNameBase());
                }
                try {
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            boolean bl = false;
                            block17: for (String string : arrayList) {
                                FileLock fileLock = null;
                                OutputStream outputStream = null;
                                try {
                                    String string2 = "Modules/" + string.replace('.', '-') + ".xml";
                                    FileObject fileObject = FileUtil.getConfigFile((String)string2);
                                    if (fileObject == null) continue;
                                    Document document = ModInstall.this.readModuleDocument(fileObject);
                                    NodeList nodeList = document.getDocumentElement().getElementsByTagName("param");
                                    int n = nodeList.getLength();
                                    boolean bl2 = false;
                                    for (int i = 0; i < n; ++i) {
                                        Element element = (Element)nodeList.item(i);
                                        if (!"enabled".equals(element.getAttribute("name"))) continue;
                                        Text text = (Text)element.getChildNodes().item(0);
                                        String string3 = text.getNodeValue();
                                        if (!"true".equals(string3)) continue block17;
                                        bl2 = true;
                                        text.setNodeValue("false");
                                        break;
                                    }
                                    if (bl2 && !bl) {
                                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModInstall.class, (String)"MSG_Install_Warning"));
                                        message.setTitle(NbBundle.getMessage(ModInstall.class, (String)"MSG_Install_Warning_Title"));
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                                        bl = true;
                                    }
                                    fileLock = fileObject.lock();
                                    outputStream = fileObject.getOutputStream(fileLock);
                                    XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                                }
                                catch (Exception exception) {
                                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                                }
                                finally {
                                    if (outputStream != null) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (fileLock == null) continue;
                                    fileLock.releaseLock();
                                }
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    private Document readModuleDocument(FileObject fileObject) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(this);
        documentBuilder.setErrorHandler(this);
        InputStream inputStream = fileObject.getInputStream();
        Document document = documentBuilder.parse(inputStream);
        inputStream.close();
        return document;
    }

    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    public void error(SAXParseException sAXParseException) {
        ErrorManager.getDefault().notify(1, (Throwable)sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        ErrorManager.getDefault().notify(1, (Throwable)sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        ErrorManager.getDefault().notify(1, (Throwable)sAXParseException);
    }

    private static class OpenProjectsListener
    implements PropertyChangeListener {
        private OpenProjectsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projectArray.length; ++i) {
                List list;
                NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)projectArray[i].getLookup().lookup(NbMavenProjectImpl.class);
                if (nbMavenProjectImpl == null || (list = nbMavenProjectImpl.getOriginalMavenProject().getRemoteArtifactRepositories()) == null) continue;
                for (ArtifactRepository artifactRepository : list) {
                    if (RepositoryPreferences.getInstance().getRepositoryInfoById(artifactRepository.getId()) != null) continue;
                    RepositoryInfo repositoryInfo = new RepositoryInfo(artifactRepository.getId(), "nexus", artifactRepository.getId() + " " + NbBundle.getMessage(ModInstall.class, (String)"LBL_REPOSITORY"), null, artifactRepository.getUrl(), null);
                    RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(repositoryInfo);
                }
            }
        }
    }
}

