/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.extension.ExtensionManagerException;
import org.apache.maven.extension.ExtensionScanningException;
import org.apache.maven.model.Resource;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reactor.MissingModuleException;
import org.apache.maven.workspace.MavenWorkspaceStore;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.maven.ActionProviderImpl;
import org.netbeans.modules.maven.CPExtender;
import org.netbeans.modules.maven.CPExtenderLookupMerger;
import org.netbeans.modules.maven.CPModifierLookupMerger;
import org.netbeans.modules.maven.CacheDirProvider;
import org.netbeans.modules.maven.LogicalViewProviderImpl;
import org.netbeans.modules.maven.M2AuxilaryConfigImpl;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.MavenSourcesImpl;
import org.netbeans.modules.maven.ProjectOpenedHookImpl;
import org.netbeans.modules.maven.ProjectProfileHandlerImpl;
import org.netbeans.modules.maven.SubprojectProviderImpl;
import org.netbeans.modules.maven.TemplateAttrProvider;
import org.netbeans.modules.maven.TestSkippingChecker;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.modules.maven.configurations.ConfigurationProviderEnabler;
import org.netbeans.modules.maven.cos.CosChecker;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.debug.DebuggerChecker;
import org.netbeans.modules.maven.debug.MavenDebuggerImpl;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenSettingsSingleton;
import org.netbeans.modules.maven.embedder.NbMavenWorkspaceStore;
import org.netbeans.modules.maven.execute.AbstractMavenExecutor;
import org.netbeans.modules.maven.execute.BackwardCompatibilityWithMevenideChecker;
import org.netbeans.modules.maven.execute.DefaultReplaceTokenProvider;
import org.netbeans.modules.maven.execute.JarPackagingRunChecker;
import org.netbeans.modules.maven.execute.PrereqCheckerMerger;
import org.netbeans.modules.maven.execute.ReactorChecker;
import org.netbeans.modules.maven.execute.UserActionGoalProvider;
import org.netbeans.modules.maven.operations.OperationsImpl;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.queries.MavenBinaryForSourceQueryImpl;
import org.netbeans.modules.maven.queries.MavenFileEncodingQueryImpl;
import org.netbeans.modules.maven.queries.MavenFileLocator;
import org.netbeans.modules.maven.queries.MavenForBinaryQueryImpl;
import org.netbeans.modules.maven.queries.MavenSharabilityQueryImpl;
import org.netbeans.modules.maven.queries.MavenSourceLevelImpl;
import org.netbeans.modules.maven.queries.MavenTestForSourceImpl;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbMavenProjectImpl
implements Project {
    public static final String PROP_PROJECT = "MavenProject";
    public static final String PROP_RESOURCE = "RESOURCES";
    private FileObject fileObject;
    private FileObject folderFileObject;
    private File projectFile;
    private Image icon;
    private Lookup lookup;
    private Updater updater1;
    private Updater updater2;
    private MavenProject project;
    private ProblemReporterImpl problemReporter;
    private Info projectInfo;
    private MavenSharabilityQueryImpl sharability;
    private SubprojectProviderImpl subs;
    private MavenProject oldProject;
    private NbMavenProject watcher;
    private ProjectState state;
    private ConfigurationProviderEnabler configEnabler;
    private M2AuxilaryConfigImpl auxiliary;
    private MavenProjectPropsImpl auxprops;
    private ProjectProfileHandler profileHandler;
    public static WatcherAccessor ACCESSOR = null;
    private static Action refreshAction;
    private static final String[] DEFAULT_FILES;
    private static final String[] USER_DIR_FILES;

    NbMavenProjectImpl(FileObject fileObject, FileObject fileObject2, File file, ProjectState projectState) throws Exception {
        this.projectFile = file;
        this.fileObject = fileObject2;
        this.folderFileObject = fileObject;
        this.projectInfo = new Info();
        this.sharability = new MavenSharabilityQueryImpl(this);
        this.watcher = ACCESSOR.createWatcher(this);
        this.subs = new SubprojectProviderImpl(this, this.watcher);
        this.lookup = new LazyLookup(this, this.watcher, this.projectInfo, this.sharability, this.subs, this.fileObject);
        this.updater1 = new Updater();
        this.updater2 = new Updater(USER_DIR_FILES);
        this.state = projectState;
        this.problemReporter = new ProblemReporterImpl(this);
        this.auxiliary = new M2AuxilaryConfigImpl(this);
        this.auxprops = new MavenProjectPropsImpl(this, this.auxiliary, this.watcher);
        this.profileHandler = new ProjectProfileHandlerImpl(this, this.auxiliary);
        this.configEnabler = new ConfigurationProviderEnabler(this, this.auxiliary, this.profileHandler);
    }

    public File getPOMFile() {
        return this.projectFile;
    }

    public NbMavenProject getProjectWatcher() {
        return this.watcher;
    }

    public ProblemReporterImpl getProblemReporter() {
        return this.problemReporter;
    }

    public synchronized MavenProject loadMavenProject(List<String> list, Properties properties) {
        return this.loadMavenProject(this.getEmbedder(), list, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MavenProject loadMavenProject(MavenEmbedder mavenEmbedder, List<String> list, Properties properties) {
        MavenExecutionResult mavenExecutionResult;
        Object object;
        block9: {
            object = new DefaultMavenExecutionRequest();
            object.addActiveProfiles(list);
            object.setPomFile(this.projectFile.getAbsolutePath());
            object.setNoSnapshotUpdates(true);
            object.setUpdateSnapshots(false);
            Properties properties2 = new Properties();
            if (properties != null) {
                properties2.putAll((Map<?, ?>)properties);
                object.setUserProperties(properties2);
            }
            object.setInteractiveMode(false);
            object.setRecursive(false);
            object.setProperties(this.createSystemPropsForProjectLoading());
            mavenExecutionResult = mavenEmbedder.readProjectWithDependencies((MavenExecutionRequest)object);
            if (mavenExecutionResult.hasExceptions()) break block9;
            MavenProject mavenProject = mavenExecutionResult.getProject();
            return mavenProject;
        }
        try {
            List list2 = mavenExecutionResult.getExceptions();
            for (Exception exception : list2) {
                Logger.getLogger(NbMavenProjectImpl.class.getName()).log(Level.INFO, "Exception thrown while loading maven project at " + this.getProjectDirectory(), exception);
            }
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(NbMavenProjectImpl.class.getName()).log(Level.INFO, "Runtime exception thrown while loading maven project at " + this.getProjectDirectory(), runtimeException);
        }
        object = InstalledFileLocator.getDefault().locate("maven2/fallback_pom.xml", null, false);
        try {
            return mavenEmbedder.readProject((File)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<String> getCurrentActiveProfiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.configEnabler.isConfigurationEnabled()) {
            arrayList.addAll(this.configEnabler.getConfigProvider().getActiveConfiguration().getActivatedProfiles());
        } else {
            List<String> list = this.profileHandler.getActiveProfiles(false);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private Properties createSystemPropsForProjectLoading() {
        Properties properties = new Properties();
        properties.setProperty("netbeans.execution", "true");
        EmbedderFactory.fillEnvVars((Properties)properties);
        properties.putAll((Map<?, ?>)AbstractMavenExecutor.excludeNetBeansProperties(System.getProperties()));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MavenProject getOriginalMavenProject() {
        if (this.project == null) {
            Object object;
            long l;
            block31: {
                Object object2;
                l = System.currentTimeMillis();
                try {
                    object2 = new DefaultMavenExecutionRequest();
                    object2.addActiveProfiles(this.getCurrentActiveProfiles());
                    object2.setPomFile(this.projectFile.getAbsolutePath());
                    object2.setNoSnapshotUpdates(true);
                    object2.setUpdateSnapshots(false);
                    object2.setInteractiveMode(false);
                    object2.setRecursive(false);
                    object2.setProperties(this.createSystemPropsForProjectLoading());
                    MavenExecutionResult mavenExecutionResult = this.getEmbedder().readProjectWithDependencies((MavenExecutionRequest)object2);
                    this.project = mavenExecutionResult.getProject();
                    if (!mavenExecutionResult.hasExceptions()) break block31;
                    for (Object e : mavenExecutionResult.getExceptions()) {
                        Object object3;
                        ProblemReport problemReport;
                        Logger.getLogger(NbMavenProjectImpl.class.getName()).log(Level.INFO, "Error on loading project " + this.projectFile.getAbsolutePath(), (Throwable)e);
                        if (e instanceof ArtifactResolutionException) {
                            problemReport = new ProblemReport(0, NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_Artifact_Resolution_problem"), ((Exception)e).getMessage(), null);
                            this.problemReporter.addReport(problemReport);
                            continue;
                        }
                        if (e instanceof ArtifactNotFoundException) {
                            problemReport = new ProblemReport(0, NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_Artifact_Not_Found"), ((Exception)e).getMessage(), null);
                            this.problemReporter.addReport(problemReport);
                            continue;
                        }
                        if (e instanceof InvalidProjectModelException) {
                            this.problemReporter.addValidatorReports((InvalidProjectModelException)e);
                            continue;
                        }
                        if (e instanceof ProjectBuildingException) {
                            this.problemReporter.addReport(new ProblemReport(0, NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_Cannot_Load_Project"), ((Exception)e).getMessage(), null));
                            continue;
                        }
                        if (e instanceof MissingModuleException) {
                            problemReport = (MissingModuleException)e;
                            object3 = new ProblemReport(0, NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_MissingSubmodule", (Object)problemReport.getModuleName()), ((Exception)e).getMessage(), null);
                            this.problemReporter.addReport((ProblemReport)object3);
                            continue;
                        }
                        if (e instanceof ExtensionScanningException) {
                            Object object4;
                            Object object5;
                            problemReport = (ExtensionScanningException)e;
                            object3 = null;
                            String string = null;
                            String string2 = null;
                            Throwable throwable = problemReport.getCause();
                            if (throwable != null && throwable instanceof ProjectBuildingException) {
                                string = NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_MissingParentPOM");
                                string2 = "http://wiki.netbeans.org/MavenMissingParentPomError";
                                object5 = (ProjectBuildingException)throwable;
                                object4 = (ArtifactNotFoundException)NbMavenProjectImpl.getCause((Exception)object5, ArtifactNotFoundException.class);
                                if (object4 != null) {
                                    object3 = NbBundle.getMessage(NbMavenProjectImpl.class, (String)"DESC_MissingParentPOM", (Object[])new String[]{object4.getGroupId(), object4.getArtifactId(), object4.getVersion(), this.repositoryListToString(object4.getRemoteRepositories())});
                                }
                            }
                            if (throwable != null && throwable instanceof ExtensionManagerException) {
                                string = NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_MissingExtensionOrPlugin");
                                string2 = "http://wiki.netbeans.org/MavenMissingExtensionPluginError";
                                object5 = (ExtensionManagerException)throwable;
                                object4 = (ArtifactNotFoundException)NbMavenProjectImpl.getCause((Exception)object5, ArtifactNotFoundException.class);
                                if (object4 != null) {
                                    object3 = NbBundle.getMessage(NbMavenProjectImpl.class, (String)"DESC_MissingExtensionOrPlugin", (Object[])new String[]{object4.getGroupId(), object4.getArtifactId(), object4.getVersion(), this.repositoryListToString(object4.getRemoteRepositories())});
                                }
                            }
                            if (string == null) {
                                string = NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_MissingSomething");
                            }
                            if (object3 == null) {
                                object3 = problemReport.getMessage();
                            }
                            if (string2 == null) {
                                string2 = "http://wiki.netbeans.org/MavenBadlyFormedProjectErrors";
                            }
                            try {
                                object5 = new OpenWikiPage(new URL(string2));
                            }
                            catch (MalformedURLException malformedURLException) {
                                Exceptions.printStackTrace((Throwable)malformedURLException);
                                object5 = null;
                            }
                            object4 = new ProblemReport(0, string, (String)object3, (Action)object5);
                            this.problemReporter.addReport((ProblemReport)object4);
                            continue;
                        }
                        Logger.getLogger(NbMavenProjectImpl.class.getName()).log(Level.INFO, "Exception thrown while loading maven project at " + this.getProjectDirectory(), (Exception)e);
                        problemReport = new ProblemReport(0, "Error reading project model", ((Exception)e).getMessage(), null);
                        this.problemReporter.addReport(problemReport);
                    }
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(NbMavenProjectImpl.class.getName()).log(Level.INFO, "Runtime exception thrown while loading maven project at " + this.getProjectDirectory(), runtimeException);
                    StringWriter stringWriter = new StringWriter();
                    object = new PrintWriter(stringWriter);
                    runtimeException.printStackTrace((PrintWriter)object);
                    ((PrintWriter)object).flush();
                    ProblemReport problemReport = new ProblemReport(0, NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_RuntimeException"), NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_RuntimeExceptionLong") + stringWriter.toString(), null);
                    this.problemReporter.addReport(problemReport);
                }
                finally {
                    if (this.project == null) {
                        object2 = InstalledFileLocator.getDefault().locate("maven2/fallback_pom.xml", null, false);
                        try {
                            this.project = this.getEmbedder().readProject((File)object2);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (this.project == null && this.oldProject != null) {
                this.project = this.oldProject;
            }
            this.oldProject = null;
            long l2 = System.currentTimeMillis();
            object = Logger.getLogger(NbMavenProjectImpl.class.getName());
            ((Logger)object).fine("Loaded project in " + (l2 - l) / 1000L + " s at " + this.getProjectDirectory().getPath());
            if (((Logger)object).isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                ((Logger)object).log(Level.FINE, "Project " + this.getProjectDirectory().getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
            }
        }
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectReload() {
        Object object;
        if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess() || SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    NbMavenProjectImpl.this.fireProjectReload();
                }
            });
            return;
        }
        try {
            object = (MavenWorkspaceStore)this.getEmbedder().getPlexusContainer().lookup("org.apache.maven.workspace.MavenWorkspaceStore");
            if (object instanceof NbMavenWorkspaceStore) {
                ((NbMavenWorkspaceStore)object).doManualClear();
            }
        }
        catch (ComponentLookupException componentLookupException) {
            Exceptions.printStackTrace((Throwable)componentLookupException);
        }
        object = this;
        synchronized (object) {
            this.oldProject = this.project;
            this.project = null;
        }
        this.problemReporter.clearReports();
        ACCESSOR.doFireReload(this.watcher);
        this.projectInfo.reset();
        this.doBaseProblemChecks();
    }

    public static void refreshLocalRepository(NbMavenProjectImpl nbMavenProjectImpl) {
        String string = nbMavenProjectImpl.getEmbedder().getLocalRepository().getBasedir();
        File file = FileUtil.normalizeFile((File)new File(string));
        FileUtil.refreshFor((File[])new File[]{file});
    }

    void doBaseProblemChecks() {
        this.problemReporter.doBaseProblemChecks(this.project);
    }

    public String getDisplayName() {
        String string = this.projectInfo.getDisplayName();
        if (string == null) {
            string = NbBundle.getMessage(NbMavenProjectImpl.class, (String)"LBL_NoProjectName");
        }
        return string;
    }

    public String getShortDescription() {
        String string = null;
        if (string == null) {
            string = this.getOriginalMavenProject().getDescription();
        }
        if (string == null) {
            string = NbBundle.getMessage(NbMavenProjectImpl.class, (String)"LBL_DefaultDescription");
        }
        return string;
    }

    Updater getProjectFolderUpdater() {
        return this.updater1;
    }

    Updater getUserFolderUpdater() {
        return this.updater2;
    }

    private Image getIcon() {
        if (this.icon == null) {
            this.icon = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/Maven2Icon.gif");
        }
        return this.icon;
    }

    public String getName() {
        String string = null;
        MavenProject mavenProject = this.getOriginalMavenProject();
        if (mavenProject != null) {
            string = mavenProject.getId();
        }
        if (string == null) {
            string = this.getProjectDirectory().getName() + " _No Project ID_";
        }
        string = string.replace(":", "_");
        return string;
    }

    public static Action createRefreshAction() {
        if (refreshAction == null) {
            refreshAction = new RefreshAction(Lookup.EMPTY);
        }
        return refreshAction;
    }

    public FileObject getProjectDirectory() {
        return this.folderFileObject;
    }

    public FileObject getHomeDirectory() {
        File file = MavenSettingsSingleton.getInstance().getM2UserDir();
        FileObject fileObject = null;
        try {
            fileObject = FileUtil.createFolder((File)file);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (fileObject == null) {
            ErrorManager.getDefault().log("Cannot convert home dir to FileObject, some functionality won't work. It's usually the case on Windows and UNC paths. The path is " + file);
        }
        return fileObject;
    }

    public String getArtifactRelativeRepositoryPath() {
        return this.getArtifactRelativeRepositoryPath(this.getOriginalMavenProject().getArtifact());
    }

    public String getTestArtifactRelativeRepositoryPath() {
        Artifact artifact = this.getOriginalMavenProject().getArtifact();
        try {
            ArtifactHandlerManager artifactHandlerManager = (ArtifactHandlerManager)this.getEmbedder().getPlexusContainer().lookup(ArtifactHandlerManager.ROLE);
            DefaultArtifact defaultArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersionRange(), Artifact.SCOPE_TEST, "test-jar", "tests", artifactHandlerManager.getArtifactHandler("test-jar"));
            return this.getArtifactRelativeRepositoryPath((Artifact)defaultArtifact);
        }
        catch (ComponentLookupException componentLookupException) {
            throw new IllegalStateException("Cannot lookup ArtifactHandlerManager, broken plexus container.", componentLookupException);
        }
    }

    public String getArtifactRelativeRepositoryPath(Artifact artifact) {
        String string = this.getEmbedder().getLocalRepository().pathOf(artifact);
        return string;
    }

    public MavenEmbedder getEmbedder() {
        return EmbedderFactory.getProjectEmbedder();
    }

    public MavenProjectPropsImpl getAuxProps() {
        return this.auxprops;
    }

    public URI[] getSourceRoots(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = bl ? this.getOriginalMavenProject().getTestCompileSourceRoots() : this.getOriginalMavenProject().getCompileSourceRoots();
        arrayList.addAll(list);
        if (!bl && this.getProjectDirectory().getFileObject("src/main/aspect") != null) {
            arrayList.add(FileUtil.toFile((FileObject)this.getProjectDirectory().getFileObject("src/main/aspect")).getAbsolutePath());
        }
        URI[] uRIArray = new URI[arrayList.size() + 2];
        int n = 0;
        for (String string : arrayList) {
            File file = FileUtil.normalizeFile((File)new File(string));
            uRIArray[n] = file.toURI();
            ++n;
        }
        uRIArray[uRIArray.length - 2] = this.getScalaDirectory(bl);
        uRIArray[uRIArray.length - 1] = this.getGroovyDirectory(bl);
        return uRIArray;
    }

    public URI[] getGeneratedSourceRoots() {
        Object[] objectArray;
        URI uRI = FileUtilities.getDirURI(this.getProjectDirectory(), "target/generated-sources");
        HashSet<URI> hashSet = new HashSet<URI>();
        File file = new File(uRI);
        if (file.exists() && file.isDirectory() && (objectArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet.add(((File)objectArray[i]).toURI());
            }
        }
        if ((objectArray = PluginPropertyUtils.getPluginPropertyList(this, "org.codehaus.mojo", "build-helper-maven-plugin", "sources", "source", "add-source")) != null && objectArray.length > 0) {
            File file2 = FileUtil.toFile((FileObject)this.getProjectDirectory());
            for (Object object : objectArray) {
                hashSet.add(FileUtilities.getDirURI(file2, (String)object));
            }
        }
        return hashSet.toArray(new URI[hashSet.size()]);
    }

    public URI getWebAppDirectory() {
        String string = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-war-plugin", "warSourceDirectory", "war");
        string = string == null ? "src/main/webapp" : string;
        return FileUtilities.getDirURI(this.getProjectDirectory(), string);
    }

    public URI getSiteDirectory() {
        String string = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-site-plugin", "siteDirectory", "site");
        string = string == null ? "src/site" : string;
        return FileUtilities.getDirURI(this.getProjectDirectory(), string);
    }

    public URI getEarAppDirectory() {
        String string = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-ear-plugin", "earSourceDirectory", "ear");
        string = string == null ? "src/main/application" : string;
        return FileUtilities.getDirURI(this.getProjectDirectory(), string);
    }

    public URI getScalaDirectory(boolean bl) {
        String string = PluginPropertyUtils.getPluginProperty(this.getOriginalMavenProject(), "org.scala.tools", "scala-maven-plugin", "sourceDir", "compile");
        string = string == null ? (bl ? "src/test/scala" : "src/main/scala") : string;
        return FileUtilities.getDirURI(this.getProjectDirectory(), string);
    }

    public URI getGroovyDirectory(boolean bl) {
        String string = bl ? "src/test/groovy" : "src/main/groovy";
        return FileUtilities.getDirURI(this.getProjectDirectory(), string);
    }

    public URI[] getResources(boolean bl) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        List list = bl ? this.getOriginalMavenProject().getTestResources() : this.getOriginalMavenProject().getResources();
        for (Resource resource : list) {
            URI uRI = FileUtilities.getDirURI(this.getProjectDirectory(), resource.getDirectory());
            arrayList.add(uRI);
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    public File[] getOtherRoots(boolean bl) {
        URI[] uRIArray;
        URI uRI = FileUtilities.getDirURI(this.getProjectDirectory(), bl ? "src/test" : "src/main");
        HashSet<File> hashSet = new HashSet<File>();
        File file = new File(uRI);
        if (file.exists()) {
            hashSet.addAll(Arrays.asList(file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return !"java".equalsIgnoreCase(string) && !"webapp".equalsIgnoreCase(string) && !"groovy".equalsIgnoreCase(string) && !"scala".equalsIgnoreCase(string) && VisibilityQuery.getDefault().isVisible(FileUtil.toFileObject((File)new File(file, string)));
                }
            })));
        }
        for (URI uRI2 : uRIArray = this.getResources(bl)) {
            File file2 = new File(uRI2);
            if (!file2.exists()) continue;
            hashSet.add(file2);
        }
        return hashSet.toArray(new File[0]);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private boolean checkForForbiddenMergers(Lookup lookup) {
        Collection collection = lookup.lookupAll(LookupMerger.class);
        for (LookupMerger lookupMerger : collection) {
            if (ProjectInformation.class.equals((Object)lookupMerger.getMergeableClass())) {
                return false;
            }
            if (SharabilityQueryImplementation.class.equals((Object)lookupMerger.getMergeableClass())) {
                return false;
            }
            if (SubprojectProvider.class.equals((Object)lookupMerger.getMergeableClass())) {
                return false;
            }
            if (!NbMavenProject.class.equals((Object)lookupMerger.getMergeableClass())) continue;
            return false;
        }
        return true;
    }

    private Lookup createBasicLookup() {
        CPExtender cPExtender = new CPExtender(this);
        Lookup lookup = Lookups.fixed((Object[])new Object[]{this.projectInfo, this, this.fileObject, new CacheDirProvider(this), new MavenForBinaryQueryImpl(this), new MavenBinaryForSourceQueryImpl(this), new ActionProviderImpl(this), this.auxiliary, this.auxprops, new MavenProjectPropsImpl.Merger(this.auxprops), this.profileHandler, new CustomizerProviderImpl(this), new LogicalViewProviderImpl(this), new ProjectOpenedHookImpl(this), new ClassPathProviderImpl(this), this.sharability, new MavenTestForSourceImpl(this), this.subs, new MavenSourcesImpl(this), new RecommendedTemplatesImpl(this), new MavenSourceLevelImpl(this), this.problemReporter, new UserActionGoalProvider(this), this.watcher, new MavenFileEncodingQueryImpl(this), new TemplateAttrProvider(this), new OperationsImpl(this, this.state), this.configEnabler, new MavenDebuggerImpl(this), new DefaultReplaceTokenProvider(this), new MavenFileLocator(this), UILookupMergerSupport.createPrivilegedTemplatesMerger(), UILookupMergerSupport.createRecommendedTemplatesMerger(), LookupProviderSupport.createSourcesMerger(), new CPExtenderLookupMerger(cPExtender), new CPModifierLookupMerger(cPExtender), new BackwardCompatibilityWithMevenideChecker(), new JarPackagingRunChecker(), new DebuggerChecker(), new CosChecker(), CosChecker.createResultChecker(), new ReactorChecker(), new PrereqCheckerMerger(), new TestSkippingChecker(), new RecommendedTemplates(){

            public String[] getRecommendedTypes() {
                return new String[]{"scala-classes"};
            }
        }});
        return lookup;
    }

    public boolean isErrorPom(MavenProject mavenProject) {
        return "error".equals(mavenProject.getArtifactId()) && "error".equals(mavenProject.getGroupId()) && "unknown".equals(mavenProject.getVersion());
    }

    public int hashCode() {
        return this.getProjectDirectory().hashCode() * 13;
    }

    public boolean equals(Object object) {
        if (object instanceof Project) {
            return this.getProjectDirectory().equals(((Project)object).getProjectDirectory());
        }
        return false;
    }

    public String toString() {
        return "Maven[" + this.fileObject.getPath() + "]";
    }

    private String repositoryListToString(List list) {
        String string = "";
        if (list != null) {
            for (Object e : list) {
                ArtifactRepository artifactRepository = (ArtifactRepository)e;
                string = string + "      " + artifactRepository.getId() + "  (" + artifactRepository.getUrl() + ")\n";
            }
        }
        return string;
    }

    private static Throwable getCause(Exception exception, Class clazz) {
        for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
            if (throwable == null || !throwable.getClass().equals(clazz)) continue;
            return throwable;
        }
        return null;
    }

    static {
        Class<NbMavenProject> clazz = NbMavenProject.class;
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DEFAULT_FILES = new String[]{"nb-configuration.xml", "pom.xml", "profiles.xml"};
        USER_DIR_FILES = new String[]{"settings.xml"};
    }

    private static class OpenWikiPage
    extends AbstractAction {
        private URL url;

        public OpenWikiPage(URL uRL) {
            this.putValue("Name", "Open Wiki page");
            this.url = uRL;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.url);
        }
    }

    private static class RefreshAction
    extends AbstractAction
    implements ContextAwareAction {
        private Lookup context;

        public RefreshAction(Lookup lookup) {
            this.context = lookup;
            Collection collection = this.context.lookupAll(NbMavenProjectImpl.class);
            if (collection.size() > 1) {
                this.putValue("Name", NbBundle.getMessage(NbMavenProjectImpl.class, (String)"ACT_Reload_Projects", (Object)collection.size()));
            } else {
                this.putValue("Name", NbBundle.getMessage(NbMavenProjectImpl.class, (String)"ACT_Reload_Project"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EmbedderFactory.resetProjectEmbedder();
            for (NbMavenProjectImpl nbMavenProjectImpl : this.context.lookupAll(NbMavenProjectImpl.class)) {
                NbMavenProject.fireMavenProjectReload(nbMavenProjectImpl);
            }
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new RefreshAction(lookup);
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] JAR_APPLICATION_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "gui-java-application", "java-beans", "oasis-XML-catalogs", "XML", "web-service-clients", "wsdl", "junit", "simple-files"};
        private static final String[] JAR_PRIVILEGED_NAMES = new String[]{"Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Classes/Interface.java", "Templates/GUIForms/JPanel.java", "Templates/GUIForms/JFrame.java", "Templates/WebServices/WebServiceClient"};
        private static final String[] POM_APPLICATION_TYPES = new String[]{"XML", "simple-files"};
        private static final String[] POM_PRIVILEGED_NAMES = new String[]{"Templates/XML/XMLWizard", "Templates/Other/Folder"};
        private static final String[] ALL_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "java-beans", "j2ee-types", "gui-java-application", "java-beans", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "web-service-clients", "wsdl", "servlet-types", "web-types", "junit", "simple-files", "ear-types"};
        private static final String[] GENERIC_WEB_TYPES = new String[]{"java-classes", "java-main-class", "java-beans", "oasis-XML-catalogs", "XML", "wsdl", "junit", "simple-files"};
        private static final String[] GENERIC_EJB_TYPES = new String[]{"java-classes", "wsdl", "java-beans", "java-main-class", "oasis-XML-catalogs", "XML", "junit", "simple-files"};
        private static final String[] GENERIC_EAR_TYPES = new String[]{"XML", "wsdl", "simple-files"};
        private List<String> prohibited;
        private NbMavenProjectImpl project;

        RecommendedTemplatesImpl(NbMavenProjectImpl nbMavenProjectImpl) {
            this.project = nbMavenProjectImpl;
            this.prohibited = new ArrayList<String>();
            this.prohibited.add("ear");
            this.prohibited.add("ejb");
            this.prohibited.add("war");
            this.prohibited.add("nbm");
        }

        public String[] getRecommendedTypes() {
            String string = this.project.getProjectWatcher().getPackagingType();
            if (string == null) {
                string = "jar";
            }
            if ("pom".equals(string = string.trim())) {
                return POM_APPLICATION_TYPES;
            }
            if ("jar".equals(string)) {
                return JAR_APPLICATION_TYPES;
            }
            if ("nbm".equals(string)) {
                return JAR_APPLICATION_TYPES;
            }
            if ("war".equals(string)) {
                return GENERIC_WEB_TYPES;
            }
            if ("ejb".equals(string)) {
                return GENERIC_EJB_TYPES;
            }
            if ("ear".equals(string)) {
                return GENERIC_EAR_TYPES;
            }
            if (this.prohibited.contains(string)) {
                return new String[0];
            }
            return ALL_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            String string = this.project.getProjectWatcher().getPackagingType();
            if (string == null) {
                string = "jar";
            }
            if ("pom".equals(string = string.trim())) {
                return POM_PRIVILEGED_NAMES;
            }
            if (this.prohibited.contains(string)) {
                return new String[0];
            }
            return JAR_PRIVILEGED_NAMES;
        }
    }

    class Updater
    implements FileChangeListener {
        private String[] filesToWatch;
        private long lastTime = 0L;
        private FileObject folder;

        Updater() {
            this(DEFAULT_FILES);
        }

        Updater(String[] stringArray) {
            this.filesToWatch = stringArray;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            String string;
            if (!fileEvent.getFile().isFolder() && Arrays.binarySearch(this.filesToWatch, string = fileEvent.getFile().getNameExt()) != -1 && this.lastTime < fileEvent.getTime()) {
                this.lastTime = System.currentTimeMillis();
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            String string;
            if (fileEvent.getFile().isFolder() && Arrays.binarySearch(this.filesToWatch, string = fileEvent.getFile().getNameExt()) != -1 && this.lastTime < fileEvent.getTime()) {
                this.lastTime = System.currentTimeMillis();
                fileEvent.getFile().addFileChangeListener((FileChangeListener)this);
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (!fileEvent.getFile().isFolder()) {
                this.lastTime = System.currentTimeMillis();
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        void attachAll(FileObject fileObject) {
            if (fileObject != null) {
                this.folder = fileObject;
                fileObject.addFileChangeListener((FileChangeListener)this);
                for (String string : this.filesToWatch) {
                    FileObject fileObject2 = fileObject.getFileObject(string);
                    if (fileObject2 == null) continue;
                    fileObject2.addFileChangeListener((FileChangeListener)this);
                }
            }
        }

        void detachAll() {
            if (this.folder != null) {
                this.folder.removeFileChangeListener((FileChangeListener)this);
                for (String string : this.filesToWatch) {
                    FileObject fileObject = this.folder.getFileObject(string);
                    if (fileObject == null) continue;
                    fileObject.removeFileChangeListener((FileChangeListener)this);
                }
                this.folder = null;
            }
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        public void reset() {
            this.firePropertyChange("displayName");
            this.pcs.firePropertyChange("icon", null, this.getIcon());
        }

        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
        }

        public String getName() {
            String string = NbMavenProjectImpl.this.getName();
            return string;
        }

        public String getDisplayName() {
            MavenProject mavenProject = NbMavenProjectImpl.this.getOriginalMavenProject();
            if (NbMavenProjectImpl.this.isErrorPom(mavenProject)) {
                return NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_FailedLoadingProject");
            }
            String string = mavenProject.getName();
            if (string == null) {
                String string2 = mavenProject.getGroupId();
                String string3 = mavenProject.getArtifactId();
                string = string2 != null && string3 != null ? string2 + ":" + string3 : NbBundle.getMessage(NbMavenProjectImpl.class, (String)"TXT_Maven_project_at", (Object)NbMavenProjectImpl.this.getProjectDirectory().getPath());
            }
            string = string + " (" + mavenProject.getPackaging() + ")";
            return string;
        }

        public Icon getIcon() {
            return ImageUtilities.image2Icon((Image)NbMavenProjectImpl.this.getIcon());
        }

        public Project getProject() {
            return NbMavenProjectImpl.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LazyLookup
    extends ProxyLookup {
        private Lookup lookup;
        boolean initialized = false;

        LazyLookup(Project project, NbMavenProject nbMavenProject, ProjectInformation projectInformation, SharabilityQueryImplementation sharabilityQueryImplementation, SubprojectProvider subprojectProvider, FileObject fileObject) {
            this.setLookups(new Lookup[]{Lookups.fixed((Object[])new Object[]{project, nbMavenProject, projectInformation, sharabilityQueryImplementation, subprojectProvider, fileObject})});
        }

        protected synchronized void beforeLookup(Lookup.Template<?> template) {
            if (!(this.initialized || ProjectInformation.class.equals((Object)template.getType()) || NbMavenProject.class.equals((Object)template.getType()) || NbMavenProjectImpl.class.equals((Object)template.getType()) || Project.class.equals((Object)template.getType()) || SharabilityQueryImplementation.class.equals((Object)template.getType()) || SubprojectProvider.class.equals((Object)template.getType()))) {
                this.initialized = true;
                this.lookup = NbMavenProjectImpl.this.createBasicLookup();
                this.setLookups(new Lookup[]{this.lookup});
                Lookup lookup = LookupProviderSupport.createCompositeLookup((Lookup)this.lookup, (String)"Projects/org-netbeans-modules-maven/Lookup");
                assert (NbMavenProjectImpl.this.checkForForbiddenMergers(lookup)) : "Cannot have a LookupMerger for ProjectInformation or SharabilityQueryImplementation";
                this.setLookups(new Lookup[]{lookup});
            }
            super.beforeLookup(template);
        }
    }

    public static abstract class WatcherAccessor {
        public abstract NbMavenProject createWatcher(NbMavenProjectImpl var1);

        public abstract void doFireReload(NbMavenProject var1);
    }
}

