/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import hidden.org.codehaus.plexus.util.IOUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Model;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.io.xpp3.ProfilesXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.build.model.ModelLineage;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenSettingsSingleton;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.profile.ProfilesModel;
import org.netbeans.modules.maven.model.profile.ProfilesModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProfileHandlerImpl
implements ProjectProfileHandler {
    private static final String PROFILES = "profiles";
    private static final String ACTIVEPROFILES = "activeProfiles";
    private static final String SEPERATOR = " ";
    private static final String NAMESPACE = null;
    private List<String> privateProfiles = new ArrayList<String>();
    private List<String> sharedProfiles = new ArrayList<String>();
    private AuxiliaryConfiguration ac;
    private NbMavenProjectImpl nmp;

    ProjectProfileHandlerImpl(NbMavenProjectImpl nbMavenProjectImpl, AuxiliaryConfiguration auxiliaryConfiguration) {
        this.nmp = nbMavenProjectImpl;
        this.ac = auxiliaryConfiguration;
        this.privateProfiles.addAll(this.retrieveActiveProfiles(auxiliaryConfiguration, false));
        this.sharedProfiles.addAll(this.retrieveActiveProfiles(auxiliaryConfiguration, true));
    }

    @Override
    public List<String> getAllProfiles() {
        HashSet<String> hashSet = new HashSet<String>();
        ProjectProfileHandlerImpl.extractProfiles(hashSet, this.nmp.getPOMFile());
        hashSet.addAll(MavenSettingsSingleton.getInstance().createUserSettingsModel().getProfilesAsMap().keySet());
        return new ArrayList<String>(hashSet);
    }

    @Override
    public List<String> getActiveProfiles(boolean bl) {
        return new ArrayList<String>(bl ? this.sharedProfiles : this.privateProfiles);
    }

    @Override
    public List<String> getMergedActiveProfiles(boolean bl) {
        FileObject fileObject;
        String string;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        MavenProject mavenProject = this.nmp.getOriginalMavenProject();
        List list = mavenProject.getActiveProfiles();
        for (Object object2 : list) {
            hashSet.add(object2.getId());
        }
        List list2 = MavenSettingsSingleton.getInstance().createUserSettingsModel().getActiveProfiles();
        object2 = list2.iterator();
        while (object2.hasNext()) {
            string = (String)object2.next();
            hashSet.add(string);
        }
        object2 = FileUtil.normalizeFile((File)mavenProject.getBasedir());
        string = FileUtil.toFileObject((File)object2);
        if (string != null && (fileObject = string.getFileObject("profiles.xml")) != null) {
            List list3;
            ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject);
            ProfilesModel profilesModel = ProfilesModelFactory.getDefault().getModel(modelSource);
            if (Model.State.VALID.equals((Object)profilesModel.getState()) && (list3 = profilesModel.getProfilesRoot().getActiveProfiles()) != null) {
                hashSet.addAll(list3);
            }
        }
        hashSet.addAll(this.getActiveProfiles(bl));
        return new ArrayList<String>(hashSet);
    }

    @Override
    public void disableProfile(String string, boolean bl) {
        Object object;
        String string2;
        Element element = this.ac.getConfigurationFragment(PROFILES, NAMESPACE, bl);
        if (element == null) {
            string2 = "project-private";
            object = XMLUtil.createDocument((String)string2, (String)NAMESPACE, null, null);
            element = object.createElementNS(NAMESPACE, PROFILES);
        }
        if ((string2 = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES)) != null && string2.length() > 0) {
            object = new StringTokenizer(string2, SEPERATOR);
            HashSet<String> hashSet = new HashSet<String>(((StringTokenizer)object).countTokens());
            while (((StringTokenizer)object).hasMoreTokens()) {
                hashSet.add(((StringTokenizer)object).nextToken());
            }
            hashSet.remove(string);
            StringBuffer stringBuffer = new StringBuffer();
            for (String string3 : hashSet) {
                stringBuffer.append(string3).append(SEPERATOR);
            }
            element.setAttributeNS(NAMESPACE, ACTIVEPROFILES, stringBuffer.toString().trim());
        }
        this.ac.putConfigurationFragment(element, bl);
        if (bl) {
            this.sharedProfiles.remove(string);
        } else {
            this.privateProfiles.remove(string);
        }
    }

    @Override
    public void enableProfile(String string, boolean bl) {
        String string2;
        Element element = this.ac.getConfigurationFragment(PROFILES, NAMESPACE, bl);
        if (element == null) {
            string2 = "project-private";
            Document document = XMLUtil.createDocument((String)string2, (String)NAMESPACE, null, null);
            element = document.createElementNS(NAMESPACE, PROFILES);
        }
        string2 = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES);
        element.setAttributeNS(NAMESPACE, ACTIVEPROFILES, string2 + SEPERATOR + string);
        this.ac.putConfigurationFragment(element, bl);
        if (bl) {
            if (!this.sharedProfiles.contains(string)) {
                this.sharedProfiles.add(string);
            }
        } else if (!this.privateProfiles.contains(string)) {
            this.privateProfiles.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractProfiles(Set<String> set, File file) {
        FileObject fileObject;
        ProjectProfileHandlerImpl.extractProfilesFromModelLineage(file, set);
        File file2 = FileUtil.normalizeFile((File)file.getParentFile());
        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
        if (fileObject2 != null && (fileObject = fileObject2.getFileObject("profiles.xml")) != null) {
            ProfilesXpp3Reader profilesXpp3Reader = new ProfilesXpp3Reader();
            InputStream inputStream = null;
            try {
                inputStream = fileObject.getInputStream();
                ProfilesRoot profilesRoot = profilesXpp3Reader.read(inputStream);
                List list = profilesRoot.getProfiles();
                for (Profile profile : list) {
                    set.add(profile.getId());
                }
            }
            catch (Exception exception) {
                Logger.getLogger(ProjectProfileHandlerImpl.class.getName()).log(Level.FINE, "Error while retrieving profiles from profiles.xml file. Ignore.", exception);
            }
            finally {
                IOUtil.close((InputStream)inputStream);
            }
        }
    }

    private static void extractProfilesFromModelLineage(File file, Set<String> set) {
        try {
            Object object;
            Iterator iterator;
            Object object2;
            Object object3;
            ModelLineage modelLineage = EmbedderFactory.createModelLineage((File)file, (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (boolean)true);
            Iterator iterator2 = modelLineage.modelIterator();
            while (iterator2.hasNext()) {
                object3 = (Model)iterator2.next();
                object2 = object3.getProfiles();
                if (object2 == null) continue;
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (org.apache.maven.model.Profile)iterator.next();
                    set.add(object.getId());
                }
            }
            if (modelLineage != null && modelLineage.getOriginatingModel() != null) {
                object3 = modelLineage.getOriginatingModel().getModules();
                object2 = FileUtil.normalizeFile((File)file.getParentFile());
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    File file2 = FileUtil.normalizeFile((File)new File((File)object2, (String)object));
                    if (file2.exists() && !file2.isFile()) {
                        file2 = new File(file2, "pom.xml");
                    }
                    if (!file2.isFile()) continue;
                    ProjectProfileHandlerImpl.extractProfilesFromModelLineage(file2, set);
                }
            }
        }
        catch (ProjectBuildingException projectBuildingException) {
            Logger.getLogger(ProjectProfileHandlerImpl.class.getName()).log(Level.FINE, "Error reading model lineage", projectBuildingException);
        }
    }

    private List<String> retrieveActiveProfiles(AuxiliaryConfiguration auxiliaryConfiguration, boolean bl) {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        Element element = auxiliaryConfiguration.getConfigurationFragment(PROFILES, NAMESPACE, bl);
        if (element != null && (string = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES)) != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPERATOR);
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        return new ArrayList<String>(hashSet);
    }
}

