/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.events.TransferListener;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbMavenProject {
    public static final String PROP_PROJECT = "MavenProject";
    public static final String PROP_RESOURCE = "RESOURCES";
    private NbMavenProjectImpl project;
    private PropertyChangeSupport support;
    private FCHSL listener = new FCHSL();
    private final List<File> files = new ArrayList<File>();
    private final RequestProcessor.Task task;
    private static RequestProcessor BINARYRP;
    private static RequestProcessor NONBINARYRP;
    public static final String TYPE_JAR = "jar";
    public static final String TYPE_WAR = "war";
    public static final String TYPE_EAR = "ear";
    public static final String TYPE_EJB = "ejb";
    public static final String TYPE_NBM = "nbm";
    public static final String TYPE_NBM_APPLICATION = "nbm-application";
    public static final String TYPE_POM = "pom";

    private NbMavenProject(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
        this.support = new PropertyChangeSupport(nbMavenProjectImpl);
        this.task = this.createBinaryDownloadTask(BINARYRP);
    }

    private RequestProcessor.Task createBinaryDownloadTask(RequestProcessor requestProcessor) {
        return requestProcessor.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FileObject fileObject = NbMavenProject.this.project.getProjectDirectory();
                if (fileObject == null || !fileObject.isValid()) {
                    return;
                }
                if ((fileObject = fileObject.getFileObject("pom.xml")) == null) {
                    return;
                }
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    return;
                }
                MavenEmbedder mavenEmbedder = EmbedderFactory.getOnlineEmbedder();
                AggregateProgressHandle aggregateProgressHandle = AggregateProgressFactory.createHandle((String)NbBundle.getMessage(NbMavenProject.class, (String)"Progress_Download"), (ProgressContributor[])new ProgressContributor[]{AggregateProgressFactory.createProgressContributor((String)"zaloha")}, null, null);
                boolean bl = true;
                try {
                    ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)aggregateProgressHandle);
                    aggregateProgressHandle.start();
                    DefaultMavenExecutionRequest defaultMavenExecutionRequest = new DefaultMavenExecutionRequest();
                    defaultMavenExecutionRequest.setPom(file);
                    defaultMavenExecutionRequest.setTransferListener((TransferListener)new ProgressTransferListener());
                    MavenExecutionResult mavenExecutionResult = mavenEmbedder.readProjectWithDependencies((MavenExecutionRequest)defaultMavenExecutionRequest);
                    if (mavenExecutionResult.hasExceptions()) {
                        bl = false;
                        Exception exception = (Exception)mavenExecutionResult.getExceptions().get(0);
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbMavenProject.class, (String)"MSG_Failed", (Object)exception.getLocalizedMessage()));
                    }
                }
                finally {
                    aggregateProgressHandle.finish();
                    ProgressTransferListener.clearAggregateHandle();
                }
                if (bl) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbMavenProject.class, (String)"MSG_Done"));
                }
                if (NbMavenProject.this.support.hasListeners(NbMavenProject.PROP_PROJECT)) {
                    NbMavenProject.fireMavenProjectReload(NbMavenProject.this.project);
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public MavenProject getMavenProject() {
        return this.project.getOriginalMavenProject();
    }

    public MavenProject loadAlternateMavenProject(MavenEmbedder mavenEmbedder, List<String> list, Properties properties) {
        return this.project.loadMavenProject(mavenEmbedder, list, properties);
    }

    public URI[] getResources(boolean bl) {
        return this.project.getResources(bl);
    }

    public URI getWebAppDirectory() {
        return this.project.getWebAppDirectory();
    }

    public URI[] getGeneratedSourceRoots() {
        return this.project.getGeneratedSourceRoots();
    }

    public URI getEarAppDirectory() {
        return this.project.getEarAppDirectory();
    }

    public String getPackagingType() {
        MavenProjectPropsImpl mavenProjectPropsImpl = this.project.getAuxProps();
        String string = mavenProjectPropsImpl.get("netbeans.hint.packaging", true);
        MavenProject mavenProject = this.project.getOriginalMavenProject();
        return string != null ? string : mavenProject.getPackaging();
    }

    public void addWatchedPath(String string) {
        this.addWatchedPath(FileUtilities.getDirURI(this.project.getProjectDirectory(), string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatchedPath(URI uRI) {
        boolean bl = false;
        File file = new File(uRI);
        List<File> list = this.files;
        synchronized (list) {
            if (!this.files.contains(file)) {
                bl = true;
            }
            this.files.add(file);
        }
        if (bl) {
            FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerDependencyDownload() {
        RequestProcessor.Task task = this.task;
        synchronized (task) {
            this.task.schedule(1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousDependencyDownload() {
        assert (!SwingUtilities.isEventDispatchThread()) : " Not to be called from AWT, can take significant amount ot time to download dependencies from the network.";
        RequestProcessor.Task task = this.task;
        synchronized (task) {
            this.task.schedule(0);
            this.task.waitFinished();
        }
    }

    public void downloadDependencyAndJavadocSource() {
        this.synchronousDependencyDownload();
        this.triggerSourceJavadocDownload(true);
        this.triggerSourceJavadocDownload(false);
    }

    public void triggerSourceJavadocDownload(final boolean bl) {
        NONBINARYRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MavenEmbedder mavenEmbedder = EmbedderFactory.getOnlineEmbedder();
                Set set = NbMavenProject.this.project.getOriginalMavenProject().getArtifacts();
                ProgressContributor[] progressContributorArray = new ProgressContributor[set.size()];
                for (int i = 0; i < set.size(); ++i) {
                    progressContributorArray[i] = AggregateProgressFactory.createProgressContributor((String)("multi-" + i));
                }
                String string = bl ? NbBundle.getMessage(NbMavenProject.class, (String)"Progress_Javadoc") : NbBundle.getMessage(NbMavenProject.class, (String)"Progress_Source");
                AggregateProgressHandle aggregateProgressHandle = AggregateProgressFactory.createHandle((String)string, (ProgressContributor[])progressContributorArray, null, null);
                aggregateProgressHandle.start();
                try {
                    ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)aggregateProgressHandle);
                    int n = 0;
                    for (Artifact artifact : set) {
                        NbMavenProject.downloadOneJavadocSources(mavenEmbedder, progressContributorArray[n], NbMavenProject.this.project, artifact, bl);
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    aggregateProgressHandle.finish();
                    ProgressTransferListener.clearAggregateHandle();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            NbMavenProject.this.fireProjectReload();
                        }
                    });
                    throw throwable;
                }
                aggregateProgressHandle.finish();
                ProgressTransferListener.clearAggregateHandle();
                RequestProcessor.getDefault().post(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadOneJavadocSources(MavenEmbedder mavenEmbedder, ProgressContributor progressContributor, NbMavenProjectImpl nbMavenProjectImpl, Artifact artifact, boolean bl) {
        progressContributor.start(2);
        if (Artifact.SCOPE_SYSTEM.equals(artifact.getScope())) {
            progressContributor.finish();
            return;
        }
        try {
            if (bl) {
                Artifact artifact2 = nbMavenProjectImpl.getEmbedder().createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "javadoc");
                progressContributor.progress(NbBundle.getMessage(NbMavenProject.class, (String)"MSG_Checking_Javadoc", (Object)artifact.getId()), 1);
                mavenEmbedder.resolve(artifact2, nbMavenProjectImpl.getOriginalMavenProject().getRemoteArtifactRepositories(), nbMavenProjectImpl.getEmbedder().getLocalRepository());
            } else {
                Artifact artifact3 = nbMavenProjectImpl.getEmbedder().createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "sources");
                progressContributor.progress(NbBundle.getMessage(NbMavenProject.class, (String)"MSG_Checking_Sources", (Object)artifact.getId()), 1);
                mavenEmbedder.resolve(artifact3, nbMavenProjectImpl.getOriginalMavenProject().getRemoteArtifactRepositories(), nbMavenProjectImpl.getEmbedder().getLocalRepository());
            }
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
        }
        catch (ArtifactResolutionException artifactResolutionException) {
        }
        finally {
            progressContributor.finish();
        }
    }

    public void removeWatchedPath(String string) {
        this.removeWatchedPath(FileUtilities.getDirURI(this.project.getProjectDirectory(), string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatchedPath(URI uRI) {
        boolean bl = false;
        File file = new File(uRI);
        List<File> list = this.files;
        synchronized (list) {
            boolean bl2 = this.files.remove(file);
            if (bl2 && !this.files.contains(file)) {
                bl = true;
            }
        }
        if (bl) {
            FileUtil.removeFileChangeListener((FileChangeListener)this.listener, (File)file);
        }
    }

    private void fireChange(URI uRI) {
        this.support.firePropertyChange(PROP_RESOURCE, null, uRI);
    }

    private void fireProjectReload() {
        this.project.fireProjectReload();
    }

    private void doFireReload() {
        FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)this.project.getProjectDirectory())});
        NbMavenProjectImpl.refreshLocalRepository(this.project);
        this.support.firePropertyChange(PROP_PROJECT, null, null);
    }

    public static void fireMavenProjectReload(Project project) {
        NbMavenProject nbMavenProject;
        if (project != null && (nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class)) != null) {
            nbMavenProject.fireProjectReload();
        }
    }

    public static void addPropertyChangeListener(Project project, PropertyChangeListener propertyChangeListener) {
        if (project != null && project instanceof NbMavenProjectImpl) {
            NbMavenProject nbMavenProject = ((NbMavenProjectImpl)project).getProjectWatcher();
            nbMavenProject.addPropertyChangeListener(propertyChangeListener);
        } else assert (false) : "Attempted to add PropertyChangeListener to project " + project;
    }

    public static void removePropertyChangeListener(Project project, PropertyChangeListener propertyChangeListener) {
        if (project != null && project instanceof NbMavenProjectImpl) {
            NbMavenProject nbMavenProject = ((NbMavenProjectImpl)project).getProjectWatcher();
            nbMavenProject.removePropertyChangeListener(propertyChangeListener);
        } else assert (false) : "Attempted to remove PropertyChangeListener from project " + project;
    }

    static {
        AccessorImpl accessorImpl = new AccessorImpl();
        accessorImpl.assign();
        BINARYRP = new RequestProcessor("Maven projects Binary Downloads", 1);
        NONBINARYRP = new RequestProcessor("Maven projects Source/Javadoc Downloads", 1);
    }

    private class FCHSL
    implements FileChangeListener {
        private FCHSL() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            NbMavenProject.this.fireChange(FileUtil.toFile((FileObject)fileEvent.getFile()).toURI());
        }

        public void fileDataCreated(FileEvent fileEvent) {
            NbMavenProject.this.fireChange(FileUtil.toFile((FileObject)fileEvent.getFile()).toURI());
        }

        public void fileChanged(FileEvent fileEvent) {
            NbMavenProject.this.fireChange(FileUtil.toFile((FileObject)fileEvent.getFile()).toURI());
        }

        public void fileDeleted(FileEvent fileEvent) {
            NbMavenProject.this.fireChange(FileUtil.toFile((FileObject)fileEvent.getFile()).toURI());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            NbMavenProject.this.fireChange(FileUtil.toFile((FileObject)fileRenameEvent.getFile()).toURI());
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }

    static class AccessorImpl
    extends NbMavenProjectImpl.WatcherAccessor {
        AccessorImpl() {
        }

        public void assign() {
            if (NbMavenProjectImpl.ACCESSOR == null) {
                NbMavenProjectImpl.ACCESSOR = this;
            }
        }

        public NbMavenProject createWatcher(NbMavenProjectImpl nbMavenProjectImpl) {
            return new NbMavenProject(nbMavenProjectImpl);
        }

        public void doFireReload(NbMavenProject nbMavenProject) {
            nbMavenProject.doFireReload();
        }
    }
}

