/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.NBPluginParameterExpressionEvaluator;
import org.openide.util.Exceptions;

public class PluginPropertyUtils {
    private static final String CONFIGURATION_EL = "configuration";

    private PluginPropertyUtils() {
    }

    public static String getPluginProperty(Project project, String string, String string2, String string3, String string4) {
        NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        assert (nbMavenProjectImpl != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginProperty(nbMavenProjectImpl.getOriginalMavenProject(), string, string2, string3, string4);
    }

    public static String getPluginProperty(MavenProject mavenProject, String string, String string2, String string3, String string4) {
        Plugin plugin;
        String string5 = null;
        if (mavenProject.getBuildPlugins() == null) {
            return string5;
        }
        for (Object e : mavenProject.getBuildPlugins()) {
            plugin = (Plugin)e;
            if (!string2.equals(plugin.getArtifactId()) || !string.equals(plugin.getGroupId())) continue;
            if (plugin.getExecutions() != null) {
                Object e2;
                PluginExecution pluginExecution;
                Iterator iterator = plugin.getExecutions().iterator();
                while (iterator.hasNext() && (!(pluginExecution = (PluginExecution)(e2 = iterator.next())).getGoals().contains(string4) || (string5 = PluginPropertyUtils.checkConfiguration(mavenProject, pluginExecution.getConfiguration(), string3)) == null)) {
                }
            }
            if (string5 != null) continue;
            string5 = PluginPropertyUtils.checkConfiguration(mavenProject, plugin.getConfiguration(), string3);
        }
        if (string5 == null && ("maven-compiler-plugin".equals(string2) || "maven-surefire-plugin".equals(string2) || "maven-resources-plugin".equals(string2)) && mavenProject.getPluginManagement() != null) {
            for (Object e : mavenProject.getPluginManagement().getPlugins()) {
                plugin = (Plugin)e;
                if (!string2.equals(plugin.getArtifactId()) || !string.equals(plugin.getGroupId())) continue;
                string5 = PluginPropertyUtils.checkConfiguration(mavenProject, plugin.getConfiguration(), string3);
                break;
            }
        }
        return string5;
    }

    public static String getReportPluginProperty(Project project, String string, String string2, String string3, String string4) {
        NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        assert (nbMavenProjectImpl != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginProperty(nbMavenProjectImpl.getOriginalMavenProject(), string, string2, string3, string4);
    }

    public static String getReportPluginProperty(MavenProject mavenProject, String string, String string2, String string3, String string4) {
        String string5 = null;
        if (mavenProject.getReportPlugins() == null) {
            return string5;
        }
        for (Object e : mavenProject.getReportPlugins()) {
            ReportPlugin reportPlugin = (ReportPlugin)e;
            if (!string2.equals(reportPlugin.getArtifactId()) || !string.equals(reportPlugin.getGroupId())) continue;
            if (reportPlugin.getReportSets() != null) {
                Object e2;
                ReportSet reportSet;
                Iterator iterator = reportPlugin.getReportSets().iterator();
                while (iterator.hasNext() && (!(reportSet = (ReportSet)(e2 = iterator.next())).getReports().contains(string4) || (string5 = PluginPropertyUtils.checkConfiguration(mavenProject, reportSet.getConfiguration(), string3)) == null)) {
                }
            }
            if (string5 != null) continue;
            string5 = PluginPropertyUtils.checkConfiguration(mavenProject, reportPlugin.getConfiguration(), string3);
        }
        return string5;
    }

    public static String getPluginVersion(MavenProject mavenProject, String string, String string2) {
        Plugin plugin;
        String string3 = null;
        if (mavenProject.getBuildPlugins() == null) {
            return string3;
        }
        for (Object e : mavenProject.getBuildPlugins()) {
            plugin = (Plugin)e;
            if (!string2.equals(plugin.getArtifactId()) || !string.equals(plugin.getGroupId())) continue;
            string3 = plugin.getVersion();
        }
        if (string3 == null && ("maven-compiler-plugin".equals(string2) || "maven-surefire-plugin".equals(string2) || "maven-resources-plugin".equals(string2)) && mavenProject.getPluginManagement() != null) {
            for (Object e : mavenProject.getPluginManagement().getPlugins()) {
                plugin = (Plugin)e;
                if (!string2.equals(plugin.getArtifactId()) || !string.equals(plugin.getGroupId())) continue;
                string3 = plugin.getVersion();
                break;
            }
        }
        return string3;
    }

    private static String checkConfiguration(MavenProject mavenProject, Object object, String string) {
        Xpp3Dom xpp3Dom;
        Xpp3Dom xpp3Dom2;
        if (object != null && object instanceof Xpp3Dom && (xpp3Dom2 = (xpp3Dom = (Xpp3Dom)object).getChild(string)) != null) {
            NBPluginParameterExpressionEvaluator nBPluginParameterExpressionEvaluator = new NBPluginParameterExpressionEvaluator(mavenProject, EmbedderFactory.getProjectEmbedder().getSettings(), new Properties());
            try {
                Object object2 = nBPluginParameterExpressionEvaluator.evaluate(xpp3Dom2.getValue().trim());
                return object2 != null ? "" + object2 : xpp3Dom2.getValue().trim();
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {
                Exceptions.printStackTrace((Throwable)expressionEvaluationException);
                return xpp3Dom2.getValue().trim();
            }
        }
        return null;
    }

    public static String[] getPluginPropertyList(Project project, String string, String string2, String string3, String string4, String string5) {
        NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        assert (nbMavenProjectImpl != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyList(nbMavenProjectImpl.getOriginalMavenProject(), string, string2, string3, string4, string5);
    }

    public static String[] getPluginPropertyList(MavenProject mavenProject, String string, String string2, String string3, String string4, String string5) {
        Plugin plugin;
        String[] stringArray = null;
        if (mavenProject.getBuildPlugins() == null) {
            return stringArray;
        }
        for (Object e : mavenProject.getBuildPlugins()) {
            plugin = (Plugin)e;
            if (!string2.equals(plugin.getArtifactId()) || !string.equals(plugin.getGroupId())) continue;
            if (plugin.getExecutions() != null) {
                Object e2;
                PluginExecution pluginExecution;
                Iterator iterator = plugin.getExecutions().iterator();
                while (iterator.hasNext() && (!(pluginExecution = (PluginExecution)(e2 = iterator.next())).getGoals().contains(string5) || (stringArray = PluginPropertyUtils.checkListConfiguration(mavenProject, pluginExecution.getConfiguration(), string3, string4)) == null)) {
                }
            }
            if (stringArray != null) continue;
            stringArray = PluginPropertyUtils.checkListConfiguration(mavenProject, plugin.getConfiguration(), string3, string4);
        }
        if (stringArray == null && ("maven-compiler-plugin".equals(string2) || "maven-surefire-plugin".equals(string2) || "maven-ear-plugin".equals(string2) || "maven-jar-plugin".equals(string2) || "maven-war-plugin".equals(string2) || "maven-resources-plugin".equals(string2)) && mavenProject.getPluginManagement() != null) {
            for (Object e : mavenProject.getPluginManagement().getPlugins()) {
                plugin = (Plugin)e;
                if (!string2.equals(plugin.getArtifactId()) || !string.equals(plugin.getGroupId())) continue;
                stringArray = PluginPropertyUtils.checkListConfiguration(mavenProject, plugin.getConfiguration(), string3, string4);
                break;
            }
        }
        return stringArray;
    }

    private static String[] checkListConfiguration(MavenProject mavenProject, Object object, String string, String string2) {
        Xpp3Dom xpp3Dom;
        Xpp3Dom xpp3Dom2;
        if (object != null && object instanceof Xpp3Dom && (xpp3Dom2 = (xpp3Dom = (Xpp3Dom)object).getChild(string)) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Xpp3Dom[] xpp3DomArray = xpp3Dom2.getChildren(string2);
            NBPluginParameterExpressionEvaluator nBPluginParameterExpressionEvaluator = new NBPluginParameterExpressionEvaluator(mavenProject, EmbedderFactory.getProjectEmbedder().getSettings(), new Properties());
            for (Xpp3Dom xpp3Dom3 : xpp3DomArray) {
                try {
                    Object object2 = nBPluginParameterExpressionEvaluator.evaluate(xpp3Dom3.getValue().trim());
                    arrayList.add(object2 != null ? "" + object2 : xpp3Dom3.getValue().trim());
                }
                catch (ExpressionEvaluationException expressionEvaluationException) {
                    Exceptions.printStackTrace((Throwable)expressionEvaluationException);
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    public static Properties getPluginPropertyParameter(Project project, String string, String string2, String string3, String string4) {
        NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        assert (nbMavenProjectImpl != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyParameter(nbMavenProjectImpl.getOriginalMavenProject(), string, string2, string3, string4);
    }

    public static Properties getPluginPropertyParameter(MavenProject mavenProject, String string, String string2, String string3, String string4) {
        Plugin plugin;
        Properties properties = null;
        if (mavenProject.getBuildPlugins() == null) {
            return properties;
        }
        for (Object e : mavenProject.getBuildPlugins()) {
            plugin = (Plugin)e;
            if (!string2.equals(plugin.getArtifactId()) || !string.equals(plugin.getGroupId())) continue;
            if (plugin.getExecutions() != null) {
                Object e2;
                PluginExecution pluginExecution;
                Iterator iterator = plugin.getExecutions().iterator();
                while (iterator.hasNext() && (!(pluginExecution = (PluginExecution)(e2 = iterator.next())).getGoals().contains(string4) || (properties = PluginPropertyUtils.checkPropertiesConfiguration(mavenProject, pluginExecution.getConfiguration(), string3)) == null)) {
                }
            }
            if (properties != null) continue;
            properties = PluginPropertyUtils.checkPropertiesConfiguration(mavenProject, plugin.getConfiguration(), string3);
        }
        if (properties == null && ("maven-compiler-plugin".equals(string2) || "maven-surefire-plugin".equals(string2) || "maven-resources-plugin".equals(string2)) && mavenProject.getPluginManagement() != null) {
            for (Object e : mavenProject.getPluginManagement().getPlugins()) {
                plugin = (Plugin)e;
                if (!string2.equals(plugin.getArtifactId()) || !string.equals(plugin.getGroupId())) continue;
                properties = PluginPropertyUtils.checkPropertiesConfiguration(mavenProject, plugin.getConfiguration(), string3);
                break;
            }
        }
        return properties;
    }

    private static Properties checkPropertiesConfiguration(MavenProject mavenProject, Object object, String string) {
        Xpp3Dom xpp3Dom;
        Xpp3Dom xpp3Dom2;
        if (object != null && object instanceof Xpp3Dom && (xpp3Dom2 = (xpp3Dom = (Xpp3Dom)object).getChild(string)) != null) {
            Properties properties = new Properties();
            Xpp3Dom[] xpp3DomArray = xpp3Dom2.getChildren();
            NBPluginParameterExpressionEvaluator nBPluginParameterExpressionEvaluator = new NBPluginParameterExpressionEvaluator(mavenProject, EmbedderFactory.getProjectEmbedder().getSettings(), new Properties());
            for (Xpp3Dom xpp3Dom3 : xpp3DomArray) {
                try {
                    String string2 = xpp3Dom3.getValue();
                    if (string2 == null) continue;
                    Object object2 = nBPluginParameterExpressionEvaluator.evaluate(string2.trim());
                    properties.put(xpp3Dom3.getName(), object2 != null ? "" + object2 : xpp3Dom3.getValue().trim());
                }
                catch (ExpressionEvaluationException expressionEvaluationException) {
                    Exceptions.printStackTrace((Throwable)expressionEvaluationException);
                }
            }
            return properties;
        }
        return null;
    }

    @Deprecated
    public static Dependency checkModelDependency(Model model, String string, String string2, boolean bl) {
        DependencyManagement dependencyManagement;
        List list = model.getDependencies();
        Object object = null;
        Dependency dependency = null;
        if (list != null) {
            dependencyManagement = list.iterator();
            while (dependencyManagement.hasNext()) {
                Dependency dependency2 = (Dependency)dependencyManagement.next();
                if (!string.equalsIgnoreCase(dependency2.getGroupId()) || !string2.equalsIgnoreCase(dependency2.getArtifactId())) continue;
                object = dependency2;
                break;
            }
        }
        if ((object == null || object.getVersion() == null) && (dependencyManagement = model.getDependencyManagement()) != null && (list = dependencyManagement.getDependencies()) != null) {
            for (Dependency dependency3 : list) {
                if (!string.equalsIgnoreCase(dependency3.getGroupId()) || !string2.equalsIgnoreCase(dependency3.getArtifactId())) continue;
                dependency = dependency3;
                break;
            }
        }
        if (bl && object == null) {
            object = new Dependency();
            object.setGroupId(string);
            object.setArtifactId(string2);
            model.addDependency((Dependency)object);
        }
        return dependency == null ? object : dependency;
    }

    @Deprecated
    public static boolean hasModelDependency(Model model, String string, String string2) {
        return PluginPropertyUtils.checkModelDependency(model, string, string2, false) != null;
    }

    @Deprecated
    public static Repository checkModelRepository(MavenProject mavenProject, Model model, String string, boolean bl) {
        Repository repository;
        Iterator iterator;
        Repository repository2;
        Object object2;
        if (string.contains("http://repo1.maven.org/maven2")) {
            return null;
        }
        for (Object object2 : model.getRepositories()) {
            repository2 = (Repository)object2;
            if (!string.equals(repository2.getUrl())) continue;
            return null;
        }
        Object object3 = mavenProject.getRepositories();
        object2 = null;
        repository2 = null;
        if (object3 != null) {
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                repository = (Repository)iterator.next();
                if (!string.equals(repository.getUrl())) continue;
                object2 = repository;
                break;
            }
        }
        if (object2 != null && (object3 = model.getRepositories()) != null) {
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                repository = (Repository)iterator.next();
                if (!repository.getId().equals(object2.getId())) continue;
                repository2 = repository;
                break;
            }
        }
        if (bl && repository2 == null && object2 == null) {
            repository2 = new Repository();
            repository2.setUrl(string);
            repository2.setId(string);
            model.addRepository(repository2);
        }
        return repository2;
    }

    @Deprecated
    public static boolean hasModelRepository(MavenProject mavenProject, Model model, String string) {
        return PluginPropertyUtils.checkModelRepository(mavenProject, model, string, false) != null;
    }

    @Deprecated
    public static void checkSourceLevel(ModelHandle modelHandle, String string) {
        ModelUtils.checkSourceLevel(modelHandle, string);
    }

    @Deprecated
    public static void checkEncoding(ModelHandle modelHandle, String string) {
        ModelUtils.checkEncoding(modelHandle, string);
    }
}

