/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.model.pom.Activation;
import org.netbeans.modules.maven.model.pom.ActivationProperty;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.model.profile.ProfilesModel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelHandle {
    public static final String PANEL_RUN = "RUN";
    public static final String PANEL_BASIC = "BASIC";
    public static final String PANEL_CONFIGURATION = "CONFIGURATION";
    public static final String PANEL_MAPPING = "MAPPING";
    public static final String PANEL_LIBRARIES = "LIBRARIES";
    public static final String PANEL_SOURCES = "SOURCES";
    public static final String PANEL_COMPILE = "COMPILE";
    public static final String PROFILE_PUBLIC = "netbeans-public";
    public static final String PROFILE_PRIVATE = "netbeans-private";
    public static final String PROPERTY_PROFILE = "netbeans.execution";
    private POMModel model;
    private MavenProject project;
    private ProfilesModel profiles;
    private Map<String, ActionToGoalMapping> mappings;
    private Map<ActionToGoalMapping, Boolean> modMappings;
    private Profile publicProfile;
    private org.netbeans.modules.maven.model.profile.Profile privateProfile;
    private List<Configuration> configurations;
    private boolean modProfiles = false;
    private boolean modModel = false;
    private boolean modConfig = false;
    private Configuration active;
    private boolean enabled = false;

    private ModelHandle(POMModel pOMModel, ProfilesModel profilesModel, MavenProject mavenProject, Map<String, ActionToGoalMapping> map, List<Configuration> list, Configuration configuration) {
        this.model = pOMModel;
        this.model.startTransaction();
        this.project = mavenProject;
        this.profiles = profilesModel;
        this.profiles.startTransaction();
        this.mappings = map;
        this.modMappings = new HashMap<ActionToGoalMapping, Boolean>();
        for (ActionToGoalMapping actionToGoalMapping : map.values()) {
            this.modMappings.put(actionToGoalMapping, Boolean.FALSE);
        }
        this.configurations = list;
        this.active = configuration;
    }

    public POMModel getPOMModel() {
        return this.model;
    }

    public ProfilesModel getProfileModel() {
        return this.profiles;
    }

    public Profile getNetbeansPublicProfile() {
        return this.getNetbeansPublicProfile(true);
    }

    public Profile getNetbeansPublicProfile(boolean bl) {
        if (this.publicProfile == null) {
            List list = this.model.getProject().getProfiles();
            if (list != null) {
                for (Profile profile : list) {
                    if (!PROFILE_PUBLIC.equals(profile.getId())) continue;
                    this.publicProfile = profile;
                    break;
                }
            }
            if (this.publicProfile == null && bl) {
                Profile profile;
                this.publicProfile = this.model.getFactory().createProfile();
                this.publicProfile.setId(PROFILE_PUBLIC);
                Activation activation = this.model.getFactory().createActivation();
                profile = this.model.getFactory().createActivationProperty();
                profile.setName(PROPERTY_PROFILE);
                profile.setValue("true");
                activation.setActivationProperty((ActivationProperty)profile);
                this.publicProfile.setActivation(activation);
                this.publicProfile.setBuildBase(this.model.getFactory().createBuildBase());
                this.model.getProject().addProfile(this.publicProfile);
                this.markAsModified(this.model);
            }
        }
        if (this.publicProfile == null && !bl) {
            return this.model.getFactory().createProfile();
        }
        return this.publicProfile;
    }

    public org.netbeans.modules.maven.model.profile.Profile getNetbeansPrivateProfile() {
        return this.getNetbeansPrivateProfile(true);
    }

    public org.netbeans.modules.maven.model.profile.Profile getNetbeansPrivateProfile(boolean bl) {
        if (this.privateProfile == null) {
            List list = this.profiles.getProfilesRoot().getProfiles();
            if (list != null) {
                for (org.netbeans.modules.maven.model.profile.Profile profile : list) {
                    if (!PROFILE_PRIVATE.equals(profile.getId())) continue;
                    this.privateProfile = profile;
                    break;
                }
            }
            if (this.privateProfile == null && bl) {
                org.netbeans.modules.maven.model.profile.Profile profile;
                this.privateProfile = this.profiles.getFactory().createProfile();
                this.privateProfile.setId(PROFILE_PRIVATE);
                org.netbeans.modules.maven.model.profile.Activation activation = this.profiles.getFactory().createActivation();
                profile = this.profiles.getFactory().createActivationProperty();
                profile.setName(PROPERTY_PROFILE);
                profile.setValue("true");
                activation.setActivationProperty((org.netbeans.modules.maven.model.profile.ActivationProperty)profile);
                this.privateProfile.setActivation(activation);
                this.profiles.getProfilesRoot().addProfile(this.privateProfile);
                this.markAsModified(this.profiles);
            }
        }
        if (this.privateProfile == null && !bl) {
            return this.profiles.getFactory().createProfile();
        }
        return this.privateProfile;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ActionToGoalMapping getActionMappings() {
        return this.mappings.get(M2Configuration.DEFAULT);
    }

    public ActionToGoalMapping getActionMappings(Configuration configuration) {
        ActionToGoalMapping actionToGoalMapping = this.mappings.get(configuration.getId());
        if (actionToGoalMapping == null) {
            actionToGoalMapping = new ActionToGoalMapping();
            this.mappings.put(configuration.getId(), actionToGoalMapping);
            this.modMappings.put(actionToGoalMapping, Boolean.FALSE);
        }
        return actionToGoalMapping;
    }

    public static void setUserActionMapping(NetbeansActionMapping netbeansActionMapping, ActionToGoalMapping actionToGoalMapping) {
        netbeansActionMapping.setPackagings(null);
        ArrayList<NetbeansActionMapping> arrayList = actionToGoalMapping.getActions() != null ? actionToGoalMapping.getActions() : new ArrayList<NetbeansActionMapping>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            NetbeansActionMapping netbeansActionMapping2 = (NetbeansActionMapping)iterator.next();
            if (!netbeansActionMapping2.getActionName().equals(netbeansActionMapping.getActionName())) continue;
            int n = arrayList.indexOf(netbeansActionMapping2);
            iterator.remove();
            arrayList.add(n, netbeansActionMapping);
            return;
        }
        arrayList.add(netbeansActionMapping);
    }

    public static NetbeansActionMapping getActiveMapping(String string, Project project) {
        return ActionToGoalUtils.getActiveMapping(string, project, null);
    }

    public void setConfigurationsEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isConfigurationsEnabled() {
        return this.enabled;
    }

    public List<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfiguration(Configuration configuration) {
        this.configurations.add(configuration);
        this.modConfig = true;
    }

    public void removeConfiguration(Configuration configuration) {
        this.configurations.remove(configuration);
        if (this.active == configuration) {
            this.active = this.configurations.size() > 0 ? this.configurations.get(0) : null;
        }
        this.modConfig = true;
    }

    public Configuration getActiveConfiguration() {
        return this.active;
    }

    public void setActiveConfiguration(Configuration configuration) {
        this.active = configuration;
    }

    public boolean isModified(Object object) {
        if (this.modMappings.containsKey(object)) {
            return this.modMappings.get(object);
        }
        if (object == this.profiles) {
            return this.modProfiles;
        }
        if (object == this.model) {
            return this.modModel;
        }
        if (object == this.configurations || this.configurations.contains(object)) {
            return this.modConfig;
        }
        return true;
    }

    public void markAsModified(Object object) {
        if (this.modMappings.containsKey(object)) {
            this.modMappings.put((ActionToGoalMapping)object, Boolean.TRUE);
        } else if (object == this.profiles) {
            this.modProfiles = true;
        } else if (object == this.model) {
            this.modModel = true;
        } else if (object == this.configurations || this.configurations.contains(object)) {
            this.modConfig = true;
        }
    }

    public static Configuration createProfileConfiguration(String string) {
        Configuration configuration = new Configuration();
        configuration.setId(string);
        configuration.setDisplayName(string);
        configuration.setProfileBased(true);
        return configuration;
    }

    public static Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setId(M2Configuration.DEFAULT);
        configuration.setDisplayName(NbBundle.getMessage(ModelHandle.class, (String)"TXT_DefautlConfig"));
        configuration.setDefault(true);
        return configuration;
    }

    public static Configuration createCustomConfiguration(String string) {
        Configuration configuration = new Configuration();
        configuration.setId(string);
        configuration.setDisplayName(string);
        return configuration;
    }

    static {
        AccessorImpl accessorImpl = new AccessorImpl();
        accessorImpl.assign();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Configuration {
        private String id;
        private boolean profileBased = false;
        private boolean defaul = false;
        private String displayName;
        private List<String> activatedProfiles;
        private boolean shared = false;

        Configuration() {
        }

        public String getFileNameExt() {
            return M2Configuration.getFileNameExt(this.id);
        }

        public boolean isDefault() {
            return this.defaul;
        }

        public void setDefault(boolean bl) {
            this.defaul = bl;
        }

        public List<String> getActivatedProfiles() {
            return this.activatedProfiles;
        }

        public void setActivatedProfiles(List<String> list) {
            this.activatedProfiles = list;
        }

        public String getDisplayName() {
            if (this.isDefault()) {
                return NbBundle.getMessage(ModelHandle.class, (String)"DefaultConfig");
            }
            if (this.isProfileBased()) {
                return NbBundle.getMessage(ModelHandle.class, (String)"ProfileConfig", (Object)this.id);
            }
            if (this.getActivatedProfiles() != null && this.getActivatedProfiles().size() > 0) {
                return NbBundle.getMessage(ModelHandle.class, (String)"CustomConfig1", (Object)this.id, (Object)Arrays.toString(this.getActivatedProfiles().toArray()));
            }
            return NbBundle.getMessage(ModelHandle.class, (String)"CustomConfig2", (Object)this.id);
        }

        public void setDisplayName(String string) {
            if (this.isProfileBased()) {
                return;
            }
            this.displayName = string;
        }

        public String getId() {
            return this.id;
        }

        public void setShared(boolean bl) {
            this.shared = bl;
        }

        public boolean isShared() {
            return this.shared;
        }

        void setId(String string) {
            this.id = string;
        }

        public boolean isProfileBased() {
            return this.profileBased;
        }

        void setProfileBased(boolean bl) {
            this.profileBased = bl;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AccessorImpl
    extends CustomizerProviderImpl.ModelAccessor {
        AccessorImpl() {
        }

        @Override
        public ModelHandle createHandle(POMModel pOMModel, ProfilesModel profilesModel, MavenProject mavenProject, Map<String, ActionToGoalMapping> map, List<Configuration> list, Configuration configuration) {
            return new ModelHandle(pOMModel, profilesModel, mavenProject, map, list, configuration);
        }

        public void assign() {
            if (CustomizerProviderImpl.ACCESSOR == null) {
                CustomizerProviderImpl.ACCESSOR = this;
            }
        }
    }
}

