/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.classpath.CompileClassPathImpl;
import org.netbeans.modules.maven.classpath.PackagedClassPathImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.SourceClassPathImpl;
import org.netbeans.modules.maven.classpath.TestCompileClassPathImpl;
import org.netbeans.modules.maven.classpath.TestRuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.TestSourceClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPathProviderImpl
implements ClassPathProvider,
ActiveJ2SEPlatformProvider,
ProjectSourcesClassPathProvider {
    private static final int TYPE_SRC = 0;
    private static final int TYPE_TESTSRC = 1;
    private static final int TYPE_WEB = 5;
    private static final int TYPE_UNKNOWN = -1;
    private NbMavenProjectImpl project;
    private ClassPath[] cache = new ClassPath[8];
    private BootClassPathImpl bcpImpl;

    public ClassPathProviderImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
    }

    @Override
    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(string)) {
            ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>(2);
            arrayList.add(this.getCompileTimeClasspath(0));
            arrayList.add(this.getCompileTimeClasspath(1));
            return arrayList.toArray(new ClassPath[arrayList.size()]);
        }
        if ("classpath/execute".equals(string)) {
            ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>(2);
            arrayList.add(this.getRuntimeClasspath(0));
            arrayList.add(this.getRuntimeClasspath(1));
            return arrayList.toArray(new ClassPath[arrayList.size()]);
        }
        if ("classpath/source".equals(string)) {
            ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>(2);
            arrayList.add(this.getSourcepath(0));
            arrayList.add(this.getSourcepath(1));
            return arrayList.toArray(new ClassPath[arrayList.size()]);
        }
        return new ClassPath[0];
    }

    @Override
    public ClassPath getProjectSourcesClassPath(String string) {
        if ("classpath/boot".equals(string)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(string)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcepath(0);
        }
        assert (false);
        return null;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        int n = this.getType(fileObject);
        if (n != 0 && n != 1 && n != 5) {
            Logger.getLogger(ClassPathProviderImpl.class.getName()).log(Level.FINEST, " bad type=" + string + " for " + fileObject);
            return null;
        }
        if (string.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(n);
        }
        if (string.equals("classpath/execute")) {
            return this.getRuntimeClasspath(n);
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcepath(n);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (string.equals("classpath/packaged")) {
            return this.getProvidedClassPath();
        }
        return null;
    }

    private synchronized ClassPath getProvidedClassPath() {
        ClassPath classPath = this.cache[7];
        if (classPath == null) {
            this.cache[7] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new PackagedClassPathImpl(this.project));
        }
        return classPath;
    }

    private boolean isChildOf(FileObject fileObject, URI[] uRIArray) {
        for (int i = 0; i < uRIArray.length; ++i) {
            FileObject fileObject2 = FileUtilities.convertURItoFileObject(uRIArray[i]);
            if (fileObject2 == null || !fileObject2.isFolder() || !fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return true;
        }
        return false;
    }

    public static FileObject[] convertStringsToFileObjects(List<String> list) {
        FileObject[] fileObjectArray = new FileObject[list.size()];
        int n = 0;
        for (String string : list) {
            File file = new File(string);
            file = FileUtil.normalizeFile((File)file);
            fileObjectArray[n] = FileUtil.toFileObject((File)file);
            ++n;
        }
        return fileObjectArray;
    }

    private int getType(FileObject fileObject) {
        if (this.isChildOf(fileObject, this.project.getSourceRoots(false)) || this.isChildOf(fileObject, this.project.getGeneratedSourceRoots())) {
            return 0;
        }
        if (this.isChildOf(fileObject, this.project.getSourceRoots(true))) {
            return 1;
        }
        URI uRI = this.project.getWebAppDirectory();
        FileObject fileObject2 = FileUtil.toFileObject((File)new File(uRI));
        if (fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            return 5;
        }
        if (this.isChildOf(fileObject, this.project.getResources(false))) {
            return 0;
        }
        if (this.isChildOf(fileObject, this.project.getResources(true))) {
            return 1;
        }
        return -1;
    }

    private synchronized ClassPath getSourcepath(int n) {
        ClassPath classPath;
        if (n == 5) {
            n = 0;
        }
        if ((classPath = this.cache[n]) == null) {
            classPath = n == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new SourceClassPathImpl(this.project)) : ClassPathFactory.createClassPath((ClassPathImplementation)new TestSourceClassPathImpl(this.project));
            this.cache[n] = classPath;
        }
        return classPath;
    }

    private synchronized ClassPath getCompileTimeClasspath(int n) {
        ClassPath classPath;
        if (n == 5) {
            n = 0;
        }
        if ((classPath = this.cache[2 + n]) == null) {
            classPath = n == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new CompileClassPathImpl(this.project)) : ClassPathFactory.createClassPath((ClassPathImplementation)new TestCompileClassPathImpl(this.project));
            this.cache[2 + n] = classPath;
        }
        return classPath;
    }

    private synchronized ClassPath getRuntimeClasspath(int n) {
        ClassPath classPath;
        if (n == 5) {
            n = 0;
        }
        if ((classPath = this.cache[4 + n]) == null) {
            classPath = n == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new RuntimeClassPathImpl(this.project)) : ClassPathFactory.createClassPath((ClassPathImplementation)new TestRuntimeClassPathImpl(this.project));
            this.cache[4 + n] = classPath;
        }
        return classPath;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = this.cache[6];
        if (classPath == null) {
            this.bcpImpl = new BootClassPathImpl(this.project);
            this.cache[6] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)this.bcpImpl);
        }
        return classPath;
    }

    @Override
    public JavaPlatform getJavaPlatform() {
        this.getBootClassPath();
        return this.bcpImpl.findActivePlatform();
    }
}

