/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.configurations.ConfigurationProviderEnabler;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ConfigProvider
implements ProjectConfigurationProvider<M2Configuration> {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private NbMavenProjectImpl project;
    private List<M2Configuration> profiles = null;
    private List<M2Configuration> shared = null;
    private List<M2Configuration> nonshared = null;
    private final M2Configuration DEFAULT;
    private M2Configuration active;
    private String initialActive;
    private AuxiliaryConfiguration aux;
    private ProjectProfileHandler profileHandler;
    private PropertyChangeListener propertyChange;

    public M2ConfigProvider(NbMavenProjectImpl nbMavenProjectImpl, AuxiliaryConfiguration auxiliaryConfiguration, ProjectProfileHandler projectProfileHandler) {
        NodeList nodeList;
        this.project = nbMavenProjectImpl;
        this.aux = auxiliaryConfiguration;
        this.profileHandler = projectProfileHandler;
        this.DEFAULT = M2Configuration.createDefault(this.project);
        Element element = auxiliaryConfiguration.getConfigurationFragment(ConfigurationProviderEnabler.ROOT, ConfigurationProviderEnabler.NAMESPACE, false);
        if (element != null && (nodeList = element.getElementsByTagNameNS(ConfigurationProviderEnabler.NAMESPACE, ConfigurationProviderEnabler.ACTIVATED)).getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            this.initialActive = new String(element2.getTextContent());
        }
        this.active = this.DEFAULT;
        this.propertyChange = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    M2ConfigProvider m2ConfigProvider = M2ConfigProvider.this;
                    synchronized (m2ConfigProvider) {
                        M2ConfigProvider.this.profiles = null;
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            M2ConfigProvider.this.firePropertyChange();
                        }
                    });
                }
            }
        };
        this.getActiveConfiguration();
    }

    private synchronized Collection<M2Configuration> getConfigurations(boolean bl) {
        if (this.profiles == null && !bl) {
            this.profiles = this.createProfilesList();
        }
        if (this.shared == null) {
            this.shared = this.readConfiguration(true);
        }
        if (this.nonshared == null) {
            this.nonshared = this.readConfiguration(false);
        }
        ArrayList<M2Configuration> arrayList = new ArrayList<M2Configuration>();
        arrayList.add(this.DEFAULT);
        arrayList.addAll(this.shared);
        arrayList.addAll(this.nonshared);
        if (!bl) {
            arrayList.addAll(this.profiles);
        }
        if (this.active != null && !arrayList.contains(this.active)) {
            arrayList.add(this.active);
        }
        return arrayList;
    }

    public synchronized Collection<M2Configuration> getConfigurations() {
        return this.getConfigurations(false);
    }

    public M2Configuration getDefaultConfig() {
        return this.DEFAULT;
    }

    public synchronized Collection<M2Configuration> getProfileConfigurations() {
        this.getConfigurations();
        return this.profiles;
    }

    public synchronized Collection<M2Configuration> getSharedConfigurations() {
        this.getConfigurations();
        return this.shared;
    }

    public synchronized Collection<M2Configuration> getNonSharedConfigurations() {
        this.getConfigurations();
        return this.nonshared;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
        customizerProviderImpl.showCustomizer("CONFIGURATION");
    }

    public boolean configurationsAffectAction(String string) {
        return !"delete".equals(string) && !"copy".equals(string) && !"move".equals(string);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support.getPropertyChangeListeners().length == 0) {
            this.project.getProjectWatcher().addPropertyChangeListener(this.propertyChange);
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
        if (this.support.getPropertyChangeListeners().length == 0) {
            this.project.getProjectWatcher().addPropertyChangeListener(this.propertyChange);
        }
    }

    public synchronized M2Configuration getActiveConfiguration() {
        if (this.initialActive != null) {
            for (M2Configuration m2Configuration : this.getConfigurations(true)) {
                if (!this.initialActive.equals(m2Configuration.getId())) continue;
                this.active = m2Configuration;
                this.initialActive = null;
                break;
            }
            if (this.initialActive != null) {
                this.active = new M2Configuration(this.initialActive, this.project);
                this.active.setActivatedProfiles(Collections.singletonList(this.initialActive));
                this.initialActive = null;
            }
        }
        return this.active;
    }

    public synchronized void setConfigurations(List<M2Configuration> list, List<M2Configuration> list2, boolean bl) {
        ConfigurationProviderEnabler.writeAuxiliaryData(this.aux, true, list);
        ConfigurationProviderEnabler.writeAuxiliaryData(this.aux, false, list2);
        this.shared = list;
        this.nonshared = list2;
        this.profiles = null;
        this.firePropertyChange();
    }

    public synchronized void setActiveConfiguration(M2Configuration m2Configuration) throws IllegalArgumentException, IOException {
        if (this.active == m2Configuration || this.active != null && this.active.equals(m2Configuration)) {
            return;
        }
        M2Configuration m2Configuration2 = this.active;
        this.active = m2Configuration;
        ConfigurationProviderEnabler.writeAuxiliaryData(this.aux, ConfigurationProviderEnabler.ACTIVATED, this.active.getId());
        this.support.firePropertyChange("activeConfiguration", m2Configuration2, this.active);
        NbMavenProject.fireMavenProjectReload(this.project);
    }

    private List<M2Configuration> createProfilesList() {
        List<String> list = this.profileHandler.getAllProfiles();
        ArrayList<M2Configuration> arrayList = new ArrayList<M2Configuration>();
        for (String string : list) {
            M2Configuration m2Configuration = new M2Configuration(string, this.project);
            m2Configuration.setActivatedProfiles(Collections.singletonList(string));
            arrayList.add(m2Configuration);
        }
        return arrayList;
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("configurations", null, null);
    }

    private List<M2Configuration> readConfiguration(boolean bl) {
        NodeList nodeList;
        Element element = this.aux.getConfigurationFragment(ConfigurationProviderEnabler.ROOT, ConfigurationProviderEnabler.NAMESPACE, bl);
        if (element != null && (nodeList = element.getElementsByTagNameNS(ConfigurationProviderEnabler.NAMESPACE, ConfigurationProviderEnabler.CONFIG)).getLength() > 0) {
            ArrayList<M2Configuration> arrayList = new ArrayList<M2Configuration>();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                M2Configuration m2Configuration = new M2Configuration(element2.getAttribute(ConfigurationProviderEnabler.CONFIG_ID_ATTR), this.project);
                String string = element2.getAttribute(ConfigurationProviderEnabler.CONFIG_PROFILES_ATTR);
                if (string != null) {
                    String[] stringArray = string.split(" ");
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (String string2 : stringArray) {
                        if (string2.trim().length() <= 0) continue;
                        arrayList2.add(string2.trim());
                    }
                    m2Configuration.setActivatedProfiles(arrayList2);
                }
                arrayList.add(m2Configuration);
            }
            return arrayList;
        }
        return new ArrayList<M2Configuration>();
    }
}

