/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.dependencies;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class CheckNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private int selectionMode;
    private boolean isSelected = true;
    private String nodeLabel;
    private Icon icon;
    private boolean disabled = false;
    private List<ChangeListener> listeners;
    private boolean strike;
    private boolean italic;
    private String tooltip;

    public CheckNode(Object object, String string, Icon icon) {
        super(object, false);
        this.setSelectionMode(4);
        this.nodeLabel = string;
        this.icon = icon;
        this.listeners = new ArrayList<ChangeListener>();
    }

    String getLabel() {
        if (this.strike) {
            return "<s>" + this.nodeLabel + "</s>";
        }
        if (this.italic) {
            return "<i>" + this.nodeLabel + "</i>";
        }
        return this.nodeLabel;
    }

    Icon getIcon() {
        return this.icon;
    }

    public void setDisabled() {
        this.disabled = true;
        this.isSelected = false;
        this.removeAllChildren();
    }

    boolean isDisabled() {
        return this.disabled;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CheckNode checkNode = (CheckNode)enumeration.nextElement();
                checkNode.setSelected(bl);
            }
        }
        this.fireChange();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            // empty if block
        }
        return this.tooltip;
    }

    void strike() {
        this.strike = true;
    }

    void unitalic() {
        this.italic = false;
    }

    void italic() {
        this.italic = true;
    }

    void unstrike() {
        this.strike = false;
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

