/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.dependencies;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.dependencies.CheckNode;
import org.netbeans.modules.maven.dependencies.CheckNodeListener;
import org.netbeans.modules.maven.dependencies.CheckRenderer;
import org.netbeans.modules.maven.dependencies.DependencyExcludeNodeVisitor;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.openide.NotificationLineSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludeDependencyPanel
extends JPanel {
    private MavenProject project;
    private DependencyNode rootnode;
    private Map<Artifact, TreeModel> modelCache;
    private Map<ChangeListener, CheckNode> change2Trans;
    private Map<ChangeListener, List<CheckNode>> change2Refs;
    private boolean isSingle = false;
    private NotificationLineSupport lineSupport;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTree trRef;
    private JTree trTrans;

    public ExcludeDependencyPanel(MavenProject mavenProject, final Artifact artifact, final Set<DependencyNode> set, final DependencyNode dependencyNode) {
        this.project = mavenProject;
        this.modelCache = new HashMap<Artifact, TreeModel>();
        this.change2Trans = new HashMap<ChangeListener, CheckNode>();
        this.change2Refs = new HashMap<ChangeListener, List<CheckNode>>();
        this.initComponents();
        boolean bl = this.isSingle = artifact != null;
        if (this.isSingle) {
            this.trTrans.setVisible(false);
            this.jScrollPane1.setVisible(false);
            this.jLabel1.setVisible(false);
        }
        this.trRef.setCellRenderer(new CheckRenderer(false));
        this.trTrans.setCellRenderer(new CheckRenderer(true));
        CheckNodeListener checkNodeListener = new CheckNodeListener(false);
        this.trRef.addMouseListener(checkNodeListener);
        this.trRef.addKeyListener(checkNodeListener);
        this.trRef.setToggleClickCount(0);
        this.trRef.setRootVisible(false);
        this.trTrans.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.trRef.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (!ExcludeDependencyPanel.this.isSingle) {
                    ExcludeDependencyPanel.this.rootnode = DependencyTreeFactory.createDependencyTree((MavenProject)ExcludeDependencyPanel.this.project, (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (String)Artifact.SCOPE_TEST);
                    ExcludeDependencyPanel.this.trTrans.setModel(new DefaultTreeModel(ExcludeDependencyPanel.this.createTransitiveDependenciesList()));
                } else {
                    ExcludeDependencyPanel.this.rootnode = dependencyNode;
                    CheckNode checkNode = new CheckNode(artifact, null, null);
                    DefaultTreeModel defaultTreeModel = new DefaultTreeModel(ExcludeDependencyPanel.this.createReferenceModel(set, checkNode));
                    ExcludeDependencyPanel.this.modelCache.put(artifact, defaultTreeModel);
                    ExcludeDependencyPanel.this.setReferenceTree(checkNode);
                }
            }
        });
        this.trTrans.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ExcludeDependencyPanel.this.printSpaceMessage();
            }

            public void focusLost(FocusEvent focusEvent) {
                ExcludeDependencyPanel.this.printSpaceMessage();
            }
        });
        this.trTrans.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ExcludeDependencyPanel.this.printSpaceMessage();
            }
        });
        this.trTrans.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (32 == keyEvent.getKeyCode()) {
                    TreePath treePath = ExcludeDependencyPanel.this.trTrans.getSelectionPath();
                    CheckNode checkNode = (CheckNode)treePath.getLastPathComponent();
                    TreeModel treeModel = ExcludeDependencyPanel.this.trRef.getModel();
                    int n = treeModel.getChildCount(treeModel.getRoot());
                    for (int i = 0; i < n; ++i) {
                        CheckNode checkNode2 = (CheckNode)treeModel.getChild(treeModel.getRoot(), i);
                        checkNode2.setSelected(true);
                    }
                    ExcludeDependencyPanel.this.trRef.repaint();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    public ExcludeDependencyPanel(MavenProject mavenProject) {
        this(mavenProject, null, null, null);
    }

    public Map<Artifact, List<DependencyNode>> getDependencyExcludes() {
        HashMap<Artifact, List<DependencyNode>> hashMap = new HashMap<Artifact, List<DependencyNode>>();
        for (ChangeListener changeListener : this.change2Trans.keySet()) {
            CheckNode checkNode = this.change2Trans.get(changeListener);
            List<CheckNode> list = this.change2Refs.get(changeListener);
            ArrayList<DependencyNode> arrayList = new ArrayList<DependencyNode>();
            for (CheckNode checkNode2 : list) {
                if (!checkNode2.isSelected()) continue;
                arrayList.add((DependencyNode)checkNode2.getUserObject());
            }
            hashMap.put((Artifact)checkNode.getUserObject(), arrayList);
        }
        return hashMap;
    }

    public void setStatusDisplayer(NotificationLineSupport notificationLineSupport) {
        this.lineSupport = notificationLineSupport;
    }

    private void printSpaceMessage() {
        if (this.lineSupport == null) {
            return;
        }
        if (this.trTrans.isFocusOwner() && this.trTrans.getSelectionPath() != null) {
            this.lineSupport.setInformationMessage(NbBundle.getMessage(ExcludeDependencyPanel.class, (String)"TXT_Exclude_all"));
        } else {
            this.lineSupport.clearMessages();
        }
    }

    private TreeNode createReferenceModel(Set<DependencyNode> set, CheckNode checkNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(null, true);
        Listener listener = new Listener();
        ArrayList<CheckNode> arrayList = new ArrayList<CheckNode>();
        Icon icon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/DependencyIcon.png", (boolean)true));
        this.change2Trans.put(listener, checkNode);
        this.change2Refs.put(listener, arrayList);
        for (DependencyNode dependencyNode : set) {
            String string = dependencyNode.getArtifact().getGroupId() + ":" + dependencyNode.getArtifact().getArtifactId();
            CheckNode checkNode2 = new CheckNode(dependencyNode, string, icon);
            checkNode2.setSelected(this.isSingle);
            checkNode2.addChangeListener(listener);
            arrayList.add(checkNode2);
            defaultMutableTreeNode.add(checkNode2);
        }
        return defaultMutableTreeNode;
    }

    private TreeNode createTransitiveDependenciesList() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(null, true);
        Set set = this.project.getArtifacts();
        Icon icon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/TransitiveDependencyIcon.png", (boolean)true));
        for (Artifact artifact : set) {
            if (artifact.getDependencyTrail().size() <= 2) continue;
            String string = artifact.getGroupId() + ":" + artifact.getArtifactId();
            defaultMutableTreeNode.add(new CheckNode(artifact, string, icon));
        }
        return defaultMutableTreeNode;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.trTrans = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.trRef = new JTree();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.trTrans.setRootVisible(false);
        this.trTrans.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ExcludeDependencyPanel.this.trTransValueChanged(treeSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.trTrans);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
        this.trRef.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        this.trRef.setRootVisible(false);
        this.jScrollPane2.setViewportView(this.trRef);
        this.jLabel1.setText(NbBundle.getBundle(ExcludeDependencyPanel.class).getString("ExcludeDependencyPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getBundle(ExcludeDependencyPanel.class).getString("ExcludeDependencyPanel.jLabel2.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jScrollPane1, -1, 315, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jLabel2).add((Component)this.jScrollPane2, -1, 320, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 363, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 363, Short.MAX_VALUE))));
    }

    private void setReferenceTree(CheckNode checkNode) {
        Artifact artifact = (Artifact)checkNode.getUserObject();
        if (this.modelCache.containsKey(artifact)) {
            this.trRef.setModel(this.modelCache.get(artifact));
        } else if (this.rootnode == null) {
            this.trRef.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        } else {
            DependencyExcludeNodeVisitor dependencyExcludeNodeVisitor = new DependencyExcludeNodeVisitor(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType());
            this.rootnode.accept((DependencyNodeVisitor)dependencyExcludeNodeVisitor);
            Set<DependencyNode> set = dependencyExcludeNodeVisitor.getDirectDependencies();
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.createReferenceModel(set, checkNode));
            this.trRef.setModel(defaultTreeModel);
            this.modelCache.put(artifact, defaultTreeModel);
        }
    }

    private void trTransValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeNode treeNode = (TreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        if (treeNode instanceof CheckNode) {
            this.setReferenceTree((CheckNode)treeNode);
        } else {
            this.trRef.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        }
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CheckNode checkNode = (CheckNode)ExcludeDependencyPanel.this.change2Trans.get(this);
            List list = (List)ExcludeDependencyPanel.this.change2Refs.get(this);
            boolean bl = true;
            boolean bl2 = false;
            for (CheckNode checkNode2 : list) {
                if (!checkNode2.isSelected()) {
                    bl = false;
                }
                if (!checkNode2.isSelected()) continue;
                bl2 = true;
            }
            if (bl) {
                checkNode.strike();
            } else {
                checkNode.unstrike();
            }
            if (bl2) {
                checkNode.italic();
            } else {
                checkNode.unitalic();
            }
            if (ExcludeDependencyPanel.this.trTrans.isVisible()) {
                ExcludeDependencyPanel.this.trTrans.repaint();
            }
        }
    }
}

