/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenCommandLineExecutor;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.execute.OutputTabMaintainer;
import org.netbeans.modules.maven.execute.ui.RunGoalsPanel;
import org.netbeans.modules.maven.spi.lifecycle.MavenBuildPlanSupport;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public abstract class AbstractMavenExecutor
extends OutputTabMaintainer
implements MavenExecutor,
Cancellable {
    protected RunConfig config;
    protected ReRunAction rerun;
    protected ReRunAction rerunDebug;
    protected StopAction stop;
    protected BuildPlanAction buildPlan;
    private List<String> messages = new ArrayList<String>();
    private List<OutputListener> listeners = new ArrayList<OutputListener>();
    protected ExecutorTask task;
    private static final Set<String> forbidden = new HashSet<String>();
    protected MavenItem item;
    protected final Object SEMAPHORE = new Object();

    protected AbstractMavenExecutor(RunConfig runConfig) {
        super(runConfig.getExecutionName());
        this.config = runConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTask(ExecutorTask executorTask) {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            this.task = executorTask;
            this.item = new MavenItem();
            this.SEMAPHORE.notifyAll();
        }
    }

    public final void addInitialMessage(String string, OutputListener outputListener) {
        this.messages.add(string);
        this.listeners.add(outputListener);
    }

    protected final void processInitialMessage() {
        Iterator<String> iterator = this.messages.iterator();
        Iterator<OutputListener> iterator2 = this.listeners.iterator();
        InputOutput inputOutput = this.getInputOutput();
        try {
            while (iterator.hasNext()) {
                OutputListener outputListener = iterator2.next();
                if (outputListener != null) {
                    inputOutput.getErr().println(iterator.next(), outputListener, true);
                    continue;
                }
                inputOutput.getErr().println(iterator.next());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected final void actionStatesAtStart() {
        this.rerun.setEnabled(false);
        this.rerunDebug.setEnabled(false);
        if (this instanceof MavenCommandLineExecutor) {
            this.buildPlan.setEnabled(false);
        } else {
            this.buildPlan.setEnabled(true);
        }
        this.stop.setEnabled(true);
    }

    protected final void actionStatesAtFinish() {
        this.rerun.setEnabled(true);
        this.rerunDebug.setEnabled(true);
        this.stop.setEnabled(false);
    }

    protected void reassignAdditionalContext(Iterator iterator) {
        this.rerun = (ReRunAction)iterator.next();
        this.rerunDebug = (ReRunAction)iterator.next();
        this.stop = (StopAction)iterator.next();
        this.buildPlan = (BuildPlanAction)iterator.next();
        this.rerun.setConfig(this.config);
        this.rerunDebug.setConfig(this.config);
        this.buildPlan.setConfig(this.config);
        this.stop.setExecutor(this);
    }

    public static final Properties excludeNetBeansProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (forbidden.contains(string)) continue;
            properties2.put(string, properties.getProperty(string));
        }
        return properties2;
    }

    protected final Collection createContext() {
        Collection<String> collection = super.createContext();
        collection.add((String)((Object)this.rerun));
        collection.add((String)((Object)this.rerunDebug));
        collection.add((String)((Object)this.stop));
        collection.add((String)((Object)this.buildPlan));
        return collection;
    }

    protected Action[] createNewTabActions() {
        this.rerun = new ReRunAction(false);
        this.rerunDebug = new ReRunAction(true);
        this.stop = new StopAction();
        this.buildPlan = new BuildPlanAction();
        this.rerun.setConfig(this.config);
        this.rerunDebug.setConfig(this.config);
        this.buildPlan.setConfig(this.config);
        this.stop.setExecutor(this);
        Action[] actionArray = !this.isEmbedded() ? new Action[]{this.rerun, this.rerunDebug, this.stop} : new Action[]{this.rerun, this.rerunDebug, this.buildPlan, this.stop};
        return actionArray;
    }

    protected boolean isEmbedded() {
        return false;
    }

    static {
        forbidden.add("netbeans.logger.console");
        forbidden.add("java.util.logging.config.class");
        forbidden.add("netbeans.autoupdate.language");
        forbidden.add("netbeans.dirs");
        forbidden.add("netbeans.home");
        forbidden.add("sun.awt.exception.handler");
        forbidden.add("org.openide.TopManager.GUI");
        forbidden.add("org.openide.major.version");
        forbidden.add("netbeans.autoupdate.variant");
        forbidden.add("netbeans.dynamic.classpath");
        forbidden.add("netbeans.autoupdate.country");
        forbidden.add("netbeans.hash.code");
        forbidden.add("org.openide.TopManager");
        forbidden.add("org.openide.version");
        forbidden.add("netbeans.buildnumber");
        forbidden.add("javax.xml.parsers.DocumentBuilderFactory");
        forbidden.add("javax.xml.parsers.SAXParserFactory");
        forbidden.add("rave.build");
        forbidden.add("netbeans.accept_license_class");
        forbidden.add("rave.version");
        forbidden.add("netbeans.autoupdate.version");
        forbidden.add("netbeans.importclass");
        forbidden.add("netbeans.user");
    }

    private class MavenItem
    implements BuildExecutionSupport.Item {
        private MavenItem() {
        }

        public String getDisplayName() {
            return AbstractMavenExecutor.this.config.getTaskDisplayName();
        }

        public void repeatExecution() {
            RunUtils.executeMaven(AbstractMavenExecutor.this.config);
        }

        public boolean isRunning() {
            return !AbstractMavenExecutor.this.task.isFinished();
        }

        public void stopRunning() {
            AbstractMavenExecutor.this.cancel();
        }
    }

    static class BuildPlanAction
    extends AbstractAction {
        private MavenEmbedder embedder;
        private RunConfig config;
        private MavenBuildPlanSupport mbps;

        BuildPlanAction() {
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/buildplangoals.png", (boolean)false));
            this.putValue("Name", NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TXT_Build_Plan"));
            this.putValue("ShortDescription", NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIP_Build_Plan_tip"));
            this.mbps = (MavenBuildPlanSupport)Lookup.getDefault().lookup(MavenBuildPlanSupport.class);
            this.setEnabled(false);
        }

        public boolean isEnabled() {
            return this.mbps != null && this.config != null && this.config.getProject() != null && super.isEnabled();
        }

        public void setConfig(RunConfig runConfig) {
            this.config = runConfig;
        }

        public void setEmbedder(MavenEmbedder mavenEmbedder) {
            this.embedder = mavenEmbedder;
            this.setEnabled(mavenEmbedder != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.embedder != null && this.config != null && this.config.getProject() != null) {
                NbMavenProject nbMavenProject = (NbMavenProject)this.config.getProject().getLookup().lookup(NbMavenProject.class);
                this.mbps.openBuildPlanView(this.embedder, nbMavenProject.getMavenProject(), this.config.getGoals().toArray(new String[0]));
            }
        }
    }

    static class StopAction
    extends AbstractAction {
        private AbstractMavenExecutor exec;

        StopAction() {
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/stop.png", (boolean)false));
            this.putValue("Name", NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TXT_Stop_execution"));
            this.putValue("ShortDescription", NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIP_Stop_Execution"));
            this.setEnabled(false);
        }

        void setExecutor(AbstractMavenExecutor abstractMavenExecutor) {
            this.exec = abstractMavenExecutor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.exec.cancel();
        }
    }

    static class ReRunAction
    extends AbstractAction {
        private RunConfig config;
        private boolean debug;

        public ReRunAction(boolean bl) {
            this.debug = bl;
            this.putValue("SmallIcon", bl ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/refreshdebug.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/refresh.png", (boolean)false));
            this.putValue("Name", bl ? NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TXT_Rerun_extra") : NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TXT_Rerun"));
            this.putValue("ShortDescription", bl ? NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIP_Rerun_Extra") : NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIP_Rerun"));
            this.setEnabled(false);
        }

        void setConfig(RunConfig runConfig) {
            this.config = runConfig;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.debug) {
                RunGoalsPanel runGoalsPanel = new RunGoalsPanel();
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runGoalsPanel, NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIT_Run_maven"));
                runGoalsPanel.readConfig(this.config);
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                if (object == DialogDescriptor.OK_OPTION) {
                    BeanRunConfig beanRunConfig = new BeanRunConfig(this.config);
                    runGoalsPanel.applyValues(beanRunConfig);
                    RunUtils.executeMaven(beanRunConfig);
                }
            } else {
                BeanRunConfig beanRunConfig = new BeanRunConfig(this.config);
                RunUtils.executeMaven(beanRunConfig);
            }
        }
    }
}

