/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.AbstractOutputHandler;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

class CommandLineOutputHandler
extends AbstractOutputHandler {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Maven ComandLine Output Redirection", 8);
    private InputOutput inputOutput;
    private Pattern linePattern = Pattern.compile("\\[(DEBUG|INFO|WARN|ERROR|FATAL)\\] (.*)");
    private Pattern startPattern = Pattern.compile("\\[INFO\\] \\[(.*):(.*)\\]");
    private OutputWriter stdOut;
    private String currentTag;
    RequestProcessor.Task outTask;
    private MavenEmbedderLogger logger;
    private Input inp;
    private ProgressHandle handle;

    CommandLineOutputHandler(ProgressHandle progressHandle) {
        super(progressHandle);
        this.handle = progressHandle;
    }

    public CommandLineOutputHandler(InputOutput inputOutput, Project project, ProgressHandle progressHandle, RunConfig runConfig) {
        this(progressHandle);
        this.inputOutput = inputOutput;
        this.stdOut = this.inputOutput.getOut();
        this.logger = new Logger();
        this.initProcessorList(project, runConfig);
    }

    protected final void checkSleepiness() {
        this.handle.progress("");
        super.checkSleepiness();
    }

    void setStdOut(InputStream inputStream) {
        this.outTask = PROCESSOR.post((Runnable)new Output(inputStream));
    }

    void setStdIn(OutputStream outputStream) {
        this.inp = new Input(outputStream, this.inputOutput);
        PROCESSOR.post((Runnable)this.inp);
    }

    void waitFor() {
        this.inp.stopInput();
        if (this.outTask != null) {
            this.outTask.waitFinished();
        }
    }

    protected InputOutput getIO() {
        return this.inputOutput;
    }

    MavenEmbedderLogger getLogger() {
        return this.logger;
    }

    private class Logger
    implements MavenEmbedderLogger {
        private Logger() {
        }

        public void debug(String string) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(string);
        }

        public void debug(String string, Throwable throwable) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(string);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void info(String string) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(string);
        }

        public void info(String string, Throwable throwable) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(string);
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public void warn(String string) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(string);
        }

        public void warn(String string, Throwable throwable) {
            CommandLineOutputHandler.this.inputOutput.getOut().println(string);
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void error(String string) {
            CommandLineOutputHandler.this.inputOutput.getErr().println(string);
        }

        public void error(String string, Throwable throwable) {
            CommandLineOutputHandler.this.inputOutput.getErr().println(string);
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public void fatalError(String string) {
            CommandLineOutputHandler.this.inputOutput.getErr().println(string);
        }

        public void fatalError(String string, Throwable throwable) {
            CommandLineOutputHandler.this.inputOutput.getErr().println(string);
        }

        public boolean isFatalErrorEnabled() {
            return true;
        }

        public void setThreshold(int n) {
        }

        public int getThreshold() {
            return 0;
        }

        public void close() {
        }
    }

    static class Input
    implements Runnable {
        private InputOutput inputOutput;
        private OutputStream str;
        private boolean stopIn = false;
        private Thread runningThread;

        public Input(OutputStream outputStream, InputOutput inputOutput) {
            this.str = outputStream;
            this.inputOutput = inputOutput;
        }

        public void stopInput() {
            this.stopIn = true;
            try {
                this.inputOutput.getIn().close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.runningThread = Thread.currentThread();
            Reader reader = this.inputOutput.getIn();
            try {
                while (true) {
                    int n;
                    if ((n = reader.read()) == -1) {
                        this.str.close();
                        return;
                    }
                    this.str.write(n);
                    this.str.flush();
                    if (this.stopIn) {
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            finally {
                try {
                    this.str.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private class Output
    implements Runnable {
        private static final String SEC_MOJO_EXEC = "mojo-execute";
        private BufferedReader str;
        private boolean skipLF = false;

        public Output(InputStream inputStream) {
            this.str = new BufferedReader(new InputStreamReader(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readLine() throws IOException {
            char[] cArray = new char[1];
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            while (bl) {
                int n = this.str.read(cArray);
                if (n != 1) {
                    if (n == -1 && stringBuffer.length() == 0) {
                        return null;
                    }
                    return stringBuffer.toString();
                }
                if (this.skipLF) {
                    this.skipLF = false;
                    if (cArray[0] == '\n') continue;
                }
                if (cArray[0] == '\n') {
                    return stringBuffer.toString();
                }
                if (cArray[0] == '\r') {
                    this.skipLF = true;
                    return stringBuffer.toString();
                }
                stringBuffer.append(cArray[0]);
                bl = this.str.ready();
                if (bl) continue;
                Output output = this;
                synchronized (output) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                    finally {
                        if (!this.str.ready()) {
                            break;
                        }
                        bl = true;
                    }
                }
            }
            return "&^#INCOMPLINE:" + stringBuffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId("project-execute", null), CommandLineOutputHandler.this.stdOut);
            try {
                String string = this.readLine();
                while (string != null) {
                    String string2;
                    Matcher matcher;
                    if (string.startsWith("&^#INCOMPLINE:")) {
                        CommandLineOutputHandler.this.stdOut.print(string.substring("&^#INCOMPLINE:".length()));
                        string = this.readLine();
                        continue;
                    }
                    if (string.startsWith("[INFO] Final Memory:")) {
                        if (CommandLineOutputHandler.this.currentTag != null) {
                            CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId(SEC_MOJO_EXEC, CommandLineOutputHandler.this.currentTag), CommandLineOutputHandler.this.stdOut);
                        }
                        CommandLineOutputHandler.this.currentTag = null;
                    }
                    if ((matcher = CommandLineOutputHandler.this.startPattern.matcher(string)).matches()) {
                        string2 = matcher.group(1) + ":" + matcher.group(2);
                        if (CommandLineOutputHandler.this.currentTag != null) {
                            CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId(SEC_MOJO_EXEC, CommandLineOutputHandler.this.currentTag), CommandLineOutputHandler.this.stdOut);
                        }
                        CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId(SEC_MOJO_EXEC, string2), CommandLineOutputHandler.this.stdOut);
                        CommandLineOutputHandler.this.currentTag = string2;
                    } else {
                        matcher = CommandLineOutputHandler.this.linePattern.matcher(string);
                        if (matcher.matches()) {
                            string2 = matcher.group(1);
                            CommandLineOutputHandler.this.processLine(matcher.group(2), CommandLineOutputHandler.this.stdOut, "INFO".equals(string2) ? "" : string2);
                        } else {
                            CommandLineOutputHandler.this.processLine(string, CommandLineOutputHandler.this.stdOut, "");
                        }
                    }
                    string = this.readLine();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId("project-execute", null), CommandLineOutputHandler.this.stdOut);
                try {
                    this.str.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

