/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.ActionProviderImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.configurations.ConfigurationProviderEnabler;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.problems.ProblemsPanel;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class MavenProjectNode
extends AbstractNode {
    private static final String BADGE_ICON = "org/netbeans/modules/maven/brokenProjectBadge.png";
    private static String toolTipBroken = "<img src=\"" + MavenProjectNode.class.getClassLoader().getResource("org/netbeans/modules/maven/brokenProjectBadge.png") + "\">&nbsp;" + NbBundle.getMessage(MavenProjectNode.class, (String)"ICON_BrokenProjectBadge");
    private NbMavenProjectImpl project;
    private ProjectInformation info;
    private ProblemReporterImpl reporter;

    public MavenProjectNode(Lookup lookup, NbMavenProjectImpl nbMavenProjectImpl) {
        super(NodeFactorySupport.createCompositeChildren((Project)nbMavenProjectImpl, (String)"Projects/org-netbeans-modules-maven/Nodes"), lookup);
        this.project = nbMavenProjectImpl;
        this.info = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        NbMavenProject.addPropertyChangeListener(this.project, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    MavenProjectNode.this.fireDisplayNameChange(null, MavenProjectNode.this.getDisplayName());
                    MavenProjectNode.this.fireIconChange();
                }
            }
        });
        this.reporter = (ProblemReporterImpl)nbMavenProjectImpl.getLookup().lookup(ProblemReporterImpl.class);
        this.reporter.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MavenProjectNode.this.fireIconChange();
                        MavenProjectNode.this.fireOpenedIconChange();
                        MavenProjectNode.this.fireDisplayNameChange(null, MavenProjectNode.this.getDisplayName());
                        MavenProjectNode.this.fireShortDescriptionChange(null, MavenProjectNode.this.getShortDescription());
                    }
                });
            }
        });
    }

    public String getDisplayName() {
        return this.project.getDisplayName();
    }

    public Image getIcon(int n) {
        Image image = ImageUtilities.icon2Image((Icon)this.info.getIcon());
        if (this.reporter.getReports().size() > 0) {
            Image image2 = ImageUtilities.loadImage((String)BADGE_ICON);
            image2 = ImageUtilities.addToolTipToImage((Image)image2, (String)toolTipBroken);
            image = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)8, (int)0);
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = ImageUtilities.icon2Image((Icon)this.info.getIcon());
        if (this.reporter.getReports().size() > 0) {
            Image image2 = ImageUtilities.loadImage((String)BADGE_ICON);
            image2 = ImageUtilities.addToolTipToImage((Image)image2, (String)toolTipBroken);
            image = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)8, (int)0);
        }
        return image;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        ActionProviderImpl actionProviderImpl = (ActionProviderImpl)this.project.getLookup().lookup(ActionProviderImpl.class);
        arrayList.add(CommonProjectActions.newFileAction());
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_Build"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_Clean_Build"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build-with-dependencies", (String)NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_Build_Deps"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_Clean"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_Javadoc"), null));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_Run"), null));
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/Debugger_Actions_temporary"));
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/Profiler_Actions_temporary"));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_Test"), null));
        List list = Utilities.actionsForPath((String)"Projects/org-netbeans-modules-maven/ProjectActions");
        for (Action action : list) {
            if (action == null || !action.isEnabled()) continue;
            arrayList.add(action);
        }
        arrayList.add(null);
        arrayList.add(actionProviderImpl.createCustomPopupAction());
        if (((ConfigurationProviderEnabler)this.project.getLookup().lookup(ConfigurationProviderEnabler.class)).isConfigurationEnabled()) {
            arrayList.add(CommonProjectActions.setProjectConfigurationAction());
        } else {
            arrayList.add(actionProviderImpl.createProfilesPopupAction());
        }
        arrayList.add(null);
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/org-netbeans-modules-maven/DependenciesActions"));
        arrayList.add(null);
        arrayList.add(NbMavenProjectImpl.createRefreshAction());
        arrayList.add(CommonProjectActions.setAsMainProjectAction());
        arrayList.add(CommonProjectActions.openSubprojectsAction());
        if ("pom".equalsIgnoreCase(this.project.getProjectWatcher().getPackagingType())) {
            arrayList.add(new CloseSuprojectsAction());
        }
        arrayList.add(CommonProjectActions.closeProjectAction());
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(FindAction.class));
        arrayList.add(null);
        arrayList.add(CommonProjectActions.renameProjectAction());
        arrayList.add(CommonProjectActions.moveProjectAction());
        arrayList.add(CommonProjectActions.copyProjectAction());
        arrayList.add(CommonProjectActions.deleteProjectAction());
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
        arrayList.add(null);
        if (this.reporter.getReports().size() > 0) {
            arrayList.add(new ShowProblemsAction());
        }
        arrayList.add(CommonProjectActions.customizeProjectAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.project.isErrorPom(this.project.getOriginalMavenProject()) ? NbBundle.getMessage(MavenProjectNode.class, (String)"TXT_FailedProjectLoadingDesc") : this.project.getShortDescription();
        stringBuffer.append("<html><i>").append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project1")).append("</i><b> ").append(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory())).append("</b><br><i>");
        stringBuffer.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project2")).append("</i><b> ").append(this.project.getOriginalMavenProject().getGroupId()).append("</b><br><i>");
        stringBuffer.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project3")).append("</i><b> ").append(this.project.getOriginalMavenProject().getArtifactId()).append("</b><br><i>");
        stringBuffer.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project4")).append("</i><b> ").append(this.project.getOriginalMavenProject().getVersion()).append("</b><br><i>");
        stringBuffer.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project5")).append("</i> ").append(this.breakPerLine(string, NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project5").length()));
        if (this.reporter.getReports().size() > 0) {
            stringBuffer.append("<br><b>").append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project6")).append("</b><br><ul>");
            for (ProblemReport problemReport : this.reporter.getReports()) {
                stringBuffer.append("<li>" + problemReport.getShortDescription() + "</li>");
            }
            stringBuffer.append("</ul>");
        }
        return stringBuffer.toString();
    }

    private String breakPerLine(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        int n2 = n;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((n2 += string2.length()) > 50) {
                n2 = 0;
                stringBuffer.append("<br>");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private class ShowProblemsAction
    extends AbstractAction {
        public ShowProblemsAction() {
            this.putValue("Name", NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_ShowProblems"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = new JButton();
            ProblemsPanel problemsPanel = new ProblemsPanel(MavenProjectNode.this.reporter);
            problemsPanel.setActionButton(jButton);
            JButton jButton2 = new JButton();
            problemsPanel.setCloseButton(jButton2);
            jButton2.setText(NbBundle.getMessage(MavenProjectNode.class, (String)"BTN_Close"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)problemsPanel, NbBundle.getMessage(MavenProjectNode.class, (String)"TIT_Show_Problems"));
            dialogDescriptor.setOptions(new Object[]{jButton, jButton2});
            dialogDescriptor.setClosingOptions(new Object[]{jButton2});
            dialogDescriptor.setModal(false);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        }
    }

    private class CloseSuprojectsAction
    extends AbstractAction {
        public CloseSuprojectsAction() {
            this.putValue("Name", NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_CloseRequired"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)MavenProjectNode.this.project.getLookup().lookup(SubprojectProvider.class);
            Set set = subprojectProvider.getSubprojects();
            Project[] projectArray = set.toArray(new Project[set.size()]);
            OpenProjects.getDefault().close(projectArray);
        }
    }
}

