/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.nodes.OthersRootNode;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

public class OtherRootNodeFactory
implements NodeFactory {
    private static final String KEY_OTHER = "otherRoots";
    private static final String KEY_OTHER_TEST = "otherTestRoots";
    private static final String MAIN = "src/main";
    private static final String TEST = "src/test";

    public NodeList createNodes(Project project) {
        NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        return new NList(nbMavenProjectImpl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NList
    extends AbstractMavenNodeList<String>
    implements PropertyChangeListener,
    FileChangeListener {
        private NbMavenProjectImpl project;

        NList(NbMavenProjectImpl nbMavenProjectImpl) {
            this.project = nbMavenProjectImpl;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.fireChange();
            }
            if ("RESOURCES".equals(propertyChangeEvent.getPropertyName()) && (OtherRootNodeFactory.MAIN.equals(propertyChangeEvent.getNewValue()) || OtherRootNodeFactory.TEST.equals(propertyChangeEvent.getNewValue()))) {
                this.fireChange();
                this.checkFileObject((String)propertyChangeEvent.getNewValue());
            }
        }

        public List<String> keys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.project.getOtherRoots(false).length > 0) {
                arrayList.add(OtherRootNodeFactory.KEY_OTHER);
            }
            if (this.project.getOtherRoots(true).length > 0) {
                arrayList.add(OtherRootNodeFactory.KEY_OTHER_TEST);
            }
            return arrayList;
        }

        public Node node(String string) {
            if (OtherRootNodeFactory.KEY_OTHER.equals(string)) {
                File[] fileArray = this.project.getOtherRoots(false);
                if (fileArray.length > 0) {
                    FileObject fileObject = FileUtil.toFileObject((File)fileArray[0].getParentFile());
                    return new OthersRootNode(this.project, false, fileObject);
                }
                return null;
            }
            if (OtherRootNodeFactory.KEY_OTHER_TEST.equals(string)) {
                File[] fileArray = this.project.getOtherRoots(true);
                if (fileArray.length > 0) {
                    FileObject fileObject = FileUtil.toFileObject((File)fileArray[0].getParentFile());
                    return new OthersRootNode(this.project, true, fileObject);
                }
                return null;
            }
            assert (false) : "Wrong key for Dependencies NodeFactory: " + string;
            return null;
        }

        @Override
        public void addNotify() {
            NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            NbMavenProject.addPropertyChangeListener(this.project, this);
            nbMavenProject.addWatchedPath(OtherRootNodeFactory.MAIN);
            nbMavenProject.addWatchedPath(OtherRootNodeFactory.TEST);
            this.checkFileObject(OtherRootNodeFactory.MAIN);
            this.checkFileObject(OtherRootNodeFactory.TEST);
        }

        @Override
        public void removeNotify() {
            NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            NbMavenProject.removePropertyChangeListener(this.project, this);
            nbMavenProject.removeWatchedPath(OtherRootNodeFactory.MAIN);
            nbMavenProject.removeWatchedPath(OtherRootNodeFactory.TEST);
            FileObject fileObject = this.project.getProjectDirectory().getFileObject(OtherRootNodeFactory.MAIN);
            if (fileObject != null) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
            }
            if ((fileObject = this.project.getProjectDirectory().getFileObject(OtherRootNodeFactory.TEST)) != null) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
            }
        }

        private void checkFileObject(String string) {
            FileObject fileObject = this.project.getProjectDirectory().getFileObject(string);
            if (fileObject != null) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
                fileObject.addFileChangeListener((FileChangeListener)this);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.fireChange();
            fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

