/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.maven.model.Resource;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.MavenSourcesImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.VisibilityQueryDataFilter;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.nodes.OthersRootNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OthersRootChildren
extends Children.Keys<SourceGroup> {
    private NbMavenProjectImpl project;
    private PropertyChangeListener changeListener;
    private boolean test;

    public OthersRootChildren(NbMavenProjectImpl nbMavenProjectImpl, boolean bl) {
        this.project = nbMavenProjectImpl;
        this.test = bl;
        this.changeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    OthersRootChildren.this.regenerateKeys();
                    OthersRootChildren.this.refresh();
                }
            }
        };
    }

    protected void addNotify() {
        super.addNotify();
        NbMavenProject.addPropertyChangeListener(this.project, this.changeListener);
        this.regenerateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
        NbMavenProject.removePropertyChangeListener(this.project, this.changeListener);
        super.removeNotify();
    }

    private void regenerateKeys() {
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        if (sources == null) {
            throw new IllegalStateException("need Sources instance in lookup");
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups(this.test ? "TestResources" : "Resources");
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            arrayList.add(sourceGroupArray[i]);
            hashSet.add(sourceGroupArray[i].getRootFolder());
        }
        this.setKeys(arrayList);
        ((OthersRootNode)this.getNode()).setFiles(hashSet);
    }

    protected Node[] createNodes(SourceGroup sourceGroup) {
        Node[] nodeArray = new Node[1];
        DataFolder dataFolder = DataFolder.findFolder((FileObject)sourceGroup.getRootFolder());
        if (sourceGroup instanceof MavenSourcesImpl.OtherGroup) {
            MavenSourcesImpl.OtherGroup otherGroup = (MavenSourcesImpl.OtherGroup)sourceGroup;
            if (otherGroup.getResource() != null) {
                nodeArray[0] = new OGFilterNode(PackageView.createPackageView((SourceGroup)sourceGroup), otherGroup);
            } else {
                Children children = dataFolder.createNodeChildren((DataFilter)VisibilityQueryDataFilter.VISIBILITY_QUERY_FILTER);
                nodeArray[0] = new OGFilterNode(dataFolder.getNodeDelegate().cloneNode(), children, otherGroup);
            }
        } else assert (false) : "Group is not a MavenSourcesImpl.OtherGroup instance";
        return nodeArray;
    }

    private static class OGFilterNode
    extends FilterNode {
        private MavenSourcesImpl.OtherGroup group;

        OGFilterNode(Node node, MavenSourcesImpl.OtherGroup otherGroup) {
            super(node);
            this.group = otherGroup;
        }

        OGFilterNode(Node node, Children children, MavenSourcesImpl.OtherGroup otherGroup) {
            super(node, children);
            this.group = otherGroup;
        }

        public String getShortDescription() {
            if (this.group.getResource() != null) {
                Resource resource = this.group.getResource();
                String string = NbBundle.getMessage(OthersRootChildren.class, (String)"TIP_Resource1", (Object)resource.getDirectory());
                if (resource.getTargetPath() != null) {
                    string = string + NbBundle.getMessage(OthersRootChildren.class, (String)"TIP_Resource2", (Object)resource.getTargetPath());
                }
                if (resource.getIncludes() != null && resource.getIncludes().size() > 0) {
                    string = string + NbBundle.getMessage(OthersRootChildren.class, (String)"TIP_Resource3", (Object)Arrays.toString(resource.getIncludes().toArray()));
                }
                if (resource.getExcludes() != null && resource.getExcludes().size() > 0) {
                    string = string + NbBundle.getMessage(OthersRootChildren.class, (String)"TIP_Resource4", (Object)Arrays.toString(resource.getExcludes().toArray()));
                }
                return string;
            }
            return NbBundle.getMessage(OthersRootChildren.class, (String)"TIP_Resource5", (Object)FileUtil.getFileDisplayName((FileObject)this.group.getRootFolder()));
        }
    }
}

