/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class DependencyAnalyzeOutputProcessor
implements OutputProcessor {
    private static final String[] DEPGOALS = new String[]{"mojo-execute#dependency:analyze"};
    private Pattern start = Pattern.compile(".*Used undeclared dependencies.*", 32);
    private boolean started = false;
    private Pattern dependency = Pattern.compile("\\s*(.*):(.*):(.*):(.*):(.*)", 32);
    private NbMavenProjectImpl project;

    DependencyAnalyzeOutputProcessor(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
    }

    public String[] getRegisteredOutputSequences() {
        return DEPGOALS;
    }

    public void processLine(String string, OutputVisitor outputVisitor) {
        Matcher matcher;
        if (this.started) {
            matcher = this.dependency.matcher(string);
            if (matcher.matches() && matcher.groupCount() >= 5) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                String string4 = matcher.group(3);
                String string5 = matcher.group(4);
                String string6 = matcher.group(5);
                outputVisitor.setLine(string + " (Click to add to pom.xml)");
                outputVisitor.setOutputListener(new Listener(this.project, string2, string3, string4, string5, string6), false);
            } else {
                this.started = false;
            }
        }
        if (!this.started && (matcher = this.start.matcher(string)).matches()) {
            this.started = true;
        }
    }

    public void sequenceStart(String string, OutputVisitor outputVisitor) {
        this.started = false;
    }

    public void sequenceEnd(String string, OutputVisitor outputVisitor) {
    }

    public void sequenceFail(String string, OutputVisitor outputVisitor) {
    }

    private static class Listener
    implements OutputListener {
        private String group;
        private String scope;
        private String version;
        private String type;
        private String artifact;
        private NbMavenProjectImpl project;

        private Listener(NbMavenProjectImpl nbMavenProjectImpl, String string, String string2, String string3, String string4, String string5) {
            this.group = string;
            this.artifact = string2;
            this.type = string3;
            this.version = string4;
            this.scope = string5;
            this.project = nbMavenProjectImpl;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            ModelUtils.addDependency(this.project.getProjectDirectory().getFileObject("pom.xml"), this.group, this.artifact, this.version, this.type, this.scope, null, false);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DependencyAnalyzeOutputProcessor.class, (String)"MSG_Dependency", (Object)(this.group + ":" + this.artifact)));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

