/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class SiteOutputProcessor
implements OutputProcessor {
    private static final String[] SITEGOALS = new String[]{"mojo-execute#site:site"};
    private Project project;

    public SiteOutputProcessor(Project project) {
        this.project = project;
    }

    public String[] getRegisteredOutputSequences() {
        return SITEGOALS;
    }

    public void processLine(String string, OutputVisitor outputVisitor) {
    }

    public void sequenceStart(String string, OutputVisitor outputVisitor) {
    }

    public void sequenceEnd(String string, OutputVisitor outputVisitor) {
        outputVisitor.setLine("     View Generated Project Site");
        outputVisitor.setOutputListener(new Listener(this.project), false);
    }

    public void sequenceFail(String string, OutputVisitor outputVisitor) {
    }

    private static class Listener
    implements OutputListener {
        private File root;

        private Listener(Project project) {
            File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
            this.root = new File(file, "target" + File.separator + "site");
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            FileObject fileObject;
            File file = FileUtil.normalizeFile((File)this.root);
            FileUtil.refreshFor((File[])new File[]{file});
            FileObject fileObject2 = FileUtil.toFileObject((File)file);
            if (fileObject2 != null && (fileObject = fileObject2.getFileObject("index.html")) != null) {
                URL uRL = URLMapper.findURL((FileObject)fileObject, (int)1);
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

