/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputUtils;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class TestOutputListenerProvider
implements OutputProcessor {
    private static final String[] TESTGOALS = new String[]{"mojo-execute#surefire:test"};
    private Pattern failSeparatePattern = Pattern.compile("(?:\\[surefire\\] )?Tests run.*[<]* FAILURE[!]*[\\s]*", 32);
    private Pattern failWindowsPattern1 = Pattern.compile("(?:\\[surefire\\] )?Tests run.*", 32);
    private Pattern failWindowsPattern2 = Pattern.compile(".*[<]* FAILURE [!]*.*", 32);
    private Pattern outDirPattern;
    private Pattern outDirPattern2;
    private Pattern runningPattern = Pattern.compile("(?:\\[surefire\\] )?Running (.*)", 32);
    private static Logger LOG = Logger.getLogger(TestOutputListenerProvider.class.getName());
    String outputDir;
    String runningTestClass;
    private String delayedLine;

    public TestOutputListenerProvider() {
        this.outDirPattern = Pattern.compile(".*Surefire report directory\\: (.*)", 32);
        this.outDirPattern2 = Pattern.compile(".*Setting reports dir\\: (.*)", 32);
    }

    public String[] getWatchedGoals() {
        return TESTGOALS;
    }

    public void processLine(String string, OutputVisitor outputVisitor) {
        Matcher matcher;
        if (this.delayedLine != null) {
            matcher = this.failWindowsPattern2.matcher(string);
            if (matcher.matches()) {
                outputVisitor.setOutputListener(new TestOutputListener(this.runningTestClass, this.outputDir), true);
                outputVisitor.setLine(this.delayedLine + string);
            } else {
                outputVisitor.setLine(this.delayedLine + "\n" + string);
            }
            this.delayedLine = null;
        }
        if ((matcher = this.outDirPattern.matcher(string)).matches()) {
            this.outputDir = matcher.group(1);
            return;
        }
        matcher = this.outDirPattern2.matcher(string);
        if (matcher.matches()) {
            this.outputDir = matcher.group(1);
            return;
        }
        matcher = this.runningPattern.matcher(string);
        if (matcher.matches()) {
            this.runningTestClass = matcher.group(1);
            return;
        }
        matcher = this.failSeparatePattern.matcher(string);
        if (matcher.matches()) {
            outputVisitor.setOutputListener(new TestOutputListener(this.runningTestClass, this.outputDir), true);
            return;
        }
        matcher = this.failWindowsPattern1.matcher(string);
        if (matcher.matches()) {
            outputVisitor.skipLine();
            this.delayedLine = string;
        }
    }

    public String[] getRegisteredOutputSequences() {
        return TESTGOALS;
    }

    public void sequenceStart(String string, OutputVisitor outputVisitor) {
    }

    public void sequenceEnd(String string, OutputVisitor outputVisitor) {
    }

    public void sequenceFail(String string, OutputVisitor outputVisitor) {
    }

    private static class TestOutputListener
    implements OutputListener {
        private String testname;
        private String outputDir;
        private Pattern testNamePattern = Pattern.compile(".*\\((.*)\\).*<<< (?:FAILURE)?(?:ERROR)?!\\s*");

        public TestOutputListener(String string, String string2) {
            this.testname = string;
            this.outputDir = string2;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            File file;
            FileObject fileObject = null;
            if (this.outputDir != null) {
                file = FileUtil.normalizeFile((File)new File(this.outputDir));
                FileUtil.refreshFor((File[])new File[]{file});
                fileObject = FileUtil.toFileObject((File)file);
            }
            if (fileObject == null) {
                LOG.info("Cannot find path " + this.outputDir + " to follow link in Output Window.");
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TestOutputListenerProvider.class, (String)"MSG_CannotFollowLink1"));
                return;
            }
            fileObject.refresh();
            file = fileObject.getFileObject(this.testname + ".txt");
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project != null) {
                NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
                File file2 = new File(nbMavenProjectImpl.getOriginalMavenProject().getBuild().getTestSourceDirectory());
                if (file != null) {
                    String string = this.testname.lastIndexOf(46) > -1 ? this.testname.substring(this.testname.lastIndexOf(46)) : this.testname;
                    this.openLog((FileObject)file, string, file2);
                } else {
                    LOG.info("Cannot find report path " + this.outputDir + this.testname + ".txt to follow link in Output Window.");
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TestOutputListenerProvider.class, (String)"MSG_CannotFollowLink2"));
                }
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openLog(FileObject fileObject, String string, File file) {
            try {
                IOProvider.getDefault().getIO(string, false).getOut().reset();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
            InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
            inputOutput.select();
            BufferedReader bufferedReader = null;
            OutputWriter outputWriter = inputOutput.getOut();
            String string2 = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
                ClassPath classPath = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    Object object;
                    Matcher matcher = this.testNamePattern.matcher(string2);
                    if (matcher.matches()) {
                        object = matcher.group(1).replace('.', File.separatorChar) + ".java";
                        File file2 = new File(file, (String)object);
                        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
                        classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/execute");
                    }
                    if (classPath != null) {
                        object = OutputUtils.matchStackTraceLine(string2, classPath);
                        if (object != null) {
                            outputWriter.println(string2, object, true);
                            continue;
                        }
                        outputWriter.println(string2);
                        continue;
                    }
                    outputWriter.println(string2);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                outputWriter.close();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }
}

