/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.validation.ModelValidationResult;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.embedder.NbArtifact;
import org.netbeans.modules.maven.nodes.DependenciesNode;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProblemReporterImpl
implements ProblemReporter,
Comparator<ProblemReport> {
    private static final String MISSINGJ2EE = "MISSINGJ2EE";
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final Set<ProblemReport> reports;
    private NbMavenProjectImpl nbproject;
    private ModuleInfo j2eeInfo;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ProblemReport problemReport;
            if ("enabled".equals(propertyChangeEvent.getPropertyName()) && (problemReport = ProblemReporterImpl.this.getReportWithId(ProblemReporterImpl.MISSINGJ2EE)) != null) {
                boolean bl;
                boolean bl2 = bl = ProblemReporterImpl.this.j2eeInfo != null && ProblemReporterImpl.this.j2eeInfo.isEnabled();
                if (bl) {
                    ProblemReporterImpl.this.removeReport(problemReport);
                    ProblemReporterImpl.this.j2eeInfo.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    };

    public ProblemReporterImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.reports = new TreeSet<ProblemReport>(this);
        this.nbproject = nbMavenProjectImpl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReport(ProblemReport problemReport) {
        assert (problemReport != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.add(problemReport);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReports(ProblemReport[] problemReportArray) {
        assert (problemReportArray != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (int i = 0; i < problemReportArray.length; ++i) {
                assert (problemReportArray[i] != null);
                this.reports.add(problemReportArray[i]);
            }
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReport(ProblemReport problemReport) {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.remove(problemReport);
        }
        this.fireChange();
    }

    private void fireChange() {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProblemReport> getReports() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            return new ArrayList<ProblemReport>(this.reports);
        }
    }

    public boolean hasReportWithId(String string) {
        return this.getReportWithId(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProblemReport getReportWithId(String string) {
        assert (string != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (ProblemReport problemReport : this.reports) {
                if (!string.equals(problemReport.getId())) continue;
                return problemReport;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReports() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.clear();
        }
        this.fireChange();
    }

    @Override
    public int compare(ProblemReport problemReport, ProblemReport problemReport2) {
        int n = new Integer(problemReport.getSeverityLevel()).compareTo(new Integer(problemReport2.getSeverityLevel()));
        if (n != 0) {
            return n;
        }
        return problemReport.hashCode() > problemReport2.hashCode() ? 1 : (problemReport.hashCode() < problemReport2.hashCode() ? -1 : 0);
    }

    public void addValidatorReports(InvalidProjectModelException invalidProjectModelException) {
        ModelValidationResult modelValidationResult = invalidProjectModelException.getValidationResult();
        if (modelValidationResult == null) {
            return;
        }
        List list = invalidProjectModelException.getValidationResult().getMessages();
        if (list != null && list.size() > 0) {
            ProblemReport problemReport = new ProblemReport(0, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_Project_validation"), invalidProjectModelException.getValidationResult().render("\n"), new OpenPomAction(this.nbproject));
            this.addReport(problemReport);
        }
    }

    private ModuleInfo findJ2eeModule() {
        Collection collection = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo moduleInfo : collection) {
            if (!"org.netbeans.modules.maven.j2ee".equals(moduleInfo.getCodeNameBase())) continue;
            return moduleInfo;
        }
        return null;
    }

    public void doBaseProblemChecks(MavenProject mavenProject) {
        Object object;
        Object object2;
        String string = this.nbproject.getProjectWatcher().getPackagingType();
        if ("war".equals(string) || "ear".equals(string) || "ejb".equals(string)) {
            boolean bl;
            if (this.j2eeInfo == null) {
                this.j2eeInfo = this.findJ2eeModule();
            }
            boolean bl2 = bl = this.j2eeInfo != null && this.j2eeInfo.isEnabled();
            if (!bl) {
                if (!this.hasReportWithId(MISSINGJ2EE)) {
                    object2 = new ProblemReport(5, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_MissingJ2eeModule"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_MissingJ2eeModule"), null);
                    ((ProblemReport)object2).setId(MISSINGJ2EE);
                    this.addReport((ProblemReport)object2);
                    if (this.j2eeInfo != null) {
                        this.j2eeInfo.addPropertyChangeListener(this.listener);
                    }
                }
            } else if (this.j2eeInfo != null) {
                this.j2eeInfo.removePropertyChangeListener(this.listener);
            }
        } else if ("nbm".equals(string)) {
            Collection collection = Lookup.getDefault().lookupAll(ModuleInfo.class);
            boolean bl = false;
            for (Object object3 : collection) {
                if (!"org.netbeans.modules.maven.apisupport".equals(object3.getCodeNameBase()) || !object3.isEnabled()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                object = new ProblemReport(5, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_MissingApisupportModule"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_MissingApisupportModule"), null);
                this.addReport((ProblemReport)object);
            }
        }
        if (mavenProject != null) {
            for (MavenProject mavenProject2 = mavenProject; mavenProject2 != null; mavenProject2 = mavenProject2.getParent()) {
                this.checkParent(mavenProject2);
            }
            object2 = mavenProject.getTestArtifacts();
            if (object2 != null) {
                Object object4;
                Object object5;
                Object object3;
                object = new ArrayList();
                object3 = object2.iterator();
                while (object3.hasNext()) {
                    object5 = (NbArtifact)object3.next();
                    if (object5.getFile() != null && object5.isFakedSystemDependency()) {
                        object4 = new ProblemReport(5, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_SystemScope"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_SystemScope"), new OpenPomAction(this.nbproject));
                        this.addReport((ProblemReport)object4);
                        continue;
                    }
                    if (object5.getFile() != null && object5.getFile().exists()) continue;
                    object.add(object5);
                }
                if (object.size() > 0) {
                    Object object6;
                    object5 = object.iterator();
                    object4 = "";
                    while (object5.hasNext()) {
                        object6 = (Artifact)object5.next();
                        object4 = (String)object4 + object6.getId() + "\n";
                    }
                    object6 = new DependenciesNode.ResolveDepsAction(this.nbproject);
                    ((AbstractAction)object6).putValue("Name", NbBundle.getMessage(ProblemReporterImpl.class, (String)"ACT_DownloadDeps"));
                    ProblemReport problemReport = new ProblemReport(5, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_NonLocal"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_NonLocal", (Object)object4), (Action)object6);
                    this.addReport(problemReport);
                }
            }
        }
    }

    private void checkParent(MavenProject mavenProject) {
        Artifact artifact = mavenProject.getParentArtifact();
        if (artifact != null && artifact instanceof NbArtifact) {
            File file = mavenProject.getParent().getFile();
            if (file != null && file.exists()) {
                return;
            }
            NbArtifact nbArtifact = (NbArtifact)artifact;
            nbArtifact.getFile();
            if (nbArtifact.getNonFakedFile() != null && !nbArtifact.getNonFakedFile().exists()) {
                ProblemReport problemReport = new ProblemReport(0, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_NoParent"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_NoParent", (Object)nbArtifact.getId()), new OpenPomAction(this.nbproject));
                this.addReport(problemReport);
            }
        }
    }

    static class OpenPomAction
    extends AbstractAction {
        private NbMavenProjectImpl project;
        private String filepath;

        OpenPomAction(NbMavenProjectImpl nbMavenProjectImpl) {
            this.putValue("Name", NbBundle.getMessage(ProblemReporterImpl.class, (String)"ACT_OpenPom"));
            this.project = nbMavenProjectImpl;
        }

        OpenPomAction(NbMavenProjectImpl nbMavenProjectImpl, String string) {
            this(nbMavenProjectImpl);
            this.filepath = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileObject fileObject = null;
            fileObject = this.filepath != null ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.filepath))) : FileUtil.toFileObject((File)this.project.getPOMFile());
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
                    editCookie.edit();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObjectNotFoundException.printStackTrace();
                }
            }
        }
    }
}

