/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenForBinaryQueryImpl
implements SourceForBinaryQueryImplementation,
JavadocForBinaryQueryImplementation {
    private NbMavenProjectImpl project;
    private final HashMap<String, BinResult> map;

    public MavenForBinaryQueryImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
        this.map = new HashMap();
        NbMavenProject.addPropertyChangeListener(nbMavenProjectImpl, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    HashMap hashMap = MavenForBinaryQueryImpl.this.map;
                    synchronized (hashMap) {
                        for (BinResult binResult : MavenForBinaryQueryImpl.this.map.values()) {
                            if (Arrays.equals(binResult.getCached(), binResult.getRoots())) continue;
                            binResult.fireChanged();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        HashMap<String, BinResult> hashMap = this.map;
        synchronized (hashMap) {
            int n;
            BinResult binResult = this.map.get(uRL.toString());
            if (binResult != null) {
                return binResult;
            }
            if (uRL.getProtocol().equals("jar") && this.checkURL(uRL) != -1) {
                binResult = new BinResult(uRL);
            }
            if (uRL.getProtocol().equals("file") && ((n = this.checkURL(uRL)) == 1 || n == 0)) {
                binResult = new BinResult(uRL);
            }
            if (binResult != null) {
                this.map.put(uRL.toString(), binResult);
            }
            return binResult;
        }
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL uRL) {
        if (this.checkURL(uRL) != -1) {
            return new DocResult(uRL);
        }
        return null;
    }

    private int checkURL(URL uRL) {
        if ("file".equals(uRL.getProtocol())) {
            try {
                Build build;
                MavenProject mavenProject = this.project.getOriginalMavenProject();
                if (mavenProject != null && (build = mavenProject.getBuild()) != null && build.getOutputDirectory() != null) {
                    File file = FileUtil.normalizeFile((File)new File(build.getOutputDirectory()));
                    URL uRL2 = file.toURI().toURL();
                    if (!uRL2.toExternalForm().endsWith("/")) {
                        uRL2 = new URL(uRL2.toExternalForm() + "/");
                    }
                    if (uRL.equals(uRL2)) {
                        return 0;
                    }
                    File file2 = FileUtil.normalizeFile((File)new File(build.getTestOutputDirectory()));
                    URL uRL3 = file2.toURI().toURL();
                    if (!uRL3.toExternalForm().endsWith("/")) {
                        uRL3 = new URL(uRL3.toExternalForm() + "/");
                    }
                    if (uRL.equals(uRL3)) {
                        return 1;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
            return -1;
        }
        if ("jar".equals(uRL.getProtocol()) && !Boolean.getBoolean("mevenide.projectLinksDisable")) {
            String string;
            int n;
            URL uRL4 = FileUtil.getArchiveFile((URL)uRL);
            File file = new File(URI.create(uRL4.toString()));
            String string2 = file.getAbsolutePath().replace('\\', '/');
            int n2 = n = string2.endsWith(string = this.project.getArtifactRelativeRepositoryPath()) ? 0 : -1;
            if (n == -1) {
                string = this.project.getTestArtifactRelativeRepositoryPath();
                n = string2.endsWith(string) ? 1 : -1;
            }
            return n;
        }
        return -1;
    }

    private FileObject[] getSrcRoot() {
        URI[] uRIArray2;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        List list = this.project.getOriginalMavenProject().getCompileSourceRoots();
        for (URI[] uRIArray2 : list) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File((String)uRIArray2)));
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        uRIArray2 = this.project.getGeneratedSourceRoots();
        for (int i = 0; i < uRIArray2.length; ++i) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(uRIArray2[i])));
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        URI[] uRIArray3 = this.project.getResources(false);
        for (int i = 0; i < uRIArray3.length; ++i) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(uRIArray3[i]));
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private FileObject[] getTestSrcRoot() {
        URI[] uRIArray2;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        List list = this.project.getOriginalMavenProject().getTestCompileSourceRoots();
        for (URI[] uRIArray2 : list) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File((String)uRIArray2)));
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        uRIArray2 = this.project.getResources(true);
        for (int i = 0; i < uRIArray2.length; ++i) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(uRIArray2[i]));
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private URL[] getJavadocRoot() {
        return new URL[0];
    }

    private class DocResult
    implements JavadocForBinaryQuery.Result {
        private URL url;
        private URL[] results;
        private final List<ChangeListener> listeners;

        public DocResult(URL uRL) {
            this.url = uRL;
            this.listeners = new ArrayList<ChangeListener>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public URL[] getRoots() {
            this.results = MavenForBinaryQueryImpl.this.checkURL(this.url) != -1 ? MavenForBinaryQueryImpl.this.getJavadocRoot() : new URL[0];
            return this.results;
        }
    }

    private class BinResult
    implements SourceForBinaryQuery.Result {
        private URL url;
        private final List<ChangeListener> listeners;
        private FileObject[] results;
        private FileObject[] cached = null;

        public BinResult(URL uRL) {
            this.url = uRL;
            this.listeners = new ArrayList<ChangeListener>();
        }

        public FileObject[] getRoots() {
            int n = MavenForBinaryQueryImpl.this.checkURL(this.url);
            this.results = n == 0 ? MavenForBinaryQueryImpl.this.getSrcRoot() : (n == 1 ? MavenForBinaryQueryImpl.this.getTestSrcRoot() : new FileObject[0]);
            this.cached = this.results;
            return this.results;
        }

        public FileObject[] getCached() {
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

