/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class RepositoryJavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation {
    public JavadocForBinaryQuery.Result findJavadoc(URL uRL) {
        File file;
        URL uRL2 = uRL;
        if (!"jar".equals(uRL.getProtocol())) {
            return null;
        }
        uRL2 = FileUtil.getArchiveFile((URL)uRL);
        FileObject fileObject = URLMapper.findFileObject((URL)uRL2);
        if (fileObject != null && (file = FileUtil.toFile((FileObject)fileObject)) != null) {
            File file2;
            if (file.getPath().endsWith("javaee/javaee-api/5/javaee-api-5.jar")) {
                return new Javaee5Result();
            }
            File file3 = file.getParentFile();
            if (file3 != null && (file2 = file3.getParentFile()) != null) {
                String string = file2.getName();
                String string2 = file3.getName();
                File file4 = new File(file3, string + "-" + string2 + "-javadoc.jar");
                if (file4.exists() || file.getName().startsWith(string) && file.getName().contains(string2)) {
                    return new DocResult(file4);
                }
            }
        }
        return null;
    }

    private class Javaee5Result
    implements JavadocForBinaryQuery.Result {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        Javaee5Result() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public URL[] getRoots() {
            try {
                File file = InstalledFileLocator.getDefault().locate("docs/javaee5-doc-api.zip", null, false);
                if (file != null) {
                    URL uRL = FileUtil.getArchiveRoot((URL)file.toURI().toURL());
                    uRL = new URL(uRL + "docs/api/");
                    return new URL[]{uRL};
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            return new URL[0];
        }
    }

    private class DocResult
    implements JavadocForBinaryQuery.Result {
        private static final String ATTR_PATH = "lastRootCheckPath";
        private static final String ATTR_STAMP = "lastRootCheckStamp";
        private File file;
        private final List<ChangeListener> listeners;

        public DocResult(File file) {
            this.file = file;
            this.listeners = new ArrayList<ChangeListener>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public URL[] getRoots() {
            try {
                if (this.file.exists()) {
                    URL[] uRLArray;
                    FileObject fileObject = FileUtil.toFileObject((File)this.file);
                    if (!FileUtil.isArchiveFile((FileObject)fileObject)) {
                        Logger.getLogger(RepositoryJavadocForBinaryQueryImpl.class.getName()).info("The following javadoc jar in repository is not really a jar file: " + this.file.getAbsolutePath());
                        return new URL[0];
                    }
                    Date date = (Date)fileObject.getAttribute(ATTR_STAMP);
                    String string = (String)fileObject.getAttribute(ATTR_PATH);
                    if (date == null || fileObject.lastModified().after(date)) {
                        string = this.checkPath(FileUtil.getArchiveRoot((FileObject)fileObject), fileObject);
                    }
                    if (string != null) {
                        uRLArray = new URL[1];
                        URL uRL = FileUtil.getArchiveRoot((URL)this.file.toURI().toURL());
                        if (!string.endsWith("/")) {
                            string = string + "/";
                        }
                        uRLArray[0] = new URL(uRL, string);
                    } else {
                        uRLArray = new URL[]{FileUtil.getArchiveRoot((URL)this.file.toURI().toURL())};
                    }
                    return uRLArray;
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
            return new URL[0];
        }

        private String checkPath(FileObject fileObject, FileObject fileObject2) {
            String string = null;
            FileObject fileObject3 = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)fileObject);
            try {
                if (fileObject3 != null && !fileObject3.equals(fileObject)) {
                    string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject3);
                    fileObject2.setAttribute(ATTR_PATH, (Object)string);
                }
                fileObject2.setAttribute(ATTR_STAMP, (Object)new Date());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return string;
        }
    }
}

