/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.spi.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Writer;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenActionsProvider
implements MavenActionsProvider {
    protected ActionToGoalMapping originalMappings;
    protected NetbeansBuildActionXpp3Reader reader = new NetbeansBuildActionXpp3Reader();
    private NetbeansBuildActionXpp3Writer writer = new NetbeansBuildActionXpp3Writer();

    protected static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        FileObject fileObject;
        Object object2;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Object object2 : lookup.lookup(new Lookup.Template(DataObject.class)).allInstances()) {
            fileObject = object2.getPrimaryFile();
            arrayList.add(fileObject);
        }
        object2 = lookup.lookupAll(SingleMethod.class);
        if (object2.size() == 1) {
            fileObject = (SingleMethod)object2.iterator().next();
            arrayList.add(fileObject.getFile());
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    @Override
    public boolean isActionEnable(String string, Project project, Lookup lookup) {
        ActionToGoalMapping actionToGoalMapping = this.getRawMappings();
        Iterator<NetbeansActionMapping> iterator = actionToGoalMapping.getActions().iterator();
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        String string2 = nbMavenProject.getPackagingType();
        while (iterator.hasNext()) {
            NetbeansActionMapping netbeansActionMapping = iterator.next();
            if (!string.equals(netbeansActionMapping.getActionName()) || !netbeansActionMapping.getPackagings().isEmpty() && !netbeansActionMapping.getPackagings().contains(string2.trim()) && !netbeansActionMapping.getPackagings().contains("*")) continue;
            return true;
        }
        return false;
    }

    @Override
    public final RunConfig createConfigForDefaultAction(String string, Project project, Lookup lookup) {
        FileObject[] fileObjectArray = AbstractMavenActionsProvider.extractFileObjectsfromLookup(lookup);
        HashMap<String, String> hashMap = (HashMap<String, String>)lookup.lookup(Map.class);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            Logger.getLogger(AbstractMavenActionsProvider.class.getName()).log(Level.FINE, "Missing replace tokens map when executing maven build. Could lead to problems with execution. See issue #159698 for details.", new Exception());
        }
        FileObject fileObject = null;
        if (fileObjectArray.length > 0) {
            fileObject = fileObjectArray[0];
        }
        return this.mapGoalsToAction(project, string, hashMap, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionToGoalMapping getRawMappings() {
        if (this.originalMappings == null || this.reloadStream()) {
            InputStream inputStream = this.getActionDefinitionStream();
            if (inputStream == null) {
                this.originalMappings = new ActionToGoalMapping();
            } else {
                InputStreamReader inputStreamReader = null;
                try {
                    inputStreamReader = new InputStreamReader(inputStream);
                    this.originalMappings = this.reader.read(inputStreamReader);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.originalMappings = new ActionToGoalMapping();
                }
                catch (XmlPullParserException xmlPullParserException) {
                    xmlPullParserException.printStackTrace();
                    this.originalMappings = new ActionToGoalMapping();
                }
                finally {
                    if (inputStreamReader != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        }
        return this.originalMappings;
    }

    public String getRawMappingsAsString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writer.write(stringWriter, this.getRawMappings());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringWriter.toString();
    }

    @Override
    public Set<String> getSupportedDefaultActions() {
        HashSet<String> hashSet = new HashSet<String>();
        ActionToGoalMapping actionToGoalMapping = this.getRawMappings();
        for (NetbeansActionMapping netbeansActionMapping : actionToGoalMapping.getActions()) {
            NetbeansActionMapping netbeansActionMapping2 = netbeansActionMapping;
            String string = netbeansActionMapping2.getActionName();
            if (string == null || string.startsWith("CUSTOM-")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected boolean reloadStream() {
        return false;
    }

    @Override
    public NetbeansActionMapping getMappingForAction(String string, Project project) {
        NetbeansActionMapping netbeansActionMapping = null;
        try {
            Reader reader = this.performDynamicSubstitutions(Collections.EMPTY_MAP, this.getRawMappingsAsString());
            ActionToGoalMapping actionToGoalMapping = this.reader.read(reader);
            Iterator<NetbeansActionMapping> iterator = actionToGoalMapping.getActions().iterator();
            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            String string2 = nbMavenProject.getPackagingType();
            while (iterator.hasNext()) {
                NetbeansActionMapping netbeansActionMapping2 = iterator.next();
                if (!string.equals(netbeansActionMapping2.getActionName()) || !netbeansActionMapping2.getPackagings().isEmpty() && !netbeansActionMapping2.getPackagings().contains(string2.trim()) && !netbeansActionMapping2.getPackagings().contains("*")) continue;
                netbeansActionMapping = netbeansActionMapping2;
                break;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return netbeansActionMapping;
    }

    protected abstract InputStream getActionDefinitionStream();

    private RunConfig mapGoalsToAction(Project project, String string, Map<String, String> map, FileObject fileObject) {
        try {
            Object object;
            Reader reader = this.performDynamicSubstitutions(map, this.getRawMappingsAsString());
            ActionToGoalMapping actionToGoalMapping = this.reader.read(reader);
            Iterator<NetbeansActionMapping> iterator = actionToGoalMapping.getActions().iterator();
            Object object2 = null;
            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            String string2 = nbMavenProject.getPackagingType();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!string.equals(((NetbeansActionMapping)object).getActionName()) || !((NetbeansActionMapping)object).getPackagings().contains(string2.trim()) && !((NetbeansActionMapping)object).getPackagings().contains("*") && ((NetbeansActionMapping)object).getPackagings().size() != 0) continue;
                object2 = object;
                break;
            }
            if (object2 != null) {
                object = new ModelRunConfig(project, (NetbeansActionMapping)object2, string, fileObject);
                if (map.containsKey("nb.single.run.methodName")) {
                    ((BeanRunConfig)object).setProperty("nb.single.run.methodName", map.get("nb.single.run.methodName"));
                }
                return object;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    protected Reader performDynamicSubstitutions(Map map, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (Map.Entry entry : map.entrySet()) {
            String string2 = "${" + entry.getKey() + "}";
            int n = stringBuffer.indexOf(string2);
            while (n > -1) {
                String string3 = (String)entry.getValue();
                if (string3 == null) {
                    // empty if block
                }
                string3 = string3 == null ? "" : string3;
                stringBuffer.replace(n, n + string2.length(), string3);
                n = stringBuffer.indexOf(string2);
            }
        }
        return new StringReader(stringBuffer.toString());
    }
}

