/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.NilImplicitNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListNode
extends Node {
    private List<Node> list = new ArrayList<Node>(0);

    public ListNode(SourcePosition position, Node firstNode) {
        this(position);
        this.list = new ArrayList<Node>(4);
        this.list.add(firstNode);
    }

    public ListNode(SourcePosition position) {
        super(position);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LISTNODE;
    }

    public ListNode add(Node node) {
        if (node == null || node == NilImplicitNode.NIL) {
            this.list.add(NilImplicitNode.NIL);
            return this;
        }
        this.list.add(node);
        if (this.getPosition() == null) {
            this.setPosition(node.getPosition());
        } else {
            this.setPosition(this.getPosition().union(node.getPosition()));
        }
        return this;
    }

    public ListNode prepend(Node node) {
        if (node == null) {
            return this;
        }
        this.list.add(0, node);
        this.setPosition(this.getPosition().union(node.getPosition()));
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public ListNode addAll(ListNode other) {
        if (other != null && other.size() > 0) {
            this.list.addAll(other.list);
            this.setPosition(this.getPosition().union(this.getLast().getPosition()));
        }
        return this;
    }

    public ListNode addAll(Node other) {
        return this.add(other);
    }

    public Node getLast() {
        return this.list.size() == 0 ? null : this.list.get(this.list.size() - 1);
    }

    @Override
    public List<Node> childNodes() {
        return this.list;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        throw new RuntimeException("Base class ListNode should never be evaluated");
    }

    public Node get(int idx) {
        return this.list.get(idx);
    }
}

