/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IntList;
import org.netbeans.core.output2.IntMap;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.SparseIntList;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.windows.IOColors;
import org.openide.windows.OutputListener;

abstract class AbstractLines
implements Lines,
Runnable,
ActionListener {
    IntList lineStartList;
    IntMap linesToListeners;
    IntMap linesToColors;
    private int longestLineLen = 0;
    private int knownCharsPerLine = -1;
    private SparseIntList knownLogicalLineCounts = null;
    private IntList errLines = null;
    private int lastStorageSize = -1;
    private int lastErrLineMarked = -1;
    private ChangeListener listener = null;
    private Timer timer = null;
    private final AtomicBoolean newEvent = new AtomicBoolean(false);
    private boolean dirty;
    private IntList importantLines = new IntList(10);
    private boolean lastLineFinished = true;
    private int lastLineLength = -1;
    static final Color[] DEF_COLORS;
    Color[] curDefColors;
    private static final int MAX_FIND_SIZE = 16384;
    private Pattern pattern;

    AbstractLines() {
        if (Controller.LOG) {
            Controller.log("Creating a new AbstractLines");
        }
        this.init();
    }

    protected abstract Storage getStorage();

    protected abstract boolean isDisposed();

    protected abstract void handleException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getText(int n, int n2, char[] cArray) {
        if (cArray == null) {
            cArray = new char[n2 - n];
        }
        if (n2 < n || n < 0) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + n2);
        }
        if (n2 - n > cArray.length) {
            throw new IllegalArgumentException("Array size is too small");
        }
        Object object = this.readLock();
        synchronized (object) {
            if (this.isDisposed()) {
                for (int i = 0; i < n2 - n; ++i) {
                    cArray[i] = '\u0000';
                }
                return cArray;
            }
            int n3 = AbstractLines.toByteIndex(n);
            int n4 = AbstractLines.toByteIndex(n2 - n);
            try {
                CharBuffer charBuffer = this.getStorage().getReadBuffer(n3, n4).asCharBuffer();
                int n5 = Math.min(n2 - n, charBuffer.remaining());
                charBuffer.get(cArray, 0, n5);
                return cArray;
            }
            catch (Exception exception) {
                this.handleException(exception);
                return new char[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int n, int n2) {
        if (n2 < n || n < 0) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + n2);
        }
        Object object = this.readLock();
        synchronized (object) {
            if (this.isDisposed()) {
                return new String(new char[n2 - n]);
            }
            int n3 = AbstractLines.toByteIndex(n);
            int n4 = AbstractLines.toByteIndex(n2 - n);
            int n5 = this.getStorage().size();
            if (n5 < n3 + n4) {
                throw new ArrayIndexOutOfBoundsException("Bytes from " + n3 + " to " + (n3 + n4) + " requested, " + "but storage is only " + n5 + " bytes long");
            }
            try {
                return this.getStorage().getReadBuffer(n3, n4).asCharBuffer().toString();
            }
            catch (Exception exception) {
                this.handleException(exception);
                return new String(new char[n2 - n]);
            }
        }
    }

    void onDispose(int n) {
        this.lastStorageSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getByteSize() {
        Object object = this.readLock();
        synchronized (object) {
            if (this.lastStorageSize >= 0) {
                return this.lastStorageSize;
            }
            Storage storage = this.getStorage();
            int n = storage == null ? 0 : storage.size();
            return n;
        }
    }

    void markErr() {
        int n;
        if (this.isDisposed() || this.getStorage().isClosed()) {
            return;
        }
        if (this.errLines == null) {
            this.errLines = new IntList(20);
        }
        if ((n = this.getLineCount()) != this.lastErrLineMarked) {
            this.errLines.add(n == 0 ? 0 : n - (this.isLastLineFinished() ? 2 : 1));
            this.lastErrLineMarked = n;
        }
    }

    public boolean isErr(int n) {
        return this.errLines != null ? this.errLines.contains(n) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
        AbstractLines abstractLines = this;
        synchronized (abstractLines) {
            if (this.getLineCount() > 0) {
                this.fire();
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listener == changeListener) {
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        this.newEvent.set(false);
        this.fire();
        AtomicBoolean atomicBoolean = this.newEvent;
        synchronized (atomicBoolean) {
            if (!this.newEvent.get()) {
                this.timer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delayedFire() {
        this.newEvent.set(true);
        if (this.listener == null) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer(200, this);
        }
        AtomicBoolean atomicBoolean = this.newEvent;
        synchronized (atomicBoolean) {
            if (this.newEvent.get() && !this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    public void fire() {
        if (Controller.LOG) {
            Controller.log(this + ": Writer firing " + this.getStorage().size() + " bytes written");
        }
        if (this.listener != null) {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    public void run() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean hasHyperlinks() {
        return this.firstListenerLine() != -1;
    }

    public boolean isHyperlink(int n) {
        return this.getListenerForLine(n) != null;
    }

    private void init() {
        this.knownLogicalLineCounts = null;
        this.lineStartList = new IntList(100);
        this.lineStartList.add(0);
        this.linesToListeners = new IntMap();
        this.linesToColors = new IntMap();
        this.longestLineLen = 0;
        this.errLines = null;
        this.listener = null;
        this.dirty = false;
        this.curDefColors = (Color[])DEF_COLORS.clone();
    }

    public boolean checkDirty(boolean bl) {
        if (this.isDisposed()) {
            return false;
        }
        boolean bl2 = this.dirty;
        if (bl) {
            this.dirty = false;
        }
        return bl2;
    }

    public int[] allListenerLines() {
        return this.linesToListeners.getKeys();
    }

    public int getCharCount() {
        return AbstractLines.toCharIndex(this.getByteSize());
    }

    public String getLine(int n) throws IOException {
        int n2 = this.getCharLineStart(n);
        int n3 = AbstractLines.toCharIndex(n < this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) : this.getByteSize());
        return this.getText(n2, n3);
    }

    private int getByteLineLength(int n) {
        if (n == this.lineStartList.size() - 1) {
            return Math.max(0, AbstractLines.toByteIndex(this.lastLineLength));
        }
        int n2 = this.getByteLineStart(n);
        int n3 = n < this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) - 2 : this.getByteSize();
        return n3 - n2;
    }

    public boolean isLineStart(int n) {
        int n2 = AbstractLines.toByteIndex(n);
        return this.lineStartList.contains(n2) || n2 == 0 || n2 == this.getByteSize() && this.lastLineFinished;
    }

    public int length(int n) {
        return AbstractLines.toCharIndex(this.getByteLineLength(n));
    }

    public int getLineStart(int n) {
        return this.getCharLineStart(n);
    }

    private int getByteLineStart(int n) {
        if (n == this.lineStartList.size() && this.lastLineFinished) {
            return this.getByteSize();
        }
        return this.lineStartList.get(n);
    }

    private int getCharLineStart(int n) {
        return AbstractLines.toCharIndex(this.getByteLineStart(n));
    }

    public int getLineAt(int n) {
        int n2 = AbstractLines.toByteIndex(n);
        if (n2 >= this.getByteSize()) {
            return this.getLineCount() - 1;
        }
        return this.lineStartList.findNearest(n2);
    }

    public int getLineCount() {
        return this.lineStartList.size();
    }

    public OutputListener getListenerForLine(int n) {
        return (OutputListener)this.linesToListeners.get(n);
    }

    public int firstListenerLine() {
        if (this.isDisposed()) {
            return -1;
        }
        return this.linesToListeners.isEmpty() ? -1 : this.linesToListeners.first();
    }

    public int nearestListenerLine(int n, boolean bl) {
        if (this.isDisposed()) {
            return -1;
        }
        return this.linesToListeners.nearest(n, bl);
    }

    public int getLongestLineLength() {
        return this.longestLineLen;
    }

    public void toPhysicalLineIndex(int[] nArray, int n) {
        int n2 = nArray[0];
        if (n2 <= 0) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = AbstractLines.lengthToLineCount(this.length(0), n);
            return;
        }
        if (n >= this.longestLineLen || this.getLineCount() < 1) {
            nArray[1] = 0;
            nArray[2] = 1;
            return;
        }
        int n3 = Math.min(this.findPhysicalLine(n2, n), this.getLineCount() - 1);
        int n4 = this.getLogicalLineCountAbove(n3, n);
        int n5 = this.length(n3);
        int n6 = AbstractLines.lengthToLineCount(n5, n);
        nArray[0] = n3;
        nArray[1] = n2 - n4;
        nArray[2] = n6;
    }

    private int findPhysicalLine(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(n2);
        }
        return this.knownLogicalLineCounts.getNextKey(n);
    }

    public int getLogicalLineCountAbove(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 >= this.longestLineLen) {
            return n;
        }
        if (n2 != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(n2);
        }
        return this.knownLogicalLineCounts.get(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogicalLineCountIfWrappedAt(int n) {
        if (n >= this.longestLineLen) {
            return this.getLineCount();
        }
        int n2 = this.getLineCount();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        Object object = this.readLock();
        synchronized (object) {
            if (n != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
                this.calcLogicalLineCount(n);
            }
            return this.knownLogicalLineCounts.get(n2 - 1);
        }
    }

    public void addListener(int n, OutputListener outputListener, boolean bl) {
        if (outputListener == null) {
            Logger.getLogger(AbstractLines.class.getName()).log(Level.WARNING, "Issue #56826 - Adding a null OutputListener for line: " + n, new NullPointerException());
        } else {
            this.linesToListeners.put(n, outputListener);
            if (bl) {
                this.importantLines.add(n);
            }
        }
    }

    public void setColor(int n, Color color) {
        if (color != null) {
            this.linesToColors.put(n, color);
        }
    }

    public int firstImportantListenerLine() {
        return this.importantLines.size() == 0 ? -1 : this.importantLines.get(0);
    }

    public boolean isImportantHyperlink(int n) {
        return this.importantLines.contains(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcLogicalLineCount(int n) {
        Object object = this.readLock();
        synchronized (object) {
            int n2 = this.getLineCount();
            this.knownLogicalLineCounts = new SparseIntList(30);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = this.length(i);
                if (n4 > n) {
                    this.knownLogicalLineCounts.add(i, n3 += AbstractLines.lengthToLineCount(n4, n));
                    continue;
                }
                ++n3;
            }
            this.knownCharsPerLine = n;
        }
    }

    static int lengthToLineCount(int n, int n2) {
        return n > n2 ? (n2 == 0 ? n : (n + n2 - 1) / n2) : 1;
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isLastLineFinished() {
        return this.lastLineFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastLine(int n, int n2) {
        Object object = this.readLock();
        synchronized (object) {
            boolean bl;
            this.longestLineLen = Math.max(this.longestLineLen, n2);
            if (this.knownLogicalLineCounts == null) {
                return;
            }
            boolean bl2 = bl = this.knownLogicalLineCounts.lastIndex() == n;
            if (bl) {
                assert (!this.lastLineFinished);
                if (n2 <= this.knownCharsPerLine) {
                    this.knownLogicalLineCounts.removeLast();
                } else {
                    int n3 = this.knownLogicalLineCounts.lastAdded() - AbstractLines.lengthToLineCount(this.lastLineLength, this.knownCharsPerLine) + AbstractLines.lengthToLineCount(n2, this.knownCharsPerLine);
                    this.knownLogicalLineCounts.updateLast(n, n3);
                }
            } else {
                if (n2 <= this.knownCharsPerLine) {
                    return;
                }
                int n4 = this.knownLogicalLineCounts.lastIndex() != -1 ? n - (this.knownLogicalLineCounts.lastIndex() + 1) + this.knownLogicalLineCounts.lastAdded() : Math.max(0, n - 1);
                this.knownLogicalLineCounts.add(n, n4 += AbstractLines.lengthToLineCount(n2, this.knownCharsPerLine));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineUpdated(int n, int n2, boolean bl) {
        Object object = this.readLock();
        synchronized (object) {
            int n3 = AbstractLines.toCharIndex(n2);
            if (bl) {
                --n3;
            }
            this.updateLastLine(this.lineStartList.size() - 1, n3);
            if (bl) {
                this.lineStartList.add(n + n2);
            }
            this.lastLineFinished = bl;
            this.lastLineLength = bl ? -1 : n3;
        }
        this.markDirty();
    }

    static int toByteIndex(int n) {
        return n << 1;
    }

    static int toCharIndex(int n) {
        assert (n % 2 == 0) : "bad index: " + n;
        return n >> 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(String string) throws IOException {
        Storage storage = this.getStorage();
        if (storage == null) {
            throw new IOException("Data has already been disposed");
        }
        File file = new File(string);
        CharBuffer charBuffer = storage.getReadBuffer(0, storage.size()).asCharBuffer();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            String string2 = System.getProperty("file.encoding");
            if (string2 == null) {
                string2 = "UTF-8";
            }
            Charset charset = Charset.forName(string2);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.write(byteBuffer);
            fileChannel.close();
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void setDefColor(IOColors.OutputType outputType, Color color) {
        this.curDefColors[outputType.ordinal()] = color;
    }

    Color getDefColor(int n) {
        return this.curDefColors[n];
    }

    Color getLineColor(int n) {
        return (Color)this.linesToColors.get(n);
    }

    public Color getColorForLine(int n) {
        Color color = (Color)this.linesToColors.get(n);
        if (color != null) {
            return color;
        }
        boolean bl = this.isHyperlink(n);
        boolean bl2 = bl ? this.isImportantHyperlink(n) : false;
        boolean bl3 = this.isErr(n);
        if (bl) {
            return bl2 ? this.curDefColors[IOColors.OutputType.HYPERLINK_IMPORTANT.ordinal()] : this.curDefColors[IOColors.OutputType.HYPERLINK.ordinal()];
        }
        return bl3 ? this.curDefColors[IOColors.OutputType.ERROR.ordinal()] : this.curDefColors[IOColors.OutputType.OUTPUT.ordinal()];
    }

    private boolean regExpChanged(String string, boolean bl) {
        return this.pattern != null && (!this.pattern.toString().equals(string) || this.pattern.flags() == 2 == bl);
    }

    public int[] find(int n, String string, boolean bl, boolean bl2) {
        Storage storage = this.getStorage();
        if (storage == null) {
            return null;
        }
        if (bl && this.regExpChanged(string, bl2)) {
            this.pattern = null;
        }
        if (!bl && !bl2) {
            string = string.toLowerCase();
        }
        while (true) {
            int n2;
            if ((n2 = this.getCharCount() - n) > 16384) {
                int n3 = this.getLineAt(n + 16384);
                n2 = this.getLineStart(n3) + this.length(n3) - n;
            } else if (n2 <= 0) break;
            CharBuffer charBuffer = null;
            try {
                charBuffer = storage.getReadBuffer(AbstractLines.toByteIndex(n), AbstractLines.toByteIndex(n2)).asCharBuffer();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (charBuffer == null) break;
            if (bl) {
                Matcher matcher;
                if (this.pattern == null) {
                    Pattern pattern = this.pattern = bl2 ? Pattern.compile(string) : Pattern.compile(string, 2);
                }
                if ((matcher = this.pattern.matcher(charBuffer)).find()) {
                    return new int[]{n + matcher.start(), n + matcher.end()};
                }
            } else {
                int n4;
                int n5 = n4 = bl2 ? charBuffer.toString().indexOf(string) : charBuffer.toString().toLowerCase().indexOf(string);
                if (n4 != -1) {
                    return new int[]{n + n4, n + n4 + string.length()};
                }
            }
            n += charBuffer.length();
        }
        return null;
    }

    public int[] rfind(int n, String string, boolean bl, boolean bl2) {
        block11: {
            int n2;
            Storage storage = this.getStorage();
            if (storage == null) {
                return null;
            }
            if (bl && this.regExpChanged(string, bl2)) {
                this.pattern = null;
            }
            if (!bl && !bl2) {
                string = string.toLowerCase();
            }
            while (true) {
                int n3;
                if ((n = (n3 = n) - 16384) < 0) {
                    n = 0;
                } else {
                    int n4 = this.getLineAt(n);
                    n = this.getLineStart(n4);
                }
                if (n == n3) break block11;
                CharBuffer charBuffer = null;
                try {
                    charBuffer = storage.getReadBuffer(AbstractLines.toByteIndex(n), AbstractLines.toByteIndex(n3 - n)).asCharBuffer();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                if (charBuffer == null) break block11;
                if (bl) {
                    if (this.pattern == null) {
                        this.pattern = bl2 ? Pattern.compile(string) : Pattern.compile(string, 2);
                    }
                    Matcher matcher = this.pattern.matcher(charBuffer);
                    int n5 = -1;
                    int n6 = -1;
                    while (matcher.find()) {
                        n5 = matcher.start();
                        n6 = matcher.end();
                    }
                    if (n5 == -1) continue;
                    return new int[]{n + n5, n + n6};
                }
                n2 = bl2 ? charBuffer.toString().lastIndexOf(string) : charBuffer.toString().toLowerCase().lastIndexOf(string);
                if (n2 != -1) break;
            }
            return new int[]{n + n2, n + n2 + string.length()};
        }
        return null;
    }

    public String toString() {
        return this.lineStartList.toString();
    }

    static {
        Color color;
        Color color2;
        Color color3;
        Color color4 = UIManager.getColor("nb.output.foreground");
        if (color4 == null && (color4 = UIManager.getColor("textText")) == null) {
            color4 = Color.BLACK;
        }
        if ((color3 = UIManager.getColor("nb.output.err.foreground")) == null) {
            color3 = new Color(164, 0, 0);
        }
        if ((color2 = UIManager.getColor("nb.output.link.foreground")) == null) {
            color2 = Color.BLUE.darker();
        }
        if ((color = UIManager.getColor("nb.output.link.foreground.important")) == null) {
            color = color3;
        }
        DEF_COLORS = new Color[]{color4, color3, color2, color};
    }
}

