/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.Component;
import java.awt.Insets;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.WeakAction;

public abstract class AbstractOutputTab
extends JComponent
implements Accessible {
    private boolean inputVisible = false;
    private AbstractOutputPane outputPane;
    private Action[] actions = new Action[0];
    private Component toFocus;

    public AbstractOutputTab() {
        this.outputPane = this.createOutputPane();
        this.add(this.outputPane);
        this.setFocusable(false);
    }

    public void setDocument(Document document) {
        this.outputPane.setDocument(document);
        if (document instanceof OutputDocument) {
            ((OutputDocument)document).setPane(this.outputPane);
        }
    }

    public AbstractOutputPane setOutputPane(AbstractOutputPane abstractOutputPane) {
        AbstractOutputPane abstractOutputPane2 = this.outputPane;
        this.remove(this.outputPane);
        this.outputPane = abstractOutputPane;
        this.add(this.outputPane);
        return abstractOutputPane2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return AbstractOutputTab.this.getName();
                }
            };
        }
        return this.accessibleContext;
    }

    public void setToFocus(Component component) {
        this.toFocus = component;
    }

    public void requestFocus() {
        if (this.toFocus != null) {
            this.toFocus.requestFocus();
            this.toFocus = null;
            return;
        }
        this.outputPane.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.getOutputPane().requestFocusInWindow();
    }

    protected abstract AbstractOutputPane createOutputPane();

    protected abstract void inputSent(String var1);

    public final AbstractOutputPane getOutputPane() {
        return this.outputPane;
    }

    public final void setToolbarActions(Action[] actionArray) {
        if (actionArray == null || actionArray.length == 0) {
            this.actions = new Action[0];
            return;
        }
        if (actionArray.length > 5) {
            throw new IllegalArgumentException("No more than 5 actions allowedin the output window toolbar");
        }
        this.actions = new Action[actionArray.length];
        for (int i = 0; i < actionArray.length; ++i) {
            this.actions[i] = actionArray[i];
            this.installKeyboardAction(this.actions[i]);
        }
    }

    public Action[] getToolbarActions() {
        return this.actions;
    }

    public void installKeyboardAction(Action action) {
        if (!(action instanceof WeakAction)) {
            action = new WeakAction(action);
        }
        KeyStroke keyStroke = null;
        Object object = action.getValue("AcceleratorKey");
        if (object instanceof KeyStroke) {
            keyStroke = (KeyStroke)object;
        }
        String string = (String)action.getValue("Name");
        if (keyStroke != null) {
            if (Controller.LOG) {
                Controller.log("Installed action " + string + " on " + keyStroke);
            }
            JEditorPane jEditorPane = this.getOutputPane().textView;
            jEditorPane.getInputMap().put(keyStroke, string);
            jEditorPane.getActionMap().put(string, action);
            this.getInputMap(1).put(keyStroke, string);
            this.getActionMap().put(string, action);
        }
    }

    public final boolean isInputVisible() {
        return this.inputVisible;
    }

    public final void setInputVisible(boolean bl) {
        if (bl == this.isInputVisible()) {
            return;
        }
        this.inputVisible = bl;
        this.outputPane.textView.setEditable(bl);
        this.validate();
        this.getOutputPane().ensureCaretPosition();
    }

    protected abstract void inputEof();

    public void doLayout() {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = this.getHeight() - insets.bottom;
        AbstractOutputPane abstractOutputPane = this.outputPane;
        if (abstractOutputPane != null) {
            abstractOutputPane.setBounds(n, insets.top, this.getWidth() - (n + insets.right), n2 - insets.top);
        }
    }

    public abstract void hasSelectionChanged(boolean var1);

    void notifyInputFocusGained() {
        this.getOutputPane().lockScroll();
        this.getOutputPane().ensureCaretPosition();
    }
}

