/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor;

import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.editor.ext.DataAccessor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FileObjectAccessor
implements DataAccessor {
    FileObject fo;
    InputStream inputStream;
    FileOutputStream fos;
    int actOff;

    public FileObjectAccessor(FileObject fileObject) {
        this.fo = fileObject;
    }

    public void append(byte[] byArray, int n, int n2) throws IOException {
        this.fos = new FileOutputStream(FileUtil.toFile((FileObject)this.fo).getPath(), true);
        this.fos.write(byArray, n, n2);
        this.fos.flush();
        this.fos.close();
        this.fos = null;
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        n = this.actOff + n;
        do {
            if ((n3 = this.readStream(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public void open(boolean bl) throws IOException {
        if (!this.fo.existsExt(this.fo.getExt())) {
            this.resetFile();
        }
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.inputStream = null;
    }

    public long getFilePointer() throws IOException {
        return this.actOff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFile() throws IOException {
        FileObject fileObject = this.fo.getParent();
        String string = this.fo.getName();
        String string2 = this.fo.getExt();
        FileLock fileLock = this.fo.lock();
        try {
            this.fo.delete(fileLock);
        }
        finally {
            fileLock.releaseLock();
        }
        this.fo = fileObject.createData(string, string2);
        this.actOff = 0;
    }

    public void seek(long l) throws IOException {
        this.actOff = (int)l;
    }

    private int readStream(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.getStream(n).read(byArray, 0, n2);
        this.actOff += n3;
        return n3;
    }

    private InputStream getStream(int n) throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.fo.getInputStream();
            this.inputStream.skip(n);
        } else if (n >= this.actOff) {
            this.inputStream.skip(n - this.actOff);
        } else {
            this.inputStream.close();
            this.inputStream = this.fo.getInputStream();
            this.inputStream.skip(n);
        }
        this.actOff = n;
        return this.inputStream;
    }

    public int getFileLength() {
        return (int)this.fo.getSize();
    }

    public String toString() {
        return this.fo.toString();
    }
}

