/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GsfHintsProvider
extends ParserResultTask<ParserResult> {
    public static Logger LOG = Logger.getLogger(GsfHintsProvider.class.getName());
    private FileObject file;
    private static final Map<Severity, org.netbeans.spi.editor.hints.Severity> errorKind2Severity = new EnumMap<Severity, org.netbeans.spi.editor.hints.Severity>(Severity.class);
    private boolean cancel;

    GsfHintsProvider(FileObject fileObject) {
        this.file = fileObject;
    }

    List<ErrorDescription> computeErrors(Document document, ParserResult parserResult, List<? extends Error> list, List<ErrorDescription> list2) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "errors = " + list);
        }
        for (Error error : list) {
            if (this.isCanceled()) {
                return null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "d = " + error);
            }
            int n = error.getStartPosition();
            int n2 = error.getEndPosition();
            int n3 = parserResult.getSnapshot().getOriginalOffset(n);
            if (n3 == -1) continue;
            int n4 = n3 + (n2 - n);
            LazyFixList lazyFixList = ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "ehm=" + lazyFixList);
            }
            String string = error.getDisplayName();
            Position[] positionArray = this.getLine(error, document, n3, n4);
            if (this.isCanceled()) {
                return null;
            }
            if (positionArray[0] == null || positionArray[1] == null) continue;
            list2.add(ErrorDescriptionFactory.createErrorDescription((org.netbeans.spi.editor.hints.Severity)errorKind2Severity.get((Object)error.getSeverity()), (String)string, (LazyFixList)lazyFixList, (Document)document, (Position)positionArray[0], (Position)positionArray[1]));
        }
        if (this.isCanceled()) {
            return null;
        }
        return list2;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    private Position[] getLine(Error error, final Document document, int n, int n2) {
        int n3;
        int n4;
        StyledDocument styledDocument = (StyledDocument)document;
        int n5 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n6 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n5);
        String string = DataLoadersBridge.getDefault().getLine(document, n5);
        if (string == null) {
            return new Position[2];
        }
        if (error.isLineError()) {
            n4 = string.length();
            for (n3 = 0; n3 < string.length() && Character.isWhitespace(string.charAt(n3)); ++n3) {
            }
            while (n4 > 0 && Character.isWhitespace(string.charAt(n4 - 1))) {
                --n4;
            }
            n = n6 + n3;
            n2 = n6 + n4;
            if (n > n2) {
                n = n6;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "startOffset = " + n);
            LOG.log(Level.FINE, "endOffset = " + n2);
        }
        n3 = n;
        n4 = n2;
        final Position[] positionArray = new Position[2];
        document.render(new Runnable(){

            public void run() {
                if (GsfHintsProvider.this.isCanceled()) {
                    return;
                }
                int n = document.getLength();
                if (n3 > n || n4 > n) {
                    if (!GsfHintsProvider.this.isCanceled() && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "document changed, but not canceled?");
                        LOG.log(Level.WARNING, "len = " + n);
                        LOG.log(Level.WARNING, "startOffset = " + n3);
                        LOG.log(Level.WARNING, "endOffset = " + n4);
                    }
                    GsfHintsProvider.this.cancel();
                    return;
                }
                try {
                    positionArray[0] = NbDocument.createPosition((Document)document, (int)n3, (Position.Bias)Position.Bias.Forward);
                    positionArray[1] = NbDocument.createPosition((Document)document, (int)n4, (Position.Bias)Position.Bias.Backward);
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, null, badLocationException);
                }
            }
        });
        return positionArray;
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(ParserResult parserResult, SchedulerEvent schedulerEvent) {
        this.resume();
        final Document document = this.getDocument();
        if (document == null) {
            LOG.log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        final ArrayList arrayList = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(parserResult.getSnapshot().getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws ParseException {
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType());
                    if (language != null) {
                        if (!(resultIterator.getParserResult() instanceof ParserResult)) {
                            return;
                        }
                        ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                        Object object = parserResult.getDiagnostics();
                        List<ErrorDescription> list = new ArrayList<ErrorDescription>();
                        HintsProvider hintsProvider = language.getHintsProvider();
                        GsfHintsManager gsfHintsManager = null;
                        RuleContext ruleContext = null;
                        if (hintsProvider != null && (gsfHintsManager = language.getHintsManager()) != null && (ruleContext = gsfHintsManager.createRuleContext(parserResult, language, -1, -1, -1)) != null) {
                            ArrayList<Error> arrayList3 = new ArrayList<Error>();
                            ArrayList<Hint> arrayList2 = new ArrayList<Hint>();
                            hintsProvider.computeErrors(gsfHintsManager, ruleContext, arrayList2, arrayList3);
                            object = arrayList3;
                            boolean bl = true;
                            for (Hint hint : arrayList2) {
                                ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, bl);
                                arrayList.add(errorDescription);
                            }
                        }
                        if ((list = GsfHintsProvider.this.computeErrors(document, parserResult, (List<? extends Error>)object, list)) == null) {
                            return;
                        }
                        arrayList.addAll(list);
                    }
                    for (Object object : resultIterator.getEmbeddings()) {
                        if (GsfHintsProvider.this.isCanceled()) {
                            return;
                        }
                        this.run(resultIterator.getResultIterator(object));
                    }
                }
            });
        }
        catch (ParseException parseException) {
            LOG.log(Level.WARNING, null, parseException);
        }
        HintsController.setErrors((Document)document, (String)"csl-hints", arrayList);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    static {
        errorKind2Severity.put(Severity.ERROR, org.netbeans.spi.editor.hints.Severity.ERROR);
        errorKind2Severity.put(Severity.WARNING, org.netbeans.spi.editor.hints.Severity.WARNING);
    }
}

