/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints.infrastructure;

import java.util.prefs.Preferences;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.openide.util.NbPreferences;

public class HintsSettings {
    static final HintSeverity SEVERITY_DEFAUT = HintSeverity.WARNING;
    static final boolean IN_TASK_LIST_DEFAULT = true;
    static final String ENABLED_KEY = "enabled";
    static final String SEVERITY_KEY = "severity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private static final String DEFAULT_PROFILE = "default";

    private HintsSettings() {
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static Preferences getPreferences(GsfHintsManager gsfHintsManager, Rule.UserConfigurableRule userConfigurableRule, String string) {
        string = string == null ? HintsSettings.getCurrentProfileId() : string;
        return NbPreferences.forModule(HintsSettings.class).node(string).node(gsfHintsManager.getId() + userConfigurableRule.getId());
    }

    public static HintSeverity getSeverity(GsfHintsManager gsfHintsManager, Rule.UserConfigurableRule userConfigurableRule) {
        return HintsSettings.getSeverity(userConfigurableRule, HintsSettings.getPreferences(gsfHintsManager, userConfigurableRule, HintsSettings.getCurrentProfileId()));
    }

    public static boolean isEnabled(GsfHintsManager gsfHintsManager, Rule.UserConfigurableRule userConfigurableRule) {
        Preferences preferences = HintsSettings.getPreferences(gsfHintsManager, userConfigurableRule, HintsSettings.getCurrentProfileId());
        return HintsSettings.isEnabled(gsfHintsManager, userConfigurableRule, preferences);
    }

    public static boolean isShowInTaskList(GsfHintsManager gsfHintsManager, Rule.UserConfigurableRule userConfigurableRule) {
        Preferences preferences = HintsSettings.getPreferences(gsfHintsManager, userConfigurableRule, HintsSettings.getCurrentProfileId());
        return HintsSettings.isShowInTaskList(userConfigurableRule, preferences);
    }

    public static boolean isEnabled(HintsProvider.HintsManager hintsManager, Rule.UserConfigurableRule userConfigurableRule, Preferences preferences) {
        return preferences.getBoolean(ENABLED_KEY, userConfigurableRule.getDefaultEnabled());
    }

    public static void setEnabled(Preferences preferences, boolean bl) {
        preferences.putBoolean(ENABLED_KEY, bl);
    }

    public static boolean isShowInTaskList(Rule.UserConfigurableRule userConfigurableRule, Preferences preferences) {
        return preferences.getBoolean(IN_TASK_LIST_KEY, userConfigurableRule.showInTasklist());
    }

    public static void setShowInTaskList(Preferences preferences, boolean bl) {
        preferences.putBoolean(IN_TASK_LIST_KEY, bl);
    }

    public static HintSeverity getSeverity(Rule.UserConfigurableRule userConfigurableRule, Preferences preferences) {
        String string = preferences.get(SEVERITY_KEY, null);
        return string == null ? userConfigurableRule.getDefaultSeverity() : HintSeverity.valueOf(string);
    }

    public static void setSeverity(Preferences preferences, HintSeverity hintSeverity) {
        preferences.put(SEVERITY_KEY, hintSeverity.name());
    }
}

