/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HintsTask
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(HintsTask.class.getName());
    private boolean cancelled = false;

    public void run(ParserResult parserResult, SchedulerEvent schedulerEvent) {
        this.resume();
        final ArrayList arrayList = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(parserResult.getSnapshot().getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws ParseException {
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType());
                    if (language == null) {
                        return;
                    }
                    HintsProvider hintsProvider = language.getHintsProvider();
                    if (hintsProvider == null) {
                        return;
                    }
                    GsfHintsManager gsfHintsManager = language.getHintsManager();
                    if (gsfHintsManager == null) {
                        return;
                    }
                    Parser.Result result = resultIterator.getParserResult();
                    if (!(result instanceof ParserResult)) {
                        return;
                    }
                    ParserResult parserResult = (ParserResult)result;
                    RuleContext ruleContext = gsfHintsManager.createRuleContext(parserResult, language, -1, -1, -1);
                    if (ruleContext == null) {
                        return;
                    }
                    ArrayList<Hint> arrayList2 = new ArrayList<Hint>();
                    hintsProvider.computeHints(gsfHintsManager, ruleContext, arrayList2);
                    if (HintsTask.this.isCancelled()) {
                        return;
                    }
                    for (Hint hint : arrayList2) {
                        ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, false);
                        arrayList.add(errorDescription);
                    }
                    for (Hint hint : resultIterator.getEmbeddings()) {
                        this.run(resultIterator.getResultIterator((Embedding)hint));
                    }
                }
            });
        }
        catch (ParseException parseException) {
            LOG.log(Level.WARNING, null, parseException);
        }
        HintsController.setErrors((FileObject)parserResult.getSnapshot().getSource().getFileObject(), (String)HintsTask.class.getName(), arrayList);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    private synchronized void resume() {
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }
}

