/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HintsUtils {
    public static ErrorDescription createProblem(Element element, CompilationInfo compilationInfo, String string) {
        return HintsUtils.createProblem(element, compilationInfo, string, Severity.ERROR, Collections.<Fix>emptyList());
    }

    public static ErrorDescription createProblem(Element element, CompilationInfo compilationInfo, String string, Severity severity) {
        return HintsUtils.createProblem(element, compilationInfo, string, severity, Collections.<Fix>emptyList());
    }

    public static ErrorDescription createProblem(Element element, CompilationInfo compilationInfo, String string, Severity severity, Fix fix) {
        return HintsUtils.createProblem(element, compilationInfo, string, severity, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element element, CompilationInfo compilationInfo, String string, Fix fix) {
        return HintsUtils.createProblem(element, compilationInfo, string, Severity.ERROR, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element element, CompilationInfo compilationInfo, String string, Severity severity, List<Fix> list) {
        ErrorDescription errorDescription = null;
        List<Object> list2 = list == null ? Collections.emptyList() : list;
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (tree != null) {
            TextSpan textSpan = HintsUtils.getUnderlineSpan(compilationInfo, tree);
            errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)severity, (String)string, list2, (FileObject)compilationInfo.getFileObject(), (int)textSpan.getStartOffset(), (int)textSpan.getEndOffset());
        }
        return errorDescription;
    }

    public static TextSpan getUnderlineSpan(CompilationInfo compilationInfo, Tree tree) {
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        int n = (int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree);
        int n2 = (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree);
        Tree tree2 = null;
        if (tree.getKind() == Tree.Kind.CLASS) {
            tree2 = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            tree2 = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            tree2 = ((VariableTree)tree).getType();
        }
        if (tree2 != null) {
            int n3 = (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree2);
            TokenSequence tokenSequence = compilationInfo.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean bl = false;
                tokenSequence.move(n3);
                do {
                    boolean bl2 = bl = !tokenSequence.moveNext();
                } while (!bl && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!bl) {
                    Token token = tokenSequence.token();
                    n = token.offset(compilationInfo.getTokenHierarchy());
                    n2 = n + token.length();
                }
            }
        }
        return new TextSpan(n, n2);
    }

    public static class TextSpan {
        private int startOffset;
        private int endOffset;

        public TextSpan(int n, int n2) {
            this.startOffset = n;
            this.endOffset = n2;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

