/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.fixes;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemFinder;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeClassPublic
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;

    public MakeClassPublic(FileObject fileObject, ElementHandle<TypeElement> elementHandle) {
        this.classHandle = elementHandle;
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = (TypeElement)MakeClassPublic.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (typeElement != null) {
                    ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    HashSet<Modifier> hashSet = new HashSet<Modifier>(classTree.getModifiers().getFlags());
                    hashSet.add(Modifier.PUBLIC);
                    ModifiersTree modifiersTree = treeMaker.Modifiers(hashSet, classTree.getModifiers().getAnnotations());
                    workingCopy.rewrite((Tree)classTree.getModifiers(), (Tree)modifiersTree);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            EJBProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getText() {
        return NbBundle.getMessage(MakeClassPublic.class, (String)"LBL_MakeClassPublic", (Object)JavaUtils.getShortClassName(this.classHandle.getQualifiedName()));
    }
}

