/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.picklist.DefaultPicklistModel;
import org.netbeans.modules.cnd.api.utils.ElfExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.MacOSXExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.PeExecutableFileFilter;
import org.netbeans.modules.cnd.makeproject.MakeProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RunDialogPanel
extends JPanel {
    private DocumentListener modifiedValidateDocumentListener = null;
    private Project[] projectChoices = null;
    private boolean executableReadOnly = true;
    private JButton actionButton;
    private static String lastSelectedExecutable = null;
    private static Project lastSelectedProject = null;
    private static DefaultPicklistModel picklist = null;
    private static String picklistHomeDir = null;
    private static final String picklistName = "executables";
    private boolean isValidating = false;
    private JLabel argumentLabel;
    private JTextField argumentTextField;
    private JLabel environmentLabel;
    private JTextField environmentTextField;
    private JLabel errorLabel;
    private JButton executableBrowseButton;
    private JLabel executableLabel1;
    private JTextField executableTextField;
    private JTextArea guidanceTextarea;
    private JComboBox projectComboBox;
    private JLabel projectLabel;
    private JButton runDirectoryBrowseButton;
    private JLabel runDirectoryLabel;
    private JTextField runDirectoryTextField;
    private ResourceBundle bundle;

    public RunDialogPanel() {
        this.initialize(null, false);
        this.errorLabel.setText("");
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.getString("RUN_DIALOG_PANEL_AD"));
        this.executableTextField.getAccessibleContext().setAccessibleDescription(this.getString("EXECUTABLE_AD"));
        this.executableBrowseButton.getAccessibleContext().setAccessibleDescription(this.getString("BROWSE_BUTTON_AD"));
        this.projectComboBox.getAccessibleContext().setAccessibleDescription(this.getString("ASSOCIATED_PROJECT_AD"));
        this.runDirectoryTextField.getAccessibleContext().setAccessibleDescription(this.getString("RUN_DIRECTORY_LABEL_AD"));
        this.runDirectoryBrowseButton.getAccessibleContext().setAccessibleDescription(this.getString("RUN_DIRECTORY_BUTTON_AD"));
        this.argumentTextField.getAccessibleContext().setAccessibleDescription(this.getString("ARGUMENTS_LABEL_AD"));
        this.environmentTextField.getAccessibleContext().setAccessibleDescription(this.getString("ENVIRONMENT_LABEL_AD"));
    }

    public RunDialogPanel(String string, boolean bl, JButton jButton) {
        this.actionButton = jButton;
        this.initialize(string, bl);
        this.errorLabel.setText("");
        this.initAccessibility();
    }

    protected void initialize(String string, boolean bl) {
        this.initComponents();
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.executableReadOnly = bl;
        this.modifiedValidateDocumentListener = new ModifiedValidateDocumentListener();
        if (bl) {
            // empty if block
        }
        if (string != null) {
            this.executableTextField.setText(string);
        }
        this.guidanceTextarea.setText(this.getString("DIALOG_GUIDANCETEXT"));
        String[] stringArray = RunDialogPanel.getExecutablePicklist().getElementsDisplayName();
        String string2 = null;
        string2 = string != null ? string : (stringArray.length > 0 ? stringArray[0] : "");
        this.executableTextField.getDocument().addDocumentListener(this.modifiedValidateDocumentListener);
        this.initGui();
        this.runDirectoryTextField.getDocument().addDocumentListener(this.modifiedValidateDocumentListener);
        this.guidanceTextarea.setBackground(this.getBackground());
        this.setPreferredSize(new Dimension(700, (int)this.getPreferredSize().getHeight()));
    }

    private void initComponents() {
        this.guidanceTextarea = new JTextArea();
        this.executableLabel1 = new JLabel();
        this.executableBrowseButton = new JButton();
        this.executableTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectComboBox = new JComboBox();
        this.errorLabel = new JLabel();
        this.runDirectoryLabel = new JLabel();
        this.runDirectoryTextField = new JTextField();
        this.runDirectoryBrowseButton = new JButton();
        this.argumentLabel = new JLabel();
        this.argumentTextField = new JTextField();
        this.environmentLabel = new JLabel();
        this.environmentTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.guidanceTextarea.setEditable(false);
        this.guidanceTextarea.setLineWrap(true);
        this.guidanceTextarea.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("DIALOG_GUIDANCETEXT"));
        this.guidanceTextarea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.guidanceTextarea, gridBagConstraints);
        this.executableLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("EXECUTABLE_MN").charAt(0));
        this.executableLabel1.setLabelFor(this.executableTextField);
        this.executableLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("EXECUTABLE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 0);
        this.add((Component)this.executableLabel1, gridBagConstraints);
        this.executableBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("BROWSE_BUTTON_MN").charAt(0));
        this.executableBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("BROWSE_BUTTON_TXT"));
        this.executableBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunDialogPanel.this.executableBrowseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 8, 12);
        this.add((Component)this.executableBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.executableTextField, gridBagConstraints);
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("ASSOCIATED_PROJECT_MN").charAt(0));
        this.projectLabel.setLabelFor(this.projectComboBox);
        this.projectLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("ASSOCIATED_PROJECT_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunDialogPanel.this.projectComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 6, 12);
        this.add((Component)this.projectComboBox, gridBagConstraints);
        this.errorLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("ERROR_NOTAEXEFILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 12, 0, 12);
        this.add((Component)this.errorLabel, gridBagConstraints);
        this.runDirectoryLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("RUN_DIRECTORY_LABEL_MN").charAt(0));
        this.runDirectoryLabel.setLabelFor(this.runDirectoryTextField);
        this.runDirectoryLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("RUN_DIRECTORY_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 12, 0, 0);
        this.add((Component)this.runDirectoryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 0, 0);
        this.add((Component)this.runDirectoryTextField, gridBagConstraints);
        this.runDirectoryBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("RUN_DIRECTORY_BUTTON_MN").charAt(0));
        this.runDirectoryBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("RUN_DIRECTORY_BUTTON_TXT"));
        this.runDirectoryBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunDialogPanel.this.runDirectoryBrowseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 0, 12);
        this.add((Component)this.runDirectoryBrowseButton, gridBagConstraints);
        this.argumentLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("ARGUMENTS_LABEL_MN").charAt(0));
        this.argumentLabel.setLabelFor(this.argumentTextField);
        this.argumentLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("ARGUMENTS_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.argumentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.argumentTextField, gridBagConstraints);
        this.environmentLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("ENVIRONMENT_LABEL_MN").charAt(0));
        this.environmentLabel.setLabelFor(this.environmentTextField);
        this.environmentLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("ENVIRONMENT_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.environmentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.environmentTextField, gridBagConstraints);
    }

    private void runDirectoryBrowseButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.runDirectoryTextField.getText().length() > 0 ? this.runDirectoryTextField.getText() : this.getExecutablePath();
        FileChooser fileChooser = new FileChooser(this.getString("SelectWorkingDir"), this.getString("SelectLabel"), 1, null, string, true);
        int n = fileChooser.showOpenDialog((Component)this);
        if (n == 1) {
            return;
        }
        this.runDirectoryTextField.setText(fileChooser.getSelectedFile().getPath());
    }

    private void projectComboBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.projectComboBox.getSelectedIndex();
        if (n == 0) {
            if (new File(this.executableTextField.getText()).getParentFile() != null) {
                this.runDirectoryTextField.setText(new File(this.executableTextField.getText()).getParentFile().getPath());
            } else if (!this.isValidating) {
                this.executableTextField.setText("");
            }
            this.argumentTextField.setText("");
            this.environmentTextField.setText("");
        } else {
            Project project = this.projectChoices[this.projectComboBox.getSelectedIndex() - 1];
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (configurationDescriptorProvider == null) {
                return;
            }
            MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
            MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
            RunProfile runProfile = makeConfiguration.getProfile();
            this.runDirectoryTextField.setText(runProfile.getRunDirectory());
            this.argumentTextField.setText(runProfile.getArgsFlat());
            this.environmentTextField.setText(runProfile.getEnvironment().toString());
        }
    }

    private void executableBrowseButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.getExecutablePath();
        if (string.length() == 0 && FileChooser.getCurrectChooserFile() != null) {
            string = FileChooser.getCurrectChooserFile().getPath();
        }
        if (string.length() == 0) {
            string = System.getProperty("user.home");
        }
        FileFilter[] fileFilterArray = Utilities.isWindows() ? new FileFilter[]{PeExecutableFileFilter.getInstance()} : (Utilities.getOperatingSystem() == 4096 ? new FileFilter[]{MacOSXExecutableFileFilter.getInstance()} : new FileFilter[]{ElfExecutableFileFilter.getInstance()});
        FileChooser fileChooser = new FileChooser(this.getString("SelectExecutable"), this.getString("SelectLabel"), 0, fileFilterArray, string, false);
        int n = fileChooser.showOpenDialog((Component)this);
        if (n == 1) {
            return;
        }
        this.executableTextField.setText(fileChooser.getSelectedFile().getPath());
    }

    private void initGui() {
        int n;
        this.projectChoices = OpenProjects.getDefault().getOpenProjects();
        ActionListener actionListener = this.projectComboBox.getActionListeners()[0];
        this.projectComboBox.removeActionListener(actionListener);
        this.projectComboBox.removeAllItems();
        this.projectComboBox.addItem(this.getString("NO_PROJECT"));
        for (n = 0; n < this.projectChoices.length; ++n) {
            this.projectComboBox.addItem(ProjectUtils.getInformation((Project)this.projectChoices[n]).getName());
        }
        n = 0;
        if (lastSelectedExecutable != null && this.getExecutablePath().equals(lastSelectedExecutable) && lastSelectedProject != null) {
            for (int i = 0; i < this.projectChoices.length; ++i) {
                if (this.projectChoices[i] != lastSelectedProject) continue;
                n = i + 1;
                break;
            }
        }
        this.projectComboBox.setSelectedIndex(n);
        this.projectComboBox.addActionListener(actionListener);
        this.projectComboBoxActionPerformed(null);
    }

    private boolean validateExecutable() {
        String string = this.getExecutablePath();
        File file = new File(string);
        if (!file.exists()) {
            this.setError("ERROR_DONTEXIST", true);
            return false;
        }
        if (file.isDirectory()) {
            this.setError("ERROR_NOTAEXEFILE", true);
            return false;
        }
        return true;
    }

    private boolean validateRunDirectory() {
        String string = this.runDirectoryTextField.getText();
        File file = new File(this.runDirectoryTextField.getText());
        if (!file.exists()) {
            this.setError("ERROR_RUNDIR_DONTEXIST", false);
            return false;
        }
        if (!file.isDirectory()) {
            this.setError("ERROR_RUNDIR_INVALID", false);
            return false;
        }
        return true;
    }

    private void setError(String string, boolean bl) {
        this.setErrorMsg(this.getString(string));
        if (bl) {
            this.runDirectoryBrowseButton.setEnabled(false);
            this.runDirectoryLabel.setEnabled(false);
            this.runDirectoryTextField.setEnabled(false);
            this.argumentLabel.setEnabled(false);
            this.argumentTextField.setEnabled(false);
            this.environmentLabel.setEnabled(false);
            this.environmentTextField.setEnabled(false);
            this.projectComboBox.setEnabled(false);
        }
        this.actionButton.setEnabled(false);
    }

    private void clearError() {
        this.setErrorMsg(" ");
        this.runDirectoryBrowseButton.setEnabled(true);
        this.runDirectoryLabel.setEnabled(true);
        this.runDirectoryTextField.setEnabled(true);
        this.argumentLabel.setEnabled(true);
        this.argumentTextField.setEnabled(true);
        this.environmentLabel.setEnabled(true);
        this.environmentTextField.setEnabled(true);
        this.projectComboBox.setEnabled(true);
        this.actionButton.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFields(DocumentEvent documentEvent) {
        this.isValidating = true;
        try {
            this.clearError();
            if (documentEvent.getDocument() == this.executableTextField.getDocument()) {
                this.projectComboBox.setSelectedIndex(0);
                if (!this.validateExecutable()) {
                    return;
                }
                this.runDirectoryTextField.setText(new File(this.executableTextField.getText()).getParentFile().getPath());
            }
            this.validateRunDirectory();
        }
        finally {
            this.isValidating = false;
        }
    }

    public Project getSelectedProject() {
        Project project;
        lastSelectedExecutable = this.getExecutablePath();
        if (this.projectComboBox.getSelectedIndex() > 0) {
            project = lastSelectedProject = this.projectChoices[this.projectComboBox.getSelectedIndex() - 1];
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
            MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
            this.updateRunProfile(makeConfiguration.getBaseDir(), makeConfiguration.getProfile());
        } else {
            try {
                String string = ProjectGenerator.getDefaultProjectFolder();
                String string2 = ProjectGenerator.getValidProjectName(string, new File(this.getExecutablePath()).getName());
                String string3 = string + File.separator + string2;
                MakeConfiguration makeConfiguration = new MakeConfiguration(string3, "Default", 0);
                String string4 = new File(this.getExecutablePath()).getParentFile().getPath();
                string4 = IpeUtils.toRelativePath((String)string3, (String)string4);
                string4 = FilePathAdaptor.normalize(string4);
                makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(string4);
                String string5 = this.getExecutablePath();
                string5 = IpeUtils.toRelativePath((String)string3, (String)string5);
                string5 = FilePathAdaptor.normalize(string5);
                makeConfiguration.getMakefileConfiguration().getOutput().setValue(string5);
                this.updateRunProfile(string3, makeConfiguration.getProfile());
                project = MakeProjectGenerator.createBlankProject(string2, string, new MakeConfiguration[]{makeConfiguration}, true);
            }
            catch (Exception exception) {
                project = null;
            }
            lastSelectedProject = project;
        }
        return project;
    }

    private void updateRunProfile(String string, RunProfile runProfile) {
        runProfile.setArgs(this.argumentTextField.getText());
        String string2 = this.runDirectoryTextField.getText();
        string2 = IpeUtils.toRelativePath((String)string, (String)string2);
        string2 = FilePathAdaptor.normalize(string2);
        runProfile.setRunDirectory(string2);
        Env env = runProfile.getEnvironment();
        env.removeAll();
        env.decode(this.environmentTextField.getText());
    }

    public String getExecutablePath() {
        return this.executableTextField.getText();
    }

    private void setErrorMsg(String string) {
        this.errorLabel.setText(string);
    }

    private static DefaultPicklistModel getExecutablePicklist() {
        if (picklist == null && (picklist = (DefaultPicklistModel)DefaultPicklistModel.restorePicklist((String)(picklistHomeDir = System.getProperty("netbeans.user") + File.separator + "var" + File.separator + "picklists"), (String)picklistName)) == null) {
            picklist = new DefaultPicklistModel(16);
        }
        return picklist;
    }

    public static void addElementToExecutablePicklist(String string) {
        RunDialogPanel.getExecutablePicklist().addElement(string);
        RunDialogPanel.getExecutablePicklist().savePicklist(picklistHomeDir, picklistName);
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(RunDialogPanel.class);
        }
        return this.bundle.getString(string);
    }

    public boolean asynchronous() {
        return false;
    }

    public class ModifiedValidateDocumentListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            RunDialogPanel.this.validateFields(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            RunDialogPanel.this.validateFields(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            RunDialogPanel.this.validateFields(documentEvent);
        }
    }
}

