/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLReader;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Lookup;

public class ConfigurationDescriptorProvider {
    public static final String USG_PROJECT_CONFIG_CND = "USG_PROJECT_CONFIG_CND";
    public static final String USG_PROJECT_OPEN_CND = "USG_PROJECT_OPEN_CND";
    private FileObject projectDirectory;
    private volatile MakeConfigurationDescriptor projectDescriptor = null;
    private volatile boolean hasTried = false;
    private String relativeOffset = null;
    private List<FileObject> trackedFiles;
    private volatile boolean needReload;
    private final Object readLock = new Object();

    public ConfigurationDescriptorProvider(FileObject fileObject) {
        this.projectDirectory = fileObject;
    }

    public void setRelativeOffset(String string) {
        this.relativeOffset = string;
    }

    public MakeConfigurationDescriptor getConfigurationDescriptor() {
        return this.getConfigurationDescriptor(true);
    }

    private boolean shouldBeLoaded() {
        return (this.projectDescriptor == null || this.needReload) && !this.hasTried;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MakeConfigurationDescriptor getConfigurationDescriptor(boolean bl) {
        if (this.shouldBeLoaded()) {
            Object object = this.readLock;
            synchronized (object) {
                if (this.shouldBeLoaded()) {
                    Object object2;
                    Object object3;
                    if (MakeProject.TRACE_MAKE_PROJECT_CREATION) {
                        System.err.println("Start of reading project descriptor for project " + this.projectDirectory.getName() + " in ConfigurationDescriptorProvider@" + System.identityHashCode(this));
                        if (this.projectDescriptor != null) {
                            new Exception("Previous project MakeConfigurationDescriptor@" + System.identityHashCode(this.projectDescriptor)).printStackTrace();
                        }
                    }
                    this.needReload = false;
                    if (this.trackedFiles == null) {
                        object3 = new ConfigurationXMLChangeListener();
                        object2 = new ArrayList(2);
                        boolean bl2 = true;
                        for (String string : new String[]{"nbproject/configurations.xml", "nbproject/private/configurations.xml"}) {
                            FileObject fileObject = this.projectDirectory.getFileObject(string);
                            if (fileObject != null) {
                                fileObject.addFileChangeListener((FileChangeListener)object3);
                                object2.add(fileObject);
                            } else if (bl2) {
                                new Exception("Attempt to read project before creation. Not found file " + this.projectDirectory.getPath() + "/" + string).printStackTrace();
                                return null;
                            }
                            bl2 = false;
                        }
                        this.trackedFiles = object2;
                    }
                    object3 = new ConfigurationXMLReader(this.projectDirectory);
                    try {
                        object2 = ((ConfigurationXMLReader)((Object)object3)).read(this.relativeOffset);
                        if (MakeProject.TRACE_MAKE_PROJECT_CREATION) {
                            System.err.println("End of reading project descriptor for project " + this.projectDirectory.getName() + " in ConfigurationDescriptorProvider@" + System.identityHashCode(this));
                        }
                        if (this.projectDescriptor == null || object2 == null) {
                            this.projectDescriptor = object2;
                            if (MakeProject.TRACE_MAKE_PROJECT_CREATION) {
                                System.err.println("Created project descriptor MakeConfigurationDescriptor@" + System.identityHashCode(this.projectDescriptor) + " for project " + this.projectDirectory.getName() + " in ConfigurationDescriptorProvider@" + System.identityHashCode(this));
                            }
                        } else {
                            ((MakeConfigurationDescriptor)object2).waitInitTask();
                            this.projectDescriptor.assign((ConfigurationDescriptor)object2);
                            if (MakeProject.TRACE_MAKE_PROJECT_CREATION) {
                                System.err.println("Reassigned project descriptor MakeConfigurationDescriptor@" + System.identityHashCode(this.projectDescriptor) + " for project " + this.projectDirectory.getName() + " in ConfigurationDescriptorProvider@" + System.identityHashCode(this));
                            }
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    this.hasTried = true;
                }
            }
        }
        if (bl && this.projectDescriptor != null) {
            this.projectDescriptor.waitInitTask();
        }
        return this.projectDescriptor;
    }

    public boolean gotDescriptor() {
        return this.projectDescriptor != null && this.projectDescriptor.getState() != ConfigurationDescriptor.State.READING;
    }

    public static ConfigurationAuxObjectProvider[] getAuxObjectProviders() {
        HashSet hashSet = new HashSet();
        Collection collection = Lookup.getDefault().lookupAll(ConfigurationAuxObjectProvider.class);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet.toArray(new ConfigurationAuxObjectProvider[hashSet.size()]);
    }

    public static void recordMetrics(String string, MakeConfigurationDescriptor makeConfigurationDescriptor) {
        if (!(makeConfigurationDescriptor instanceof MakeConfigurationDescriptor)) {
            return;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.metrics.cnd");
        if (logger.isLoggable(Level.INFO)) {
            int n;
            CharSequence charSequence;
            String string2;
            String string3;
            String[] stringArray;
            CompilerSet compilerSet;
            String string4;
            String string5;
            LogRecord logRecord = new LogRecord(Level.INFO, string);
            if (makeConfigurationDescriptor.getConfs() == null || makeConfigurationDescriptor.getConfs().getActive() == null) {
                return;
            }
            Item[] itemArray = makeConfigurationDescriptor.getProjectItems();
            if (itemArray == null || itemArray.length == 0) {
                return;
            }
            MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
            switch (makeConfiguration.getConfigurationType().getValue()) {
                case 0: {
                    string5 = "MAKEFILE";
                    break;
                }
                case 1: {
                    string5 = "APPLICATION";
                    break;
                }
                case 2: {
                    string5 = "DYNAMIC_LIB";
                    break;
                }
                case 3: {
                    string5 = "STATIC_LIB";
                    break;
                }
                case 4: {
                    string5 = "QT_APPLICATION";
                    break;
                }
                case 5: {
                    string5 = "QT_DYNAMIC_LIB";
                    break;
                }
                case 6: {
                    string5 = "QT_STATIC_LIB";
                    break;
                }
                default: {
                    string5 = "UNKNOWN";
                }
            }
            if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
                string4 = "LOCAL";
                compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            } else {
                string4 = "REMOTE";
                compilerSet = null;
            }
            if (compilerSet != null) {
                stringArray = compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily();
                string3 = compilerSet.getCompilerFlavor().toString();
            } else {
                stringArray = new String[]{};
                string3 = makeConfiguration.getCompilerSet().getFlavor();
            }
            if (stringArray.length == 0) {
                string2 = "UKNOWN";
            } else {
                charSequence = new StringBuilder();
                for (n = 0; n < stringArray.length; ++n) {
                    ((StringBuilder)charSequence).append(stringArray[n]);
                    if (n >= stringArray.length - 1) continue;
                    ((StringBuilder)charSequence).append(",");
                }
                string2 = ((StringBuilder)charSequence).toString();
            }
            charSequence = Platforms.getPlatform(makeConfiguration.getCompilerSet().getPlatform()) != null ? Platforms.getPlatform(makeConfiguration.getCompilerSet().getPlatform()).getName() : "UNKNOWN_PLATFORM";
            makeConfiguration.reCountLanguages(makeConfigurationDescriptor);
            n = 0;
            int n2 = itemArray.length;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            block16: for (Item item : itemArray) {
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration == null || itemConfiguration.getExcluded().getValue()) continue;
                ++n;
                switch (itemConfiguration.getTool()) {
                    case 0: {
                        bl = true;
                        continue block16;
                    }
                    case 1: {
                        bl2 = true;
                        continue block16;
                    }
                    case 2: {
                        bl3 = true;
                        continue block16;
                    }
                    case 4: {
                        bl4 = true;
                    }
                }
            }
            String string6 = bl2 ? "USE_CPP" : "NO_CPP";
            String string7 = bl ? "USE_C" : "NO_C";
            String string8 = bl3 ? "USE_FORTRAN" : "NO_FORTRAN";
            String string9 = bl4 ? "USE_ASM" : "NO_ASM";
            logRecord.setParameters(new Object[]{string5, string3, string2, string4, charSequence, ConfigurationDescriptorProvider.toSizeString(n2), ConfigurationDescriptorProvider.toSizeString(n), string6, string7, string8, string9});
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    private static String toSizeString(int n) {
        String string = n < 25 ? "25" : (n < 100 ? "100" : (n < 500 ? "500" : (n < 1000 ? "1000" : (n < 2000 ? "2000" : (n < 5000 ? "5000" : (n < 10000 ? "10000" : (n < 20000 ? "20000" : (n < 50000 ? "50000" : "99999"))))))));
        return string;
    }

    private class ConfigurationXMLChangeListener
    implements FileChangeListener {
        private ConfigurationXMLChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetConfiguration() {
            if (ConfigurationDescriptorProvider.this.projectDescriptor == null || !ConfigurationDescriptorProvider.this.projectDescriptor.getModified()) {
                Object object = ConfigurationDescriptorProvider.this.readLock;
                synchronized (object) {
                    if (ConfigurationDescriptorProvider.this.projectDescriptor == null || !ConfigurationDescriptorProvider.this.projectDescriptor.getModified()) {
                        if (MakeProject.TRACE_MAKE_PROJECT_CREATION) {
                            new Exception("Mark to reload project descriptor MakeConfigurationDescriptor@" + System.identityHashCode(ConfigurationDescriptorProvider.this.projectDescriptor) + " for project " + ConfigurationDescriptorProvider.this.projectDirectory.getName() + " in ConfigurationDescriptorProvider@" + System.identityHashCode(this)).printStackTrace();
                        }
                        ConfigurationDescriptorProvider.this.needReload = true;
                        ConfigurationDescriptorProvider.this.hasTried = false;
                    }
                }
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.resetConfiguration();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.resetConfiguration();
        }

        public void fileChanged(FileEvent fileEvent) {
            this.resetConfiguration();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.resetConfiguration();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.resetConfiguration();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

