/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationBase;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ItemXMLCodec;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ItemConfiguration
implements ConfigurationAuxObject {
    private boolean needSave = false;
    private Configuration configuration;
    private Item item;
    private BooleanConfiguration excluded;
    private byte tool = (byte)-1;
    private ConfigurationBase lastConfiguration;
    private static ResourceBundle bundle = null;

    public ItemConfiguration(Configuration configuration, Item item) {
        this.configuration = configuration;
        this.setItem(item);
        this.excluded = new BooleanConfiguration(null, false);
        item.getFolder().getFolderConfiguration(configuration);
        this.clearChanged();
    }

    public ItemConfiguration(ItemConfiguration itemConfiguration) {
        this.configuration = itemConfiguration.configuration;
        this.item = itemConfiguration.item;
        this.excluded = itemConfiguration.excluded;
        this.needSave = itemConfiguration.needSave;
        this.tool = itemConfiguration.tool;
        this.lastConfiguration = itemConfiguration.lastConfiguration;
    }

    public boolean isDefaultConfiguration() {
        if (this.excluded.getValue()) {
            return false;
        }
        if (this.getTool() != this.item.getDefaultTool()) {
            return false;
        }
        return this.lastConfiguration == null || !this.lastConfiguration.getModified();
    }

    public boolean isCompilerToolConfiguration() {
        switch (this.getTool()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public BasicCompilerConfiguration getCompilerConfiguration() {
        switch (this.getTool()) {
            case 4: {
                return this.getAssemblerConfiguration();
            }
            case 1: {
                return this.getCCCompilerConfiguration();
            }
            case 0: {
                return this.getCCompilerConfiguration();
            }
            case 2: {
                return this.getFortranCompilerConfiguration();
            }
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Item getItem() {
        return this.item;
    }

    private void setItem(Item item) {
        if (this.item != item) {
            this.item = item;
            this.needSave = true;
        }
    }

    public BooleanConfiguration getExcluded() {
        return this.excluded;
    }

    public void setExcluded(BooleanConfiguration booleanConfiguration) {
        this.excluded = booleanConfiguration;
        this.needSave = true;
    }

    public void setTool(String string) {
        this.setTool(Tool.getTool((String)string));
    }

    public void setTool(int n) {
        if (this.tool != n) {
            this.lastConfiguration = null;
        }
        this.tool = (byte)n;
    }

    public int getTool() {
        if (this.tool == -1) {
            this.tool = (byte)this.item.getDefaultTool();
        }
        return this.tool;
    }

    protected String[] getToolNames() {
        return Tool.getCompilerToolNames();
    }

    public void setCustomToolConfiguration(CustomToolConfiguration customToolConfiguration) {
        this.lastConfiguration = customToolConfiguration;
    }

    public synchronized CustomToolConfiguration getCustomToolConfiguration() {
        if (this.getTool() == 3) {
            if (this.lastConfiguration == null) {
                this.lastConfiguration = new CustomToolConfiguration();
            }
            assert (this.lastConfiguration instanceof CustomToolConfiguration);
            return (CustomToolConfiguration)this.lastConfiguration;
        }
        return null;
    }

    public void setCCompilerConfiguration(CCompilerConfiguration cCompilerConfiguration) {
        this.lastConfiguration = cCompilerConfiguration;
    }

    public synchronized CCompilerConfiguration getCCompilerConfiguration() {
        if (this.getTool() == 0) {
            if (this.lastConfiguration == null) {
                FolderConfiguration folderConfiguration = this.item.getFolder().getFolderConfiguration(this.configuration);
                this.lastConfiguration = folderConfiguration != null ? new CCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), folderConfiguration.getCCompilerConfiguration()) : new CCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), null);
            }
            assert (this.lastConfiguration instanceof CCompilerConfiguration);
            return (CCompilerConfiguration)this.lastConfiguration;
        }
        return null;
    }

    public void setCCCompilerConfiguration(CCCompilerConfiguration cCCompilerConfiguration) {
        this.lastConfiguration = cCCompilerConfiguration;
    }

    public synchronized CCCompilerConfiguration getCCCompilerConfiguration() {
        if (this.getTool() == 1) {
            if (this.lastConfiguration == null) {
                FolderConfiguration folderConfiguration = this.item.getFolder().getFolderConfiguration(this.configuration);
                this.lastConfiguration = folderConfiguration != null ? new CCCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), folderConfiguration.getCCCompilerConfiguration()) : new CCCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), null);
            }
            assert (this.lastConfiguration instanceof CCCompilerConfiguration);
            return (CCCompilerConfiguration)this.lastConfiguration;
        }
        return null;
    }

    public void setFortranCompilerConfiguration(FortranCompilerConfiguration fortranCompilerConfiguration) {
        this.lastConfiguration = fortranCompilerConfiguration;
    }

    public synchronized FortranCompilerConfiguration getFortranCompilerConfiguration() {
        if (this.getTool() == 2) {
            if (this.lastConfiguration == null) {
                this.lastConfiguration = new FortranCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), ((MakeConfiguration)this.configuration).getFortranCompilerConfiguration());
            }
            assert (this.lastConfiguration instanceof FortranCompilerConfiguration);
            return (FortranCompilerConfiguration)this.lastConfiguration;
        }
        return null;
    }

    public void setAssemblerConfiguration(AssemblerConfiguration assemblerConfiguration) {
        this.lastConfiguration = assemblerConfiguration;
    }

    public synchronized AssemblerConfiguration getAssemblerConfiguration() {
        if (this.getTool() == 4) {
            if (this.lastConfiguration == null) {
                this.lastConfiguration = new AssemblerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), ((MakeConfiguration)this.configuration).getAssemblerConfiguration());
            }
            assert (this.lastConfiguration instanceof AssemblerConfiguration);
            return (AssemblerConfiguration)this.lastConfiguration;
        }
        return null;
    }

    public boolean shared() {
        return true;
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public String getId() {
        return this.item.getId();
    }

    public void assign(ConfigurationAuxObject configurationAuxObject) {
        if (!(configurationAuxObject instanceof ItemConfiguration)) {
            System.err.println("Item - assign: Profile object type expected - got " + configurationAuxObject);
            return;
        }
        ItemConfiguration itemConfiguration = (ItemConfiguration)configurationAuxObject;
        if (!this.getId().equals(itemConfiguration.getItem().getId())) {
            System.err.println("Item - assign: Item ID " + this.getId() + " expected - got " + itemConfiguration.getItem().getId());
            return;
        }
        this.setConfiguration(itemConfiguration.getConfiguration());
        this.setItem(itemConfiguration.getItem());
        this.getExcluded().assign(itemConfiguration.getExcluded());
        this.setTool(itemConfiguration.getTool());
        switch (this.getTool()) {
            case 4: {
                this.getAssemblerConfiguration().assign(itemConfiguration.getAssemblerConfiguration());
                break;
            }
            case 1: {
                this.getCCCompilerConfiguration().assign(itemConfiguration.getCCCompilerConfiguration());
                break;
            }
            case 0: {
                this.getCCompilerConfiguration().assign(itemConfiguration.getCCompilerConfiguration());
                break;
            }
            case 3: {
                this.getCustomToolConfiguration().assign(itemConfiguration.getCustomToolConfiguration());
                break;
            }
            case 2: {
                this.getFortranCompilerConfiguration().assign(itemConfiguration.getFortranCompilerConfiguration());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void assignValues(ConfigurationAuxObject configurationAuxObject) {
        if (!(configurationAuxObject instanceof ItemConfiguration)) {
            System.err.println("Item - assign: Profile object type expected - got " + configurationAuxObject);
            return;
        }
        ItemConfiguration itemConfiguration = (ItemConfiguration)configurationAuxObject;
        this.getExcluded().assign(itemConfiguration.getExcluded());
        this.setTool(itemConfiguration.getTool());
        switch (this.getTool()) {
            case 4: {
                this.getAssemblerConfiguration().assign(itemConfiguration.getAssemblerConfiguration());
                break;
            }
            case 1: {
                this.getCCCompilerConfiguration().assign(itemConfiguration.getCCCompilerConfiguration());
                break;
            }
            case 0: {
                this.getCCompilerConfiguration().assign(itemConfiguration.getCCompilerConfiguration());
                break;
            }
            case 3: {
                this.getCustomToolConfiguration().assign(itemConfiguration.getCustomToolConfiguration());
                break;
            }
            case 2: {
                this.getFortranCompilerConfiguration().assign(itemConfiguration.getFortranCompilerConfiguration());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public ItemConfiguration copy(MakeConfiguration makeConfiguration) {
        ItemConfiguration itemConfiguration = new ItemConfiguration(makeConfiguration, this.getItem());
        itemConfiguration.assign(this);
        itemConfiguration.setConfiguration(makeConfiguration);
        return itemConfiguration;
    }

    public ItemConfiguration clone(Configuration configuration) {
        ItemConfiguration itemConfiguration = new ItemConfiguration(configuration, this.getItem());
        itemConfiguration.setExcluded(this.getExcluded().clone());
        itemConfiguration.setTool(this.getTool());
        switch (this.getTool()) {
            case 4: {
                itemConfiguration.setAssemblerConfiguration(this.getAssemblerConfiguration().clone());
                break;
            }
            case 1: {
                itemConfiguration.setCCCompilerConfiguration(this.getCCCompilerConfiguration().clone());
                break;
            }
            case 0: {
                itemConfiguration.setCCompilerConfiguration(this.getCCompilerConfiguration().clone());
                break;
            }
            case 3: {
                itemConfiguration.setCustomToolConfiguration(this.getCustomToolConfiguration().clone());
                break;
            }
            case 2: {
                itemConfiguration.setFortranCompilerConfiguration(this.getFortranCompilerConfiguration().clone());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return itemConfiguration;
    }

    public XMLDecoder getXMLDecoder() {
        return new ItemXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new ItemXMLCodec(this);
    }

    public void initialize() {
    }

    public Sheet getGeneralSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Item");
        set.setDisplayName(ItemConfiguration.getString("ItemTxt"));
        set.setShortDescription(ItemConfiguration.getString("ItemHint"));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("NameTxt"), IpeUtils.getBaseName((String)this.item.getPath())));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("FilePathTxt"), this.item.getPath()));
        String string = IpeUtils.toAbsolutePath((String)((MakeConfiguration)this.configuration).getBaseDir(), (String)this.item.getPath());
        String string2 = "";
        File file = new File(string);
        if (file.exists()) {
            string2 = DateFormat.getDateInstance().format(new Date(file.lastModified()));
            string2 = string2 + " " + DateFormat.getTimeInstance().format(new Date(file.lastModified()));
        }
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("FullFilePathTxt"), string));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("LastModifiedTxt"), string2));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("ItemConfiguration");
        set.setDisplayName(ItemConfiguration.getString("ItemConfigurationTxt"));
        set.setShortDescription(ItemConfiguration.getString("ItemConfigurationHint"));
        if (this.getConfiguration() instanceof MakeConfiguration && ((MakeConfiguration)this.getConfiguration()).isMakefileConfiguration()) {
            set.put((Node.Property)new BooleanNodeProp(this.getExcluded(), true, "ExcludedFromBuild", ItemConfiguration.getString("ExcludedFromCodeAssistanceTxt"), ItemConfiguration.getString("ExcludedFromCodeAssistanceHint")));
        } else {
            set.put((Node.Property)new BooleanNodeProp(this.getExcluded(), true, "ExcludedFromBuild", ItemConfiguration.getString("ExcludedFromBuildTxt"), ItemConfiguration.getString("ExcludedFromBuildHint")));
        }
        set.put((Node.Property)new ToolNodeProp());
        sheet.put(set);
        return sheet;
    }

    public String toString() {
        return this.getItem().getPath();
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(ItemConfiguration.class);
        }
        return bundle.getString(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringRONodeProp
    extends PropertySupport<String> {
        String value;

        public StringRONodeProp(String string, String string2) {
            super(string, String.class, string, string, true, false);
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
        }
    }

    private class ToolEditor
    extends PropertyEditorSupport {
        private ToolEditor() {
        }

        public String getJavaInitializationString() {
            return this.getAsText();
        }

        public String getAsText() {
            int n = (Integer)this.getValue();
            return Tool.getName((int)n);
        }

        public void setAsText(String string) throws IllegalArgumentException {
            this.setValue(Tool.getTool((String)string));
        }

        public String[] getTags() {
            return ItemConfiguration.this.getToolNames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ToolNodeProp
    extends Node.Property<Integer> {
        public ToolNodeProp() {
            super(Integer.class);
        }

        public String getName() {
            return ItemConfiguration.getString("ToolTxt1");
        }

        public Integer getValue() {
            return ItemConfiguration.this.getTool();
        }

        public void setValue(Integer n) {
            ItemConfiguration.this.setTool(n);
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            return new ToolEditor();
        }
    }
}

