/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.utils.ElfDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfStaticLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.MacOSXDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.PeDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.PeStaticLibraryFileFilter;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ui.LibraryOptionPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.MakeArtifactChooser;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StdLibPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.TableEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrariesPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    private Project project;
    private MakeConfiguration conf;
    private MyListEditorPanel myListEditorPanel;
    private String baseDir;
    private PropertyEditorSupport editor;
    private JButton addProjectButton;
    private JButton addStandardLibraryButton;
    private JButton addLibraryButton;
    private JButton addLibraryFileButton;
    private JButton addLibraryOption;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JPanel outerPanel;
    private static ResourceBundle bundle;

    public LibrariesPanel(Project project, MakeConfiguration makeConfiguration, String string, List<LibraryItem> list, PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
        this.project = project;
        this.conf = makeConfiguration;
        this.baseDir = string;
        this.editor = propertyEditorSupport;
        this.initComponents();
        this.addProjectButton = new JButton(LibrariesPanel.getString("ADD_PROJECT_BUTTON_TXT"));
        this.addProjectButton.setToolTipText(LibrariesPanel.getString("ADD_PROJECT_BUTTON_TT"));
        this.addProjectButton.setMnemonic(LibrariesPanel.getString("ADD_PROJECT_BUTTON_MN").charAt(0));
        this.addStandardLibraryButton = new JButton(LibrariesPanel.getString("ADD_STANDARD_LIBRARY_BUTTON_TXT"));
        this.addStandardLibraryButton.setToolTipText(LibrariesPanel.getString("ADD_STANDARD_LIBRARY_BUTTON_TT"));
        this.addStandardLibraryButton.setMnemonic(LibrariesPanel.getString("ADD_STANDARD_LIBRARY_BUTTON_MN").charAt(0));
        this.addLibraryButton = new JButton(LibrariesPanel.getString("ADD_LIBRARY_BUTTON_TXT"));
        this.addLibraryButton.setToolTipText(LibrariesPanel.getString("ADD_LIBRARY_BUTTON_TT"));
        this.addLibraryButton.setMnemonic(LibrariesPanel.getString("ADD_LIBRARY_BUTTON_MN").charAt(0));
        this.addLibraryFileButton = new JButton(LibrariesPanel.getString("ADD_LIBRARY_FILE_BUTTON_TXT"));
        this.addLibraryFileButton.setToolTipText(LibrariesPanel.getString("ADD_LIBRARY_FILE_BUTTON_TT"));
        this.addLibraryFileButton.setMnemonic(LibrariesPanel.getString("ADD_LIBRARY_FILE_BUTTON_MN").charAt(0));
        this.addLibraryOption = new JButton(LibrariesPanel.getString("ADD_OPTION_BUTTON_TXT"));
        this.addLibraryOption.setToolTipText(LibrariesPanel.getString("ADD_OPTION_BUTTON_TT"));
        this.addLibraryOption.setMnemonic(LibrariesPanel.getString("ADD_OPTION_BUTTON_MN").charAt(0));
        JButton[] jButtonArray = new JButton[]{this.addProjectButton, this.addStandardLibraryButton, this.addLibraryButton, this.addLibraryFileButton, this.addLibraryOption};
        this.myListEditorPanel = new MyListEditorPanel(list, jButtonArray);
        this.addProjectButton.addActionListener(new AddProjectButtonAction());
        this.addStandardLibraryButton.addActionListener(new AddStandardLibraryButtonAction());
        this.addLibraryButton.addActionListener(new AddLibraryButtonAction());
        this.addLibraryOption.addActionListener(new AddLinkerOptionButtonAction());
        this.addLibraryFileButton.addActionListener(new AddLibraryFileButtonAction());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.outerPanel.add((Component)this.myListEditorPanel, gridBagConstraints);
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.setPreferredSize(new Dimension(700, 450));
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setInstructionsText(String string) {
        this.instructionsTextArea.setText(string);
    }

    public void setListData(List<LibraryItem> list) {
        this.myListEditorPanel.setListData(list);
    }

    public Vector<LibraryItem> getListData() {
        return this.myListEditorPanel.getListData();
    }

    private ArrayList<LibraryItem> getPropertyValue() throws IllegalStateException {
        return new ArrayList<LibraryItem>(this.getListData());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Libraries");
    }

    private void initComponents() {
        this.outerPanel = new JPanel();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(323, 223));
        this.outerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.outerPanel, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(LibrariesPanel.class);
        }
        return bundle.getString(string);
    }

    class AddLinkerOptionButtonAction
    implements ActionListener {
        AddLinkerOptionButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryOptionPanel libraryOptionPanel = new LibraryOptionPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)libraryOptionPanel, LibrariesPanel.getString("SELECT_OPTION_DIALOG_TITLE"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            if (libraryOptionPanel.getOption(LibrariesPanel.this.conf).trim().length() == 0) {
                return;
            }
            LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.OptionItem(libraryOptionPanel.getOption(LibrariesPanel.this.conf)));
        }
    }

    class AddLibraryFileButtonAction
    implements ActionListener {
        AddLibraryFileButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = LibrariesPanel.this.baseDir;
            }
            FileFilter[] fileFilterArray = Utilities.isWindows() ? new FileFilter[]{PeStaticLibraryFileFilter.getInstance(), PeDynamicLibraryFileFilter.getInstance()} : (Utilities.getOperatingSystem() == 4096 ? new FileFilter[]{ElfStaticLibraryFileFilter.getInstance(), MacOSXDynamicLibraryFileFilter.getInstance()} : new FileFilter[]{ElfStaticLibraryFileFilter.getInstance(), ElfDynamicLibraryFileFilter.getInstance()});
            FileChooser fileChooser = new FileChooser(LibrariesPanel.getString("SELECT_LIBRARY_FILE_CHOOSER_TITLE"), LibrariesPanel.getString("SELECT_CHOOSER_BUTTON"), 0, fileFilterArray, string, true);
            PathPanel pathPanel = new PathPanel();
            fileChooser.setAccessory((JComponent)pathPanel);
            int n = fileChooser.showOpenDialog(null);
            if (n == 1) {
                return;
            }
            String string2 = fileChooser.getSelectedFile().getPath();
            if (PathPanel.getMode() == 0) {
                string2 = IpeUtils.toAbsoluteOrRelativePath((String)LibrariesPanel.this.baseDir, (String)string2);
            } else if (PathPanel.getMode() == 1) {
                string2 = IpeUtils.toRelativePath((String)LibrariesPanel.this.baseDir, (String)string2);
            }
            string2 = FilePathAdaptor.normalize(string2);
            LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.LibFileItem(string2));
        }
    }

    class AddLibraryButtonAction
    implements ActionListener {
        AddLibraryButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = LibrariesPanel.this.baseDir;
            }
            FileFilter[] fileFilterArray = Utilities.isWindows() ? new FileFilter[]{PeStaticLibraryFileFilter.getInstance(), PeDynamicLibraryFileFilter.getInstance()} : (Utilities.getOperatingSystem() == 4096 ? new FileFilter[]{ElfStaticLibraryFileFilter.getInstance(), MacOSXDynamicLibraryFileFilter.getInstance()} : new FileFilter[]{ElfStaticLibraryFileFilter.getInstance(), ElfDynamicLibraryFileFilter.getInstance()});
            FileChooser fileChooser = new FileChooser(LibrariesPanel.getString("SELECT_LIBRARY_CHOOSER_TITLE"), LibrariesPanel.getString("SELECT_CHOOSER_BUTTON"), 0, fileFilterArray, string, true);
            int n = fileChooser.showOpenDialog((Component)LibrariesPanel.this.myListEditorPanel);
            if (n == 1) {
                return;
            }
            String string2 = fileChooser.getSelectedFile().getName();
            if (string2.startsWith("lib")) {
                string2 = string2.substring(3);
            }
            if (string2.endsWith(".so") || string2.endsWith(".dll") || string2.endsWith(".dylib") || string2.endsWith(".lib") || string2.endsWith(".a")) {
                int n2 = string2.lastIndexOf(46);
                string2 = string2.substring(0, n2);
            }
            LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.LibItem(string2));
        }
    }

    class AddStandardLibraryButtonAction
    implements ActionListener {
        AddStandardLibraryButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StdLibPanel stdLibPanel = new StdLibPanel(Platforms.getPlatform(LibrariesPanel.this.conf.getDevelopmentHost().getBuildPlatform()).getStandardLibraries());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)stdLibPanel, LibrariesPanel.getString("SELECT_STATNDARD_LIBRARY_DIALOG_TITLE"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            LibraryItem.StdLibItem[] stdLibItemArray = stdLibPanel.getSelectedStdLibs();
            for (int i = 0; i < stdLibItemArray.length; ++i) {
                LibrariesPanel.this.myListEditorPanel.addObjectAction(stdLibItemArray[i]);
            }
        }
    }

    class AddProjectButtonAction
    implements ActionListener {
        AddProjectButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MakeArtifact[] makeArtifactArray = MakeArtifactChooser.showDialog(MakeArtifactChooser.ArtifactType.LIBRARY, LibrariesPanel.this.project, LibrariesPanel.this.myListEditorPanel);
            if (makeArtifactArray != null) {
                for (int i = 0; i < makeArtifactArray.length; ++i) {
                    String string;
                    String string2;
                    if (PathPanel.getMode() == 0) {
                        string2 = IpeUtils.toAbsoluteOrRelativePath((String)LibrariesPanel.this.baseDir, (String)makeArtifactArray[i].getProjectLocation());
                        string = IpeUtils.toAbsoluteOrRelativePath((String)LibrariesPanel.this.baseDir, (String)makeArtifactArray[i].getWorkingDirectory());
                    } else if (PathPanel.getMode() == 1) {
                        string2 = IpeUtils.toRelativePath((String)LibrariesPanel.this.baseDir, (String)makeArtifactArray[i].getProjectLocation());
                        string = IpeUtils.toRelativePath((String)LibrariesPanel.this.baseDir, (String)makeArtifactArray[i].getWorkingDirectory());
                    } else {
                        string2 = makeArtifactArray[i].getProjectLocation();
                        string = makeArtifactArray[i].getWorkingDirectory();
                    }
                    string2 = FilePathAdaptor.normalize(string2);
                    string = FilePathAdaptor.normalize(string);
                    makeArtifactArray[i].setProjectLocation(string2);
                    makeArtifactArray[i].setWorkingDirectory(string);
                    LibrariesPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.ProjectItem(makeArtifactArray[i]));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListEditorPanel
    extends TableEditorPanel {
        public MyListEditorPanel(List<LibraryItem> list, JButton[] jButtonArray) {
            super(list, jButtonArray, LibrariesPanel.this.baseDir);
            this.getAddButton().setVisible(false);
            this.getEditButton().setVisible(false);
            this.getDefaultButton().setVisible(false);
        }

        @Override
        public String getListLabelText() {
            return LibrariesPanel.getString("LIBRARIES_AND_OPTIONS_TXT");
        }

        @Override
        public char getListLabelMnemonic() {
            return LibrariesPanel.getString("LIBRARIES_AND_OPTIONS_MN").charAt(0);
        }

        @Override
        public LibraryItem copyAction(LibraryItem libraryItem) {
            LibraryItem libraryItem2 = libraryItem;
            return libraryItem2.clone();
        }
    }
}

