/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingAddingFilesProgressPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingFilesOuterPanel;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingNewLinkPanel;
import org.netbeans.modules.cnd.makeproject.ui.utils.ListEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagingFilesPanel
extends ListEditorPanel<PackagerFileElement> {
    private String baseDir;
    private JTable targetList;
    private MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
    private JButton addButton;
    private JButton addFileOrDirectoryButton;
    private JButton addFilesButton;
    private JButton addLinkButton;
    private PackagingFilesOuterPanel packagingFilesOuterPanel;
    private static ResourceBundle bundle;

    public PackagingFilesPanel(List<PackagerFileElement> list, String string) {
        super(list, new JButton[]{new JButton(), new JButton(), new JButton(), new JButton()});
        this.getAddButton().setVisible(false);
        this.baseDir = string;
        this.addButton = this.extraButtons[0];
        this.addFileOrDirectoryButton = this.extraButtons[1];
        this.addFilesButton = this.extraButtons[2];
        this.addLinkButton = this.extraButtons[3];
        this.addButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.text"));
        this.addButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.mn").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addButton.ad"));
        this.addButton.addActionListener(new AddButtonAction());
        this.addFileOrDirectoryButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.text"));
        this.addFileOrDirectoryButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.mn").charAt(0));
        this.addFileOrDirectoryButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addFileOrDirButton.ad"));
        this.addFileOrDirectoryButton.addActionListener(new AddFileOrDirectoryButtonAction());
        this.addFilesButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.text"));
        this.addFilesButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.mn").charAt(0));
        this.addFilesButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addFilesButton.ad"));
        this.addFilesButton.addActionListener(new AddFilesButtonAction());
        this.addLinkButton.setText(PackagingFilesPanel.getString("PackagingFilesPanel.addLinkButton.text"));
        this.addLinkButton.setMnemonic(PackagingFilesPanel.getString("PackagingFilesPanel.addLinkButton.mn").charAt(0));
        this.addLinkButton.getAccessibleContext().setAccessibleDescription(PackagingFilesPanel.getString("PackagingFilesPanel.addLinkButton.ad"));
        this.addLinkButton.addActionListener(new AddLinkButtonAction());
        this.getEditButton().setVisible(false);
        this.getDefaultButton().setVisible(false);
    }

    private void refresh() {
        this.packagingFilesOuterPanel.getPackagingConfiguration().getTopDir().setValue(this.packagingFilesOuterPanel.getTopDirectoryTextField().getText());
        this.getTargetList().validate();
        this.getTargetList().repaint();
    }

    public void setOuterPanel(PackagingFilesOuterPanel packagingFilesOuterPanel) {
        this.packagingFilesOuterPanel = packagingFilesOuterPanel;
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                PackagingFilesPanel.this.refresh();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PackagingFilesPanel.this.refresh();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                PackagingFilesPanel.this.refresh();
            }
        };
        packagingFilesOuterPanel.getTopDirectoryTextField().getDocument().addDocumentListener(documentListener);
    }

    @Override
    public PackagerFileElement copyAction(PackagerFileElement packagerFileElement) {
        PackagerFileElement packagerFileElement2 = packagerFileElement;
        PackagerFileElement packagerFileElement3 = new PackagerFileElement(packagerFileElement2.getType(), new String(packagerFileElement2.getFrom()), new String(packagerFileElement2.getTo()));
        packagerFileElement3.setOwner(packagerFileElement2.getOwner());
        packagerFileElement3.setPermission(packagerFileElement2.getPermission());
        packagerFileElement3.setGroup(packagerFileElement2.getGroup());
        return packagerFileElement3;
    }

    @Override
    public String getCopyButtonText() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.text");
    }

    @Override
    public char getCopyButtonMnemonics() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.mn").charAt(0);
    }

    @Override
    public String getCopyButtonAD() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.duplicateButton.ad");
    }

    @Override
    public String getListLabelText() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.listlabel.text");
    }

    @Override
    public char getListLabelMnemonic() {
        return PackagingFilesPanel.getString("PackagingFilesPanel.listlabel.mn").charAt(0);
    }

    @Override
    public int getSelectedIndex() {
        int n = this.getTargetList().getSelectedRow();
        if (n >= 0 && n < this.listData.size()) {
            return n;
        }
        return 0;
    }

    @Override
    protected void setSelectedIndex(int n) {
        this.getTargetList().getSelectionModel().setSelectionInterval(n, n);
    }

    @Override
    protected void setData(Vector vector) {
        this.getTargetList().setModel(new MyTableModel());
        if (this.getTargetList().getColumnModel().getColumnCount() >= 4) {
            this.getTargetList().getColumnModel().getColumn(0).setPreferredWidth(40);
            this.getTargetList().getColumnModel().getColumn(0).setMaxWidth(200);
            this.getTargetList().getColumnModel().getColumn(3).setPreferredWidth(50);
            this.getTargetList().getColumnModel().getColumn(3).setMaxWidth(200);
        }
        if (this.getTargetList().getColumnModel().getColumnCount() >= 6) {
            this.getTargetList().getColumnModel().getColumn(4).setPreferredWidth(50);
            this.getTargetList().getColumnModel().getColumn(4).setMaxWidth(200);
            this.getTargetList().getColumnModel().getColumn(5).setPreferredWidth(50);
            this.getTargetList().getColumnModel().getColumn(5).setMaxWidth(200);
        }
        ((DefaultTableCellRenderer)this.getTargetList().getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }

    @Override
    protected void ensureIndexIsVisible(int n) {
        Rectangle rectangle = this.getTargetList().getCellRect(n, 0, true);
        this.getTargetList().scrollRectToVisible(rectangle);
    }

    @Override
    protected Component getViewComponent() {
        return this.getTargetList();
    }

    private JTable getTargetList() {
        if (this.targetList == null) {
            this.targetList = new MyTable();
            this.setData(null);
            this.getListLabel().setLabelFor(this.targetList);
            this.getTargetList().getSelectionModel().setSelectionMode(0);
            this.getTargetList().getSelectionModel().addListSelectionListener(new TargetSelectionListener());
        }
        return this.targetList;
    }

    public int getActualColumnCount() {
        return 6;
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PackagingFilesPanel.class);
        }
        return bundle.getString(string);
    }

    private static String getString(String string, String string2) {
        return NbBundle.getMessage(PackagingFilesPanel.class, (String)string, (Object)string2);
    }

    class MyTableModel
    extends DefaultTableModel {
        private String[] columnNames = new String[]{PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.0.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.1.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.2.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.3.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.4.text"), PackagingFilesPanel.access$200("PackagingFilesOuterPanel.column.5.text")};

        MyTableModel() {
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return PackagingFilesPanel.this.getActualColumnCount();
        }

        public int getRowCount() {
            return PackagingFilesPanel.this.listData.size();
        }

        public Object getValueAt(int n, int n2) {
            PackagerFileElement packagerFileElement = (PackagerFileElement)PackagingFilesPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                return packagerFileElement.getType();
            }
            if (n2 == 2) {
                if (packagerFileElement.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    return "";
                }
                return packagerFileElement.getFrom();
            }
            if (n2 == 1) {
                return packagerFileElement.getTo();
            }
            if (n2 == 3) {
                return packagerFileElement.getPermission();
            }
            if (n2 == 4) {
                return packagerFileElement.getOwner();
            }
            if (n2 == 5) {
                return packagerFileElement.getGroup();
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return true;
            }
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            PackagerFileElement packagerFileElement = (PackagerFileElement)PackagingFilesPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                PackagerFileElement.FileType fileType = (PackagerFileElement.FileType)((Object)object);
                if (fileType == PackagerFileElement.FileType.FILE) {
                    packagerFileElement.setType(fileType);
                    packagerFileElement.setPermission(PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText());
                    packagerFileElement.setOwner(PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText());
                    packagerFileElement.setGroup(PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText());
                } else if (fileType == PackagerFileElement.FileType.DIRECTORY) {
                    packagerFileElement.setType(fileType);
                    packagerFileElement.setPermission(PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText());
                    packagerFileElement.setOwner(PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText());
                    packagerFileElement.setGroup(PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText());
                } else if (fileType == PackagerFileElement.FileType.SOFTLINK) {
                    packagerFileElement.setType(fileType);
                    packagerFileElement.setPermission("");
                    packagerFileElement.setOwner("");
                    packagerFileElement.setGroup("");
                } else assert (false);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 2) {
                packagerFileElement.setFrom((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 1) {
                packagerFileElement.setTo((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 3) {
                packagerFileElement.setPermission((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 4) {
                packagerFileElement.setOwner((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 5) {
                packagerFileElement.setGroup((String)object);
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else assert (false);
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        MyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            PackagerFileElement packagerFileElement = (PackagerFileElement)PackagingFilesPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                jLabel.setText(packagerFileElement.getType().toString());
            } else if (n2 == 1) {
                String string2;
                if (packagerFileElement.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    string2 = PackagingFilesPanel.getString("Softlink_tt", packagerFileElement.getTo() + "->" + packagerFileElement.getFrom());
                    jLabel.setToolTipText(string2);
                } else if (packagerFileElement.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    string2 = PackagingFilesPanel.getString("Directory_tt", packagerFileElement.getTo());
                    jLabel.setToolTipText(string2);
                } else if (packagerFileElement.getType() == PackagerFileElement.FileType.FILE) {
                    string2 = PackagingFilesPanel.getString("File_tt", new File(IpeUtils.toAbsolutePath((String)PackagingFilesPanel.this.baseDir, (String)packagerFileElement.getFrom())).getAbsolutePath());
                    jLabel.setToolTipText(string2);
                }
                string2 = packagerFileElement.getTo();
                if (string2.indexOf("${") >= 0) {
                    String string3 = PackagingFilesPanel.this.packagingFilesOuterPanel.getPackagingConfiguration().expandMacros(string2);
                    jLabel.setText(string3);
                }
            } else if (n2 == 2 && (string = packagerFileElement.getFrom()).indexOf("${") >= 0) {
                String string4 = PackagingFilesPanel.this.packagingFilesOuterPanel.getPackagingConfiguration().expandMacros(string);
                jLabel.setText(string4);
            }
            return jLabel;
        }
    }

    class MyTable
    extends JTable {
        public MyTable() {
            this.getAccessibleContext().setAccessibleDescription("");
            this.getAccessibleContext().setAccessibleName("");
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }

        public Color getGridColor() {
            return new Color(225, 225, 225);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return PackagingFilesPanel.this.myTableCellRenderer;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                PackagerFileElement packagerFileElement = (PackagerFileElement)PackagingFilesPanel.this.listData.elementAt(n);
                JComboBox<PackagerFileElement.FileType> jComboBox = new JComboBox<PackagerFileElement.FileType>();
                jComboBox.addItem(PackagerFileElement.FileType.FILE);
                jComboBox.addItem(PackagerFileElement.FileType.DIRECTORY);
                jComboBox.addItem(PackagerFileElement.FileType.SOFTLINK);
                if (packagerFileElement.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    jComboBox.setSelectedIndex(1);
                } else if (packagerFileElement.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    jComboBox.setSelectedIndex(2);
                } else {
                    jComboBox.setSelectedIndex(0);
                }
                return new DefaultCellEditor(jComboBox);
            }
            return super.getCellEditor(n, n2);
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            PackagingFilesPanel.this.checkSelection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AddFilesButtonAction
    implements ActionListener {
        private boolean cancelled = false;

        AddFilesButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = PackagingFilesPanel.this.baseDir;
            }
            FileChooser fileChooser = new FileChooser(PackagingFilesPanel.getString("FileChooserFilesTitle"), PackagingFilesPanel.getString("FileChooserButtonText"), 1, null, string, false);
            PathPanel pathPanel = new PathPanel();
            fileChooser.setAccessory((JComponent)pathPanel);
            fileChooser.setMultiSelectionEnabled(false);
            int n = fileChooser.showOpenDialog(null);
            if (n == 1) {
                return;
            }
            final File file = fileChooser.getSelectedFile();
            JButton jButton = new JButton(PackagingFilesPanel.getString("PackagingAddingFilesProgressPanel.Stop.Button.text"));
            jButton.setMnemonic(PackagingFilesPanel.getString("PackagingAddingFilesProgressPanel.Stop.Button.text").charAt(0));
            jButton.addActionListener(new StopButtonAction());
            final PackagingAddingFilesProgressPanel packagingAddingFilesProgressPanel = new PackagingAddingFilesProgressPanel(jButton);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)packagingAddingFilesProgressPanel, PackagingFilesPanel.getString("PackagingAddingFilesProgressPanel.title"), true, (Object[])new JButton[]{jButton}, (Object)jButton, 1, null, null);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    new AddFilesFromDir(file, packagingAddingFilesProgressPanel, dialog).start();
                }
            });
            dialog.setVisible(true);
        }

        private void addFilesFromDirectory(ArrayList<PackagerFileElement> arrayList, File file, File file2, PackagingAddingFilesProgressPanel packagingAddingFilesProgressPanel) {
            File[] fileArray = file2.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length && !this.cancelled; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.addFilesFromDirectory(arrayList, file, fileArray[i], packagingAddingFilesProgressPanel);
                    continue;
                }
                String string = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)PackagingFilesPanel.this.baseDir, (String)fileArray[i].getPath()) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)PackagingFilesPanel.this.baseDir, (String)fileArray[i].getPath()) : fileArray[i].getPath());
                string = FilePathAdaptor.normalize(string);
                String string2 = IpeUtils.toRelativePath((String)file.getParentFile().getAbsolutePath(), (String)fileArray[i].getPath());
                string2 = FilePathAdaptor.normalize(string2);
                String string3 = "${PACKAGE_TOP_DIR}";
                String string4 = fileArray[i].getName().endsWith(".exe") || fileArray[i].isDirectory() || IpeUtils.isExecutable((File)fileArray[i]) ? PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText() : PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText();
                arrayList.add(new PackagerFileElement(PackagerFileElement.FileType.FILE, string, string3 + string2, string4, PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
                packagingAddingFilesProgressPanel.setProgress(string);
            }
        }

        class StopButtonAction
        implements ActionListener {
            StopButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AddFilesButtonAction.this.cancelled = true;
            }
        }

        class AddFilesFromDir
        extends Thread {
            private PackagingAddingFilesProgressPanel progressPanel;
            private Dialog progressDialog;
            private File dir;

            AddFilesFromDir(File file, PackagingAddingFilesProgressPanel packagingAddingFilesProgressPanel, Dialog dialog) {
                this.progressPanel = packagingAddingFilesProgressPanel;
                this.progressDialog = dialog;
                this.dir = file;
            }

            public void run() {
                final ArrayList arrayList = new ArrayList();
                AddFilesButtonAction.this.addFilesFromDirectory(arrayList, this.dir, this.dir, this.progressPanel);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PackagingFilesPanel.this.addObjectsAction(arrayList);
                        AddFilesFromDir.this.progressDialog.setVisible(false);
                    }
                });
            }
        }
    }

    class AddFileOrDirectoryButtonAction
    implements ActionListener {
        AddFileOrDirectoryButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = PackagingFilesPanel.this.baseDir;
            }
            FileChooser fileChooser = new FileChooser(PackagingFilesPanel.getString("FileChooserFileTitle"), PackagingFilesPanel.getString("FileChooserButtonText"), 2, null, string, false);
            PathPanel pathPanel = new PathPanel();
            fileChooser.setAccessory((JComponent)pathPanel);
            fileChooser.setMultiSelectionEnabled(true);
            int n = fileChooser.showOpenDialog(null);
            if (n == 1) {
                return;
            }
            File[] fileArray = fileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)PackagingFilesPanel.this.baseDir, (String)fileArray[i].getPath()) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)PackagingFilesPanel.this.baseDir, (String)fileArray[i].getPath()) : fileArray[i].getPath());
                string2 = FilePathAdaptor.normalize(string2);
                String string3 = "${PACKAGE_TOP_DIR}";
                if (fileArray[i].isDirectory()) {
                    PackagingFilesPanel.this.addObjectAction(new PackagerFileElement(PackagerFileElement.FileType.DIRECTORY, "", string3 + fileArray[i].getName(), PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
                    continue;
                }
                String string4 = IpeUtils.isExecutable((File)fileArray[i]) ? PackagingFilesPanel.this.packagingFilesOuterPanel.getDirPermTextField().getText() : PackagingFilesPanel.this.packagingFilesOuterPanel.getFilePermTextField().getText();
                PackagingFilesPanel.this.addObjectAction(new PackagerFileElement(PackagerFileElement.FileType.FILE, string2, string3 + fileArray[i].getName(), string4, PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
            }
        }
    }

    class AddLinkButtonAction
    implements ActionListener {
        AddLinkButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PackagingNewLinkPanel packagingNewLinkPanel = new PackagingNewLinkPanel(PackagingFilesPanel.this.packagingFilesOuterPanel.getTopDirectoryTextField().getText());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)packagingNewLinkPanel, PackagingFilesPanel.getString("AddNewLinkDialogTitle"));
            packagingNewLinkPanel.setDialogDesriptor(dialogDescriptor);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            PackagingFilesPanel.this.addObjectAction(new PackagerFileElement(PackagerFileElement.FileType.SOFTLINK, packagingNewLinkPanel.getLink(), packagingNewLinkPanel.getLinkName(), "", PackagingFilesPanel.this.packagingFilesOuterPanel.getOwnerTextField().getText(), PackagingFilesPanel.this.packagingFilesOuterPanel.getGroupTextField().getText()));
        }
    }

    class AddButtonAction
    implements ActionListener {
        AddButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "${PACKAGE_TOP_DIR}";
            PackagingFilesPanel.this.addObjectAction(new PackagerFileElement(PackagerFileElement.FileType.UNKNOWN, "", string));
        }
    }
}

