/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerListDisplayer;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class RemoteDevelopmentAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static final String HOST_ENV = "org.netbeans.modules.cnd.makeproject.ui.RemoteHost";
    private static final String CONF = "org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration";
    private static final String PROJECT = "org.netbeans.modules.cnd.makeproject.api.configurations.MakeProject";
    private JMenu subMenu;
    private MakeProject project;

    public RemoteDevelopmentAction(MakeProject makeProject) {
        super(NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_RemoteDevelopmentAction_Name"), null);
        this.project = makeProject;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    public JMenuItem getMenuPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    private void createSubMenu() {
        Object object;
        if (this.subMenu == null) {
            object = NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_RemoteDevelopmentAction_Name");
            this.subMenu = new JMenu((String)object);
        }
        this.subMenu.removeAll();
        object = this.project.getActiveConfiguration();
        ExecutionEnvironment executionEnvironment = this.project.getDevelopmentHostExecutionEnvironment();
        if (object == null || executionEnvironment == null) {
            return;
        }
        MenuItemActionListener menuItemActionListener = new MenuItemActionListener();
        for (ServerRecord serverRecord : ServerList.getRecords()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(serverRecord.getServerDisplayName(), executionEnvironment.equals(serverRecord.getExecutionEnvironment()));
            this.subMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.putClientProperty(HOST_ENV, serverRecord.getExecutionEnvironment());
            jRadioButtonMenuItem.putClientProperty(CONF, object);
            jRadioButtonMenuItem.putClientProperty(PROJECT, this.project);
            jRadioButtonMenuItem.addActionListener(menuItemActionListener);
        }
        this.subMenu.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_ManagePlatforms_Name"));
        this.subMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerListDisplayer.showServerListDialog();
            }
        });
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)jMenuItem.getClientProperty(RemoteDevelopmentAction.HOST_ENV);
                MakeConfiguration makeConfiguration = (MakeConfiguration)jMenuItem.getClientProperty(RemoteDevelopmentAction.CONF);
                if (makeConfiguration != null && executionEnvironment != null) {
                    ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
                    if (!serverRecord.isSetUp() && !serverRecord.setUp()) {
                        return;
                    }
                    DevelopmentHostConfiguration developmentHostConfiguration = new DevelopmentHostConfiguration(executionEnvironment);
                    DevelopmentHostConfiguration developmentHostConfiguration2 = makeConfiguration.getDevelopmentHost();
                    makeConfiguration.setDevelopmentHost(developmentHostConfiguration);
                    makeConfiguration.setCompilerSet(new CompilerSet2Configuration(developmentHostConfiguration));
                    Project project = (Project)jMenuItem.getClientProperty(RemoteDevelopmentAction.PROJECT);
                    NativeProjectProvider nativeProjectProvider = (NativeProjectProvider)project.getLookup().lookup(NativeProjectProvider.class);
                    nativeProjectProvider.propertyChange(new PropertyChangeEvent(this, "activeconfiguration", null, makeConfiguration));
                    ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                    MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
                    ((ConfigurationDescriptor)makeConfigurationDescriptor).setModified(true);
                }
            }
        }
    }
}

