/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SelectModeDescriptorPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private WizardDescriptor wizardDescriptor;
    private SelectModePanel component;
    private String name;
    private WizardStorage wizardStorage = new WizardStorage();
    private boolean isValid = false;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public SelectModeDescriptorPanel() {
        this.name = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeName");
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new SelectModePanel(this);
            this.component.setName(this.name);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("NewMakeWizardP0");
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void validate() {
        this.isValid = this.component.valid();
        this.fireChangeEvent();
    }

    private void setMode(boolean bl) {
        if (bl) {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
        } else {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.FALSE);
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    WizardDescriptor getWizardDescriptor() {
        return this.wizardDescriptor;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = this.component.getClientProperty("WizardPanel_contentData");
        String[] stringArray = (String[])object;
        String[] stringArray2 = Boolean.TRUE.equals(this.wizardDescriptor.getProperty("simpleMode")) ? new String[]{stringArray[0]} : new String[]{stringArray[0], "..."};
        this.component.putClientProperty("WizardPanel_contentData", stringArray2);
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        return Boolean.TRUE.equals(this.wizardDescriptor.getProperty("simpleMode"));
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
        if (this.wizardDescriptor.getProperty("simpleMode") == null) {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
        }
    }

    public void storeSettings(Object object) {
        this.component.store((WizardDescriptor)object);
    }

    public WizardStorage getWizardStorage() {
        return this.wizardStorage;
    }

    public static String findConfigureScript(String string) {
        String[] stringArray = new String[]{"configure"};
        File file = new File(string);
        if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
            return null;
        }
        for (String string2 : stringArray) {
            file = new File(string + "/" + string2);
            if (!SelectModeDescriptorPanel.isRunnable(file)) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    public static boolean isRunnable(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            DataObject dataObject;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null || !fileObject.isValid()) {
                return false;
            }
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return false;
            }
            if (dataObject == null) {
                return false;
            }
            Node node = dataObject.getNodeDelegate();
            if (node == null) {
                return false;
            }
            ShellExecSupport shellExecSupport = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
            return shellExecSupport != null;
        }
        return false;
    }

    public static String findMakefile(String string) {
        String[] stringArray = new String[]{"GNUmakefile", "makefile", "Makefile"};
        File file = new File(string);
        if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
            return null;
        }
        for (String string2 : stringArray) {
            file = new File(string + "/" + string2);
            if (!file.exists() || !file.isFile() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    public static class WizardDescriptorAdapter
    extends WizardDescriptor {
        private WizardStorage storage;

        public WizardDescriptorAdapter(WizardStorage wizardStorage) {
            this.storage = wizardStorage;
        }

        public synchronized Object getProperty(String string) {
            if ("path".equals(string)) {
                return this.storage.getPath();
            }
            if ("realFlags".equals(string)) {
                return this.storage.getRealFlags();
            }
            if ("buildProject".equals(string)) {
                if (this.storage.isBuildProject()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("setMain".equals(string)) {
                if (this.storage.isSetMain()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("simpleMode".equals(string)) {
                return Boolean.TRUE;
            }
            if ("makefileName".equals(string)) {
                return this.storage.getMake();
            }
            if ("configureName".equals(string)) {
                return this.storage.getConfigure();
            }
            return super.getProperty(string);
        }
    }

    public class WizardStorage {
        private String path = "";
        private static final String PREDEFINED_FLAGS = "\"-g3 -gdwarf-2\"";
        private String flags = "";
        private boolean setMain = true;
        private boolean buildProject = true;

        public void setMode(boolean bl) {
            SelectModeDescriptorPanel.this.setMode(bl);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string.trim();
            SelectModeDescriptorPanel.this.validate();
        }

        public String getConfigure() {
            if (this.path.length() == 0) {
                return null;
            }
            return SelectModeDescriptorPanel.findConfigureScript(this.path);
        }

        public boolean isNbProjectFolder() {
            if (this.path.length() == 0) {
                return false;
            }
            File file = new File(this.path);
            if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
                return false;
            }
            file = new File(this.path + "/nbproject/project.xml");
            return file.exists();
        }

        public String getMake() {
            if (this.path.length() == 0) {
                return null;
            }
            return SelectModeDescriptorPanel.findMakefile(this.path);
        }

        public String getFlags() {
            return this.flags;
        }

        public String getRealFlags() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.flags.indexOf("CFLAGS=") < 0) {
                stringBuilder.append("CFLAGS=\"-g3 -gdwarf-2\"");
            }
            if (this.flags.indexOf("CXXFLAGS=") < 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("CXXFLAGS=\"-g3 -gdwarf-2\"");
            }
            if (this.flags.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.flags);
            }
            return stringBuilder.toString();
        }

        public void setFlags(String string) {
            this.flags = string;
            SelectModeDescriptorPanel.this.validate();
        }

        public boolean isSetMain() {
            return this.setMain;
        }

        public void setSetMain(boolean bl) {
            this.setMain = bl;
            SelectModeDescriptorPanel.this.validate();
        }

        public boolean isBuildProject() {
            return this.buildProject;
        }

        public void setBuildProject(boolean bl) {
            this.buildProject = bl;
            SelectModeDescriptorPanel.this.validate();
        }
    }
}

