/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRs;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRsStackProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MavenProjectRestSupport
extends WebRestSupport {
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    private static final String TEST_SERVICES_HTML = "test-services.html";
    String[] classPathTypes = new String[]{"classpath/compile"};

    public MavenProjectRestSupport(Project project) {
        super(project);
    }

    public void upgrade() {
        if (!this.isRestSupportOn()) {
            return;
        }
        try {
            FileObject fileObject = this.getWebXml();
            WebApp webApp = this.getWebApp();
            if (webApp == null) {
                return;
            }
            Servlet servlet = this.getRestServletAdaptor(webApp);
            if (servlet != null && "com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(servlet.getServletClass())) {
                servlet.setServletClass(this.getServletAdapterClass());
                webApp.write(fileObject);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void extendBuildScripts() throws IOException {
    }

    public void ensureRestDevelopmentReady() throws IOException {
        this.addResourceConfigToWebApp();
        this.addSwdpLibrary();
    }

    public void removeRestDevelopmentReadiness() throws IOException {
        this.removeResourceConfigFromWebApp();
        this.removeSwdpLibrary(new String[]{"classpath/compile"});
    }

    public boolean isReady() {
        return this.isRestSupportOn() && this.hasSwdpLibrary() && this.hasRestServletAdaptor();
    }

    private boolean platformHasRestLib(J2eePlatform j2eePlatform) {
        WSStack wSStack;
        if (j2eePlatform != null && (wSStack = JaxRsStackProvider.getJaxRsStack((J2eePlatform)j2eePlatform)) != null) {
            return wSStack.isFeatureSupported((WSStack.Feature)JaxRs.Feature.JAXRS);
        }
        return false;
    }

    public boolean hasSwdpLibrary() {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray.length > 0) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
            FileObject fileObject = classPath.findResource("javax/ws/rs/core/Context.class");
            return fileObject != null;
        }
        return false;
    }

    private void addSwdpLibrary() throws IOException {
        Library library;
        if (!this.hasSwdpLibrary() && (library = LibraryManager.getDefault().getLibrary("restlib")) != null) {
            this.addSwdpLibrary(this.classPathTypes, library);
        }
    }

    private FileObject getApplicationContextXml() {
        FileObject fileObject;
        FileObject fileObject2;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        FileObject[] fileObjectArray = j2eeModuleProvider.getSourceRoots();
        if (fileObjectArray.length > 0 && (fileObject2 = (fileObject = fileObjectArray[0]).getFileObject("WEB-INF")) != null) {
            return fileObject2.getFileObject("applicationContext", "xml");
        }
        return null;
    }

    public Datasource getDatasource(String string) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return j2eeModuleProvider.getConfigSupport().findDatasource(string);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public boolean isRestSupportOn() {
        return true;
    }

    public FileObject generateTestClient(File file) throws IOException {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("src/main/resources");
        if (fileObject != null) {
            FileObject fileObject2 = fileObject.getFileObject("rest");
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder("rest");
            }
            return this.generateMavenTester(FileUtil.toFile((FileObject)fileObject2), this.getBaseURL());
        }
        return null;
    }

    private FileObject generateMavenTester(File file, String string) throws IOException {
        String[] stringArray = new String[]{"TTL_TEST_RESBEANS", "MSG_TEST_RESBEANS_INFO"};
        String[] stringArray2 = new String[]{"MSG_TEST_RESBEANS_wadlErr", "MSG_TEST_RESBEANS_No_AJAX", "MSG_TEST_RESBEANS_Resource", "MSG_TEST_RESBEANS_See", "MSG_TEST_RESBEANS_No_Container", "MSG_TEST_RESBEANS_Content", "MSG_TEST_RESBEANS_TabularView", "MSG_TEST_RESBEANS_RawView", "MSG_TEST_RESBEANS_ResponseHeaders", "MSG_TEST_RESBEANS_Help", "MSG_TEST_RESBEANS_TestButton", "MSG_TEST_RESBEANS_Loading", "MSG_TEST_RESBEANS_Status", "MSG_TEST_RESBEANS_Headers", "MSG_TEST_RESBEANS_HeaderName", "MSG_TEST_RESBEANS_HeaderValue", "MSG_TEST_RESBEANS_Insert", "MSG_TEST_RESBEANS_NoContents", "MSG_TEST_RESBEANS_AddParamButton", "MSG_TEST_RESBEANS_Monitor", "MSG_TEST_RESBEANS_No_SubResources", "MSG_TEST_RESBEANS_SubResources", "MSG_TEST_RESBEANS_ChooseMethod", "MSG_TEST_RESBEANS_ChooseMime", "MSG_TEST_RESBEANS_Continue", "MSG_TEST_RESBEANS_AdditionalParams", "MSG_TEST_RESBEANS_INFO", "MSG_TEST_RESBEANS_Request", "MSG_TEST_RESBEANS_Sent", "MSG_TEST_RESBEANS_Received", "MSG_TEST_RESBEANS_TimeStamp", "MSG_TEST_RESBEANS_Response", "MSG_TEST_RESBEANS_CurrentSelection", "MSG_TEST_RESBEANS_DebugWindow", "MSG_TEST_RESBEANS_Wadl", "MSG_TEST_RESBEANS_RequestFailed"};
        FileObject fileObject = this.copyFileAndReplaceBaseUrl(file, TEST_SERVICES_HTML, stringArray, string);
        MavenProjectRestSupport.copyFile((File)file, (String)"test-resbeans.js", (String[])stringArray2, (boolean)false);
        MavenProjectRestSupport.copyFile((File)file, (String)"test-resbeans.css");
        MavenProjectRestSupport.copyFile((File)file, (String)"css_master-all.css");
        MavenProjectRestSupport.copyFile((File)file, (String)"expand.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"collapse.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"item.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"cc.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"og.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"cg.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"app.gif");
        File file2 = new File(file, "images");
        file2.mkdir();
        MavenProjectRestSupport.copyFile((File)file, (String)"images/background_border_bottom.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pbsel.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/bg_gradient.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pname.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/level1_selected-1lvl.jpg");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/primary-enabled.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/masthead.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/primary-roll.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pbdis.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/secondary-enabled.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pbena.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/tbsel.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pbmou.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/tbuns.png");
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyFileAndReplaceBaseUrl(File file, String string, String[] stringArray, String string2) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createData(string);
        }
        FileLock fileLock = null;
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            int n;
            fileLock = fileObject2.lock();
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            InputStream inputStream = RestSupport.class.getResourceAsStream("resources/" + string);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string4 = "\n";
            if (File.separatorChar == '\\') {
                string4 = "\r\n";
            }
            String[] stringArray2 = null;
            if (stringArray != null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = NbBundle.getMessage(RestSupport.class, (String)stringArray[n]);
                }
            }
            while ((string3 = bufferedReader.readLine()) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    string3 = string3.replaceAll(stringArray[n], stringArray2[n]);
                }
                string3 = string3.replace("${BASE_URL}", string2);
                bufferedWriter.write(string3);
                bufferedWriter.write(string4);
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return fileObject2;
    }

    private String getBaseURL() throws IOException {
        String string = "localhost";
        String string2 = "8080";
        String string3 = "";
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            String string4 = "";
            String string5 = "";
            int n = 0;
            for (ServletMapping servletMapping : webApp.getServletMapping()) {
                string4 = string4 + (n > 0 ? "," : "") + servletMapping.getServletName();
                string5 = string5 + (n > 0 ? "," : "") + servletMapping.getUrlPattern();
                ++n;
            }
            return this.getContextRootURL() + "||" + string4 + "||" + string5;
        }
        throw new IOException("Cannot read web.xml");
    }

    private String getContextRootURL() {
        ServerInstance serverInstance;
        String string = "8080";
        String string2 = "localhost";
        String string3 = "";
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        Deployment.getDefault().getServerInstance(j2eeModuleProvider.getServerInstanceID());
        String string4 = j2eeModuleProvider.getServerInstanceID();
        if (string4 == null || "DEV-NULL".equals(string4)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MavenProjectRestSupport.class, (String)"MSG_MissingServer"), 0));
        } else {
            serverInstance = Deployment.getDefault().getServerInstance(string4);
            try {
                ServerInstance.Descriptor descriptor = serverInstance.getDescriptor();
                if (descriptor != null) {
                    String string5;
                    int n = descriptor.getHttpPort();
                    if (n > 0) {
                        string = String.valueOf(n);
                    }
                    if ((string5 = descriptor.getHostname()) != null) {
                        string2 = string5;
                    }
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                // empty catch block
            }
        }
        serverInstance = j2eeModuleProvider.getConfigSupport();
        try {
            string3 = serverInstance.getWebContextRoot();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (string3.length() > 0 && string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        return "http://" + string2 + ":" + string + "/" + (string3.length() > 0 ? string3 + "/" : "");
    }
}

