/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.jaxb.actions.JAXBRegenerateCodeAction;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEvent;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListener;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListenerAdapter;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schemas;
import org.netbeans.modules.xml.jaxb.ui.JAXBWizardSchemaNode;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JAXBWizardRootNode
extends AbstractNode {
    private Project project;
    private static Action[] actions = null;

    public JAXBWizardRootNode(Project project) {
        this(project, new InstanceContent());
        this.project = project;
        Children children = this.getChildren();
        this.initActions();
    }

    private JAXBWizardRootNode(Project project, InstanceContent instanceContent) {
        super((Children)new JAXBWizardRootNodeChildren(project), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        instanceContent.add((Object)this);
        instanceContent.add((Object)project);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JAXBWizardRootNode.class, (String)"LBL_JAXB_Bindings");
    }

    public String getName() {
        return "JAXB Bindings";
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == Project.class && this.project instanceof Node.Cookie) {
            return (Node.Cookie)this.project;
        }
        return super.getCookie(clazz);
    }

    private void initActions() {
        if (actions == null) {
            actions = new Action[]{new JAXBRegenerateCodeAction()};
        }
    }

    public Action[] getActions(boolean bl) {
        return actions;
    }

    public Image getIcon(int n) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/jaxb/resources/packageRoot.gif");
    }

    public Image getOpenedIcon(int n) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/jaxb/resources/packageRootOpen.gif");
    }

    public static class JAXBWizardRootNodeChildren
    extends Children.Keys {
        private Project project;
        private Schemas schemas;
        private Map<String, Schema> nameSchemaMap = new HashMap<String, Schema>();
        private JAXBWizEventListener modelListener = new ModelListener();

        public JAXBWizardRootNodeChildren(Project project) {
            this.project = project;
            this.addNodify();
        }

        public void addNodify() {
            Schema[] schemaArray;
            this.schemas = ProjectHelper.getXMLBindingSchemas(this.project);
            this.nameSchemaMap.clear();
            for (Schema schema : schemaArray = this.schemas.getSchema()) {
                this.nameSchemaMap.put(schema.getName(), schema);
            }
            this.updateKeys();
            super.addNotify();
            ProjectHelper.addModelListener(this.project, this.modelListener);
        }

        public void removeNotify() {
            ProjectHelper.removeModelListener(this.project, this.modelListener);
        }

        public void updateKeys() {
            if (this.schemas == null) {
                return;
            }
            this.setKeys(this.nameSchemaMap.keySet());
        }

        private void updateBindingKeys(Schemas schemas) {
            Schema[] schemaArray;
            this.schemas = schemas;
            this.nameSchemaMap.clear();
            for (Schema schema : schemaArray = this.schemas.getSchema()) {
                this.nameSchemaMap.put(schema.getName(), schema);
            }
            this.updateKeys();
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray = null;
            if (object instanceof String) {
                Schema schema = this.nameSchemaMap.get((String)object);
                JAXBWizardSchemaNode jAXBWizardSchemaNode = new JAXBWizardSchemaNode(this.project, schema);
                nodeArray = new Node[]{jAXBWizardSchemaNode};
            }
            return nodeArray;
        }

        private final class ModelListener
        extends JAXBWizEventListenerAdapter {
            private ModelListener() {
            }

            public void bindingAdded(JAXBWizEvent jAXBWizEvent) {
                if (jAXBWizEvent.getSource() instanceof Schemas) {
                    JAXBWizardRootNodeChildren.this.updateBindingKeys((Schemas)jAXBWizEvent.getSource());
                }
            }

            public void bindingChanged(JAXBWizEvent jAXBWizEvent) {
                if (jAXBWizEvent.getSource() instanceof Schemas) {
                    Schema schema = (Schema)jAXBWizEvent.getNewValue();
                    Schema schema2 = (Schema)jAXBWizEvent.getOldValue();
                    String string = schema.getName();
                    String string2 = schema2.getName();
                    if (string != null && !string.equals(string2)) {
                        JAXBWizardRootNodeChildren.this.updateBindingKeys((Schemas)jAXBWizEvent.getSource());
                    }
                }
            }

            public void bindingDeleted(JAXBWizEvent jAXBWizEvent) {
                if (jAXBWizEvent.getSource() instanceof Schemas) {
                    JAXBWizardRootNodeChildren.this.updateBindingKeys((Schemas)jAXBWizEvent.getSource());
                }
            }

            public void configFileEdited(JAXBWizEvent jAXBWizEvent) {
                if (jAXBWizEvent.getSource() instanceof Schemas) {
                    JAXBWizardRootNodeChildren.this.updateBindingKeys((Schemas)jAXBWizEvent.getSource());
                }
            }
        }
    }
}

