/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.xml.jaxb.api.model.JAXBWizModel;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListener;
import org.netbeans.modules.xml.jaxb.cfg.schema.Binding;
import org.netbeans.modules.xml.jaxb.cfg.schema.Bindings;
import org.netbeans.modules.xml.jaxb.cfg.schema.Catalog;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.cfg.schema.SchemaSource;
import org.netbeans.modules.xml.jaxb.cfg.schema.SchemaSources;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schemas;
import org.netbeans.modules.xml.jaxb.cfg.schema.XjcOption;
import org.netbeans.modules.xml.jaxb.cfg.schema.XjcOptions;
import org.netbeans.modules.xml.jaxb.model.JAXBWizModelImpl;
import org.netbeans.modules.xml.jaxb.util.FileSysUtil;
import org.netbeans.modules.xml.jaxb.util.JAXBWizModuleConstants;
import org.netbeans.modules.xml.retriever.Retriever;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectHelper {
    public static final int PROJECT_TYPE_J2SE = 0;
    public static final int PROJECT_TYPE_EJB = 1;
    public static final int PROJECT_TYPE_WEB = 2;
    private static final String JAXB_ANT_XTN_NAME = "jaxb";
    private static final String JAXB_LIB_NAME = "jaxb";
    private static final String PROP_BUILD_DIR = "build.dir";
    private static final String PROP_SRC_DIR = "src.dir";
    private static final String PROP_SRC_ROOT = "source.root";
    private static final String NBPROJECT_DIR = "nbproject";
    private static final String XML_BINDING_CONFIG_FILE_NAME = "xml_binding_cfg.xml";
    private static final String XML_BINDING_BUILD_FILE_NAME = "xml_binding_build.xml";
    private static final String FILE_OBJECT_SEPARATOR = "/";
    private static final String XSL_RESOURCE = "org/netbeans/modules/xml/jaxb/resources/JAXBBuild.xsl";
    private static final String EJB_XSL_RESOURCE = "org/netbeans/modules/xml/jaxb/resources/JAXBBuild_ejb.xsl";
    private static final String WEB_XSL_RESOURCE = "org/netbeans/modules/xml/jaxb/resources/JAXBBuild_web.xsl";
    private static final String BUILD_GEN_JAXB_DIR = "build/generated-sources/jaxb";
    private static final String NON_JAVA_SE_CONFIG_DIR = "conf/xml-resources/jaxb";
    private static final String JAVA_SE_CONFIG_DIR = "xml-resources/jaxb";
    private static final String RUN_JVM_ARGS_KEY = "run.jvmargs";
    private static final String PROP_ENDORSED = "jaxbwiz.endorsed.dirs";
    private static final String PROP_XJC_DEF_CLASSPATH = "jaxbwiz.xjcdef.classpath";
    private static final String PROP_XJC_RUN_CLASSPATH = "jaxbwiz.xjcrun.classpath";
    private static final String PROP_JAXB_GEN_SRC_CLASSPATH = "jaxbwiz.gensrc.classpath";
    private static final String PROP_VAL_JAXB_LIB_CLASSPATH = "${libs.jaxb.classpath}";
    private static final String RUN_JVM_ARGS_VAL_PREFIX = "-Djava.endorsed.dirs";
    private static final String RUN_JVM_ARGS_VAL = "-Djava.endorsed.dirs=${jaxbwiz.endorsed.dirs}";
    private static final String PROP_SYS_RUN_ENDORSED = "run-sys-prop.java.endorsed.dirs";
    private static final String PROP_SYS_RUN_ENDORSED_VAL = "${jaxbwiz.endorsed.dirs}";
    private static final String JAXB_CONTEXT_CLASS_RES_PATH = "javax/xml/bind/JAXBContext.class";

    private ProjectHelper() {
    }

    public static void refreshBuildScript(Project project) {
        try {
            StreamSource streamSource = new StreamSource(ProjectHelper.getXMLBindingConfigFile(project));
            StreamSource streamSource2 = null;
            int n = ProjectHelper.getProjectType(project);
            streamSource2 = n == 1 ? new StreamSource(ProjectHelper.class.getClassLoader().getResourceAsStream(EJB_XSL_RESOURCE)) : (n == 2 ? new StreamSource(ProjectHelper.class.getClassLoader().getResourceAsStream(WEB_XSL_RESOURCE)) : new StreamSource(ProjectHelper.class.getClassLoader().getResourceAsStream(XSL_RESOURCE)));
            StreamResult streamResult = new StreamResult(ProjectHelper.getXMLBindingBuildFile(project));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Transformer transformer = transformerFactory.newTransformer(streamSource2);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(streamSource, streamResult);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private static String getProperty(Project project, String string, String string2) {
        AntProjectHelper antProjectHelper = ProjectHelper.getAntProjectHelper(project);
        EditableProperties editableProperties = antProjectHelper.getProperties(string);
        String string3 = null;
        String string4 = editableProperties.getProperty(string2);
        if (string4 != null) {
            PropertyEvaluator propertyEvaluator = antProjectHelper.getStandardPropertyEvaluator();
            string3 = propertyEvaluator.evaluate(string4);
        }
        return string3;
    }

    private static void saveProperty(Project project, String string, String string2, String string3) {
        AntProjectHelper antProjectHelper = ProjectHelper.getAntProjectHelper(project);
        EditableProperties editableProperties = antProjectHelper.getProperties(string);
        if (string3 != null) {
            editableProperties.put(string2, string3);
            antProjectHelper.putProperties(string, editableProperties);
        }
    }

    private static String getProjectProperty(Project project, String string) {
        return ProjectHelper.getProperty(project, "nbproject/project.properties", string);
    }

    private static String getPrivateProperty(Project project, String string) {
        return ProjectHelper.getProperty(project, "nbproject/project.properties", string);
    }

    private static void savePrivateProperty(Project project, String string, String string2) {
        ProjectHelper.saveProperty(project, "nbproject/private/private.properties", string, string2);
    }

    private static void saveProjectProperty(Project project, String string, String string2) {
        ProjectHelper.saveProperty(project, "nbproject/project.properties", string, string2);
    }

    public static String getProjectSourceDir(Project project) {
        return ProjectHelper.getProperty(project, "nbproject/project.properties", PROP_SRC_DIR);
    }

    public static File getSourceDirectoryFile(Project project) {
        return new File(ProjectHelper.getProjectSourceDir(project));
    }

    public static String getProjectBuildDir(Project project) {
        return ProjectHelper.getProperty(project, "nbproject/project.properties", PROP_BUILD_DIR);
    }

    public static String getProjectSourceRoot(Project project) {
        return ProjectHelper.getProperty(project, "nbproject/project.properties", PROP_SRC_ROOT);
    }

    public static File getProjectDirectory(Project project) {
        return FileUtil.toFile((FileObject)project.getProjectDirectory());
    }

    public static String getProjectRelativePath(Project project, String string) {
        String string2 = null;
        if (string != null) {
            String string3 = ProjectHelper.getProjectDirectory(project).getAbsolutePath();
            string2 = string.toLowerCase().indexOf(string3.toLowerCase()) != -1 ? string.substring(string3.length() + 1) : string;
        }
        return string2;
    }

    private static void addJAXBLibrary(Project project) {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
        ClassPath classPath3 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath2, classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/boot")});
        FileObject fileObject = classPath3.findResource(JAXB_CONTEXT_CLASS_RES_PATH);
        if (fileObject == null) {
            SourceGroup[] sourceGroupArray2;
            Library library = LibraryManager.getDefault().getLibrary("jaxb");
            Sources sources = ProjectUtils.getSources((Project)project);
            if (sources != null && (sourceGroupArray2 = sources.getSourceGroups("java")) != null && sourceGroupArray2.length > 0) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)sourceGroupArray2[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    public static int getProjectType(Project project) {
        String string = project.getClass().getName();
        int n = 0;
        if (string.indexOf("EjbJarProject") != -1) {
            n = 1;
        } else if (string.indexOf("WebProject") != -1) {
            n = 2;
        }
        return n;
    }

    public static Schemas getXMLBindingSchemas(Project project) {
        Schemas schemas = null;
        if (project != null) {
            FileObject fileObject = project.getProjectDirectory();
            String string = fileObject.getName();
            File file = FileUtil.toFile((FileObject)fileObject);
            File file2 = null;
            try {
                file2 = new File(file, NBPROJECT_DIR + File.separator + XML_BINDING_CONFIG_FILE_NAME);
                if (file2.exists()) {
                    schemas = Schemas.read(file2);
                } else {
                    ProjectInformation projectInformation;
                    schemas = new Schemas();
                    Lookup lookup = project.getLookup();
                    if (lookup != null && (projectInformation = (ProjectInformation)lookup.lookup(ProjectInformation.class)) != null) {
                        string = projectInformation.getName();
                    }
                    schemas.setProjectName(string);
                    schemas.setDestdir(BUILD_GEN_JAXB_DIR);
                    schemas.setVersion(JAXBWizModuleConstants.LATEST_CFG_VERSION);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return schemas;
    }

    private static File getXMLBindingBuildFile(Project project) {
        File file = null;
        if (project != null) {
            FileObject fileObject = project.getProjectDirectory();
            File file2 = FileUtil.toFile((FileObject)fileObject);
            try {
                file = new File(file2, NBPROJECT_DIR + File.separator + XML_BINDING_BUILD_FILE_NAME);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return file;
    }

    private static File getXMLBindingConfigFile(Project project) {
        File file = null;
        if (project != null) {
            FileObject fileObject = project.getProjectDirectory();
            File file2 = FileUtil.toFile((FileObject)fileObject);
            try {
                file = new File(file2, NBPROJECT_DIR + File.separator + XML_BINDING_CONFIG_FILE_NAME);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return file;
    }

    private static void saveXMLBindingSchemas(Project project, Schemas schemas) {
        try {
            File file = ProjectHelper.getXMLBindingConfigFile(project);
            if (file != null) {
                schemas.write(file);
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private static XjcOptions populateXjcOptions(WizardDescriptor wizardDescriptor) {
        XjcOptions xjcOptions = new XjcOptions();
        Map map = (Map)wizardDescriptor.getProperty("jaxb.xjc.options");
        if (map != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            String string = null;
            XjcOption xjcOption = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                Boolean bl = (Boolean)map.get(string);
                xjcOption = new XjcOption();
                xjcOption.setName(string);
                xjcOption.setValue(bl.toString());
                xjcOptions.addXjcOption(xjcOption);
            }
        }
        return xjcOptions;
    }

    public static FileObject retrieveResource(FileObject fileObject, URI uRI) {
        Retriever retriever = Retriever.getDefault();
        FileObject fileObject2 = null;
        try {
            fileObject2 = retriever.retrieveResource(fileObject, uRI);
        }
        catch (UnknownHostException unknownHostException) {
            Exceptions.printStackTrace((Throwable)unknownHostException);
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (fileObject2 == null) {
            // empty if block
        }
        return fileObject2;
    }

    private static String replace(String string, String string2, String string3) {
        return string.replaceFirst(string2, string3);
    }

    private static Map<String, String> getOrigNewLocationMap(Schema schema, String string, String string2) {
        Catalog catalog;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = string2 + FILE_OBJECT_SEPARATOR + schema.getName();
        String string4 = string2 + FILE_OBJECT_SEPARATOR + string;
        SchemaSources schemaSources = schema.getSchemaSources();
        SchemaSource[] schemaSourceArray = schemaSources.getSchemaSource();
        for (SchemaSource schemaSource : schemaSourceArray) {
            hashMap.put(schemaSource.getOrigLocation(), ProjectHelper.replace(schemaSource.getLocation(), string3, string4));
        }
        Bindings bindings = schema.getBindings();
        if (bindings != null) {
            Binding[] bindingArray;
            for (Binding binding : bindingArray = bindings.getBinding()) {
                hashMap.put(binding.getOrigLocation(), ProjectHelper.replace(binding.getLocation(), string3, string4));
            }
        }
        if ((catalog = schema.getCatalog()) != null && catalog.getOrigLocation() != null) {
            hashMap.put(catalog.getOrigLocation(), ProjectHelper.replace(catalog.getLocation(), string3, string4));
        }
        return hashMap;
    }

    private static void deleteStaleResources(FileObject fileObject, Map<String, String> map, List<String> list) {
        Set<String> set = map.keySet();
        FileObject fileObject2 = null;
        String string = null;
        for (String string2 : set) {
            string = map.get(string2);
            if (list.contains(string) || (fileObject2 = fileObject.getFileObject(string)) == null) continue;
            try {
                fileObject2.delete();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema importResources(Project project, WizardDescriptor wizardDescriptor, Schema schema) throws IOException {
        int n;
        Object object;
        FileObject fileObject;
        File file;
        Map<Object, Object> map = null;
        HashMap<String, String> hashMap = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        FileObject fileObject2 = project.getProjectDirectory();
        FileObject fileObject3 = ProjectHelper.getFOProjectSchemaDir(project);
        File file2 = FileUtil.toFile((FileObject)fileObject3);
        File file3 = FileUtil.toFile((FileObject)fileObject2);
        Schema schema2 = new Schema();
        SchemaSources schemaSources = new SchemaSources();
        SchemaSource schemaSource = null;
        Bindings bindings = new Bindings();
        Binding binding = null;
        Catalog catalog = new Catalog();
        schema2.setName((String)wizardDescriptor.getProperty("schema.name"));
        schema2.setPackage((String)wizardDescriptor.getProperty("xsd.package.name"));
        schema2.setCatalog(catalog);
        schema2.setBindings(bindings);
        schema2.setSchemaSources(schemaSources);
        schema2.setType((String)wizardDescriptor.getProperty("jaxb.schema.type"));
        schema2.setXjcOptions(ProjectHelper.populateXjcOptions(wizardDescriptor));
        if (schema != null) {
            map = ProjectHelper.getOrigNewLocationMap(schema, schema2.getName(), FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject3));
            hashMap = new HashMap();
            hashMap.putAll(map);
            string = schema.getName();
            if (!string.equals(schema2.getName())) {
                file = new File(file2, string);
                if (!file.exists()) {
                    FileUtil.createFolder((File)file);
                }
                fileObject = FileUtil.toFileObject((File)file);
                object = null;
                try {
                    object = fileObject.lock();
                    fileObject.rename((FileLock)object, schema2.getName(), null);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                finally {
                    if (object != null) {
                        object.releaseLock();
                    }
                }
            }
        } else {
            map = new HashMap();
            hashMap = new HashMap<String, String>();
        }
        if (!(file = new File(file2, schema2.getName())).exists()) {
            FileUtil.createFolder((File)file);
        }
        fileObject = FileUtil.toFileObject((File)file);
        object = null;
        File file4 = null;
        FileObject fileObject4 = null;
        String string2 = null;
        URL uRL = null;
        List list = (List)wizardDescriptor.getProperty("xsd.file.list");
        List list2 = (List)wizardDescriptor.getProperty("jaxb.binding.files");
        String string3 = (String)wizardDescriptor.getProperty("jaxb.catalog.file");
        boolean bl = "url".equals((String)wizardDescriptor.getProperty("xsd.locatiom.type"));
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                if (bl) {
                    string2 = (String)list.get(n);
                    schemaSource = new SchemaSource();
                    schemaSource.setOrigLocation(string2);
                    schemaSource.setOrigLocationType("url");
                    schemaSources.addSchemaSource(schemaSource);
                    hashMap.remove(string2);
                    if (map.get(string2) == null) {
                        uRL = new URL(string2);
                        try {
                            fileObject4 = ProjectHelper.retrieveResource(fileObject, uRL.toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new IOException(uRISyntaxException.getMessage());
                        }
                        schemaSource.setLocation(FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject4));
                        arrayList.add(FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject4));
                        continue;
                    }
                    schemaSource.setLocation((String)map.get(string2));
                    arrayList.add((String)map.get(string2));
                    continue;
                }
                schemaSource = new SchemaSource();
                schemaSource.setOrigLocation((String)list.get(n));
                schemaSources.addSchemaSource(schemaSource);
                hashMap.remove(list.get(n));
                if (map.get(list.get(n)) == null) {
                    object = FileSysUtil.Relative2AbsolutePath(file3, (String)list.get(n));
                    file4 = new File(file, ((File)object).getName());
                    if (file4.exists()) {
                        file4.delete();
                    }
                    fileObject4 = ProjectHelper.retrieveResource(fileObject, ((File)object).toURI());
                    schemaSource.setLocation(FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject4));
                    arrayList.add(FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject4));
                    continue;
                }
                schemaSource.setLocation((String)map.get(list.get(n)));
                arrayList.add((String)map.get(list.get(n)));
            }
        }
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                binding = new Binding();
                binding.setOrigLocation((String)list2.get(n));
                bindings.addBinding(binding);
                hashMap.remove(list2.get(n));
                if (map.get(list2.get(n)) == null) {
                    object = FileSysUtil.Relative2AbsolutePath(file3, (String)list2.get(n));
                    file4 = new File(file, ((File)object).getName());
                    if (file4.exists()) {
                        file4.delete();
                    }
                    fileObject4 = ProjectHelper.retrieveResource(fileObject, ((File)object).toURI());
                    binding.setLocation(FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject4));
                    arrayList.add(FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject4));
                    continue;
                }
                binding.setLocation((String)map.get(list2.get(n)));
                arrayList.add((String)map.get(list2.get(n)));
            }
        }
        if (string3 != null) {
            catalog.setOrigLocation(string3);
            hashMap.remove(string3);
            if (map.get(string3) == null) {
                object = FileSysUtil.Relative2AbsolutePath(file3, string3);
                file4 = new File(file, ((File)object).getName());
                if (file4.exists()) {
                    file4.delete();
                }
                fileObject4 = ProjectHelper.retrieveResource(fileObject, ((File)object).toURI());
                catalog.setLocation(FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject4));
                arrayList.add(FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject4));
            } else {
                catalog.setLocation((String)map.get(string3));
                arrayList.add((String)map.get(string3));
            }
        }
        ProjectHelper.deleteStaleResources(fileObject2, hashMap, arrayList);
        return schema2;
    }

    public static AntProjectHelper getAntProjectHelper(Project project) {
        try {
            Method method = project.getClass().getMethod("getAntProjectHelper", new Class[0]);
            if (method != null) {
                AntProjectHelper antProjectHelper = (AntProjectHelper)method.invoke((Object)project, new Object[0]);
                return antProjectHelper;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public static FileObject getFOForProjectBuildFile(Project project) {
        FileObject fileObject = null;
        if (project != null) {
            FileObject fileObject2 = project.getProjectDirectory();
            fileObject = fileObject2.getFileObject("build.xml");
        }
        return fileObject;
    }

    public static FileObject getFOForNBProjectDir(Project project) {
        return project.getProjectDirectory().getFileObject(NBPROJECT_DIR);
    }

    public static FileObject getFOForBindingConfigFile(Project project) {
        FileObject fileObject = null;
        if (project != null) {
            FileObject fileObject2 = project.getProjectDirectory();
            try {
                fileObject2.getFileObject("nbproject/").refresh();
                fileObject = fileObject2.getFileObject("nbproject/xml_binding_cfg.xml");
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return fileObject;
    }

    public static FileObject getFOForBindingBuildFile(Project project) {
        FileObject fileObject = null;
        if (project != null) {
            FileObject fileObject2 = project.getProjectDirectory();
            try {
                fileObject2.getFileObject("nbproject/").refresh();
                fileObject = fileObject2.getFileObject("nbproject/xml_binding_build.xml");
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return fileObject;
    }

    private static void createDirs(FileObject fileObject, String string) {
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = new File(file, string);
        if (!file2.exists()) {
            try {
                FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static FileObject getFOProjectSchemaDir(Project project) {
        String string = null;
        FileObject fileObject = null;
        FileObject fileObject2 = project.getProjectDirectory();
        if (ProjectHelper.getProjectType(project) == 1 || ProjectHelper.getProjectType(project) == 2) {
            string = ProjectHelper.getProjectSourceRoot(project);
            FileObject fileObject3 = fileObject2.getFileObject(string);
            ProjectHelper.createDirs(fileObject3, NON_JAVA_SE_CONFIG_DIR);
            fileObject = fileObject3.getFileObject(NON_JAVA_SE_CONFIG_DIR);
        } else {
            FileObject fileObject4 = fileObject2;
            ProjectHelper.createDirs(fileObject4, JAVA_SE_CONFIG_DIR);
            fileObject = fileObject4.getFileObject(JAVA_SE_CONFIG_DIR);
        }
        return fileObject;
    }

    private static String getEndorsedDirs(Project project) {
        String string = "\"${netbeans.home}/../ide9/modules/ext/jaxb/api\"";
        return string;
    }

    private static void addEndorsedDir(Project project) {
        String string = ProjectHelper.getProjectProperty(project, PROP_ENDORSED);
        if (string == null || "".equals(string.trim())) {
            string = ProjectHelper.getEndorsedDirs(project);
            String string2 = ProjectHelper.getProjectProperty(project, RUN_JVM_ARGS_KEY);
            if (string2 == null || string2.length() == 0) {
                ProjectHelper.saveProjectProperty(project, PROP_ENDORSED, string);
                ProjectHelper.saveProjectProperty(project, RUN_JVM_ARGS_KEY, RUN_JVM_ARGS_VAL);
            } else {
                ProjectHelper.saveProjectProperty(project, PROP_ENDORSED, string);
                ProjectHelper.saveProjectProperty(project, PROP_SYS_RUN_ENDORSED, PROP_SYS_RUN_ENDORSED_VAL);
            }
            try {
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static void addClasspathProperties(Project project) {
        String string;
        String string2;
        String string3 = ProjectHelper.getProjectProperty(project, PROP_XJC_DEF_CLASSPATH);
        boolean bl = false;
        if (string3 == null || "".equals(string3)) {
            ProjectHelper.saveProjectProperty(project, PROP_XJC_DEF_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
            bl = true;
        }
        if ((string2 = ProjectHelper.getProjectProperty(project, PROP_XJC_RUN_CLASSPATH)) == null || "".equals(string2)) {
            ProjectHelper.saveProjectProperty(project, PROP_XJC_RUN_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
            bl = true;
        }
        if ((string = ProjectHelper.getProjectProperty(project, PROP_JAXB_GEN_SRC_CLASSPATH)) == null || "".equals(string)) {
            ProjectHelper.saveProjectProperty(project, PROP_JAXB_GEN_SRC_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
            bl = true;
        }
        if (bl) {
            try {
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static Schema addSchema(Project project, Schemas schemas, Schema schema) {
        try {
            schemas.addSchema(schema);
            ProjectHelper.saveXMLBindingSchemas(project, schemas);
            ProjectHelper.refreshBuildScript(project);
            ProjectHelper.addClasspathProperties(project);
            ProjectHelper.addEndorsedDir(project);
            AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
            if (antBuildExtender != null && antBuildExtender.getExtension("jaxb") == null) {
                FileObject fileObject;
                FileObject fileObject2 = ProjectHelper.getFOForBindingBuildFile(project);
                AntBuildExtender.Extension extension = antBuildExtender.addExtension("jaxb", fileObject2);
                extension.addDependency("-pre-pre-compile", "jaxb-code-generation");
                ProjectManager.getDefault().saveProject(project);
                String string = ProjectHelper.getProjectBuildDir(project);
                if (project.getProjectDirectory() != null && (fileObject = project.getProjectDirectory().getFileObject(string)) != null) {
                    fileObject.refresh();
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return schema;
    }

    public static List<String> getSchemaNames(Project project) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Schemas schemas = ProjectHelper.getXMLBindingSchemas(project);
        if (schemas != null) {
            Schema[] schemaArray;
            for (Schema schema : schemaArray = schemas.getSchema()) {
                arrayList.add(schema.getName());
            }
        }
        return arrayList;
    }

    public static void removeSchema(Project project, Schemas schemas, Schema schema) {
        try {
            schemas.removeSchema(schema);
            ProjectHelper.saveXMLBindingSchemas(project, schemas);
            ProjectHelper.refreshBuildScript(project);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public static void compileXSDs(Project project) {
        ProjectHelper.compileXSDs(project, false);
    }

    public static void compileXSDs(Project project, boolean bl) {
        ProjectHelper.executeAntTarget(project, bl, "jaxb-code-generation");
    }

    public static void cleanCompileXSDs(Project project, boolean bl) {
        ProjectHelper.executeAntTarget(project, bl, "jaxb-clean-code-generation");
    }

    private static void executeAntTarget(final Project project, final boolean bl, final String string) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ProjectHelper.class, (String)"MSG_JAXB_PROGRESS"));
        progressHandle.start();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (bl) {
                        ProjectHelper.addJAXBLibrary(project);
                    }
                    FileObject fileObject = ProjectHelper.getFOForProjectBuildFile(project);
                    String[] stringArray = new String[]{string};
                    if (fileObject != null) {
                        ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, null);
                        executorTask.waitFinished();
                        if (executorTask.result() != 0) {
                            String string2 = NbBundle.getMessage(ProjectHelper.class, (String)"MSG_ERROR_COMPILING");
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                finally {
                    progressHandle.finish();
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    public static void addCfgFileChangeListener(Project project, FileChangeListener fileChangeListener) {
        FileObject fileObject = ProjectHelper.getFOForBindingConfigFile(project);
        FileChangeListener fileChangeListener2 = null;
        if (fileObject != null) {
            fileChangeListener2 = FileUtil.weakFileChangeListener((FileChangeListener)fileChangeListener, (Object)fileObject);
            fileObject.addFileChangeListener(fileChangeListener2);
        } else {
            fileObject = ProjectHelper.getFOForNBProjectDir(project);
            if (fileObject != null) {
                fileChangeListener2 = FileUtil.weakFileChangeListener((FileChangeListener)fileChangeListener, (Object)fileObject);
                fileObject.addFileChangeListener(fileChangeListener2);
            }
        }
    }

    public static void removeModelListner(Project project, FileChangeListener fileChangeListener) {
        FileObject fileObject = ProjectHelper.getFOForBindingConfigFile(project);
        if (fileObject != null) {
            fileObject.removeFileChangeListener(fileChangeListener);
        }
        if ((fileObject = ProjectHelper.getFOForNBProjectDir(project)) != null) {
            fileObject.removeFileChangeListener(fileChangeListener);
        }
    }

    public static void addModelListener(Project project, JAXBWizEventListener jAXBWizEventListener) {
        JAXBWizModel jAXBWizModel;
        if (project != null && (jAXBWizModel = (JAXBWizModel)project.getLookup().lookup(JAXBWizModel.class)) != null) {
            JAXBWizEventListener jAXBWizEventListener2 = (JAXBWizEventListener)WeakListeners.create(JAXBWizEventListener.class, (EventListener)jAXBWizEventListener, (Object)jAXBWizModel);
            jAXBWizModel.addJAXBWizEventListener(jAXBWizEventListener2);
        }
    }

    public static void removeModelListener(Project project, JAXBWizEventListener jAXBWizEventListener) {
        JAXBWizModel jAXBWizModel;
        if (project != null && (jAXBWizModel = (JAXBWizModel)project.getLookup().lookup(JAXBWizModel.class)) != null) {
            jAXBWizModel.removeJAXBWizEventListener(jAXBWizEventListener);
        }
    }

    public static void addSchema2Model(Project project, Schema schema) {
        JAXBWizModelImpl jAXBWizModelImpl;
        if (project != null && (jAXBWizModelImpl = (JAXBWizModelImpl)project.getLookup().lookup(JAXBWizModel.class)) != null) {
            jAXBWizModelImpl.addSchema(schema);
        }
    }

    public static void changeSchemaInModel(Project project, Schema schema, Schema schema2) {
        JAXBWizModelImpl jAXBWizModelImpl;
        if (project != null && (jAXBWizModelImpl = (JAXBWizModelImpl)project.getLookup().lookup(JAXBWizModel.class)) != null) {
            jAXBWizModelImpl.changeSchema(schema, schema2);
        }
    }

    public static void deleteSchemaFromModel(Project project, Schema schema) {
        JAXBWizModelImpl jAXBWizModelImpl;
        if (project != null && (jAXBWizModelImpl = (JAXBWizModelImpl)project.getLookup().lookup(JAXBWizModel.class)) != null) {
            jAXBWizModelImpl.deleteSchema(schema);
        }
    }

    public static void cleanupLocalSchemaDir(Project project, Schema schema) {
        FileObject fileObject = ProjectHelper.getFOProjectSchemaDir(project);
        FileObject fileObject2 = fileObject.getFileObject(schema.getName());
        if (fileObject2 != null) {
            try {
                fileObject2.delete();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    public static void migrateProjectFromPreDot5Version(Project project) {
        ProjectHelper.addJAXBLibrary(project);
        String string = ProjectHelper.getEndorsedDirs(project);
        ProjectHelper.saveProjectProperty(project, PROP_ENDORSED, string);
        ProjectHelper.saveProjectProperty(project, PROP_XJC_DEF_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
        ProjectHelper.saveProjectProperty(project, PROP_XJC_RUN_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
        ProjectHelper.saveProjectProperty(project, PROP_JAXB_GEN_SRC_CLASSPATH, PROP_VAL_JAXB_LIB_CLASSPATH);
        try {
            ProjectManager.getDefault().saveProject(project);
            Schemas schemas = ProjectHelper.getXMLBindingSchemas(project);
            ProjectHelper.refreshBuildScript(project);
            schemas.setVersion(JAXBWizModuleConstants.LATEST_CFG_VERSION);
            ProjectHelper.saveXMLBindingSchemas(project, schemas);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

