/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.MultiDiffPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DiffExecutor {
    private final Context context;
    private final String contextName;

    public DiffExecutor(Context context, String string) {
        this.context = context;
        this.contextName = string;
    }

    public DiffExecutor(String string) {
        this.contextName = string;
        this.context = null;
    }

    public void showRemoteDiff(ExecutorGroup executorGroup) {
        this.showDiff(1, executorGroup);
    }

    public void showAllDiff(ExecutorGroup executorGroup) {
        this.showDiff(2, executorGroup);
    }

    public void showLocalDiff(ExecutorGroup executorGroup) {
        this.showDiff(0, executorGroup);
    }

    public void showDiff(File file, String string, String string2) {
        MultiDiffPanel multiDiffPanel = new MultiDiffPanel(file, string, string2);
        this.openDiff(multiDiffPanel, null);
    }

    private void showDiff(int n, ExecutorGroup executorGroup) {
        VersionsCache.getInstance().purgeVolatileRevisions();
        MultiDiffPanel multiDiffPanel = new MultiDiffPanel(this.context, n, this.contextName, executorGroup);
        this.openDiff(multiDiffPanel, executorGroup);
    }

    private void openDiff(final JComponent jComponent, final ExecutorGroup executorGroup) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffTopComponent diffTopComponent = new DiffTopComponent(jComponent);
                diffTopComponent.setName(NbBundle.getMessage(DiffExecutor.class, (String)"CTL_DiffPanel_Title", (Object)DiffExecutor.this.contextName));
                diffTopComponent.open();
                diffTopComponent.requestActive();
                diffTopComponent.setGroup(executorGroup);
            }
        });
    }

    public static File[] getModifiedFiles(Context context, int n) {
        File[] fileArray;
        CvsFileTableModel cvsFileTableModel = CvsVersioningSystem.getInstance().getFileTableModel(context, n);
        CvsFileNode[] cvsFileNodeArray = cvsFileTableModel.getNodes();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < cvsFileNodeArray.length; ++i) {
            fileArray = cvsFileNodeArray[i].getFile();
            if (CvsModuleConfig.getDefault().isExcludedFromCommit((File)fileArray)) continue;
            arrayList.add(fileArray);
        }
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.isFile() || (fileStatusCache.getStatus(file).getStatus() & n) == 0 || arrayList.contains(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiffTopComponent
    extends TopComponent
    implements DiffSetupSource {
        public DiffTopComponent() {
        }

        public DiffTopComponent(JComponent jComponent) {
            this.setLayout(new BorderLayout());
            jComponent.putClientProperty(TopComponent.class, this);
            this.add(jComponent, "Center");
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSN_Diff_Top_Component"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSD_Diff_Top_Component"));
        }

        public UndoRedo getUndoRedo() {
            MultiDiffPanel multiDiffPanel = (MultiDiffPanel)this.getComponent(0);
            return multiDiffPanel.getUndoRedo();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected void componentClosed() {
            ((MultiDiffPanel)this.getComponent(0)).componentClosed();
            super.componentClosed();
        }

        protected String preferredID() {
            return "DiffExecutorTopComponent";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }

        protected void componentActivated() {
            super.componentActivated();
            MultiDiffPanel multiDiffPanel = (MultiDiffPanel)this.getComponent(0);
            multiDiffPanel.requestActive();
        }

        @Override
        public Collection<Setup> getSetups() {
            DiffSetupSource diffSetupSource = (DiffSetupSource)((Object)this.getComponent(0));
            return diffSetupSource.getSetups();
        }

        @Override
        public String getSetupDisplayName() {
            DiffSetupSource diffSetupSource = (DiffSetupSource)((Object)this.getComponent(0));
            return diffSetupSource.getSetupDisplayName();
        }

        public void setGroup(ExecutorGroup executorGroup) {
            MultiDiffPanel multiDiffPanel = (MultiDiffPanel)this.getComponent(0);
            multiDiffPanel.setGroup(executorGroup);
        }
    }
}

