/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.ui.history.DiffResultsView;
import org.netbeans.modules.versioning.system.cvss.ui.history.Divider;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchHistoryPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ActionListener,
DiffSetupSource {
    private final File[] roots;
    private final SearchCriteriaPanel criteria;
    private final DelegatingUndoRedo undoRedo = new DelegatingUndoRedo();
    private Divider divider;
    private RequestProcessor.Task currentSearchTask;
    private boolean criteriaVisible;
    private boolean searchInProgress;
    private List results;
    private List<Object> dispResults;
    private SummaryView summaryView;
    private DiffResultsView diffView;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private Map<File, Project> fileProjects = new HashMap<File, Project>(100);
    private ExplorerManager explorerManager;
    private final Project NULL_PROJECT = new Project(){

        public FileObject getProjectDirectory() {
            return null;
        }

        public Lookup getLookup() {
            return null;
        }
    };
    private static final Comparator revisionsComparator = new ByRemotePathRevisionNumberComparator(){

        public int compare(Object object, Object object2) {
            return super.compare(((DispRevision)object).getRevision(), ((DispRevision)object2).getRevision());
        }
    };
    private JButton bNext;
    private JButton bPrev;
    private JButton bSearch;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JSeparator jSeparator2;
    private JToolBar jToolBar1;
    private JPanel resultsPanel;
    private JPanel searchCriteriaPanel;
    private JToggleButton tbDiff;
    private JToggleButton tbSummary;

    public SearchHistoryPanel(File[] fileArray, SearchCriteriaPanel searchCriteriaPanel) {
        this.roots = fileArray;
        this.criteria = searchCriteriaPanel;
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.setupComponents();
        this.refreshComponents(true);
    }

    private void setupComponents() {
        this.remove(this.jPanel1);
        this.divider = new Divider(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.divider, gridBagConstraints);
        this.searchCriteriaPanel.add(this.criteria);
        AbstractAction abstractAction = new AbstractAction(NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search")){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_Search"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.search();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "search");
        this.getActionMap().put("search", abstractAction);
        this.bSearch.setAction(abstractAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search"));
        Dimension dimension = this.tbSummary.getPreferredSize();
        Dimension dimension2 = this.tbDiff.getPreferredSize();
        if (dimension.width > dimension2.width) {
            this.tbDiff.setPreferredSize(dimension);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.diffView.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.diffView.onPrevButton();
            }
        };
        this.bNext.setAction(this.nextAction);
        this.bPrev.setAction(this.prevAction);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 1) {
            this.criteriaVisible = !this.criteriaVisible;
            this.refreshComponents(false);
        }
    }

    void setSearchCriteriaVisible(boolean bl) {
        this.criteriaVisible = bl;
        this.refreshComponents(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (topComponent == null) {
                return;
            }
            topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void removeNotify() {
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    final void refreshComponents(boolean bl) {
        if (bl) {
            this.resultsPanel.removeAll();
            if (this.results == null) {
                if (this.searchInProgress) {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_Searching")));
                } else {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_NoResults")));
                }
                this.undoRedo.setDiffView(null);
            } else if (this.tbSummary.isSelected()) {
                this.undoRedo.setDiffView(null);
                if (this.summaryView == null) {
                    this.summaryView = new SummaryView(this, this.dispResults);
                }
                this.resultsPanel.add(this.summaryView.getComponent());
            } else {
                if (this.diffView == null) {
                    this.diffView = new DiffResultsView(this, this.dispResults);
                }
                this.undoRedo.setDiffView(this.diffView.getCurrentDiffComponent());
                this.resultsPanel.add(this.diffView.getComponent());
            }
            this.resultsPanel.revalidate();
            this.resultsPanel.repaint();
        }
        this.nextAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isNextEnabled());
        this.prevAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isPrevEnabled());
        this.divider.setArrowDirection(this.criteriaVisible ? 1 : 0);
        this.searchCriteriaPanel.setVisible(this.criteriaVisible);
        this.bSearch.setVisible(this.criteriaVisible);
        this.revalidate();
        this.repaint();
    }

    public void setResults(List list) {
        this.setResults(list, false);
    }

    private void setResults(List list, boolean bl) {
        if (list != null) {
            this.dispResults = this.createDisplayList(list);
        }
        this.results = list;
        this.searchInProgress = bl;
        this.summaryView = null;
        this.diffView = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchHistoryPanel.this.refreshComponents(true);
            }
        });
    }

    List getDispResults() {
        return this.dispResults;
    }

    Project getProject(File file) {
        Project project = this.fileProjects.get(file);
        if (project == null) {
            project = Utils.getProject(file);
            if (project == null) {
                project = this.NULL_PROJECT;
            }
            this.fileProjects.put(file, project);
        }
        if (project == this.NULL_PROJECT) {
            project = null;
        }
        return project;
    }

    public File[] getRoots() {
        return this.roots;
    }

    public SearchCriteriaPanel getCriteria() {
        return this.criteria;
    }

    private synchronized void search() {
        if (this.currentSearchTask != null) {
            this.currentSearchTask.cancel();
        }
        this.setResults(null, true);
        SearchExecutor searchExecutor = new SearchExecutor(this);
        this.currentSearchTask = RequestProcessor.getDefault().create((Runnable)searchExecutor);
        this.currentSearchTask.schedule(0);
    }

    private List<Object> createDisplayList(List<LogInformation.Revision> list) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list.isEmpty()) {
            return arrayList;
        }
        ArrayList<LogInformation.Revision> arrayList2 = new ArrayList<LogInformation.Revision>(list);
        Collections.sort(arrayList2, new ByRemotePathRevisionNumberComparator());
        ArrayList<DispRevision> arrayList3 = new ArrayList<DispRevision>(arrayList2.size());
        HashSet<String> hashSet = new HashSet<String>(10);
        for (LogInformation.Revision object2 : arrayList2) {
            LogInformation.Revision revision;
            Object object3;
            String string = this.getBranchName(object2);
            if (string != null && hashSet.add(string)) {
                object = object2.getLogInfoHeader().getSymNamesForRevision(Utils.createBranchRevisionNumber(string));
                object3 = null;
                if (object.size() > 0) {
                    object3 = ((LogInformation.SymName)object.get(0)).getName();
                }
                revision = new LogInformation.Revision(object2.getLogInfoHeader());
                revision.setNumber(string);
                arrayList3.add(new DispRevision(string, (String)object3, revision));
            }
            object = object2.getLogInfoHeader().getAllSymbolicNames();
            object3 = new ArrayList(2);
            revision = new ArrayList(2);
            String string2 = object2.getNumber() + ".0.";
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                LogInformation.SymName symName = (LogInformation.SymName)iterator.next();
                String string3 = symName.getRevision();
                if (object2.getNumber().equals(string3)) {
                    object3.add(symName.getName());
                }
                if (!string3.startsWith(string2)) continue;
                int n = string3.lastIndexOf(46);
                revision.add(symName.getName() + " (" + string3.substring(0, n - 1) + string3.substring(n + 1) + ")");
            }
            arrayList3.add(new DispRevision(object2, (List<String>)object3, (List<String>)revision));
        }
        Object object5 = null;
        object5 = new ResultsContainer(((DispRevision)arrayList3.get(0)).getRevision().getLogInfoHeader());
        ((ResultsContainer)object5).add(this.createLocalRevision(((DispRevision)arrayList3.get(0)).getRevision().getLogInfoHeader()));
        arrayList.add(object5);
        for (DispRevision dispRevision : arrayList3) {
            if (((ResultsContainer)object5).getHeader() != dispRevision.getRevision().getLogInfoHeader()) {
                this.getProject(((ResultsContainer)object5).getHeader().getFile());
                if (((ResultsContainer)object5).getRevisions().size() < 1) {
                    arrayList.remove(object5);
                    if (((ResultsContainer)object5).getRevisions().size() == 1) {
                        arrayList.add(((ResultsContainer)object5).getRevisions().get(0));
                    }
                }
                object5 = new ResultsContainer(dispRevision.getRevision().getLogInfoHeader());
                ((ResultsContainer)object5).add(this.createLocalRevision(dispRevision.getRevision().getLogInfoHeader()));
                arrayList.add(object5);
            }
            if ((object = SearchHistoryPanel.getParentRevision(arrayList3, dispRevision)) != null) {
                ((DispRevision)object).addRevision(dispRevision);
                continue;
            }
            ((ResultsContainer)object5).add(dispRevision);
        }
        if (((ResultsContainer)object5).getRevisions().size() < 1) {
            arrayList.remove(object5);
            if (((ResultsContainer)object5).getRevisions().size() == 1) {
                arrayList.add(((ResultsContainer)object5).getRevisions().get(0));
            }
        }
        return arrayList;
    }

    private DispRevision createLocalRevision(LogInformation logInformation) {
        LogInformation.Revision revision = new LogInformation.Revision(logInformation);
        revision.setNumber("");
        return new DispRevision(revision, null, null);
    }

    private String getBranchName(LogInformation.Revision revision) {
        String string = revision.getNumber();
        int n = string.lastIndexOf(46, string.lastIndexOf(46) - 1);
        return n == -1 ? null : string.substring(0, string.lastIndexOf(46));
    }

    private static DispRevision getParentRevision(List list, DispRevision dispRevision) {
        LogInformation.Revision revision;
        int n;
        String string = dispRevision.getRevision().getNumber();
        do {
            int n2;
            if ((n2 = string.lastIndexOf(46)) == -1) {
                return null;
            }
            string = string.substring(0, n2);
            revision = new LogInformation.Revision(dispRevision.getRevision().getLogInfoHeader());
            revision.setNumber(string);
        } while ((n = Collections.binarySearch(list, new DispRevision(revision, null, null), revisionsComparator)) < 0);
        return (DispRevision)list.get(n);
    }

    void executeSearch() {
        this.search();
    }

    void showDiff(DispRevision dispRevision) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(dispRevision);
    }

    public void showDiff(ResultsContainer resultsContainer) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(resultsContainer);
    }

    @Override
    public Collection<Setup> getSetups() {
        String string;
        File file;
        Object object;
        if (this.dispResults == null) {
            return Collections.emptySet();
        }
        List<Object> list = this.dispResults;
        list = this.tbSummary.isSelected() ? this.summaryView.getSelection() : this.diffView.getSelection();
        if (list.size() == 0) {
            for (Object object32 : this.dispResults) {
                if (!(object32 instanceof ResultsContainer)) continue;
                list.add(object32);
            }
        }
        ArrayList arrayList = new ArrayList(list.size());
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object2 : list) {
            String string2;
            if (!(object2 instanceof ResultsContainer)) continue;
            object = (ResultsContainer)object2;
            file = ((ResultsContainer)object).getHeader().getFile();
            boolean bl = true;
            string = null;
            List<DispRevision> j = ((ResultsContainer)object).getRevisions();
            for (DispRevision dispRevision : j) {
                string2 = dispRevision.getRevision().getNumber();
                if ("".equals(string2)) continue;
                if (string != null && !string2.equals(Utils.previousRevision(string))) {
                    bl = false;
                    break;
                }
                string = string2;
            }
            if (!bl) continue;
            String string3 = ((ResultsContainer)object).getEldestRevision();
            string2 = ((ResultsContainer)object).getNewestRevision();
            Setup setup = new Setup(file, string3, string2);
            hashSet.add(((ResultsContainer)object).getHeader());
            arrayList.add(setup);
        }
        for (int i = 0; i < list.size(); ++i) {
            String string4;
            Object object2;
            object2 = list.get(i);
            if (!(object2 instanceof DispRevision) || hashSet.contains(file = ((DispRevision)(object = (DispRevision)object2)).getRevision().getLogInfoHeader())) continue;
            string = string4 = ((DispRevision)object).getRevision().getNumber();
            for (int string42 = i + 1; string42 < list.size(); ++string42) {
                DispRevision dispRevision;
                Object object3 = list.get(string42);
                if (!(object3 instanceof DispRevision) || !((Object)file).equals((dispRevision = (DispRevision)object3).getRevision().getLogInfoHeader())) continue;
                string = dispRevision.getRevision().getNumber();
            }
            if (string == null) continue;
            if (SearchHistoryPanel.compareRevisions(string4, string) > 0) {
                String setup = string;
                string = string4;
                string4 = setup;
            }
            if (Utils.previousRevision(string4) != null) {
                string4 = Utils.previousRevision(string4);
            }
            Setup setup = new Setup(file.getFile(), string4, string);
            hashSet.add(file);
            arrayList.add(setup);
        }
        return arrayList;
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    DelegatingUndoRedo getUndoRedo() {
        return this.undoRedo;
    }

    public static int compareRevisionsTrunkFirst(String string, String string2) {
        int n;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        do {
            if (!stringTokenizer.hasMoreTokens()) {
                return stringTokenizer2.hasMoreTokens() ? -1 : 0;
            }
            if (stringTokenizer2.hasMoreTokens()) continue;
            return stringTokenizer.hasMoreTokens() ? 1 : 0;
        } while ((n2 = Integer.parseInt(stringTokenizer.nextToken())) == (n = Integer.parseInt(stringTokenizer2.nextToken())));
        return n - n2;
    }

    public static int compareRevisions(String string, String string2) {
        int n;
        int n2;
        if (string.equals(string2)) {
            return 0;
        }
        if (string.equals("")) {
            return 1;
        }
        if (string2.equals("")) {
            return -1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        do {
            if (!stringTokenizer.hasMoreTokens()) {
                return -1;
            }
            if (stringTokenizer2.hasMoreTokens()) continue;
            return 1;
        } while ((n2 = Integer.parseInt(stringTokenizer.nextToken())) == (n = Integer.parseInt(stringTokenizer2.nextToken())));
        return n2 - n;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.searchCriteriaPanel = new JPanel();
        this.bSearch = new JButton();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.tbSummary = new JToggleButton();
        this.tbDiff = new JToggleButton();
        this.jSeparator2 = new JSeparator();
        this.bNext = new JButton();
        this.bPrev = new JButton();
        this.resultsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        this.searchCriteriaPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.searchCriteriaPanel, gridBagConstraints);
        this.bSearch.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Search"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.bSearch, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(10, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.tbSummary);
        this.tbSummary.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbSummary, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_ShowSummary"));
        this.tbSummary.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Summary"));
        this.tbSummary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.onViewToggle(actionEvent);
            }
        });
        this.jToolBar1.add(this.tbSummary);
        this.buttonGroup1.add(this.tbDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDiff, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_ShowDiff"));
        this.tbDiff.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_ShowDiff"));
        this.tbDiff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.onViewToggle(actionEvent);
            }
        });
        this.jToolBar1.add(this.tbDiff);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator2);
        this.bNext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png")));
        this.jToolBar1.add(this.bNext);
        this.bNext.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("ACSN_NextDifference"));
        this.bPrev.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png")));
        this.jToolBar1.add(this.bPrev);
        this.bPrev.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("ACSN_PrevDifference"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.resultsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    private void onViewToggle(ActionEvent actionEvent) {
        this.refreshComponents(true);
    }

    private static class ByRemotePathRevisionNumberComparator
    implements Comparator {
        private ByRemotePathRevisionNumberComparator() {
        }

        public int compare(Object object, Object object2) {
            LogInformation.Revision revision = (LogInformation.Revision)object;
            LogInformation.Revision revision2 = (LogInformation.Revision)object2;
            int n = revision.getLogInfoHeader().getFile().getName().compareToIgnoreCase(revision2.getLogInfoHeader().getFile().getName());
            if (n != 0) {
                return n;
            }
            n = revision.getLogInfoHeader().getRepositoryFilename().compareToIgnoreCase(revision2.getLogInfoHeader().getRepositoryFilename());
            if (n != 0) {
                return n;
            }
            return SearchHistoryPanel.compareRevisionsTrunkFirst(revision.getNumber(), revision2.getNumber());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DispRevision {
        private final LogInformation.Revision revision;
        private String name;
        private List children;
        private String path;
        private int indentation;
        private final String branchNumber;
        private final String branchName;
        private final int hashCode;
        private final List<String> tags;
        private final List<String> branches;

        public DispRevision(String string, String string2, LogInformation.Revision revision) {
            this.branchNumber = string;
            this.branchName = string2;
            this.revision = revision;
            this.hashCode = string.hashCode();
            this.tags = null;
            this.branches = null;
        }

        public DispRevision(LogInformation.Revision revision, List<String> list, List<String> list2) {
            block2: {
                this.revision = revision;
                this.tags = list == null ? null : Collections.unmodifiableList(list);
                this.branches = list2 == null ? null : Collections.unmodifiableList(list2);
                this.hashCode = revision.hashCode();
                this.branchNumber = null;
                this.branchName = null;
                File file = revision.getLogInfoHeader().getFile();
                try {
                    this.name = CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParentFile().getAbsolutePath(), "") + "/" + file.getName();
                }
                catch (Exception exception) {
                    this.name = revision.getLogInfoHeader().getRepositoryFilename();
                    if (!this.name.endsWith(",v")) break block2;
                    this.name = this.name.substring(0, this.name.lastIndexOf(",v"));
                }
            }
            this.path = this.name.substring(0, this.name.lastIndexOf(47));
        }

        public List<String> getTags() {
            return this.tags;
        }

        public List<String> getBranches() {
            return this.branches;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public LogInformation.Revision getRevision() {
            return this.revision;
        }

        public void addRevision(DispRevision dispRevision) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(dispRevision);
        }

        public List getChildren() {
            return this.children;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DispRevision)) {
                return false;
            }
            if (this.branchNumber != null) {
                return this.branchNumber.equals(((DispRevision)object).branchNumber);
            }
            return this.revision.equals(((DispRevision)object).revision);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public int getIndentation() {
            return this.indentation;
        }

        public void setIndentation(int n) {
            this.indentation = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("  ");
            for (int i = 0; i < this.getIndentation(); ++i) {
                stringBuffer.append("  ");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(stringBuffer).append(this.getRevision().getNumber()).append("\t").append(this.getRevision().getDateString()).append(" ").append(this.getRevision().getAuthor());
            stringBuffer2.append("\n");
            stringBuffer2.append(this.getRevision().getMessage());
            return stringBuffer2.toString();
        }

        public boolean isBranchRoot() {
            return this.branchNumber != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResultsContainer {
        private List<DispRevision> revisions;
        private String name;
        private String path;
        private final LogInformation header;

        public ResultsContainer(LogInformation logInformation) {
            block2: {
                this.revisions = new ArrayList<DispRevision>(2);
                this.header = logInformation;
                File file = logInformation.getFile();
                try {
                    this.name = CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParentFile().getAbsolutePath(), "") + "/" + file.getName();
                }
                catch (Exception exception) {
                    this.name = logInformation.getRepositoryFilename();
                    if (!this.name.endsWith(",v")) break block2;
                    this.name = this.name.substring(0, this.name.lastIndexOf(",v"));
                }
            }
            this.path = this.name.substring(0, this.name.lastIndexOf(47));
            this.name = this.name.substring(this.path.length() + 1);
        }

        public LogInformation getHeader() {
            return this.header;
        }

        public void add(DispRevision dispRevision) {
            this.revisions.add(this.revisions.size(), dispRevision);
        }

        public String getName() {
            return this.name;
        }

        public List<DispRevision> getRevisions() {
            return this.revisions;
        }

        public String getEldestRevision() {
            DispRevision dispRevision = this.revisions.get(this.revisions.size() - 1);
            String string = Utils.previousRevision(dispRevision.getRevision().getNumber());
            return string != null ? string : dispRevision.getRevision().getNumber();
        }

        public String getNewestRevision() {
            String string = this.revisions.get(0).getRevision().getNumber();
            if ("".equals(string)) {
                string = this.revisions.get(1).getRevision().getNumber();
            }
            return string;
        }

        public String getPath() {
            return this.path;
        }

        public File getFile() {
            return this.header.getFile();
        }

        public String toString() {
            return this.getName() + "    " + this.getPath();
        }
    }
}

