/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.Reflector;

public class CachedClass {
    private CachedClass cachedSuperClass;
    private static final MetaMethod[] EMPTY = new MetaMethod[0];
    int hashCode;
    private Reflector reflector;
    private volatile Object metaClassForClass;
    private CachedField[] fields;
    private CachedConstructor[] constructors;
    private CachedMethod[] methods;
    private final Class cachedClass;
    private MetaMethod[] newMetaMethods = EMPTY;
    public CachedMethod[] mopMethods;
    public static final CachedClass[] EMPTY_ARRAY = new CachedClass[0];
    private Object staticMetaClassField;
    private static final Object NONE = new Object();
    private Set ownInterfaces;
    private Set interfaces;
    public final boolean isArray;
    public final boolean isPrimitive;
    public final int modifiers;
    int distance = -1;
    public final boolean isInterface;
    public final boolean isNumber;
    static /* synthetic */ Class class$groovy$lang$MetaClass;

    public Set getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new HashSet(0);
            if (this.getTheClass().isInterface()) {
                this.interfaces.add(this);
            }
            Class<?>[] classes = this.getTheClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                CachedClass aClass = ReflectionCache.getCachedClass(classes[i]);
                if (this.interfaces.contains(aClass)) continue;
                this.interfaces.addAll(aClass.getInterfaces());
            }
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                this.interfaces.addAll(superClass.getInterfaces());
            }
        }
        return this.interfaces;
    }

    public Set getOwnInterfaces() {
        if (this.ownInterfaces == null) {
            this.ownInterfaces = new HashSet(0);
            if (this.getTheClass().isInterface()) {
                this.ownInterfaces.add(this);
            }
            Class<?>[] classes = this.getTheClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                CachedClass aClass = ReflectionCache.getCachedClass(classes[i]);
                if (this.ownInterfaces.contains(aClass)) continue;
                this.ownInterfaces.addAll(aClass.getInterfaces());
            }
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                this.ownInterfaces.addAll(superClass.getInterfaces());
            }
        }
        return this.ownInterfaces;
    }

    public CachedClass(Class klazz) {
        this.cachedClass = klazz;
        this.isArray = klazz.isArray();
        this.isPrimitive = klazz.isPrimitive();
        this.modifiers = klazz.getModifiers();
        this.isInterface = klazz.isInterface();
        this.isNumber = Number.class.isAssignableFrom(klazz);
    }

    final void initialize() {
        Iterator it = this.getInterfaces().iterator();
        while (it.hasNext()) {
            CachedClass inf = (CachedClass)it.next();
            ReflectionCache.isAssignableFrom(this.cachedClass, inf.cachedClass);
        }
        for (CachedClass cur = this; cur != null; cur = cur.getCachedSuperClass()) {
            ReflectionCache.setAssignableFrom(cur.cachedClass, this.cachedClass);
        }
    }

    public CachedClass getCachedSuperClass() {
        if (this.cachedSuperClass == null) {
            this.cachedSuperClass = !this.isArray ? ReflectionCache.getCachedClass(this.getTheClass().getSuperclass()) : (this.cachedClass.getComponentType().isPrimitive() || this.cachedClass.getComponentType() == Object.class ? ReflectionCache.OBJECT_CLASS : ReflectionCache.OBJECT_ARRAY_CLASS);
        }
        return this.cachedSuperClass;
    }

    public synchronized CachedMethod[] getMethods() {
        if (this.methods == null) {
            Method[] declaredMethods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getTheClass().getDeclaredMethods();
                }
            });
            ArrayList<CachedMethod> methods = new ArrayList<CachedMethod>(declaredMethods.length);
            ArrayList<CachedMethod> mopMethods = new ArrayList<CachedMethod>(declaredMethods.length);
            for (int i = 0; i != declaredMethods.length; ++i) {
                CachedMethod cachedMethod = new CachedMethod(this, declaredMethods[i]);
                String name = cachedMethod.getName();
                if (name.indexOf(43) >= 0) continue;
                if (name.startsWith("this$") || name.startsWith("super$")) {
                    mopMethods.add(cachedMethod);
                    continue;
                }
                methods.add(cachedMethod);
            }
            this.methods = methods.toArray(new CachedMethod[methods.size()]);
            Arrays.sort(this.methods);
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                superClass.getMethods();
                CachedMethod[] superMopMethods = superClass.mopMethods;
                for (int i = 0; i != superMopMethods.length; ++i) {
                    mopMethods.add(superMopMethods[i]);
                }
            }
            this.mopMethods = mopMethods.toArray(new CachedMethod[mopMethods.size()]);
            Arrays.sort(this.mopMethods, CachedMethodComparatorByName.INSTANCE);
        }
        return this.methods;
    }

    public synchronized CachedField[] getFields() {
        if (this.fields == null) {
            Field[] declaredFields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getTheClass().getDeclaredFields();
                }
            });
            this.fields = new CachedField[declaredFields.length];
            for (int i = 0; i != this.fields.length; ++i) {
                this.fields[i] = new CachedField(this, declaredFields[i]);
            }
        }
        return this.fields;
    }

    public synchronized CachedConstructor[] getConstructors() {
        if (this.constructors == null) {
            Constructor[] declaredConstructors = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getTheClass().getDeclaredConstructors();
                }
            });
            this.constructors = new CachedConstructor[declaredConstructors.length];
            for (int i = 0; i != this.constructors.length; ++i) {
                this.constructors[i] = new CachedConstructor(this, declaredConstructors[i]);
            }
        }
        return this.constructors;
    }

    public CachedMethod searchMethods(String name, CachedClass[] parameterTypes) {
        CachedMethod[] methods = this.getMethods();
        CachedMethod res = null;
        for (int i = 0; i < methods.length; ++i) {
            CachedMethod m = methods[i];
            if (!m.getName().equals(name) || !ReflectionCache.arrayContentsEq(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
            res = m;
        }
        return res;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public Object coerceArgument(Object argument) {
        return argument;
    }

    public int getSuperClassDistance() {
        if (this.distance == -1) {
            int distance = 0;
            for (Class klazz = this.getTheClass(); klazz != null; klazz = klazz.getSuperclass()) {
                ++distance;
            }
            this.distance = distance;
        }
        return this.distance;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = -889274690;
            }
        }
        return this.hashCode;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isVoid() {
        return this.getTheClass() == Void.TYPE;
    }

    public void box(BytecodeHelper helper) {
        helper.box(this.getTheClass());
    }

    public void unbox(BytecodeHelper helper) {
        helper.unbox(this.getTheClass());
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void doCast(BytecodeHelper helper) {
        helper.doCast(this.getTheClass());
    }

    public String getName() {
        return this.getTheClass().getName();
    }

    public String getTypeDescription() {
        return BytecodeHelper.getTypeDescription(this.getTheClass());
    }

    public Reflector getReflector() {
        return this.reflector;
    }

    public final Class getTheClass() {
        return this.cachedClass;
    }

    public MetaMethod[] getNewMetaMethods() {
        return this.newMetaMethods;
    }

    public void setNewMopMethods(ArrayList arr) {
        this.newMetaMethods = arr.toArray(new MetaMethod[arr.size()]);
    }

    public synchronized void setStaticMetaClassField(MetaClass mc) {
        if (this.staticMetaClassField == NONE) {
            return;
        }
        if (this.staticMetaClassField == null) {
            CachedField[] cachedFields = this.getFields();
            for (int i = 0; i < cachedFields.length; ++i) {
                CachedField cachedField = cachedFields[i];
                if (!cachedField.getName().startsWith("$staticMetaClass") || cachedField.getType() != (class$groovy$lang$MetaClass == null ? CachedClass.class$("groovy.lang.MetaClass") : class$groovy$lang$MetaClass) || !cachedField.isStatic()) continue;
                this.staticMetaClassField = cachedField;
                break;
            }
        }
        if (this.staticMetaClassField == null) {
            this.staticMetaClassField = NONE;
            return;
        }
        ((CachedField)this.staticMetaClassField).setProperty(null, mc);
    }

    public MetaClass getMetaClassForClass() {
        Object cur = this.metaClassForClass;
        if (cur == null) {
            return null;
        }
        if (cur instanceof SoftReference) {
            SoftReference softReference = (SoftReference)cur;
            return (MetaClass)softReference.get();
        }
        return (MetaClass)this.metaClassForClass;
    }

    public void setMetaClassForClass(MetaClass metaClassForClass, boolean isConst) {
        this.metaClassForClass = isConst || metaClassForClass == null ? metaClassForClass : new SoftReference<MetaClass>(metaClassForClass);
        this.setStaticMetaClassField(metaClassForClass);
    }

    public boolean isAssignableFrom(Class argument) {
        return argument == null || ReflectionCache.isAssignableFrom(this.getTheClass(), argument);
    }

    boolean isDirectlyAssignable(Object argument) {
        return ReflectionCache.isAssignableFrom(this.getTheClass(), argument.getClass());
    }

    public String toString() {
        return this.cachedClass.toString();
    }

    public static class CachedMethodComparatorWithString
    implements Comparator {
        public static final Comparator INSTANCE = new CachedMethodComparatorWithString();

        public int compare(Object o1, Object o2) {
            if (o1 instanceof CachedMethod) {
                return ((CachedMethod)o1).getName().compareTo((String)o2);
            }
            return ((String)o1).compareTo(((CachedMethod)o2).getName());
        }
    }

    public static class CachedMethodComparatorByName
    implements Comparator {
        public static final Comparator INSTANCE = new CachedMethodComparatorByName();

        public int compare(Object o1, Object o2) {
            return ((CachedMethod)o1).getName().compareTo(((CachedMethod)o2).getName());
        }
    }
}

