/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.project.libraries.LibraryAccessor;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LibraryManager {
    public static final String PROP_LIBRARIES = "libraries";
    private static LibraryManager instance;
    private Lookup.Result<LibraryProvider> result;
    private final Collection<LibraryProvider> currentStorages = new ArrayList<LibraryProvider>();
    private final PropertyChangeListener plistener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (LibraryManager.PROP_LIBRARIES.equals(propertyChangeEvent.getPropertyName())) {
                LibraryManager.this.resetCache();
            }
        }
    };
    private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private static final PropertyChangeSupport openLibraryManagerListListeners;
    private static final PropertyChangeListener AREAL_LIBRARY_PROVIDER_LISTENER;
    public static final String PROP_OPEN_LIBRARY_MANAGERS = "openManagers";
    private static Lookup.Result<ArealLibraryProvider> areaProvidersLookupResult;
    private static Collection<? extends ArealLibraryProvider> currentAreaProviders;
    private Collection<Library> cache;
    private final ArealLibraryProvider alp;
    private final LibraryStorageArea area;
    private LookupListener lookupListener;
    private long eventId;

    private LibraryManager() {
        this.alp = null;
        this.area = null;
    }

    private LibraryManager(ArealLibraryProvider arealLibraryProvider, LibraryStorageArea libraryStorageArea) {
        this.alp = arealLibraryProvider;
        this.area = libraryStorageArea;
        LibraryProvider libraryProvider = LibraryAccessor.getLibraries(arealLibraryProvider, libraryStorageArea);
        libraryProvider.addPropertyChangeListener(this.plistener);
        this.currentStorages.add(libraryProvider);
    }

    public String getDisplayName() {
        if (this.area == null) {
            return LibrariesModel.GLOBAL_AREA.getDisplayName();
        }
        return this.area.getDisplayName();
    }

    public URL getLocation() {
        return this.area != null ? this.area.getLocation() : null;
    }

    public Library getLibrary(String string) {
        assert (string != null);
        Library[] libraryArray = this.getLibraries();
        for (int i = 0; i < libraryArray.length; ++i) {
            if (!string.equals(libraryArray[i].getName())) continue;
            return libraryArray[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library[] getLibraries() {
        long l;
        Collection<LibraryProvider<Object>> collection;
        ArrayList<Library> arrayList = new ArrayList<Library>();
        Object object = this;
        synchronized (object) {
            if (this.cache != null) {
                return this.cache.toArray(new Library[0]);
            }
            if (this.area == null) {
                if (this.result == null) {
                    this.result = Lookup.getDefault().lookupResult(LibraryProvider.class);
                    this.lookupListener = new LookupListener(){

                        public void resultChanged(LookupEvent lookupEvent) {
                            LibraryManager.this.resetCache();
                        }
                    };
                    this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, this.result));
                }
                collection = this.result.allInstances();
                HashSet<LibraryProvider> object2 = new HashSet<LibraryProvider>(collection);
                object2.removeAll(this.currentStorages);
                LibraryImplementation[] libraryImplementationArray = new HashSet(this.currentStorages);
                libraryImplementationArray.removeAll(collection);
                this.currentStorages.clear();
                for (LibraryProvider<Object> libraryProvider : collection) {
                    this.currentStorages.add(libraryProvider);
                }
                for (LibraryProvider<Object> libraryProvider : libraryImplementationArray) {
                    libraryProvider.removePropertyChangeListener(this.plistener);
                }
                for (LibraryProvider<Object> libraryProvider : object2) {
                    libraryProvider.addPropertyChangeListener(this.plistener);
                }
            } else {
                collection = Collections.singleton(this.currentStorages.iterator().next());
            }
            l = this.eventId;
        }
        assert (collection != null);
        for (LibraryProvider libraryProvider : collection) {
            for (LibraryImplementation libraryImplementation : libraryProvider.getLibraries()) {
                arrayList.add(new Library(libraryImplementation, this));
            }
        }
        object = this;
        synchronized (object) {
            assert (arrayList != null);
            if (this.eventId == l) {
                this.cache = arrayList;
                return this.cache.toArray(new Library[0]);
            }
            return arrayList.toArray(new Library[0]);
        }
    }

    @Deprecated
    public void addLibrary(Library library) throws IOException, IllegalArgumentException {
        assert (library != null);
        if (LibrariesSupport.getLibraryTypeProvider(library.getType()) == null) {
            throw new IllegalArgumentException("Trying to add a library of unknown type: " + library.getType());
        }
        String string = library.getName();
        if (string == null || this.getLibrary(string) != null) {
            throw new IllegalArgumentException("Library hasn't name or the name is already used: " + string);
        }
        Collection collection = Lookup.getDefault().lookupAll(WritableLibraryProvider.class);
        assert (collection.size() == 1);
        ((WritableLibraryProvider)collection.iterator().next()).addLibrary(library.getLibraryImplementation());
    }

    public Library createLibrary(String string, String string2, Map<String, List<URL>> map) throws IOException {
        LibraryImplementation libraryImplementation;
        if (this.getLibrary(string2) != null) {
            throw new IllegalArgumentException("Name already in use: " + string2);
        }
        if (this.area == null) {
            LibraryTypeProvider libraryTypeProvider = LibrariesSupport.getLibraryTypeProvider(string);
            if (libraryTypeProvider == null) {
                throw new IllegalArgumentException("Trying to add a library of unknown type: " + string);
            }
            libraryImplementation = libraryTypeProvider.createLibrary();
            libraryImplementation.setName(string2);
            for (Map.Entry<String, List<URL>> entry : map.entrySet()) {
                libraryImplementation.setContent(entry.getKey(), entry.getValue());
            }
            ((WritableLibraryProvider)Lookup.getDefault().lookup(WritableLibraryProvider.class)).addLibrary(libraryImplementation);
        } else {
            HashMap<String, List<URI>> hashMap = new HashMap<String, List<URI>>();
            for (Map.Entry<String, List<URL>> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), LibrariesModel.convertURLsToURIs(entry.getValue()));
            }
            libraryImplementation = LibraryAccessor.createLibrary(this.alp, string, string2, this.area, hashMap);
        }
        return new Library(libraryImplementation, this);
    }

    public Library createURILibrary(String string, String string2, Map<String, List<URI>> map) throws IOException {
        LibraryImplementation libraryImplementation;
        if (this.getLibrary(string2) != null) {
            throw new IllegalArgumentException("Name already in use: " + string2);
        }
        if (this.area == null) {
            LibraryTypeProvider libraryTypeProvider = LibrariesSupport.getLibraryTypeProvider(string);
            if (libraryTypeProvider == null) {
                throw new IllegalArgumentException("Trying to add a library of unknown type: " + string);
            }
            libraryImplementation = libraryTypeProvider.createLibrary();
            libraryImplementation.setName(string2);
            for (Map.Entry<String, List<URI>> entry : map.entrySet()) {
                libraryImplementation.setContent(entry.getKey(), LibrariesModel.convertURIsToURLs(entry.getValue()));
            }
            ((WritableLibraryProvider)Lookup.getDefault().lookup(WritableLibraryProvider.class)).addLibrary(libraryImplementation);
        } else {
            libraryImplementation = LibraryAccessor.createLibrary(this.alp, string, string2, this.area, map);
        }
        return new Library(libraryImplementation, this);
    }

    public void removeLibrary(Library library) throws IOException, IllegalArgumentException {
        assert (library != null);
        if (this.area == null) {
            Collection collection = Lookup.getDefault().lookupAll(WritableLibraryProvider.class);
            assert (collection.size() == 1);
            ((WritableLibraryProvider)collection.iterator().next()).removeLibrary(library.getLibraryImplementation());
        } else {
            assert (library.getLibraryImplementation() instanceof LibraryImplementation2);
            LibraryAccessor.remove(this.alp, (LibraryImplementation2)library.getLibraryImplementation());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (propertyChangeListener != null);
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (propertyChangeListener != null);
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetCache() {
        LibraryManager libraryManager = this;
        synchronized (libraryManager) {
            this.cache = null;
            ++this.eventId;
        }
        this.listeners.firePropertyChange(PROP_LIBRARIES, null, null);
    }

    public static synchronized LibraryManager getDefault() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }

    public static LibraryManager forLocation(URL uRL) throws IllegalArgumentException {
        for (ArealLibraryProvider arealLibraryProvider : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            Object a = arealLibraryProvider.loadArea(uRL);
            if (a == null) continue;
            return new LibraryManager(arealLibraryProvider, (LibraryStorageArea)a);
        }
        throw new IllegalArgumentException(uRL.toExternalForm());
    }

    public static Collection<LibraryManager> getOpenManagers() {
        ArrayList<LibraryManager> arrayList = new ArrayList<LibraryManager>();
        arrayList.add(LibraryManager.getDefault());
        HashSet<URL> hashSet = new HashSet<URL>();
        for (ArealLibraryProvider arealLibraryProvider : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            for (LibraryStorageArea object : LibraryAccessor.getOpenAreas(arealLibraryProvider)) {
                if (!hashSet.add(object.getLocation())) continue;
                arrayList.add(new LibraryManager(arealLibraryProvider, object));
            }
        }
        for (ArealLibraryProvider arealLibraryProvider : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            for (URL uRL : LibrariesModel.createdAreas) {
                Object a = arealLibraryProvider.loadArea(uRL);
                if (a == null) continue;
                assert (a.getLocation().equals(uRL)) : "Bad location " + a.getLocation() + " does not match " + uRL + " from " + arealLibraryProvider.getClass().getName();
                if (!hashSet.add(uRL)) continue;
                arrayList.add(new LibraryManager(arealLibraryProvider, (LibraryStorageArea)a));
            }
        }
        return arrayList;
    }

    public static synchronized void addOpenManagersPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (propertyChangeListener != null);
        if (areaProvidersLookupResult == null) {
            areaProvidersLookupResult = Lookup.getDefault().lookupResult(ArealLibraryProvider.class);
            LibraryManager.attachListeners(areaProvidersLookupResult.allInstances());
            areaProvidersLookupResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    LibraryManager.attachListeners(areaProvidersLookupResult.allInstances());
                }
            });
        }
        openLibraryManagerListListeners.addPropertyChangeListener(propertyChangeListener);
    }

    private static synchronized void attachListeners(Collection<? extends ArealLibraryProvider> collection) {
        for (ArealLibraryProvider arealLibraryProvider : currentAreaProviders) {
            arealLibraryProvider.removePropertyChangeListener(AREAL_LIBRARY_PROVIDER_LISTENER);
        }
        for (ArealLibraryProvider arealLibraryProvider : collection) {
            arealLibraryProvider.addPropertyChangeListener(AREAL_LIBRARY_PROVIDER_LISTENER);
        }
        currentAreaProviders = collection;
    }

    public static void removeOpenManagersPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (propertyChangeListener != null);
        openLibraryManagerListListeners.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        URL uRL = this.getLocation();
        return "LibraryManager[" + (uRL != null ? uRL : "default") + "]";
    }

    LibraryStorageArea getArea() {
        return this.area;
    }

    static {
        openLibraryManagerListListeners = new PropertyChangeSupport(LibraryManager.class);
        AREAL_LIBRARY_PROVIDER_LISTENER = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                openLibraryManagerListListeners.firePropertyChange(LibraryManager.PROP_OPEN_LIBRARY_MANAGERS, null, null);
            }
        };
        areaProvidersLookupResult = null;
        currentAreaProviders = new ArrayList<ArealLibraryProvider>();
    }
}

