/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmFunction,
Disposable,
RawNamable,
CsmTemplate {
    private static final String OPERATOR = "operator";
    private final CharSequence name;
    private final CsmType returnType;
    private final FunctionParameterListImpl parameterList;
    private CharSequence signature;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final CharSequence[] rawName;
    private TemplateDescriptor templateDescriptor = null;
    protected final CharSequence classTemplateSuffix;
    private static final byte FLAGS_VOID_PARMLIST = 1;
    private static final byte FLAGS_STATIC = 2;
    private static final byte FLAGS_CONST = 4;
    private static final byte FLAGS_OPERATOR = 8;
    private static final byte FLAGS_INVALID = 16;
    protected static final int LAST_USED_FLAG_INDEX = 4;
    private byte flags;
    private static final boolean CHECK_SCOPE = false;

    public FunctionImpl(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl, boolean bl2) throws AstRendererException {
        this(aST, csmFile, null, csmScope, bl, bl2);
    }

    public FunctionImpl(AST aST, CsmFile csmFile, CsmType csmType, CsmScope csmScope, boolean bl, boolean bl2) throws AstRendererException {
        super(aST, csmFile);
        Object object;
        this.name = QualifiedNameCache.getManager().getString((CharSequence)this.initName(aST));
        if (this.name.length() == 0) {
            throw new AstRendererException((FileImpl)csmFile, this.getStartOffset(), "Empty function name.");
        }
        this.rawName = AstUtil.getRawNameInChildren(aST);
        AST aST2 = aST.getFirstChild();
        if (aST2 != null) {
            this.setStatic(aST2.getType() == 48);
        } else {
            System.err.println("function ast " + aST.getText() + " without childs in file " + csmFile.getAbsolutePath());
        }
        if (!this.isStatic()) {
            CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(this.name, true, true, false);
            object = CsmSelect.getStaticFunctions((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
            while (object.hasNext()) {
                CsmFunction csmFunction = (CsmFunction)object.next();
                if (!this.name.equals(csmFunction.getName())) continue;
                this.setStatic(true);
                break;
            }
        }
        if (csmScope instanceof CsmNamespace && !NamespaceImpl.isNamespaceScope(this)) {
            csmScope = csmFile;
        }
        this._setScope(csmScope);
        if (bl2) {
            RepositoryUtils.hang(this);
        } else {
            Utils.setSelfUID(this);
        }
        boolean bl3 = FunctionImpl.initConst(aST);
        this.setFlags((byte)4, bl3);
        object = new StringBuilder();
        this.templateDescriptor = this.createTemplateDescriptor(aST, (CsmScope)this, (StringBuilder)object, bl2);
        this.classTemplateSuffix = NameCache.getManager().getString((CharSequence)object);
        this.returnType = csmType != null ? csmType : this.initReturnType(aST);
        this.parameterList = this.createParameterList(aST, !bl2);
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            this.setFlags((byte)1, this.isVoidParameter(aST));
        } else {
            this.setFlags((byte)1, false);
        }
        if (((Object)this.name).toString().startsWith(OPERATOR) && this.name.length() > OPERATOR.length() && !Character.isJavaIdentifierPart(this.name.charAt(OPERATOR.length()))) {
            this.setFlags((byte)8, true);
        }
        if (bl) {
            this.registerInProject();
        }
        if (this.parameterList == null) {
            System.err.println("NO PARAM LIST FOR FUNC:" + this.name + " at " + AstUtil.getOffsetString(aST) + " in " + csmFile.getAbsolutePath());
        }
    }

    public void setScope(CsmScope csmScope) {
        this.unregisterInProject();
        try {
            this._setScope(csmScope);
        }
        catch (AstRendererException astRendererException) {
            DiagnosticExceptoins.register(astRendererException);
        }
        this.registerInProject();
    }

    private void _setScope(CsmScope csmScope) throws AstRendererException {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    public boolean isPureDefinition() {
        return this.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    protected boolean hasFlags(byte by) {
        return (this.flags & by) == by;
    }

    protected void setFlags(byte by, boolean bl) {
        this.flags = bl ? (byte)(this.flags | by) : (byte)(this.flags & ~by);
    }

    public boolean isStatic() {
        return this.hasFlags((byte)2);
    }

    protected void setStatic(boolean bl) {
        this.setFlags((byte)2, bl);
    }

    private AST findParameterNode(AST aST) {
        AST aST2;
        AST aST3 = AstUtil.findChildOfType(aST, 280);
        if (aST3 != null && (aST2 = AstUtil.findSiblingOfType(aST3.getNextSibling(), 281)) != null) {
            aST3 = aST2;
        }
        return aST3;
    }

    protected CharSequence getScopeSuffix() {
        return this.classTemplateSuffix != null ? this.classTemplateSuffix : CharSequenceKey.empty();
    }

    protected String initName(AST aST) {
        return FunctionImpl.findFunctionName(aST);
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequenceKey.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public boolean isVoidParameterList() {
        return this.hasFlags((byte)1);
    }

    private static String extractName(AST aST) {
        AST aST2;
        int n = aST.getType();
        if (n == 205) {
            return aST.getText();
        }
        if (n == 288 && (aST2 = AstUtil.getLastChild(aST)) != null) {
            if (aST2.getType() == 205) {
                return aST2.getText();
            }
            AST aST3 = AstUtil.findChildOfType(aST, 25);
            if (aST3 != null) {
                StringBuilder stringBuilder = new StringBuilder(aST3.getText());
                stringBuilder.append(' ');
                for (AST aST4 = aST3.getNextSibling(); aST4 != null; aST4 = aST4.getNextSibling()) {
                    stringBuilder.append(aST4.getText());
                }
                return stringBuilder.toString();
            }
            AST aST5 = aST.getFirstChild();
            if (aST5.getType() == 205) {
                return aST5.getText();
            }
        }
        return "";
    }

    private static String findFunctionName(AST aST) {
        if (CastUtils.isCast(aST)) {
            return CastUtils.getFunctionName(aST);
        }
        AST aST2 = AstUtil.findMethodName(aST);
        if (aST2 != null) {
            return FunctionImpl.extractName(aST2);
        }
        return "";
    }

    protected boolean isCStyleStatic() {
        return this.isStatic() && CsmKindUtilities.isFile((CsmObject)this.getScope());
    }

    protected void registerInProject() {
        if (this.isCStyleStatic()) {
            return;
        }
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).registerDeclaration(this);
        }
    }

    private void unregisterInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).unregisterDeclaration(this);
            this.cleanUID();
        }
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CharSequence charSequence;
        CsmScope csmScope = this.getScope();
        if ((csmScope instanceof CsmNamespace || csmScope instanceof CsmClass || csmScope instanceof CsmNamespaceDefinition) && (charSequence = ((CsmQualifiedNamedElement)csmScope).getQualifiedName()) != null && charSequence.length() > 0) {
            return CharSequenceKey.create((CharSequence)(((Object)charSequence).toString() + this.getScopeSuffix() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    @Override
    public CharSequence getUniqueNameWithoutPrefix() {
        return ((Object)this.getQualifiedName()).toString() + ((Object)this.getSignature()).toString().substring(this.getName().length());
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION;
    }

    public String getDeclarationText() {
        return "";
    }

    public CsmFunctionDefinition getDefinition() {
        CsmFunctionDefinition csmFunctionDefinition;
        block5: {
            CsmProject csmProject;
            Iterator<Object> iterator;
            if (this.isCStyleStatic()) {
                CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false);
                Iterator iterator2 = CsmSelect.getDeclarations((CsmFile)this.getContainingFile(), (CsmSelect.CsmFilter)csmFilter);
                while (iterator2.hasNext()) {
                    CsmDeclaration csmDeclaration = (CsmDeclaration)iterator2.next();
                    if (!CsmKindUtilities.isFunctionDefinition((CsmObject)csmDeclaration) || !this.getName().equals(csmDeclaration.getName())) continue;
                    CsmFunctionDefinition csmFunctionDefinition2 = (CsmFunctionDefinition)csmDeclaration;
                    if (!this.getSignature().equals(csmFunctionDefinition2.getSignature())) continue;
                    return csmFunctionDefinition2;
                }
                return null;
            }
            String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + this.getUniqueNameWithoutPrefix();
            CsmProject csmProject2 = this.getContainingFile().getProject();
            csmFunctionDefinition = this.findDefinition(csmProject2, string);
            if (csmFunctionDefinition == null) {
                iterator = csmProject2.getLibraries().iterator();
                while (iterator.hasNext() && (csmFunctionDefinition = this.findDefinition(csmProject = (CsmProject)iterator.next(), string)) == null) {
                }
            }
            if (csmFunctionDefinition != null || !(csmProject2 instanceof ProjectBase)) break block5;
            iterator = ((ProjectBase)csmProject2).getDependentProjects().iterator();
            while (iterator.hasNext() && (csmFunctionDefinition = this.findDefinition(csmProject = (ProjectBase)iterator.next(), string)) == null) {
            }
        }
        return csmFunctionDefinition;
    }

    private CsmDeclaration fixCastOperator(CsmProject csmProject, String string) {
        String string2;
        int n;
        int n2 = string.indexOf("operator ");
        if (n2 > 0 && (n = (string2 = string.substring(n2 + 9)).lastIndexOf("::")) > 0) {
            string2 = string.substring(0, n2 + 9) + " " + string2.substring(n + 2);
            return csmProject.findDeclaration((CharSequence)string2);
        }
        return null;
    }

    private CsmFunctionDefinition findDefinition(CsmProject csmProject, String string) {
        CsmDeclaration csmDeclaration = csmProject.findDeclaration((CharSequence)string);
        if (csmDeclaration == null && this.isOperator()) {
            csmDeclaration = this.fixCastOperator(csmProject, string);
        }
        if (csmDeclaration instanceof CsmFunctionDefinition) {
            return (CsmFunctionDefinition)csmDeclaration;
        }
        if (csmProject instanceof ProjectBase) {
            int n = this.getParameters().size();
            boolean bl = this.isVoidParameterList();
            String string2 = string.substring(0, string.indexOf(40) + 1);
            Collection<CsmOffsetableDeclaration> collection = ((ProjectBase)csmProject).findDeclarationsByPrefix(string2);
            CsmFunctionDefinition csmFunctionDefinition = null;
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection) {
                CsmFunctionDefinition csmFunctionDefinition2 = (CsmFunctionDefinition)csmOffsetableDeclaration;
                int n2 = csmFunctionDefinition2.getParameters().size();
                if (!bl && n == 0 && !ProjectBase.isCppFile(csmOffsetableDeclaration.getContainingFile())) {
                    return csmFunctionDefinition2;
                }
                if (n != n2) continue;
                if (csmFunctionDefinition == null) {
                    csmFunctionDefinition = csmFunctionDefinition2;
                    continue;
                }
                return null;
            }
            return csmFunctionDefinition;
        }
        return null;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public CsmCompoundStatement getBody() {
        return null;
    }

    public boolean isInline() {
        return false;
    }

    private CsmType initReturnType(AST aST) {
        TypeImpl typeImpl = null;
        AST aST2 = FunctionImpl.getTypeToken(aST);
        if (aST2 != null) {
            typeImpl = AstRenderer.renderType(aST2, this.getContainingFile());
        }
        if (typeImpl == null) {
            typeImpl = TypeFactory.createBuiltinType("int", null, 0, null, this.getContainingFile());
        }
        return TemplateUtils.checkTemplateType(typeImpl, (CsmScope)this);
    }

    public CsmType getReturnType() {
        return this.returnType;
    }

    private static AST getTypeToken(AST aST) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            int n = aST2.getType();
            switch (n) {
                case 45: 
                case 73: 
                case 74: 
                case 75: 
                case 255: 
                case 256: {
                    return aST2;
                }
            }
            if (!AstRenderer.isCVQualifier(n)) continue;
            return aST2;
        }
        return null;
    }

    private FunctionParameterListImpl createParameterList(AST aST, boolean bl) {
        return FunctionParameterListImpl.create(this.getContainingFile(), aST, (CsmScope)this, bl);
    }

    private boolean isVoidParameter(AST aST) {
        AST aST2 = this.findParameterNode(aST);
        return AstRenderer.isVoidParameter(aST2);
    }

    public FunctionParameterListImpl getParameterList() {
        return this.parameterList;
    }

    public Collection<CsmParameter> getParameters() {
        return this._getParameters();
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    public CharSequence getSignature() {
        if (this.signature == null) {
            this.signature = QualifiedNameCache.getManager().getString(this.createSignature());
        }
        return this.signature;
    }

    public CsmFunction getDeclaration() {
        return this;
    }

    public boolean isOperator() {
        return this.hasFlags((byte)8);
    }

    public CsmFunction.OperatorKind getOperatorKind() {
        CsmFunction.OperatorKind operatorKind = CsmFunction.OperatorKind.NONE;
        if (this.isOperator()) {
            int n;
            String string = ((Object)this.getName()).toString();
            int n2 = string.indexOf(OPERATOR);
            assert (n2 >= 0) : "must have word \"operator\" in name";
            String string2 = string.substring(n2 += OPERATOR.length()).trim();
            CsmFunction.OperatorKind operatorKind2 = CsmFunction.OperatorKind.getKindByImage((String)string2, (boolean)true);
            CsmFunction.OperatorKind operatorKind3 = CsmFunction.OperatorKind.getKindByImage((String)string2, (boolean)false);
            operatorKind = operatorKind2 != CsmFunction.OperatorKind.NONE && operatorKind3 != CsmFunction.OperatorKind.NONE ? ((n = this.getNrParameters()) == 0 ? operatorKind3 : (n == 1 ? (CsmKindUtilities.isClass((CsmObject)this.getScope()) ? operatorKind2 : operatorKind3) : (n == 2 ? operatorKind2 : operatorKind3))) : (operatorKind2 != CsmFunction.OperatorKind.NONE ? operatorKind2 : operatorKind3);
        }
        return operatorKind;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> arrayList = new ArrayList<CsmScopeElement>();
        arrayList.addAll(this.getParameters());
        return arrayList;
    }

    private CharSequence createSignature() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        this.appendTemplateSignature(stringBuilder);
        InstantiationProviderImpl.appendParametersSignature(this.getParameters(), stringBuilder);
        if (this.isConst()) {
            stringBuilder.append(" const");
        }
        return stringBuilder;
    }

    private void appendTemplateSignature(StringBuilder stringBuilder) {
        List<CsmTemplateParameter> list = this.getTemplateParameters();
        ArrayList<CsmTemplateParameter> arrayList = new ArrayList<CsmTemplateParameter>();
        if (list != null) {
            int n;
            int n2 = n = this.templateDescriptor != null ? this.templateDescriptor.getInheritedTemplateParametersNumber() : 0;
            if (list.size() > n) {
                Iterator<CsmTemplateParameter> iterator = list.iterator();
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    iterator.next();
                }
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        InstantiationProviderImpl.appendTemplateParamsSignature(arrayList, stringBuilder);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        CsmScope csmScope = this._getScope();
        if (csmScope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
        this.unregisterInProject();
        this._disposeParameters();
        this.setFlags((byte)16, true);
    }

    @Override
    public boolean isValid() {
        return !this.hasFlags((byte)16) && super.isValid();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    private static boolean initConst(AST aST) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null && aST2.getType() != 288; aST2 = aST2.getNextSibling()) {
        }
        while (aST2 != null) {
            if (AstRenderer.isConstQualifier(aST2.getType())) {
                return true;
            }
            aST2 = aST2.getNextSibling();
        }
        return false;
    }

    protected boolean isConst() {
        return this.hasFlags((byte)4);
    }

    private synchronized CsmScope _getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return csmScope;
    }

    private Collection<CsmParameter> _getParameters() {
        if (this.parameterList == null) {
            return Collections.emptyList();
        }
        return this.parameterList.getParameters();
    }

    private int getNrParameters() {
        if (this.isVoidParameterList() || this.parameterList == null) {
            return 0;
        }
        return this.parameterList.getNrParameters();
    }

    private void _disposeParameters() {
        if (this.parameterList != null) {
            this.parameterList.dispose();
        }
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        PersistentUtils.writeType(this.returnType, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        PersistentUtils.writeParameterList(this.parameterList, dataOutput);
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        uIDObjectFactory.writeUID(this.scopeUID, dataOutput);
        PersistentUtils.writeUTF(this.signature, dataOutput);
        dataOutput.writeByte(this.flags);
        PersistentUtils.writeUTF(this.getScopeSuffix(), dataOutput);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, dataOutput);
    }

    public FunctionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.returnType = PersistentUtils.readType(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.parameterList = (FunctionParameterListImpl)PersistentUtils.readParameterList(dataInput);
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.scopeUID = uIDObjectFactory.readUID(dataInput);
        this.scopeRef = null;
        this.signature = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        this.flags = dataInput.readByte();
        this.classTemplateSuffix = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(dataInput);
    }
}

